/*************************************************************
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@geom.umn.edu              *
*************************************************************/

/*************************************************************
/*
/*    file:      cgigraph.c
/*               display()
/* 
/*    Contents:  Graphics routines for CGI graphics
*/



/* All coordinates in absolute pixels in current viewport */

#include "include.h"
#include "cgi.h"

void reset_mode(void);

static int maxx,maxy;  /* max viewport coordinates */
static double xscale,yscale;  /* for scaling to screen size */

static int laserflag;  /* set to do laser output */

static double light[3] = { 0.0, 1.0, 0.0 };
static short    gray[16]  /* Toshiba color to gray scale map */
    = { 0, 1, 4, 5, 8, 2, 6, 9, 3, 12, 13, 7, 10, 11, 14, 15 };

/* for Toshiba Xenix ega */
static short ega_gray[8] = { 0, 4, 2, 7, 3, 6, 1, 5 };
#define  GMODE  1
#define  CMODE  0
#define  BOTTOM 0
#define  LEFT   0
#define  CENTER 1

static short devhandle,ginhandle,savin[20],work_out[66];
void reset_mode()
{
  char line[100];
  short xy[2];

  if ( laserflag )
    laserflag = 0;
  else
    {
      xy[0] = 100; xy[1] = 1000;
      line[0] = 0;
      vrq_string(devhandle,sizeof(line)-10,1,xy,line);
      v_enter_cur(devhandle);
      if ( toupper(line[0]) == 'L' ) laserflag = 1;
    }
  v_clswk(devhandle);
  init_flag = 0;
}


void cgi_init()
{
   short joy_stat;
   short cgi_error;

  if ( init_flag )
    {
      /* clear screen  */
      v_clrwk(devhandle); 
      return;
    }
   /* mouse open */
   /* savin[1] - savin[10] are passed to the driver*/
   savin[0] = 0;                /* don't preserve aspect ratio */
   savin[1] = 1;
   savin[2] = 1;
   savin[3] = 3;
   savin[4] = 1;
   savin[5] = 1;
   savin[6] = 1;
   savin[7] = 0;
   savin[8] = 0;
   savin[9] = 1;
   savin[10] = 1;  /* prompt for paper changes */
   savin[11] = 'G';             /* OPEN GIN DEVICE */
   savin[12] = 'I';
   savin[13] = 'N';
   savin[14] = ' ';
   savin[15] = ' ';
   savin[16] = ' ';
   savin[17] = ' ';
   savin[18] = ' ';

   /* test for presence of GIN device*/

   joy_stat = v_opnwk(savin, &ginhandle, work_out);

   /* savin[1] - savin[10] are passed to the driver*/
   savin[0] = 1;                /* preserve aspect ratio */
   savin[1] = 1;
   savin[2] = 1;
   savin[3] = 3;
   savin[4] = 1;
   savin[5] = 1;
   savin[6] = 1;
   savin[7] = 0;
   savin[8] = 0;
   savin[9] = 1;
   savin[10] = 1;  /* prompt for paper changes */
   if ( laserflag )
     {
       savin[11] = 'L';             /* OPEN laser printer device dirver */
       savin[12] = 'A';
       savin[13] = 'S';
       savin[14] = 'E';
       savin[15] = 'R';
       savin[16] = ' ';
       savin[17] = ' ';
       savin[18] = ' ';
     }
   else
     {
       savin[11] = 'D';             /* OPEN CRT DEVICE */
       savin[12] = 'I';
       savin[13] = 'S';
       savin[14] = 'P';
       savin[15] = 'L';
       savin[16] = 'A';
       savin[17] = 'Y';
       savin[18] = ' ';
     }
   /* open the workstation and save output in work_out array*/
   cgi_error = v_opnwk(savin, &devhandle, work_out);
   if (cgi_error < 0)
   {
      reset_mode();
      sprintf(errmsg,"CGI error %d opening display device\n",vq_error());
      error(errmsg,RECOVERABLE);
   }

  if (joy_stat < 0) ginhandle = devhandle;

  maxx = work_out[51]; maxy = work_out[52];
  if ( laserflag )
    {
      xscale = maxx/3.0;
      yscale = maxx/3.0;
    }
  else
    {
      xscale = maxy/3.0;
      yscale = maxy/3.0;
    }
  init_flag = 1;
}


void cgigraph_edge(e)
struct tsort *e;
{
  short x[3][2];
  double xx[2][2]; /* for clipping */
  double t,tt,t1,t2,t3,t4; /* for clipping */
  double dx,dy;
  short i,j;

  if ( e->color == CLEAR ) return;
  for ( i = 0 ; i < 2 ; i++ )
    {
      xx[i][0] = (e->x[i][0]*xscale) + maxx/2;
      xx[i][1] = (e->x[i][1]*yscale) + maxy/2;
    }       

  /* clip */
  dx = xx[1][0] - xx[0][0];
  if ( fabs(dx) > 0.5 )
   {
     t1 = -xx[0][0]/dx; t2 = (maxx - xx[0][0])/dx;
     if ( t2 < t1 ) { t = t1; t1 = t2 ; t2 = t; }
   }
  else
   { if ( xx[0][0] < 0.0 ) t1 = t2 = -1;
     else if ( xx[0][0] > maxx ) t1 = t2 = 2;
     else { t1 = 0.0; t2 = 1.0; }
   }
  dy = xx[1][1] - xx[0][1];
  if ( fabs(dy) > 0.5 )
   {
     t3 = -xx[0][1]/dy; t4 = (maxy - xx[0][1])/dy;
     if ( t4 < t3 ) { t = t3; t3 = t4 ; t4 = t; }
   }
  else
   { if ( xx[0][1] < 0.0 ) t3 = t4 = -1;
     else if ( xx[0][1] > maxy ) t3 = t4 = 2;
     else { t3 = 0.0; t4 = 1.0; }
   }
  if ( t1 > 0.0 ) t = t1; else t = 0.0;
  if ( t3 > t  ) t = t3;
  if ( t2 < 1.0 ) tt = t2; else tt = 1.0;
  if ( t4 < tt  ) tt = t4;
  if ( t > tt ) return;   /* off screen */
  for ( i = 0 ; i < 2 ; i++ )
   { x[0][i] = (short)((1-t)*xx[0][i] + t*xx[1][i]);
     x[1][i] = (short)((1-tt)*xx[0][i] + tt*xx[1][i]);
   }
  vsl_color(devhandle,ega_gray[e->color]);
  v_pline(devhandle,2,(short *)x);
}


void cgigraph_facet(t)
struct tsort *t;
{
  short x[4][2];
  short i,k,color;
  double top,norm;
  int maxcolor;


  for ( i = 0 ; i < 3 ; i++ )
    {
      x[i][0] = (short)(t->x[i][0]*xscale) + maxx/2;
      x[i][1] = (short)(t->x[i][1]*yscale) + maxy/2;
    }
  x[3][0] = x[0][0]; x[3][1] = x[0][1]; /* wraparound */

  if ( work_out[13] > 8 ) maxcolor = 7;
  else maxcolor = work_out[13] - 1;
  if ( valid_id(t->f_id) )
    {
      top = 0.0;
      norm = 0.0;
      for ( i = 0 ; i < 3 ; i++ )
        {
          top += t->normal[i]*light[i];
          norm += t->normal[i]*t->normal[i];
        }

      if ( t->color ) color = t->color;
      else color = maxcolor*(1 - top/sqrt(norm))/2.0 - 0.01;

      if ( web.hide_flag )
        {
          vsf_interior(devhandle,SOLID);
          vsf_color(devhandle,ega_gray[color]);
          v_fillarea(devhandle,3,(short *)x);
        }
    }
  if ( edgeshow_flag )
    {
      vsf_interior(devhandle,HOLLOW);
      vsf_color(devhandle,ega_gray[fillcolor]);
      v_fillarea(devhandle,3,(short *)x);
    }
  /* show designated edges */
  for ( k = 0 ; k < 3 ; k++ )
    { if ( t->etype[k] == INVISIBLE_EDGE ) continue;
      if ( t->ecolor[k] == CLEAR ) continue;
      vsl_color(devhandle,ega_gray[t->ecolor[k]]);
      v_pline(devhandle,2,x[k]);
    }
}

void cgi_finish()
{
  reset_mode();
}

void cgi_close()
{
  reset_mode();
  init_flag = 0;
}

void display()
{
  ENTER_GRAPH_MUTEX
  init_graphics = cgi_init;
  finish_graphics = cgi_finish;
  close_graphics = cgi_close;
  graph_start = painter_start;
  graph_edge  = painter_edge;
  display_edge = cgigraph_edge;
  graph_facet = painter_facet;
  display_facet = cgigraph_facet;
  graph_end = painter_end;
  
  graphgen();
  LEAVE_GRAPH_MUTEX
}
