/***************************************************************************
                          FLFormSearchDB.h  -  description
                             -------------------
    begin                : Sun Nov 4 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FLFORMSEARCHDB_H
#define FLFORMSEARCHDB_H

#include <qpushbutton.h>
#include <qsqlrecord.h>

#include "FLFormDB.h"

/** Subclase de la clase FLFormDB, pensada para buscar un registro
    	en una tabla.

    	El comportamiento de elegir un registro se modifica para solamente
   	cerrar el formulario y as el objeto que lo invoca pueda obtener
    	del cursor dicho registro.
    	Tambin aade botones Aceptar y Cancelar. Aceptar indica que se ha
    	elegido el registro activo (igual que hacer doble clic sobre l o
    	pulsar la tecla Intro) y Cancelar aborta la operacin.

    	@author   Federico Albujer Zornoza
    	@version  0.4 */
class FLFormSearchDB:public FLFormDB
{
	Q_OBJECT

	public:

	/** constructor.

      	@param name	Nombre de la tabla origen para el formulario.
		@param receiver	Objeto del tipo FLReceiver, que controlar y recibir seales
                        de este formulario. Este objeto pasa a ser propiedad del formulario,
                        y es l quien lo borra.  */
  	FLFormSearchDB (const char *name, QWidget * parent = 0, FLReceiver * receiver=0);

  	/** constructor sobrecargado.

      	El cursor es pasado a la clase, por lo que no es de su
      	propiedad y por lo tanto no lo debe borrar.

      	@param cursor	Objeto FLSqlCursor para asignar a este formulario */
	FLFormSearchDB (FLSqlCursor *cursor, QWidget * parent = 0, FLReceiver * receiver=0);      	
      	
  	/** destructor */
   	~FLFormSearchDB ();

  	/** Reimplementado, aade un widget como principal del formulario */
  	void setMainWidget (QWidget * w);

  	/** Muestra el formulario y entra en un nuevo bucle de eventos
      	para esperar, a seleccionar registro. */
  	void exec ();

  	/** Devuelve si se ha aceptado el formulario,  es decir no se ha pulsado el botn cancelar */
  	const bool accepted() const
  	{
  		return accepted_;
  	}
  	
	protected:

	/** Capa para botones Aceptar y Cancelar */
    	QHBoxLayout * layoutButtons;

  	/** Boton Aceptar */
  	QPushButton *pushButtonAccept;

  	/** Boton Cancelar */
  	QPushButton *pushButtonCancel;

  	/** Captura evento cerrar */
  	virtual void closeEvent (QCloseEvent * e);

  	protected slots:
	
	/** Se activa al pulsar el boton aceptar */
  	virtual void accept ();

	/** Se activa al pulsar el botn cancelar */
  	virtual void reject ();

  	private:

  	/** Almacena si se ha abierto el formulario con el mtodo FLFormSearchDB::exec() */
  	bool loop;
  	
  	/** Almacena que se aceptado, es decir NO se ha pulsado, botn cancelar */
  	bool accepted_;
};

#endif
