/*
 * farsight.h - Overall include file for Farsight
 *
 * Farsight Voice+Video library
 * Copyright (c) 2005 INdT.
 * @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __FARSIGHT_H__
#define __FARSIGHT_H__

#include <farsight/farsight-plugin.h>
#include <farsight/farsight-codec.h>
#include <farsight/farsight-session.h>
#include <farsight/farsight-stream.h>

#ifdef FS_ENABLE_DEBUG

#define STREAM_DEBUG(stream, format, ...) \
  g_debug ("%s - %s: " format, \
      farsight_stream_get_media_type (FARSIGHT_STREAM (stream)) \
       == FARSIGHT_MEDIA_TYPE_AUDIO?"AUDIO":"VIDEO", \
      G_STRFUNC, ##__VA_ARGS__)

#define DEBUG(format, ...) \
  g_debug ("%s: " format, G_STRFUNC, ##__VA_ARGS__)

#else

#define STREAM_DEBUG(stream, format, ...) do { } while (0);
#define DEBUG(format, ...) do { } while (0);

#endif

#define STREAM_WARNING(stream, format, ...) \
  g_warning ("%s - %s: " format, \
      (farsight_stream_get_media_type (FARSIGHT_STREAM (stream)) \
       == FARSIGHT_MEDIA_TYPE_AUDIO)?"AUDIO":"VIDEO", \
      G_STRFUNC, ##__VA_ARGS__)

#define WARNING(format, ...) \
  g_warning ("%s: " format, G_STRFUNC, ##__VA_ARGS__)

#endif
