/*
 * $Id: sig_mem_bus.h,v 1.11 2009-05-21 16:38:08 vrsieh Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_MEM_BUS_H_INCLUDED
#define __SIG_MEM_BUS_H_INCLUDED

#include "sig_boolean.h"
#include "sig_cs.h"
#include "sig_i2c_bus.h"
#include "sig_gen.h"

struct sig_mem_bus_main {
	int dummy;
};

extern struct sig_mem_bus_main *
sig_mem_bus_main_create(const char *name);
extern void
sig_mem_bus_main_destroy(struct sig_mem_bus_main *sig);

struct sig_mem_bus {
	enum sig_gen_type type;
	struct sig_boolean *power;
	struct sig_cs *cs0;
	struct sig_cs *cs1;
	struct sig_i2c_bus *i2cbus;
	struct sig_boolean *id0;
	struct sig_boolean *id1;
	struct sig_boolean *id2;
};

extern struct sig_mem_bus *
sig_mem_bus_create(const char *name);
extern void
sig_mem_bus_destroy(struct sig_mem_bus *sig);

#endif /* __SIG_MEM_BUS_H_INCLUDED */
