/* $Id: cim_integer.c,v 1.7 2009-01-27 17:06:39 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "cim_integer.h"

static void
cim_integer_set(void *_css, int val)
{
	struct cim_integer *css = (struct cim_integer *) _css;

	cim_send(&css->bridge, &val, sizeof(val));
}

static void
cim_integer_receive(void *_css, void *_val, unsigned int bufsize)
{
	struct cim_integer *css = (struct cim_integer *) _css;
	unsigned int val = *(unsigned int *) _val;

	sig_integer_set(css->sig_integer, css, val);
}

void
cim_integer_init(struct cim_integer *css, struct sig_integer *sig_integer)
{
	static const struct sig_integer_funcs funcs = {
		.set = cim_integer_set,
	};

	cim_connect(&css->bridge, cim_integer_receive, css);

	/* Out */
	css->sig_integer = sig_integer;
	// sig_integer_connect_out(sig_integer, css, 0);

	/* In */
	sig_integer_connect_in(sig_integer, css, &funcs);
}

void
cim_integer_create(struct cim_integer *css)
{
	cim_create(&css->bridge);
}

void
cim_integer_destroy(struct cim_integer *css)
{
	cim_destroy(&css->bridge);
}
