/*
 * $Id: conn_dio48.c,v 1.7 2009-06-03 11:34:05 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

#include "conn_dio48.h"

#define CONN_(x) conn_dio48_ ## x

struct cpssp {
	int dummy;
};

void *
CONN_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_dio48 *port_dev,
	struct sig_std_logic *port_A0,
	struct sig_std_logic *port_A1,
	struct sig_std_logic *port_A2,
	struct sig_std_logic *port_A3,
	struct sig_std_logic *port_A4,
	struct sig_std_logic *port_A5,
	struct sig_std_logic *port_A6,
	struct sig_std_logic *port_A7,
	struct sig_std_logic *port_B0,
	struct sig_std_logic *port_B1,
	struct sig_std_logic *port_B2,
	struct sig_std_logic *port_B3,
	struct sig_std_logic *port_B4,
	struct sig_std_logic *port_B5,
	struct sig_std_logic *port_B6,
	struct sig_std_logic *port_B7,
	struct sig_std_logic *port_C0,
	struct sig_std_logic *port_C1,
	struct sig_std_logic *port_C2,
	struct sig_std_logic *port_C3,
	struct sig_std_logic *port_C4,
	struct sig_std_logic *port_C5,
	struct sig_std_logic *port_C6,
	struct sig_std_logic *port_C7,
	struct sig_std_logic *port_D0,
	struct sig_std_logic *port_D1,
	struct sig_std_logic *port_D2,
	struct sig_std_logic *port_D3,
	struct sig_std_logic *port_D4,
	struct sig_std_logic *port_D5,
	struct sig_std_logic *port_D6,
	struct sig_std_logic *port_D7,
	struct sig_std_logic *port_E0,
	struct sig_std_logic *port_E1,
	struct sig_std_logic *port_E2,
	struct sig_std_logic *port_E3,
	struct sig_std_logic *port_E4,
	struct sig_std_logic *port_E5,
	struct sig_std_logic *port_E6,
	struct sig_std_logic *port_E7,
	struct sig_std_logic *port_F0,
	struct sig_std_logic *port_F1,
	struct sig_std_logic *port_F2,
	struct sig_std_logic *port_F3,
	struct sig_std_logic *port_F4,
	struct sig_std_logic *port_F5,
	struct sig_std_logic *port_F6,
	struct sig_std_logic *port_F7
)
{
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 0], port_A0);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 1], port_A1);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 2], port_A2);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 3], port_A3);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 4], port_A4);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 5], port_A5);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 6], port_A6);
	(void) sig_std_logic_merge(port_dev->sig[0 * 8 + 7], port_A7);

	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 0], port_B0);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 1], port_B1);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 2], port_B2);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 3], port_B3);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 4], port_B4);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 5], port_B5);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 6], port_B6);
	(void) sig_std_logic_merge(port_dev->sig[1 * 8 + 7], port_B7);

	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 0], port_C0);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 1], port_C1);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 2], port_C2);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 3], port_C3);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 4], port_C4);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 5], port_C5);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 6], port_C6);
	(void) sig_std_logic_merge(port_dev->sig[2 * 8 + 7], port_C7);

	(void) sig_std_logic_merge(port_dev->sig[3 * 8 + 0], port_D0);
	(void) sig_std_logic_merge(port_dev->sig[3 * 8 + 1], port_D1);
	(void) sig_std_logic_merge(port_dev->sig[3 * 8 + 2], port_D2);
	(void) sig_std_logic_merge(port_dev->sig[3 * 8 + 3], port_D3);
	(void) sig_std_logic_merge(port_dev->sig[3 * 8 + 4], port_D4);
	(void) sig_std_logic_merge(port_dev->sig[3 * 8 + 5], port_D5);
	(void) sig_std_logic_merge(port_dev->sig[3 * 8 + 6], port_D6);
	(void) sig_std_logic_merge(port_dev->sig[3 * 8 + 7], port_D7);

	(void) sig_std_logic_merge(port_dev->sig[4 * 8 + 0], port_E0);
	(void) sig_std_logic_merge(port_dev->sig[4 * 8 + 1], port_E1);
	(void) sig_std_logic_merge(port_dev->sig[4 * 8 + 2], port_E2);
	(void) sig_std_logic_merge(port_dev->sig[4 * 8 + 3], port_E3);
	(void) sig_std_logic_merge(port_dev->sig[4 * 8 + 4], port_E4);
	(void) sig_std_logic_merge(port_dev->sig[4 * 8 + 5], port_E5);
	(void) sig_std_logic_merge(port_dev->sig[4 * 8 + 6], port_E6);
	(void) sig_std_logic_merge(port_dev->sig[4 * 8 + 7], port_E7);

	(void) sig_std_logic_merge(port_dev->sig[5 * 8 + 0], port_F0);
	(void) sig_std_logic_merge(port_dev->sig[5 * 8 + 1], port_F1);
	(void) sig_std_logic_merge(port_dev->sig[5 * 8 + 2], port_F2);
	(void) sig_std_logic_merge(port_dev->sig[5 * 8 + 3], port_F3);
	(void) sig_std_logic_merge(port_dev->sig[5 * 8 + 4], port_F4);
	(void) sig_std_logic_merge(port_dev->sig[5 * 8 + 5], port_F5);
	(void) sig_std_logic_merge(port_dev->sig[5 * 8 + 6], port_F6);
	(void) sig_std_logic_merge(port_dev->sig[5 * 8 + 7], port_F7);

	return cpssp;
}

void
CONN_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	/* FIXME */

	free(cpssp);
}
