/*
 * $Id: network_cable_gui.c,v 1.1 2009-06-15 09:09:47 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-gui.h"

#include "network_cable_gui.h"

#ifdef HAVE_GTK
#include "network_cable_gui_gtk.h"
#endif

void *
network_cable_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *manage,
	struct sig_eth *port_end0,
	struct sig_eth *port_end1
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return network_cable_gui_gtk_create(page, name,
				manage, port_end0, port_end1);
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
network_cable_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		network_cable_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
