/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <string.h>

#include "glue.h"

#include "conv_s19.h"

int64_t
conv_s19_read(
	void *_c,
	void *_buf,
	uint64_t buflen,
	uint64_t pos
)
{
	char *c = _c;
	char *buf = _buf;

	memcpy(buf, &c[pos], buflen);
	return buflen;
}

void *
conv_s19_open(const char *path, uint64_t size)
{
	char *c;
	int ret;

	c = shm_alloc(size);

	ret = glue_rom_read(path, c, size);
	assert(0 <= ret);

	return c;
}

int
conv_s19_close(void *_c)
{
	char *c = _c;

	shm_free(c);

	return 0;
}
