/* arc.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* contains functions assoc. with drawing of labelled lines */
/*
 * $Log: arc.c,v $
 * Revision 1.2  2000/12/06 20:56:01  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:30  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:29  moz
 * CVS Import
 *
 * Revision 1.7  2000/03/10 00:29:17  moz
 * Use new_text() not text_button() for starting label.
 *
 * Revision 1.6  2000/03/09 23:32:10  moz
 * Joinstyle should always be JoinRound.
 *
 * Revision 1.5  2000/02/18 02:45:14  moz
 * Compile fixes.
 *
 * Revision 1.4  2000/01/29 20:59:47  moz
 * Fixes to get_nearest_point call.
 *
 * Revision 1.3  1999/11/15 00:45:13  moz
 * Name change.
 *
 * Revision 1.2  1999/05/19 17:05:56  moz
 * 1.0 Checkin.
 *
 * Revision 1.1  1999/03/30 00:03:48  moz
 * Initial revision
 *
 */

/* see mouse_button.c for general behaviour */  
 
#include <math.h> 
#include "include/figurine.h"  
#include "include/extern.h"
 
  
static Boolean held = FALSE; /* mouse button down  */ 
static Boolean intext = FALSE; /* when we've drawn the line */
static long orig_x=0; /* started from here  */ 
static long orig_y=0;
static Boolean orig_derried = FALSE; /* derrying of start/end  */ 
static Boolean end_derried = FALSE; 
static Object *rob=NULL;  /* for derrying  */ 
static Object *endrob=NULL; 

void 
unselect_arc(View *view)
{
	intext = FALSE;
	set_window_cursor(view->draw_window->win,XC_crosshair);
}

/* this takes document coordinates  */  
void 
commit_arc(View *view, long x, long y)
{
	Object *ob;
	SPoint *p1,*p2,*p3;
	short mx,my;

	ob = (Object *)malloc(sizeof(Object));
	p1 = (SPoint *)malloc(sizeof(SPoint));
	p2 = (SPoint *)malloc(sizeof(SPoint));
	p3 = (SPoint *)malloc(sizeof(SPoint));
	p1->x = orig_x;
	p1->y = orig_y;
	p1->derried = orig_derried;
	p1->s = 0.0;
	p3->x = x;
	p3->y = y;
	p3->derried = end_derried; 
	p3->s = 0.0;
	/* calc midpoint  */  
	bent_midpoint(p1->x,p1->y,p3->x,p3->y,0.261799388,&mx,&my);
	p2->x = mx;
	p2->y = my;
	p2->derried = FALSE; 
	p2->s = -1.0; /* interpolated  */  
	ob->type = ARC;
	ob->ob.spline.closed = FALSE;
	ob->bbox.x1 = orig_x;
	ob->bbox.y1 = orig_y;
	ob->bbox.x2 = orig_x;
	ob->bbox.y2 = orig_y;
	p1->x -= ob->bbox.x1; 
	p1->y -= ob->bbox.y1; 
	p2->x -= ob->bbox.x1; 
	p2->y -= ob->bbox.y1; 
	p3->x -= ob->bbox.x1; 
	p3->y -= ob->bbox.y1; 
	ob->ls = view->linestyle; 
	ob->lw = view->linewidth; 
	ob->es = view->endstyle;
	ob->js = JoinRound;
	if (view->barrow_on)
		ob->barrow = make_arrow(view->barrow);
	else
		ob->barrow = NULL;
	if (view->farrow_on)
		ob->farrow = make_arrow(view->farrow);
	else
		ob->farrow = NULL; 
	ob->colour = view->colour; 
	if (view->fillon)
		ob->fs = view->fillstyle;
	else
		ob->fs = NONE;
	ob->fillcolour = view->fillcolour; 
	ob->ticket = ob_ticket++; 
	ob->derries = NULL; 
	ob->depth = view->doc->ob_depth--; 
	ob->ob.spline.points = create_list(0,0,(void *)p1);
	ob->ob.spline.points = add_to_list(ob->ob.spline.points,1,0,(void *)p2); 
	ob->ob.spline.points = add_to_list(ob->ob.spline.points,2,0,(void *)p3); 
	ob->ob.spline.cache = compute_spline_segment(ob->ob.spline.points, FALSE);
	recalc_polyline_bbox(ob,TRUE); 
	view->doc->o = add_object(view->doc->o, &view->doc->lo, ob);
	register_undo(UNDO_PASTE,ob,view->doc); 
	/* add derries if set  */  
	if (orig_derried)
		add_derry(rob,ob,(VPoint *)p1);
	orig_derried = FALSE;
	if (end_derried)
		add_derry(endrob,ob,(VPoint *)p3);
	end_derried = FALSE;
	send_redraw_object(view,ob); 
} 

Boolean 
arc_key(View *view, XKeyPressedEvent *report)
{
	if (intext)
		{ 
		text_key(view,report);
		return TRUE; 
		}
	else
		return FALSE; /* not interested if not typing */ 
}

void 
arc_button(BEvent *bev, View *view)
{
	BEvent b;
	short bx,by; 
	long x,y; 
	long ax,ay; 

	if (bev->button==Button2) 
		return; 

	if (bev->button==Button3 && state.busy_drawing)
		{
		if (!intext)
			{
			/* cancel the current line */ 
			if (!held) 
				XUngrabPointer(display,CurrentTime);
		
			toggle_arc(view, bev->x, bev->y);
		
			state.busy_drawing = FALSE;
			held = FALSE;
			}
		else
			{
			/* pass event over to text.c  */  
			text_button(bev,view); 
			intext = FALSE;
			};
		}
	else if (bev->button==Button1)
		{
		if (intext) 
			{
			/* pass event over to text.c  */ 
			text_button(bev,view);
			}
		else
			{
			if (!P_IN_DOC(bev->x, bev->y, view) && state.busy_drawing)
				{
				/* ok, cancel the particular line we're drawing  */
				state.busy_drawing = FALSE;
			 
				if (!held)
					XUngrabPointer(display,CurrentTime);
				else 
					held = FALSE;
			
				toggle_arc(view, bev->x, bev->y);
				}
			else
				{
				switch (bev->type)
					{
					case BUTTON_HELD:
						if (!state.busy_drawing)
							{
							/* start drawing */  
							state.busy_drawing = TRUE;
							held = TRUE;
							if (state.shift_down && 
								get_nearest_point(view,view->doc->o, XP2D(bev->x,view),YP2D(bev->y,view),&x,&y,&rob))
								{
								if (view->guide_lines && view->guide_lines_displayed)
									{
									toggle_guidelines(view);
									view->guide_lines_displayed = FALSE;
									};
								 
								orig_x = x;
								orig_y = y;
								orig_derried = TRUE; 
								bev->x = XD2P(x,view); 
								bev->y = YD2P(y,view); 
								mouse_x = bev->x;
								mouse_y = bev->y;
								XWarpPointer(display, None, view->draw_window->win, 0, 0, 1, 1, 
												 bev->x,bev->y);
								}  
							else
								{
								orig_derried = FALSE; 
								if (view->gridon)
									{
									orig_x = GXP2D(bev->x,view);
									orig_y = GYP2D(bev->y,view);
									}
								else
									{
									orig_x = XP2D(bev->x,view);
									orig_y = YP2D(bev->y,view);
									};	
								}; 
								 
							toggle_arc(view, bev->x, bev->y);  
							/* start drawing the line  */  
							}; 
						break; 

					case BUTTON_CLICKED:
						if (held)
							{
							XGrabPointer(display, view->draw_window->win, False, ButtonPressMask | ButtonReleaseMask | PointerMotionMask
											 | ButtonMotionMask | Button1MotionMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime); 
							}
						else
							{
							ax = XP2D(bev->x,view);
							ay = YP2D(bev->y,view);
							end_derried = FALSE; 
							/* finished the line, see if derried */  
							if (state.shift_down && get_nearest_point(view,view->doc->o, XP2D(bev->x,view),YP2D(bev->y,view),&ax,&ay,&endrob))
								{
								if (view->guide_lines && view->guide_lines_displayed)
									{
									toggle_guidelines(view);
									view->guide_lines_displayed = FALSE;
									};
								 
								bev->x = XD2P(ax,view); 
								bev->y = YD2P(ay,view); 
								mouse_x = bev->x;
								mouse_y = bev->y;
								end_derried = TRUE; 
								XWarpPointer(display, None, view->draw_window->win, 0, 0, 1, 1, 
												 bev->x,bev->y);
								};
							toggle_arc(view, bev->x, bev->y);
							commit_arc(view, ax,ay);
							/* ok, we're done with the line now  */  
							state.busy_drawing = FALSE;
							intext=TRUE; 
							/* fake a button event to start text label */  
							b.type  = BUTTON_RELEASED;
							b.button = Button1; 
							if ((XD2P(orig_x,view)-x)*(YD2P(orig_y,view)-y)>0)
								bent_midpoint(XD2P(orig_x,view),YD2P(orig_y,view),bev->x,bev->y,0.161799388,&bx,&by);
							else
								bent_midpoint(XD2P(orig_x,view),YD2P(orig_y,view),bev->x,bev->y,-0.161799388,&bx,&by);
							b.x = bx-D2P(I2D(view->fontsize/72.0,view),view);
							b.y = by-D2P(I2D(view->fontsize/72.0,view),view);
							set_window_cursor(view->draw_window->win,XC_xterm);
							new_text(&b, view);
							};	
					 
						if (!held)
							XUngrabPointer(display,CurrentTime);
						held = FALSE; 
						break;
					 
					case BUTTON_RELEASED:
						ax = XP2D(bev->x,view);
						ay = YP2D(bev->y,view);
						end_derried = FALSE; 
						if (state.shift_down && get_nearest_point(view,view->doc->o, XP2D(bev->x,view),YP2D(bev->y,view),&ax,&ay,&endrob))
							{
							if (view->guide_lines && view->guide_lines_displayed)
								{
								toggle_guidelines(view);
								view->guide_lines_displayed = FALSE;
								};
							 
							bev->x = XD2P(ax,view); 
							bev->y = YD2P(ay,view); 
							end_derried = TRUE; 
							mouse_x = bev->x;
							mouse_y = bev->y;
							XWarpPointer(display, None, view->draw_window->win, 0, 0, 1, 1, 
											 bev->x,bev->y);
							};
						toggle_arc(view, bev->x, bev->y);
						commit_arc(view, ax,ay);
						state.busy_drawing = FALSE;
						held = FALSE;
						intext=TRUE; 
						/* fake a button event to start text label */  
						b.type  = BUTTON_RELEASED;
						b.button = Button1; 
						if ((XD2P(orig_x,view)-x)*(YD2P(orig_y,view)-y)>0)
							bent_midpoint(XD2P(orig_x,view),YD2P(orig_y,view),bev->x,bev->y,0.161799388,&bx,&by);
						else
							bent_midpoint(XD2P(orig_x,view),YD2P(orig_y,view),bev->x,bev->y,-0.161799388,&bx,&by);
						b.x = bx-D2P(I2D(view->fontsize/72.0,view),view);
						b.y = by-D2P(I2D(view->fontsize/72.0,view),view);
						set_window_cursor(view->draw_window->win,XC_xterm);
						new_text(&b, view);
						break;
					};
				}; 
			}; 
		};  
}

void 
toggle_arc(View *view, int x, int y)
{
	VLine *pl;
	VLine line;
	Boolean clipped; 

	line.x1 = XD2P(orig_x,view);
	line.y1 = YD2P(orig_y,view);
	 
	if (view->gridon)
		{
		line.x2 = XD2P(GXP2D(x,view),view);
		line.y2 = YD2P(GYP2D(y,view),view);
		}
	else
		{
		line.x2 = x;
		line.y2 = y;
		};

	pl = clip_line(0,0,(signed long)view->draw_window->w,(signed long)view->draw_window->h, &line, &clipped, 1); 
		 
  	if (pl!=NULL)    
		XDrawLine(display,view->draw_window->win, blackxorgc, pl->x1, pl->y1, pl->x2, pl->y2);
}
