/* gc.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* for altering the utility gc's  */  
/*
 * $Log: gc.c,v $
 * Revision 1.3  2000/12/17 00:57:42  moz
 * examples, filled open splines, highlight_objects
 *
 * Revision 1.2  2000/12/06 20:56:01  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:29  moz
 * CVS Import
 *
 * Revision 1.9  2000/03/08 01:10:09  moz
 * Compile fixes.
 *
 * Revision 1.8  2000/03/04 19:02:35  moz
 * Was using gc_width=-10
 *
 * Revision 1.7  1999/11/15 02:10:23  moz
 * Name change.
 *
 * Revision 1.6  1999/06/30 13:42:23  moz
 * Fix for dashed infinitely thin lines.
 *
 * Revision 1.5  1999/05/19 17:10:40  moz
 * 1.0 Checkin.
 *
 * Revision 1.4  1999/04/24 22:23:27  moz
 * Changes to accomodate read-only user-defined colours.
 *
 * Revision 1.3  1999/04/15 22:23:37  moz
 * Fixed logic of when to change fill type.
 *
 * Revision 1.2  1999/04/08 02:06:45  moz
 * Small fixes.
 *
 * Revision 1.1  1999/03/30 00:04:50  moz
 * Initial revision
 *
 */    

#include "include/figurine.h"
#include "include/extern.h"

/* initial parameters  */
/* gc is only changed if 
	different from these values */  
static uint gc_style = SOLID;
static uint gc_width = 1; 
static int gc_fillstyle = NONE; 
static ulong gc_col=1; 
static ulong gc_fillcol=1; 
static int gc_cap = CapRound;
static int gc_joinval = JoinRound;
static int cstyle = LineSolid; 
  
/* end style  */ 
void 
gc_end(GC gc, Object *ob)
{
	if (ob->type==TEXT || ob->type==COMPOUND || ob->type==ELLIPSE)
		return;

	if (gc_cap==ob->es)
		return;
	
	gc_cap = ob->es;

	XSetLineAttributes(display,gc,gc_width,cstyle, gc_cap, gc_joinval);
}

/* line join style  */  
void 
gc_join(GC gc, Object *ob)
{
	if (ob->type==TEXT || ob->type==COMPOUND || ob->type==ELLIPSE || ob->type==ARCELLIPSE)
		return;

	if (gc_joinval==ob->js)
		return;
	
	gc_joinval = ob->js;

	XSetLineAttributes(display,gc,gc_width,cstyle, gc_cap, gc_joinval);
}

/* valued line width  */  
void 
gc_lw_v(View *view, GC gc, int lw)
{

	if (gc_width==(ulong)(((double)I2P(lw,view))/80.0))
		return;

	gc_width=(long)(((double)I2P(lw,view))/80.0);
	 
	if (gc_width==1)
		{
		/* set to infinitely thin if approp.  */  
		if (lw!=2)
			gc_width=0;
		else
			gc_width=1;
		}; 

	XSetLineAttributes(display,gc,gc_width,cstyle, gc_cap, gc_joinval);
}

/* line width from object  */  
void 
gc_lw(View *view,GC gc, Object *ob)
{
	if (ob->type==TEXT || ob->type==COMPOUND)
		return;
	
	gc_lw_v(view, gc, ob->lw); 
}

/* fill style  */  
void 
gc_fill(GC gc, Object *ob)
{
	if (ob->fs == NONE)
		return;

	if (ob->fs == gc_fillstyle)
		return;
	
	if (ob->type!=POLYGON && ob->type!=ELLIPSE && ob->type!=ROUNDBOX && ob->type!=SPLINE
		&& ob->type!=ARC &&
		(ob->type!=ARCELLIPSE || ob->ob.arcellipse.open))
		return;
	
	gc_fillstyle = ob->fs;

	XSetStipple(display,gc,bfills[gc_fillstyle]);
}

/* line style  */  
void 
gc_line(GC gc, Object *ob)
{
	char dash_list[10];
	int dash_list_no; 
	int w=gc_width; 

	if (ob->type==TEXT || ob->type==COMPOUND)
		return;

	if (gc_style==ob->ls)
		return;

	gc_style = ob->ls;

	if (w==0)
		w++;

	switch (ob->ls)
		{
		case SOLID:
			cstyle = LineSolid;
			XSetLineAttributes(display,gc,gc_width,cstyle, gc_cap, gc_joinval);
			return;
			break;
	
		case DOTTED:
			dash_list[0] = 1*w;
			dash_list[1] = 2*w; 
			dash_list_no = 2;
			break;
			 
		case DASHED:
			dash_list[0] = 4*w;
			dash_list[1] = 3*w; 
			dash_list_no = 2;
			break;
			 
		case DASH_DOTTED:
			dash_list[0] = 4*w;
			dash_list[1] = 3*w;
			dash_list[2] = 1*w;
			dash_list[3] = 3*w;
			dash_list_no = 4;
			break;
			 
		case DASH_DOUBLE_DOTTED:
			dash_list[0] = 4*w;
			dash_list[1] = 3*w;
			dash_list[2] = 1*w;
			dash_list[3] = 2*w;
			dash_list[4] = 1*w;
			dash_list[5] = 3*w;
			dash_list_no = 6;
			break;
			 
		case DASH_TRIPLE_DOTTED:
			dash_list[0] = 4*w;
			dash_list[1] = 3*w;
			dash_list[2] = 1*w;
			dash_list[3] = 2*w;
			dash_list[4] = 1*w;
			dash_list[5] = 2*w;
			dash_list[6] = 1*w;
			dash_list[7] = 3*w;
			dash_list_no = 8;
			break;
		
		default: 
			cstyle = LineSolid;
			XSetLineAttributes(display,gc,gc_width,cstyle, gc_cap, gc_joinval);
			return; 
			break;
		};
	
	/* infinitely thin lines can't have dashes  */  
	if (gc_width==0)
		gc_width++;
		 
	cstyle = LineOnOffDash; 
 	XSetLineAttributes(display,gc,gc_width,cstyle, gc_cap, gc_joinval);
 	XSetDashes(display, gc, 0, dash_list, dash_list_no); 
}

/* set pen colour  */  
/* a lookup table is used to simplify
	the colour menu */  
void 
gc_colour(View *view, GC gc, Object *ob)
{
	unsigned long a;

	if (ob->type==COMPOUND)
		return;

	switch (ob->colour)
		{
		case CBLACK:		 a=cols[28].colour; break; 
		case CBLUE: 		 a=cols[3].colour; break; 
		case CGREEN:		 a=cols[7].colour; break; 
		case CCYAN: 		 a=cols[11].colour; break; 
		case CRED: 		 a=cols[15].colour; break; 
		case CMAGENTA:	 a=cols[19].colour; break; 
		case CYELLOW:		 a=cols[30].colour; break; 
		case CWHITE:		 a=cols[29].colour; break; 
		case CBLUE4:		 a=cols[0].colour; break; 
		case CBLUE3:		 a=cols[1].colour; break; 
		case CBLUE2:		 a=cols[2].colour; break; 
		case CLIGHTBLUE:  a=cols[31].colour; break; 
		case CGREEN4:		 a=cols[4].colour; break; 
		case CGREEN3:		 a=cols[5].colour; break; 
		case CGREEN2:		 a=cols[6].colour; break; 
		case CCYAN4:		 a=cols[8].colour; break; 
		case CCYAN3:		 a=cols[9].colour; break; 
		case CCYAN2:		 a=cols[10].colour; break; 
		case CRED4:		 a=cols[12].colour; break; 
		case CRED3:		 a=cols[13].colour; break; 
		case CRED2:		 a=cols[14].colour; break; 
		case CMAGENTA4:	 a=cols[16].colour; break; 
		case CMAGENTA3:	 a=cols[17].colour; break; 
		case CMAGENTA2:	 a=cols[18].colour; break; 
		case CBROWN4:		 a=cols[20].colour; break; 
		case CBROWN3:		 a=cols[21].colour; break; 
		case CBROWN2:		 a=cols[22].colour; break; 
		case CPINK4:		 a=cols[24].colour; break; 
		case CPINK3:		 a=cols[25].colour; break; 
		case CPINK2:		 a=cols[26].colour; break; 
		case CPINK:		 a=cols[27].colour; break; 
		case CGOLD:		 a=cols[23].colour; break; 
		default:           
			/* check for user-defined colour  */  
			if (ob->colour>(STARTOFCOLOURS+31) && ob->colour<(STARTOFCOLOURS+512+31))
				{
				List l;

				l = where_in_list(view->doc->cols,ob->colour-STARTOFCOLOURS);

				if (l!=NULL)
					a=UCOLOUR(l)->colour;
				else
					a=cols[28].colour; 
				}
			else
				a=cols[28].colour; 
			break; 
		}; 

 	if (a!=gc_col)
 		{ 
		gc_col = a;
		XSetForeground(display,gc,gc_col);
		XSetForeground(display,fillgc,gc_col);
 		}; 
		
}

/* set fill colour  */  
/* a lookup table is used to simplify
	the fill colour menu */  
void 
gc_fillcolour(View *view, GC gc, Object *ob)
{
	unsigned long a;

	if (ob->type==COMPOUND)
		return;

	switch (ob->fillcolour)
		{
		case FILLCBLACK:		 a=fillcols[28].colour; break; 
		case FILLCBLUE: 		 a=fillcols[3].colour; break; 
		case FILLCGREEN:		 a=fillcols[7].colour; break; 
		case FILLCCYAN: 		 a=fillcols[11].colour; break; 
		case FILLCRED: 		 a=fillcols[15].colour; break; 
		case FILLCMAGENTA:	 a=fillcols[19].colour; break; 
		case FILLCYELLOW:		 a=fillcols[30].colour; break; 
		case FILLCWHITE:		 a=fillcols[29].colour; break; 
		case FILLCBLUE4:		 a=fillcols[0].colour; break; 
		case FILLCBLUE3:		 a=fillcols[1].colour; break; 
		case FILLCBLUE2:		 a=fillcols[2].colour; break; 
		case FILLCLIGHTBLUE:  a=fillcols[31].colour; break; 
		case FILLCGREEN4:		 a=fillcols[4].colour; break; 
		case FILLCGREEN3:		 a=fillcols[5].colour; break; 
		case FILLCGREEN2:		 a=fillcols[6].colour; break; 
		case FILLCCYAN4:		 a=fillcols[8].colour; break; 
		case FILLCCYAN3:		 a=fillcols[9].colour; break; 
		case FILLCCYAN2:		 a=fillcols[10].colour; break; 
		case FILLCRED4:		 a=fillcols[12].colour; break; 
		case FILLCRED3:		 a=fillcols[13].colour; break; 
		case FILLCRED2:		 a=fillcols[14].colour; break; 
		case FILLCMAGENTA4:	 a=fillcols[16].colour; break; 
		case FILLCMAGENTA3:	 a=fillcols[17].colour; break; 
		case FILLCMAGENTA2:	 a=fillcols[18].colour; break; 
		case FILLCBROWN4:		 a=fillcols[20].colour; break; 
		case FILLCBROWN3:		 a=fillcols[21].colour; break; 
		case FILLCBROWN2:		 a=fillcols[22].colour; break; 
		case FILLCPINK4:		 a=fillcols[24].colour; break; 
		case FILLCPINK3:		 a=fillcols[25].colour; break; 
		case FILLCPINK2:		 a=fillcols[26].colour; break; 
		case FILLCPINK:		 a=fillcols[27].colour; break; 
		case FILLCGOLD:		 a=fillcols[23].colour; break; 
		default:           
			/* check for user-defined colour  */  
			if (ob->fillcolour>(STARTOFFILLCOLOURS+31) && ob->fillcolour<(STARTOFFILLCOLOURS+512+31))
				{
				List l;

				l = where_in_list(view->doc->cols,ob->fillcolour-STARTOFFILLCOLOURS);

				if (l!=NULL)
					a=UCOLOUR(l)->colour;
				else
					a=cols[28].colour; 
				}
			else
				a=cols[28].colour; 
			break; 
		}; 

 	if (a!=gc_fillcol)  
 		{ 
		gc_fillcol = a;
		XSetBackground(display,gc,gc_fillcol);
 		}; 
		
}
