/* Handle icon presses */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: handle_icon.c,v $
 * Revision 1.2  2000/12/06 20:56:01  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.11  2000/03/09 23:42:58  moz
 * Spline end/join style special-casing.
 *
 * Revision 1.10  2000/03/09 00:59:48  moz
 * stk_display_menu() cleanup.
 *
 * Revision 1.9  2000/03/08 22:30:43  moz
 * Compile fixes.
 *
 * Revision 1.8  2000/02/25 00:14:49  moz
 * Set node fillcolour.
 *
 * Revision 1.7  2000/02/15 01:48:40  moz
 * check views before switch_icons().
 *
 * Revision 1.6  2000/02/08 18:36:41  moz
 * Need to set grid/showgrid icons as we may
 * have used fake from keyboard
 *
 * Revision 1.5  2000/02/04 01:53:20  moz
 * switch_icons() needs view.
 *
 * Revision 1.4  2000/02/01 15:35:32  moz
 * whoops, Bevel was setting Miter !
 *
 * Revision 1.3  1999/11/15 02:10:00  moz
 * Name change.
 * Show font size selection.
 *
 * Revision 1.2  1999/08/09 00:20:34  moz
 * Split from event_loop.c.
 *
 * 
 */    

#include <stdio.h>
#include <string.h> 

#include "include/figurine.h"
#include "include/extern.h" 

void 
change_function(XEvent report) 
{
	List l; 
	IconType icon = report.xclient.data.l[0];

	/* change the document cursor if necessary  */  
	if (IS_TEXT_FUNC(state.current_icon) && !IS_TEXT_FUNC(icon))
		{
		l = state.views;
		while (l!=NULL)
			{
			set_window_cursor(VIEW(l)->draw_window->win,XC_crosshair); 
			l=l->next;
			};
		}
	else if (!IS_TEXT_FUNC(state.current_icon) && IS_TEXT_FUNC(icon))
		{
		l = state.views;
		while (l!=NULL)
			{
			set_window_cursor(VIEW(l)->draw_window->win,XC_xterm);
			l=l->next;
			}; 
		};

	/* unselect the old one  */  
	stk_unselect_icon((int)state.current_icon, toolWindow.win);
	stk_unselect_icon((int)state.current_icon, float_menu);

	/* if changing from POINTERICON, deselect object  */  
	if (state.current_icon==POINTERICON && icon!=POINTERICON)
		deselect_everything();

	/* ok set it, and change views  */  
	state.current_icon = icon;
	if (state.views) 
		switch_icons(VIEW(state.views));
	stk_select_icon((int)state.current_icon, toolWindow.win); 
	stk_select_icon((int)state.current_icon, float_menu);
									 
}

void
icon_swap_pixmap(View *v, Window parent, int a, int b)
{
	stk_swap_pixmap(a, v->view_icon_window->win, b, parent);
}

void
icon_chosen(XEvent report)
{
	List l; 
	List l2;
	char a[FIGURINE_PATH_MAX]; 
	Window w1;
	int x1,y1; 
	int idum; 
	uint indum; 
	IconType icon = report.xclient.data.l[0];
	Window par = (Window)report.xclient.data.l[1]; 

	/* these icons are on a menu, so we require a set menu_view  */  
	/* we use state.menu_view=-1 as indication of a match  */  
	if (state.menu_view!=NULL)
		{
		View *v=state.menu_view;

		/* a fill style has been selected, deal with it  */  
		if (icon>=STARTOFFILLSTYLES && icon<STARTOFCOLOURS)
			{ 
			icon_swap_pixmap(v,par,FILLSTYLEICON,(int)icon);

			v->fillstyle = (icon==FILLSTYLENONE) ? NONE : (((int)icon) - STARTOFFILLSTYLES); 
									 
			if (isselob(v))
				{ 
				register_undo(UNDO_OB_PROP, selob(v), v->doc);
				selob(v)->fs = v->fillstyle;
				if (selobtype(v,TEXT) && selob(v)->ob.text.node)
					selob(v)->ob.text.ellipse->fs = v->fillstyle;
				send_redraw_object(v, selob(v));
				};
			state.menu_view=NULL;
			return;
			}
		else if (icon>=STARTOFCOLOURS && icon<STARTOFCOLOURS+70)
			{ 
			icon_swap_pixmap(v,par,COLOURICON,(int)icon);

			v->colour = icon;
									 
			if (isselob(v))
				{ 
				register_undo(UNDO_OB_PROP, selob(v), v->doc);
				selob(v)->colour = v->colour;
				send_redraw_object(v, selob(v));
				};
			state.menu_view=NULL;
			return;
			}
		else if (icon>=STARTOFFILLCOLOURS && icon<STARTOFFILLCOLOURS+70)
			{ 
			icon_swap_pixmap(v,par,FILLCOLOURICON,(int)icon);

			v->fillcolour = icon; 
									 
			if (isselob(v))
				{ 
				register_undo(UNDO_OB_PROP, selob(v), v->doc);
				selob(v)->fillcolour = v->fillcolour;
				if (selobtype(v,TEXT) && selob(v)->ob.text.node)
					selob(v)->ob.text.ellipse->fillcolour = v->fillcolour;
				send_redraw_object(v, selob(v));
				};
			state.menu_view=NULL;
			return;
			};

		switch (icon) 
			{
			
			/* open/closed arcellipses  */ 
			 
			case OPENARCELLIPSEICON:
				icon_swap_pixmap(v,par,SETARCELLIPSEICON,OPENARCELLIPSEICON);
				v->openarc = TRUE;
				if (selobtype(v,ARCELLIPSE))
					{
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->ob.arcellipse.open = TRUE;
					send_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;
			
			case CLOSEDARCELLIPSEICON:
				icon_swap_pixmap(v,par,SETARCELLIPSEICON,CLOSEDARCELLIPSEICON);
				v->openarc = FALSE;
				if (selobtype(v,ARCELLIPSE))
					{
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->ob.arcellipse.open = FALSE;
					send_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;
			
			/* justification  */  
			 
			case LEFTJUSTICON:
				icon_swap_pixmap(v,par,JUSTIFICATIONICON,LEFTJUSTICON);
				v->justification = LEFT;
				if (state.editing_text)
					{
					set_text_just(v); 
					send_redraw_object(v, v->text_object);
					};
				v = (View *)-1;
				break;
			
			case CENTREJUSTICON:
				icon_swap_pixmap(v,par,JUSTIFICATIONICON,CENTREJUSTICON);
				v->justification = CENTRE;
				if (state.editing_text)
					{
					set_text_just(v); 
					send_redraw_object(v, v->text_object);
					};
				v = (View *)-1;
				break;
			
			case RIGHTJUSTICON:
				icon_swap_pixmap(v,par,JUSTIFICATIONICON,RIGHTJUSTICON);
				v->justification = RIGHT;
				if (state.editing_text)
					{
					set_text_just(v); 
					send_redraw_object(v, v->text_object);
					};
				v = (View *)-1;
				break;

			/* line ends  */  
			 
			case ROUNDENDICON:
				icon_swap_pixmap(v,par,ENDSTYLEICON,ROUNDENDICON);
				v->endstyle = CapRound;
				if (isselob(v) && !((selob(v)->type==ARC || selob(v)->type==SPLINE) && selob(v)->ob.spline.closed))
					{
					store_redraw_object(selob(v)); 
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->es = v->endstyle;
					send_stored_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;
			
			case FLATENDICON:
				icon_swap_pixmap(v,par,ENDSTYLEICON,FLATENDICON);
				v->endstyle = CapButt;
				if (isselob(v) && !((selob(v)->type==ARC || selob(v)->type==SPLINE) && selob(v)->ob.spline.closed))
					{
					store_redraw_object(selob(v)); 
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->es = v->endstyle;
					send_stored_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;
			
			case PROJECTINGENDICON:
				icon_swap_pixmap(v,par,ENDSTYLEICON,PROJECTINGENDICON);
				v->endstyle = CapProjecting;
				if (isselob(v) && !((selob(v)->type==ARC || selob(v)->type==SPLINE) && selob(v)->ob.spline.closed))
					{
					store_redraw_object(selob(v)); 
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->es = v->endstyle;
					send_stored_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;
			
			/* join styles  */  
			 
			case ROUNDJOINICON:
				icon_swap_pixmap(v,par,JOINSTYLEICON,ROUNDJOINICON);
				v->joinstyle = JoinRound;
				if (isselob(v) && selob(v)->type!=SPLINE && selob(v)->type!=ARC)
					{
					store_redraw_object(selob(v)); 
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->js = v->joinstyle;
					send_stored_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;
			
			case SHARPJOINICON:
				icon_swap_pixmap(v,par,JOINSTYLEICON,SHARPJOINICON);
				v->joinstyle = JoinMiter;
				if (isselob(v) && selob(v)->type!=SPLINE && selob(v)->type!=ARC)
					{
					store_redraw_object(selob(v)); 
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->js = v->joinstyle;
					send_stored_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;
				 
			case BEVELJOINICON:
				icon_swap_pixmap(v,par,JOINSTYLEICON,BEVELJOINICON);
				v->joinstyle = JoinBevel;
				if (isselob(v) && selob(v)->type!=SPLINE && selob(v)->type!=ARC)
					{
					store_redraw_object(selob(v)); 
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->js = v->joinstyle;
					send_stored_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;
			 
			/* line styles  */   
			 
			case SOLIDICON:
				icon_swap_pixmap(v,par,LINESTYLEICON,SOLIDICON);
				v->linestyle = SOLID;
				if (isselob(v))
					{
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->ls = v->linestyle;
					if (selobtype(v,TEXT) && selob(v)->ob.text.node)
						selob(v)->ob.text.ellipse->ls = selob(v)->ls;
					send_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;
				 
			case DASHEDICON:
				icon_swap_pixmap(v,par,LINESTYLEICON,DASHEDICON);
				v->linestyle = DASHED;
				if (isselob(v))
					{
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->ls = v->linestyle;
					if (selobtype(v,TEXT) && selob(v)->ob.text.node)
						selob(v)->ob.text.ellipse->ls = selob(v)->ls;
					send_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;

			case DOTTEDICON:
				icon_swap_pixmap(v,par,LINESTYLEICON,DOTTEDICON);
				v->linestyle = DOTTED;
				if (isselob(v))
					{
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->ls = v->linestyle;
					if (selobtype(v,TEXT) && selob(v)->ob.text.node)
						selob(v)->ob.text.ellipse->ls = selob(v)->ls;
					send_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;

			case DASHDOTTEDICON:
				icon_swap_pixmap(v,par,LINESTYLEICON,DASHDOTTEDICON);
				v->linestyle = DASH_DOTTED;
				if (isselob(v))
					{
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->ls = v->linestyle;
					if (selobtype(v,TEXT) && selob(v)->ob.text.node)
						selob(v)->ob.text.ellipse->ls = selob(v)->ls;
					send_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;

			case DASHDOUBLEDOTTEDICON:
				icon_swap_pixmap(v,par,LINESTYLEICON,DASHDOUBLEDOTTEDICON);
				v->linestyle = DASH_DOUBLE_DOTTED;
				if (isselob(v))
					{
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->ls = v->linestyle;
					if (selobtype(v,TEXT) && selob(v)->ob.text.node)
						selob(v)->ob.text.ellipse->ls = selob(v)->ls;
					send_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;

			case DASHTRIPLEDOTTEDICON:
				icon_swap_pixmap(v,par,LINESTYLEICON,DASHTRIPLEDOTTEDICON);
				v->linestyle = DASH_TRIPLE_DOTTED;
				if (isselob(v))
					{
					register_undo(UNDO_OB_PROP, selob(v), v->doc);
					selob(v)->ls = v->linestyle;
					if (selobtype(v,TEXT) && selob(v)->ob.text.node)
						selob(v)->ob.text.ellipse->ls = selob(v)->ls;
					send_redraw_object(v, selob(v));
					};
				v = (View *)-1;
				break;
			
			default:
				/* other cases below  */ 
				break; 
			};
		 
		/* did we hit a case ?  */   
		if (v==(View *)-1)
			{
			state.menu_view=NULL;
			return;
			}; 
		};

	/* these icons open up an icon menu  */  
	if (icon==JUSTIFICATIONICON ||
		 icon==COLOURICON ||
		 icon==FILLCOLOURICON ||
		 icon==FILLSTYLEICON ||
		 icon==SETARCELLIPSEICON ||
		 icon==ENDSTYLEICON ||
		 icon==JOINSTYLEICON ||
		 icon==LINESTYLEICON)
		{
		l = where_in_list(wins, (ulong)par);
		l = where_in_list(wins, (ulong)WS(l)->parent); 
		XUngrabPointer(display,CurrentTime);
		state.menu_view = VIEW(l); 
		XQueryPointer(display,RootWindow(display,screen),&w1,&w1,&x1,&y1,&idum, &idum, &indum); 
		
		/* open suitable menu  */  
		switch (icon)
			{
			case JUSTIFICATIONICON:
				stk_display_icon_menu(justification_menu, x1,y1, TRUE, Button3);
				break;
			 
			case COLOURICON:
				stk_display_icon_menu(colour_menu, x1, y1, TRUE, Button3);
				break;

			case FILLCOLOURICON:
				stk_display_icon_menu(fillcolour_menu, x1, y1, TRUE, Button3);
				break;

			case FILLSTYLEICON:
				stk_display_icon_menu(fillstyle_menu, x1,y1, TRUE, Button3);
				break; 
			 
			case SETARCELLIPSEICON:
				stk_display_icon_menu(setarcellipse_menu, x1,y1, TRUE, Button3);
				break;

			case ENDSTYLEICON:
				stk_display_icon_menu(endstyle_menu, x1,y1, TRUE, Button3);
				break;

			case JOINSTYLEICON:
				stk_display_icon_menu(joinstyle_menu, x1,y1, TRUE, Button3);
				break;
			 
			case LINESTYLEICON:
				stk_display_icon_menu(linestyle_menu, x1,y1, TRUE, Button3);
				break; 
			
			default:
				v_error(icon);
				break; 
			};
		return;
		};

	/* common or garden icons now  */  
	
	l = where_in_list(wins, (ulong)par);

	switch (icon)
		{
 		case EYEICON:
			stk_display_menu(VIEW(l),vmw, VIEW(l)->window.x, VIEW(l)->window.y + 21, Button3);
			break;

		case GRIDICON:
			l2 = where_in_list(wins, WS(l)->parent);
			/* could be from keyboard, should set icon */  
			((VIEW(l2)->gridon = !VIEW(l2)->gridon)==TRUE)
				?  stk_select_icon(GRIDICON,VIEW(l2)->view_icon_window->win) 
				:  stk_unselect_icon(GRIDICON,VIEW(l2)->view_icon_window->win); 
			break;

		case SHOWGRIDICON:
			l2 = where_in_list(wins, WS(l)->parent);
			/* could be from keyboard, should set icon */  
			((VIEW(l2)->showgrid = !VIEW(l2)->showgrid)==TRUE)
				?  stk_select_icon(SHOWGRIDICON,VIEW(l2)->view_icon_window->win) 
				:  stk_unselect_icon(SHOWGRIDICON,VIEW(l2)->view_icon_window->win); 
			redraw_view_window(VIEW(l2)); 
			break;

		case ZOOMINICON:
			l2 = where_in_list(wins, WS(l)->parent);
			zoom_in(VIEW(l2),TRUE); 
			break;
			 
		case ZOOMOUTICON:
			l2 = where_in_list(wins, WS(l)->parent);
			zoom_out(VIEW(l2),TRUE); 
			break;
			 
		case LINEWIDTHICON:
			l2 = where_in_list(wins, WS(l)->parent);
			if (isselob(VIEW(l2))) 
				dialog_text_val(lw_entry, selob(VIEW(l2))->lw);
			else
				dialog_text_val(lw_entry, VIEW(l2)->linewidth); 
										 
			stk_open_dialog(lw_dialog,VIEW(l2)); 
			break;

		case SETSPLINEICON: 
			l2 = where_in_list(wins, WS(l)->parent);
			if (VIEW(l2)->closed)
				stk_choice_on(spline_choice,0);
			else
				stk_choice_off(spline_choice,0); 
				 
			stk_set_slider_pos(spline_slider,(VIEW(l2)->current_sfactor+1.0)/2.0);
			sprintf(a, "%.2f", VIEW(l2)->current_sfactor);
			stk_set_text_entry(spline_entry,a); 
			stk_open_dialog(spline_dialog,VIEW(l2)); 
			break; 
			 
		case FONTICON: 
			l2 = where_in_list(wins, WS(l)->parent);
				 
			dialog_text_val(font_entry, VIEW(l2)->fontsize);
			stk_unselect_textlist(font_size_text); 
			sprintf(a,"%d",VIEW(l2)->fontsize); 
			stk_select_textlist_member(font_size_text,a);
			stk_unselect_textlist(font_typeface_text); 
			stk_select_textlist_member(font_typeface_text,fontnames[VIEW(l2)->fontnum][1]); 
			stk_open_dialog(font_dialog,VIEW(l2)); 
			break; 
			 
		case ARROWICON:
			l2 = where_in_list(wins, WS(l)->parent);
				 
			if (!isselob(VIEW(l2)) || !selob(VIEW(l2))->farrow)
				{
				(VIEW(l2)->farrow_on) ? stk_choice_on(rarrow_choice,0) : stk_choice_off(rarrow_choice,0);
				(VIEW(l2)->farrow.filled) ?  stk_choice_on(rarrow_fillchoice,0)
							  :  stk_choice_off(rarrow_fillchoice,0);
					
				dialog_text_val(rarrow_thickness,VIEW(l2)->farrow.lw); 
				dialog_text_val(rarrow_width,VIEW(l2)->farrow.w); 
				dialog_text_val(rarrow_height,VIEW(l2)->farrow.h); 
				set_arrow_radio(VIEW(l2)->farrow.type,rarrow_type); 
				};

			if (!isselob(VIEW(l2)) || !selob(VIEW(l2))->barrow)
				{ 
				(VIEW(l2)->barrow_on) ? stk_choice_on(larrow_choice,0) : stk_choice_off(larrow_choice,0);
				(VIEW(l2)->barrow.filled) ?  stk_choice_on(larrow_fillchoice,0)
							  :  stk_choice_off(larrow_fillchoice,0);
					
				dialog_text_val(larrow_thickness,VIEW(l2)->barrow.lw); 
				dialog_text_val(larrow_width,VIEW(l2)->barrow.w); 
				dialog_text_val(larrow_height,VIEW(l2)->barrow.h); 
				set_arrow_radio(VIEW(l2)->barrow.type,larrow_type); 
				};

			if (isselob(VIEW(l2)))
				{
				if (selob(VIEW(l2))->farrow)
					{
					stk_choice_on(rarrow_choice,0);
					(selob(VIEW(l2))->farrow->filled) ?  stk_choice_on(rarrow_fillchoice,0)
									 :  stk_choice_off(rarrow_fillchoice,0);
					
					dialog_text_val(rarrow_thickness,selob(VIEW(l2))->farrow->lw); 
					dialog_text_val(rarrow_width,selob(VIEW(l2))->farrow->w); 
					dialog_text_val(rarrow_height,selob(VIEW(l2))->farrow->h); 
					set_arrow_radio(selob(VIEW(l2))->farrow->type,rarrow_type); 
					};

				if (selob(VIEW(l2))->barrow)
					{
					stk_choice_on(larrow_choice,0);
					(selob(VIEW(l2))->barrow->filled) ?  stk_choice_on(larrow_fillchoice,0)
									 :  stk_choice_off(larrow_fillchoice,0);
					
					dialog_text_val(larrow_thickness,selob(VIEW(l2))->barrow->lw); 
					dialog_text_val(larrow_width,selob(VIEW(l2))->barrow->w); 
					dialog_text_val(larrow_height,selob(VIEW(l2))->barrow->h); 
					set_arrow_radio(selob(VIEW(l2))->barrow->type,larrow_type); 
					};
				};
				 
			stk_open_dialog(arrow_dialog,VIEW(l2)); 
			break; 
				  
		case SETPOLYGONICON: 
			l2 = where_in_list(wins, WS(l)->parent);
			(VIEW(l2)->regular) ? stk_choice_on(polygon_choice,0) : stk_choice_off(polygon_choice,0); 
			dialog_text_val(polygon_entry,VIEW(l2)->sides); 
			stk_open_dialog(polygon_dialog,VIEW(l2)); 
			break; 
			 
		case ROUNDBOXICON: 
			l2 = where_in_list(wins, WS(l)->parent);
			if (isselob(VIEW(l2))) 
				{
				if (selob(VIEW(l2))->type==ROUNDBOX)
					{
					stk_choice_on(roundbox_choice,0);
					dialog_text_val(roundbox_entry,selob(VIEW(l2))->ob.roundbox.radius); 
					} 
				else
					dialog_text_val(roundbox_entry,VIEW(l2)->roundsize); 
				} 
			else
				{
				if (VIEW(l2)->roundbox)
					stk_choice_on(roundbox_choice,0);
				else
					stk_choice_off(roundbox_choice,0); 
				dialog_text_val(roundbox_entry,VIEW(l2)->roundsize); 
				}; 
				 
			stk_open_dialog(roundbox_dialog,VIEW(l2)); 
			break; 
		
		default:
			v_error(icon); 
			break; 
		};
} 

void dialog_text_val(Window te, long val)
{
	char a[100];

	sprintf(a,"%ld",val);
	stk_set_text_entry(te,a);
}

/* convenience function for setting up
	arrow dialog */  
void 
set_arrow_radio(uint type, Window win)
{
 
	switch (type)
		{
		case ARROWSTICK:
			stk_choice_on(win,1); 
			stk_choice_off(win,2); 
			stk_choice_off(win,3); 
			stk_choice_off(win,4); 
			break;

		case ARROWFLAT:
			stk_choice_off(win,1); 
			stk_choice_on(win,2); 
			stk_choice_off(win,3); 
			stk_choice_off(win,4); 
			break;

		case ARROWINDENTED:
			stk_choice_off(win,1); 
			stk_choice_off(win,2); 
			stk_choice_on(win,3); 
			stk_choice_off(win,4); 
			break;

		case ARROWPOINTED:
			stk_choice_off(win,1); 
			stk_choice_off(win,2); 
			stk_choice_off(win,3); 
			stk_choice_on(win,4); 
			break;
		};
}
