/* handle_menu.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* various menu functions handled  */  
/*
 * $Log: handle_menu.c,v $
 * Revision 1.7  2001/01/31 15:38:06  movement
 * pre11 - fix netscape, add metapost support, credit foggy
 *
 * Revision 1.7  2001/01/29 20:57:28  moz
 * Make netscape work again, metapost support.
 *
 * Revision 1.6  2000/12/17 00:57:42  moz
 * examples, filled open splines, highlight_objects
 *
 * Revision 1.5  2000/12/08 22:33:33  moz
 * Clean up possibly unsafe tmp file handling.
 *
 * Revision 1.4  2000/12/08 02:45:54  moz
 * Quit even if user saved on the way out.
 *
 * Minor webpage fixes
 *
 * Revision 1.3  2000/12/06 20:56:02  moz
 * GPL stuff.
 *
 * Revision 1.2  2000/09/05 00:54:50  moz
 * Make system() calls secure.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.26  2000/05/03 21:41:20  moz
 * Was dropping the percent on title on save ...
 *
 * Revision 1.25  2000/03/22 15:37:17  moz
 * Fix stupid typo.
 *
 * Revision 1.24  2000/03/07 21:40:16  moz
 * Compile fixes.
 *
 * Revision 1.23  2000/03/01 18:38:27  moz
 * If $BROWSER is netscape, still use -remote.
 *
 * Revision 1.22  2000/01/30 17:20:39  moz
 * Set check_dial to 0 to show it's closed.
 *
 * Revision 1.21  2000/01/26 18:12:38  moz
 * Make sure to call stk_clear_textlist
 * where appropriate.
 *
 * Revision 1.20  1999/11/15 02:09:34  moz
 * Name change.
 *
 * Revision 1.19  1999/08/08 20:54:56  moz
 * From clean up of structs.
 *
 * Revision 1.18  1999/06/16 00:56:12  moz
 * Use netscape -remote when possible.
 *
 * Revision 1.17  1999/05/19 17:10:28  moz
 * 1.0 Checkin.
 *
 * Revision 1.16  1999/05/05 12:28:51  moz
 * Print dialog.
 *
 * Revision 1.15  1999/05/04 15:49:17  moz
 * Moved duplicate_object() and kill_object() to object.c
 *
 * Revision 1.14  1999/05/03 06:21:26  moz
 * fill_in_file takes .fig filter option.
 *
 * Revision 1.13  1999/04/29 22:06:24  moz
 * Removed notify_compound_undo.
 *
 * Revision 1.12  1999/04/29 22:01:52  moz
 * Move move_object to remove duplicate objects on paste_object.
 *
 * Revision 1.11  1999/04/28 23:47:29  moz
 * Place paste with move_object.
 * Set pasted object's depth to correct value.
 *
 * Revision 1.10  1999/04/28 15:11:40  moz
 * Strip trailing slash from FIGURINEDIR env var.
 *
 * Revision 1.9  1999/04/27 07:39:48  moz
 * When copying compound, link into undo stack.
 *
 * Revision 1.8  1999/04/27 06:45:32  moz
 * load and insert_file need cmdline==FALSE
 *
 * Revision 1.7  1999/04/27 04:10:50  moz
 * -Wall appeased.
 *
 * Revision 1.6  1999/04/25 19:44:22  moz
 * Copy text angle in duplicate_object
 *
 * Revision 1.5  1999/04/23 00:39:39  moz
 * redraw_view_window change.
 *
 * Revision 1.4  1999/04/22 22:16:25  moz
 * Check there's something to paste in paste_object.
 *
 * Revision 1.3  1999/04/04 01:49:47  moz
 * Correct help implementation.
 * Export dialog functionality.
 *
 * Revision 1.2  1999/04/03 21:12:50  moz
 * start_help function.
 *
 * Revision 1.1  1999/03/30 00:05:08  moz
 * Initial revision
 *
 */    

#include "include/figurine.h"
#include "include/extern.h"

Object *buffer=NULL; /* our cut buffer  */  

void 
cut_object(View *view, Object *ob)
{
	register_undo(UNDO_CUT,ob,view->doc); 
	view->doc->o = trash_object(view->doc->o,&view->doc->lo,ob);
	/* if buffer's full already, delete the buffer */  
	if (buffer!=NULL)
		kill_object(buffer);
	
 	buffer = ob; 
}

void 
copy_object(Object *ob)
{
	/* if buffer's full already, delete the buffer */  
	if (buffer!=NULL)
		kill_object(buffer);
	
	buffer = duplicate_object(ob);

}

void 
paste_object(View *view, long x, long y)
{
	Object *ob;

	if (view->highlighted_object!=NULL)
		send_redraw_object(view,view->highlighted_object->ob);

	if (buffer==NULL)
		return;

	ob = duplicate_object(buffer);
	
	ob->depth = view->doc->ob_depth--; 
	
	view->doc->o = add_object(view->doc->o, &view->doc->lo, ob); 
	/* move pasted object to current cursor position  */  
	move_object(view,ob,x-ob->bbox.x1,y-ob->bbox.y1); 

	view->selected_object = get_object_node(view->doc->o, ob);
	view->highlighted_object = view->selected_object;
	send_redraw_object(view,ob); 
	register_undo(UNDO_PASTE,ob,view->doc); 
}

/* user asked for Help ^H  */  
void
start_help()
{
	char *e;
	char *f; 
	char s[FIGURINE_PATH_MAX]; 
	char t[FIGURINE_PATH_MAX]; 

	e = getenv("FIGURINEDIR");
	f = getenv("BROWSER"); 

	/* if user has already set netscape, we'd like to
	   still use remote functionality */
	if (f && streq(f,"netscape"))
		f=NULL;

	/* strip terminating / if there */  
	if (e && strlen(e) && e[strlen(e)-1]=='/')
		{
		strncpy(t,e,FIGURINE_PATH_MAX);
		t[strlen(t)-1]='\0'; 
		e = t;
		};
		 
	if (e)
		{
		/* FIGURINEDIR has been set  */  
		if (f)
			sprintf(s,"%s '%s/index.html' &",f,e);
		else
			sprintf(s, "sh -c 'netscape -remote \"openURL(%s/index.html,new-window)\"; if test \"$?\" -ne 0 ; then (netscape \"%s/index.html\" &) ; fi'",e,e);
		} 
	else
		{ 
		/* use compiled in FIGINTDIR instead  */  
		if (f)
			sprintf(s,"%s '%s/index.html' &",f,FIGINTDIR);
		else
			sprintf(s, "sh -c 'netscape -remote \"openURL(%s/index.html,new-window)\"; if test \"$?\" -ne 0 ; then (netscape \"%s/index.html\" &) ; fi'",FIGINTDIR,FIGINTDIR);
		}; 

	/* spawn browser */
	system(s);
}

/* a button has been pressed on a dialog.
	determine the dialog, the button, and react
	appropriately */  
void 
handle_dialog(XEvent report, ulong dw)
{
	View *v;
	char a[FIGURINE_PATH_MAX];

	/******************** file dialog  */  
	if (dw==(ulong)file_dialog)
		{
		if (report.xclient.window==file_ok)
			{
			 
			stk_get_text_entry(file_entry, a); 
			if (is_directory(a))
				{
				if (streq("../",a))
					strip_end_dir(state.cwd);
				else
					{
					strcpy(state.cwd, a);
					};
				stk_clear_textlist(lfile_text);
				stk_clear_textlist(rfile_text);
				stk_unselect_textlist(lfile_text); 
				stk_unselect_textlist(rfile_text); 

				chdir(state.cwd);
				fill_in_file(lfile_text,rfile_text,state.show_fig_files_only);
				stk_set_text_entry(file_entry, state.cwd);
				} 
			else
				{
				load(a,FALSE); 
				stk_clear_textlist(lfile_text);
				stk_clear_textlist(rfile_text);
				stk_close_dialog(file_dialog);
				};
			}
		else if (report.xclient.window==file_cancel)
			{
			stk_clear_textlist(lfile_text);
			stk_clear_textlist(rfile_text);
			stk_close_dialog(file_dialog);
			};
		}
	/************** savefile dialog  */  
	else if (dw==(ulong)savefile_dialog)
		{
		if (report.xclient.window==savefile_ok)
			{
			 
			stk_get_text_entry(savefile_entry, a); 
			if (is_directory(a))
				{
				if (streq("../",a))
					strip_end_dir(state.cwd);
				else
					{
					strcpy(state.cwd, a);
					};
				stk_clear_textlist(savelfile_text);
				stk_clear_textlist(saverfile_text);
				stk_unselect_textlist(savelfile_text); 
				stk_unselect_textlist(saverfile_text); 

				chdir(state.cwd);
				fill_in_file(savelfile_text,saverfile_text,state.show_fig_files_only);
				stk_set_text_entry(savefile_entry, state.cwd);
				} 
			else
				{
				char s[FIGURINE_PATH_MAX];
				char a2[20]; 
				int c = strlen(a);
				v=((View *)report.xclient.data.l[1]); 
				
				save_name(v->doc,a);  
				strcpy(s,a);
				while (strlen(s) && s[strlen(s)-1]!='/')
					{
					s[strlen(s)-1] = '\0';
					c--;
					};

				strcpy(v->doc->pathname,s);
				strcpy(v->doc->filename,a+c);
				sprintf(a2," (%.1f%%)",v->zoom_factor*100); 
				strcat(a, a2); 
				set_window_name(&v->window,a); 
				stk_clear_textlist(savelfile_text);
				stk_clear_textlist(saverfile_text);
				stk_close_dialog(savefile_dialog);
				};
			}
		else if (report.xclient.window==savefile_cancel)
			{
			stk_clear_textlist(savelfile_text);
			stk_clear_textlist(saverfile_text);
			stk_close_dialog(savefile_dialog);
			};
		}
	/************** insertfile dialog  */  
	else if (dw==(ulong)insertfile_dialog)
		{
		if (report.xclient.window==insertfile_ok)
			{
			 
			stk_get_text_entry(insertfile_entry, a); 
			if (is_directory(a))
				{
				if (streq("../",a))
					strip_end_dir(state.cwd);
				else
					{
					strcpy(state.cwd, a);
					};
				stk_clear_textlist(insertlfile_text);
				stk_clear_textlist(insertrfile_text);
				stk_unselect_textlist(insertlfile_text); 
				stk_unselect_textlist(insertrfile_text); 

				chdir(state.cwd);
				fill_in_file(insertlfile_text,insertrfile_text,state.show_fig_files_only);
				stk_set_text_entry(insertfile_entry, state.cwd);
				} 
			else
				{
				List l;

				insert_file(((View *)report.xclient.data.l[1])->doc,a,FALSE,FALSE); 
				stk_clear_textlist(insertlfile_text);
				stk_clear_textlist(insertrfile_text);
				stk_close_dialog(insertfile_dialog);
				l = ((View *)report.xclient.data.l[1])->doc->views;
				while (l!=NULL)
					{ 
					redraw_view_window(VIEW(l)); 
					l = l->next;
					};
				};
			}
		else if (report.xclient.window==insertfile_cancel)
			{
			stk_clear_textlist(insertlfile_text);
			stk_clear_textlist(insertrfile_text);
			stk_close_dialog(insertfile_dialog);
			};
		} 
	/************** exportfile dialog  */  
	else if (dw==(ulong)exportfile_dialog)
		{
		if (report.xclient.window==exportfile_ok)
			{
			 
			stk_get_text_entry(exportfile_entry, a); 
			if (is_directory(a))
				{
				if (streq("../",a))
					strip_end_dir(state.cwd);
				else
					{
					strcpy(state.cwd, a);
					};
				stk_clear_textlist(exportlfile_text);
				stk_clear_textlist(exportrfile_text);
				stk_unselect_textlist(exportlfile_text); 
				stk_unselect_textlist(exportrfile_text); 

				chdir(state.cwd);
				fill_in_file(exportlfile_text,exportrfile_text,FALSE);
				stk_set_text_entry(exportfile_entry, state.cwd);
				} 
			else
				{
				export_name(((View *)report.xclient.data.l[1])->doc,a,stk_get_textlist_selection_num(exportformat_text));
				stk_clear_textlist(exportlfile_text);
				stk_clear_textlist(exportrfile_text);
				stk_close_dialog(exportfile_dialog);
				};
			}
		else if (report.xclient.window==exportfile_cancel)
			{
			stk_clear_textlist(exportlfile_text);
			stk_clear_textlist(exportrfile_text);
			stk_close_dialog(exportfile_dialog);
			};
		} 
	/******************** view dialog  */  
	else if (dw==(ulong)view_dialog)
		{
		if (report.xclient.window==view_ok || report.xclient.window==view_apply)
			{
			double d,dy; 

			v = (View *)report.xclient.data.l[1];
			stk_get_text_entry(view_gridx_entry, a); 
			sscanf(a,"%lf",&d); 
			stk_get_text_entry(view_gridy_entry, a); 
			sscanf(a,"%lf",&dy); 
			if (stk_get_choice(view_units,1)!=v->in_mm)
				{
				v->in_mm = !v->in_mm;
				REDRAW_ALL_WINDOW(v->ruler_x_window);
				REDRAW_ALL_WINDOW(v->ruler_y_window);
				}; 
				
			if (stk_get_choice(view_guides,0)!=v->guide_lines)
				{
				v->guide_lines = !v->guide_lines;
				v->guide_lines_displayed = FALSE; 
				redraw_view_window(v); 
				};

			if (stk_get_choice(view_highlight,0)!=v->highlight_objects)
				{
				v->highlight_objects = !v->highlight_objects;
				redraw_view_window(v);
				};

			if (stk_get_choice(view_compounds,0)!=v->show_compounds)
				{
				v->show_compounds = !v->show_compounds;
				redraw_view_window(v); 
				};

			if (v->grid_x != (long)min(2400,max(10,v->doc->ppi*d)) ||
				 v->grid_y != (long)min(2400,max(10,v->doc->ppi*dy)))
				{
				v->grid_x = (long)min(2400,max(10,v->doc->ppi*d));
				v->grid_y = (long)min(2400,max(10,v->doc->ppi*dy));
				if (v->showgrid)
					redraw_view_window(v); 
				}; 
			if (report.xclient.window==view_ok) 
				stk_close_dialog(view_dialog);
			}
		else if (report.xclient.window==view_cancel)
			stk_close_dialog(view_dialog);
		} 	
	/************* lw dialog */ 
	else if (dw==(ulong)lw_dialog)
		{
		if (report.xclient.window==lw_ok || report.xclient.window==lw_apply)
			{
			long val;

			v = (View *)report.xclient.data.l[1];
			
			stk_get_text_entry(lw_entry,a);

			sscanf(a,"%ld",&val);

			if (val<0)
				val = 0; 
				
			if (val>40)
				val = 40;
			
			if (v->selected_object!=NULL)
				{
				register_undo(UNDO_OB_PROP,v->selected_object->ob,v->doc); 
				store_redraw_object(v->selected_object->ob);
				v->selected_object->ob->lw = val;
				if (v->selected_object->ob->type==TEXT &&
					 v->selected_object->ob->ob.text.node)
					{
					v->selected_object->ob->ob.text.ellipse->lw = val;
					};
				send_stored_redraw_object(v,v->selected_object->ob);
				}
			else
				{ 
				v->linewidth = val;
				v->farrow.lw = val;
				v->barrow.lw = val;
				}; 
				 
			if (report.xclient.window==lw_apply)
				{
				sprintf(a,"%ld",val);
				stk_set_text_entry(lw_entry,a);
				}
			else if (report.xclient.window==lw_ok) 
				stk_close_dialog(lw_dialog);
			}
		else
			stk_close_dialog(lw_dialog);
		}
	/************ roundbox dialog  */ 	
	else if (dw==(ulong)roundbox_dialog) 
		{
		if (report.xclient.window==roundbox_ok || report.xclient.window==roundbox_apply)
			{
			long val;
			
			v = (View *)report.xclient.data.l[1];
			
			v->roundbox = stk_get_choice(roundbox_choice,0);
			stk_get_text_entry(roundbox_entry,a);

			sscanf(a,"%ld",&val);

			if (val<1)
				val = 1; 
				
			if (val>40)
				val = 40;
			
			if (v->selected_object!=NULL && v->selected_object->ob->type==ROUNDBOX)
				{
				register_undo(UNDO_OB_PROP,v->selected_object->ob,v->doc); 
				store_redraw_object(v->selected_object->ob);
				v->selected_object->ob->ob.roundbox.radius = val;
				send_stored_redraw_object(v,v->selected_object->ob);
				}
			else
				v->roundsize = val;
				 
			if (report.xclient.window==roundbox_apply)
				{
				sprintf(a,"%ld",val);
				stk_set_text_entry(roundbox_entry,a);
				}
			else if (report.xclient.window==roundbox_ok) 
				stk_close_dialog(roundbox_dialog);
			}
		else
			stk_close_dialog(roundbox_dialog);
		} 
		/************ polygon dialog  */ 	
	else if (dw==(ulong)polygon_dialog) 
		{
		if (report.xclient.window==polygon_ok || report.xclient.window==polygon_apply)
			{
			long val;
			
			v = (View *)report.xclient.data.l[1];
			
			v->regular = stk_get_choice(polygon_choice,0);
			stk_get_text_entry(polygon_entry,a);

			sscanf(a,"%ld",&val);

			if (val<3)
				val = 3; 
				
			if (val>128)
				val = 128;
			
			v->sides = val;
			v->side_angle = (PI*2.0)/v->sides; 
				 
			if (report.xclient.window==polygon_apply)
				{
				sprintf(a,"%ld",val);
				stk_set_text_entry(polygon_entry,a);
				}
			else if (report.xclient.window==polygon_ok) 
				stk_close_dialog(polygon_dialog);
			}
		else
			stk_close_dialog(polygon_dialog);
		}  
	/************ spline dialog  */ 	
	else if (dw==(ulong)spline_dialog) 
		{
		if (report.xclient.window==spline_ok || report.xclient.window==spline_apply)
			{
			double val;
			
			v = (View *)report.xclient.data.l[1];
			
			v->closed = stk_get_choice(spline_choice,0);
		
			stk_get_text_entry(spline_entry,a);

			sscanf(a,"%lf",&val);
			v->current_sfactor = max(-1.0,min(1.0,val));
			
			if (report.xclient.window==spline_apply)
				{
				sprintf(a,"%.2f",v->current_sfactor);
				stk_set_text_entry(spline_entry, a);
				stk_set_slider_pos(spline_slider,(v->current_sfactor+1.0)/2.0);   
				}
			else if (report.xclient.window==spline_ok) 
				stk_close_dialog(spline_dialog);
			}
		else
			stk_close_dialog(spline_dialog);
		}   
	/************ font dialog  */ 	
	else if (dw==(ulong)font_dialog) 
		{
		int val;
		
		v = (View *)report.xclient.data.l[1];
		
		stk_get_text_entry(font_entry,a);

		sscanf(a,"%d",&val);
		v->fontsize = max(5,min(300,val));

		v->fontnum = stk_get_textlist_selection_num(font_typeface_text);
		
		stk_close_dialog(font_dialog);
		}  
	/************* arrow dialog  */
	else if (dw==(ulong)arrow_dialog)
		{
		v = (View *)report.xclient.data.l[1];

		if (report.xclient.window==arrow_cancel)
			{ 
			stk_close_dialog(arrow_dialog); 
			return;
			}; 

		if (v->selected_object!=NULL)
			{
			Arrow ar; 
			Object *ob = v->selected_object->ob; 
			 
			register_undo(UNDO_OB_PROP,v->selected_object->ob,v->doc); 
			store_redraw_object(ob); 
			 
			if (stk_get_choice(rarrow_choice,0))
				{
				ar.filled = stk_get_choice(rarrow_fillchoice,0); 
				stk_get_text_entry(rarrow_thickness,a);
				sscanf(a,"%ld",&ar.lw);
				stk_get_text_entry(rarrow_width,a);
				sscanf(a,"%ld",&ar.w);
				stk_get_text_entry(rarrow_height,a);
				sscanf(a,"%ld",&ar.h);
				if (stk_get_choice(rarrow_type,1))
					ar.type = ARROWSTICK;
				else if (stk_get_choice(rarrow_type,2))
					ar.type = ARROWFLAT;
				else if (stk_get_choice(rarrow_type,3))
					ar.type = ARROWINDENTED;
				else
					ar.type = ARROWPOINTED;
					 
				if (ob->farrow!=NULL)
					free(ob->farrow);
				ob->farrow = make_arrow(ar);
				}
			else
				{
				if (ob->farrow!=NULL)
					free (ob->farrow);
				};
			if (stk_get_choice(larrow_choice,0))
				{
				ar.filled = stk_get_choice(larrow_fillchoice,0); 
				stk_get_text_entry(larrow_thickness,a);
				sscanf(a,"%ld",&ar.lw);
				stk_get_text_entry(larrow_width,a);
				sscanf(a,"%ld",&ar.w);
				stk_get_text_entry(larrow_height,a);
				sscanf(a,"%ld",&ar.h);
				if (stk_get_choice(larrow_type,1))
					ar.type = ARROWSTICK;
				else if (stk_get_choice(larrow_type,2))
					ar.type = ARROWFLAT;
				else if (stk_get_choice(larrow_type,3))
					ar.type = ARROWINDENTED;
				else
					ar.type = ARROWPOINTED;
					 
				if (ob->barrow!=NULL)
					free(ob->barrow);
				ob->barrow = make_arrow(ar);
				}
			else
				{
				if (ob->barrow!=NULL)
					free (ob->barrow);
				};
			send_stored_redraw_object(v,ob); 
			}
		else
			{
			v->farrow_on = stk_get_choice(rarrow_choice,0);
			v->barrow_on = stk_get_choice(larrow_choice,0);
			v->farrow.filled = stk_get_choice(rarrow_fillchoice,0); 
			v->barrow.filled = stk_get_choice(larrow_fillchoice,0); 
			stk_get_text_entry(rarrow_thickness,a);
			sscanf(a,"%ld",&v->farrow.lw);
			stk_get_text_entry(larrow_thickness,a);
			sscanf(a,"%ld",&v->barrow.lw);
			stk_get_text_entry(rarrow_width,a);
			sscanf(a,"%ld",&v->farrow.w);
			stk_get_text_entry(larrow_width,a);
			sscanf(a,"%ld",&v->barrow.w);
			stk_get_text_entry(rarrow_height,a);
			sscanf(a,"%ld",&v->farrow.h);
			stk_get_text_entry(larrow_height,a);
			sscanf(a,"%ld",&v->barrow.h);
			if (stk_get_choice(rarrow_type,1))
				v->farrow.type = ARROWSTICK;
			else if (stk_get_choice(rarrow_type,2))
				v->farrow.type = ARROWFLAT;
			else if (stk_get_choice(rarrow_type,3))
				v->farrow.type = ARROWINDENTED;
			else
				v->farrow.type = ARROWPOINTED;
				 
			if (stk_get_choice(larrow_type,1))
				v->barrow.type = ARROWSTICK;
			else if (stk_get_choice(larrow_type,2))
				v->barrow.type = ARROWFLAT;
			else if (stk_get_choice(larrow_type,3))
				v->barrow.type = ARROWINDENTED;
			else
				v->barrow.type = ARROWPOINTED;
			};
		if (report.xclient.window==arrow_ok)
			stk_close_dialog(arrow_dialog); 
		}
	/* ******* print file dialog  */  
	else if (dw==(ulong)printfile_dialog)
		{
		v=((View *)report.xclient.data.l[1]); 
		stk_get_text_entry(printfile_entry,a);
		strncpy(state.print,a,100);
		if (report.xclient.window==printfile_cancel) 
			stk_close_dialog(dw); 
		else
			{
			char b[FIGURINE_PATH_MAX]; 
			char *name;
			v->doc->centred = stk_get_choice(printfile_choice,1);
			stk_close_dialog(dw); 
			name = export_name(v->doc,NULL,EXPORT_PS);
			if (name!=NULL) 
				{
				sprintf(b,"sh -c \"'%s' '%s'\"",state.print,name);
				if (system(b)!=0)
					{
					strcpy(a,"Could not print using command ");
					strcat(a,b);
					strcat(a,"\n");
					stk_open_info(a);
					};
				free(name);
				};
			};
		}
	/********* save check message  */  
	else
		{
		List l = docs; 

		while (l!=NULL)
			{
			if (report.xclient.window==DOC(l)->check_save) 
				{
				DOC(l)->check_dial=0; 
				save(DOC(l)); 
				really_close_doc(DOC(l)); 
				stk_close_dialog(dw); 
				if (quitting)
					close_down();
				break; 
				}
			else if (report.xclient.window==DOC(l)->check_close) 
				{
				DOC(l)->check_dial=0; 
				really_close_doc(DOC(l)); 
				stk_close_dialog(dw); 
				if (quitting)
					close_down();
				break; 
				}
			else if (report.xclient.window==DOC(l)->check_cancel) 
				{ 
				if (quitting)
					quitting=FALSE;
				DOC(l)->check_dial=0; 
				stk_close_dialog(dw); 
				break;
				};

			l = l->next;
			};
		
		if (l==NULL)
			stk_close_dialog(dw);
		};
}
