/* list.o  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* provides utility functions for linked lists  */
/*
 * $Log: list.c,v $
 * Revision 1.2  2000/12/06 20:56:02  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.11  2000/02/18 03:04:47  moz
 * Compile fixes.
 *
 * Revision 1.10  2000/01/28 17:01:55  moz
 * Unravelled where_in_list and is_in_list*
 * Fixed compiler warnings.
 *
 * Revision 1.9  2000/01/26 18:57:50  moz
 * Don't recurse delete_list().
 *
 * Revision 1.8  2000/01/26 18:17:24  moz
 * Introduce FIG_DEBUG_LIST_ALLOC.
 *
 * Revision 1.7  1999/11/15 02:08:48  moz
 * Name change.
 *
 * Revision 1.6  1999/06/30 18:06:57  moz
 * Removed old commented-out code.
 *
 * Revision 1.5  1999/05/24 01:01:27  moz
 * Create non-recursive add_to_list_*
 *
 * Revision 1.4  1999/05/22 03:53:44  moz
 * It would be helpful if add_to_list_neq recursed to itself, not
 * add_to_list.
 *
 * Revision 1.3  1999/05/22 02:54:02  moz
 * Added add_to_list_neq (places new equal id value afterwards).
 *
 * Revision 1.2  1999/05/04 15:50:04  moz
 * Merged in insert_before and insert_after.
 *
 * Revision 1.1  1999/03/30 00:05:19  moz
 * Initial revision
 *
 */    

#include <stdlib.h> 
#include "include/figurine.h"

inline List 
create_list(ulong id, ulong type, void *data)
{
	ListEl *list;
	
	list = (ListEl *) malloc(sizeof(ListEl));

	if (list == NULL)
		return NULL;
	
	list->id = id;
	list->type = type;
	list->data = data;
	list->next = NULL;
	list->prev = NULL;

#ifdef FIG_DEBUG_LIST_ALLOC
	fprintf(stderr,"figurine: create_list called %d,%d,%p\n",id,type,list); 
#endif
	return list;
}

inline void
delete_list(List list)
{
	List l,l2;

#ifdef FIG_DEBUG_LIST_ALLOC
	fprintf(stderr,"figurine: delete_list called\n"); 
#endif
 
 	l=list;
	while (l!=NULL)
		{
		l2=l->next;
		free(l);
		l=l2;
		}; 
}

inline List
add_to_list_neq0(List list, ulong id, ulong type, void *data)
{
	ListEl *listelp;
	List l=list; 
	List l2=NULL; 
#ifdef FIG_DEBUG_LIST_ALLOC
	int i=0; 
#endif
	 
	listelp = (ListEl *)malloc(sizeof(ListEl));
	 
#ifdef FIG_DEBUG_LIST_ALLOC
	l2=list;
	while (l2!=NULL)
		{
		i++;
		l2=l2->next;
		}; 
	l2=NULL; 
	fprintf(stderr,"figurine: add_to_list_neq size %d: %d,%d\n",i,id,type,listelp); 
#endif
 
	listelp->id = id; 
	listelp->type = type;
	listelp->data = data; 
	while (l!=NULL) 
		{
		if (l->id > id)
			{
			listelp->prev = l->prev;
			listelp->next = l; 
			if (l->prev!=NULL)
				l->prev->next = listelp;
			l->prev = listelp; 
			if (listelp->prev==NULL)
				return listelp;
			else
				return list;
			};
		l2=l; 
		l=l->next;
		};
		 
	if (l2==NULL)
		{
		listelp->next = NULL; listelp->prev = NULL;
		return listelp;
		}
	else
		{
		l2->next = listelp; listelp->prev = l2;
		listelp->next = NULL;
		return list;
		};
}
 
inline List
add_to_list0(List list, ulong id, ulong type, void *data)
{
	ListEl *listelp;
	List l=list; 
	List l2=NULL; 
#ifdef FIG_DEBUG_LIST_ALLOC
	int i=0; 
#endif

	listelp = (ListEl *)malloc(sizeof(ListEl));

#ifdef FIG_DEBUG_LIST_ALLOC
	l2=list;
	while (l2!=NULL)
		{
		i++;
		l2=l2->next;
		}; 
	l2=NULL; 
	fprintf(stderr,"figurine: add_to_list size %d: %d,%d,%p\n",i,id,type,listelp); 
#endif

	listelp->id = id; 
	listelp->type = type;
	listelp->data = data; 
	while (l!=NULL) 
		{
		if (l->id >= id)
			{
			listelp->prev = l->prev;
			listelp->next = l; 
			if (l->prev!=NULL)
				l->prev->next = listelp;
			l->prev = listelp; 
			if (listelp->prev==NULL)
				return listelp;
			else
				return list;
			};
		l2=l; 
		l=l->next;
		};
		 
	if (l2==NULL)
		{
		listelp->next = NULL; listelp->prev = NULL;
		return listelp;
		}
	else
		{
		l2->next = listelp; listelp->prev = l2;
		listelp->next = NULL;
		return list;
		};
}

List 
insert_after(List list, ListEl *pos, ulong id, ulong type, void *data, ListEl **le)
{
	ListEl *listelp;
	List l;

	if (list==NULL)
		{
		l = create_list(id,type,data);
		*le = l;
		return l;
		};

	l = list;
	
	listelp = (ListEl *) malloc(sizeof(ListEl));
	if (listelp == NULL)
		return NULL;
	listelp->id = id;
	listelp->type = type;
	listelp->data = data; 
	*le = listelp; 
	 
	while (l->next!=NULL)
		{
		if (l==pos)
			{
			/* insert after  */ 
			listelp->next = l->next;
			listelp->prev = l;
			listelp->next->prev = listelp;
			l->next = listelp;
			break; 
			};
		l=l->next;
		};
	
	if (l->next==NULL)
		{
		/* insert at end of list  */ 
		listelp->next=NULL;
		listelp->prev = l;
		l->next = listelp;
		};

	return list;
}
 
List 
insert_before(List list, ListEl *pos, ulong id, ulong type, void *data, ListEl **le)
{
	ListEl *listelp;
	List l;

	if (list==NULL)
		{
		l = create_list(id,type,data);
		*le = l;
		return l;
		};

	l = list;
	
	listelp = (ListEl *) malloc(sizeof(ListEl));
	if (listelp == NULL)
		return NULL;
	listelp->id = id;
	listelp->type = type;
	listelp->data = data; 
	*le = listelp; 
	 
	if (l==pos)
		{
		listelp->next = l;
		listelp->prev = NULL;
		l->prev = listelp;
		return listelp;
		};

	while (l!=NULL)
		{
		if (l==pos)
			{
			/* insert before */ 
			listelp->next = l;
			listelp->prev = l->prev;
			listelp->prev->next = listelp; 
			l->prev = listelp;
			break; 
			};
		l=l->next;
		};
	
	return list;
}
 
List 
delete_from_list_v(List list, void *v)
{
	List temp1;
	
	if (list==NULL)
		return list;
	
	if (v == list->data) /* found it */ 
		{
		if (list->next!=NULL)
			list->next->prev = list->prev;

		temp1 = list->next;
		free(list);
		return temp1;
		}
	else
		{
		list->next = delete_from_list_v(list->next,v); 
		return list; 
		};
}
			
List
delete_from_list(List list, ulong id)
{
	List temp1;
	
	if (list==NULL)
		return list;
	
	if (id == list->id) /* found it */ 
		{
		if (list->next!=NULL)
			list->next->prev = list->prev;

		temp1 = list->next;
		free(list);
		return temp1;
		}
	else
		{
		list->next = delete_from_list(list->next,id); 
		return list; 
		};
}
			
inline Boolean 
is_in_list_v(List list, void *d)
{
	List l=list;

	while (l && l->data!=d)
		l=l->next;
		 
	if (l)
		return TRUE;
		 
	return FALSE;
}
 
inline Boolean
is_in_list(List list, ulong id)
{
	List l=list;

	while (l && l->id!=id)
		l=l->next;
		 
	if (l)
		return TRUE;
		 
	return FALSE;
}

inline List
where_in_list(List list, ulong id)
{
	List l=list;

	while (l && l->id!=id)
		l=l->next;
		 
	if (l)
		return l;
		 
	return NULL;
}
