/* stk_handle_button_press  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: stk_handle_button.c,v $
 * Revision 1.2  2000/12/06 20:56:04  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.12  2000/03/09 22:23:52  moz
 * Compile fixes.
 *
 * Revision 1.11  2000/02/27 21:10:58  moz
 * Remove unused variables.
 *
 * Revision 1.10  2000/02/19 01:08:29  moz
 * Fixed mouse clicks on a hidden "call" menu.
 *
 * Revision 1.9  2000/02/18 02:43:28  moz
 * Compile fixes.
 *
 * Revision 1.8  1999/08/09 00:18:34  moz
 * Quiesce -pedantic about different sign for dummy variable.
 *
 * Revision 1.7  1999/08/08 20:55:20  moz
 * From clean up of structs.
 *
 * Revision 1.6  1999/07/03 22:33:31  moz
 * Changes to scroll when holding button over text list arrow.
 *
 * Revision 1.5  1999/05/19 17:07:49  moz
 * 1.0 Checkin.
 *
 * Revision 1.4  1999/05/04 22:23:01  moz
 * Report when a menu is cancelled - STK_MENU_CANCELLED.
 *
 * Revision 1.3  1999/04/23 01:05:53  moz
 * Send a message when we select a CHOICE.
 *
 * Revision 1.2  1999/04/04 00:36:44  moz
 * Fixed coredump due to not checking for NULL current_menu_el.
 *
 * Revision 1.1  1999/03/30 00:06:22  moz
 * Initial revision
 *
 */    

#include <stdio.h> 
#include <unistd.h> 
#include <sys/time.h>
#include <limits.h> 
#include "include/stk_internal.h"
#include "include/stk_extern.h"
#include "include/stk.h"

void 
stk_handle_button_press(Window win, int x, int y, uint button)
{
	List entry;
	List elements;
	stkInternalMenuBarElement *elp; 
	Boolean q=True;
	XEvent xev; 
	Window wdum; 
	int dum;
	uint val; 
#ifndef HAVE_USLEEP
	ulong i;
#endif
	 
	/* close tooltip at button press  */   
	if (tooltip_on)
		{
		XUnmapWindow(stk_display,tooltip_window->win);
		tooltip_on = FALSE;
		};

	switch (button)
		{
		case Button1:
			mousebutton_pressed[0] = TRUE; 
			break; 
	 
		case Button2:
			mousebutton_pressed[1] = TRUE; 
			break; 
	 
		case Button3:
			mousebutton_pressed[2] = TRUE; 
			break; 
		}; 
		 
   entry = where_in_list(stk_window_list, (ulong)win);

   switch (entry->type)
		{
		case BUTTON_TYPE:
			if (button == Button1)
				{
				BUTTON(entry)->pressed = TRUE;
				stk_redraw_dialog_button(BUTTON(entry));
				};
			break;

		case DIALOG_VSLIDER_TYPE:
			sliding=TRUE;
			break;

		case DIALOG_TEXT_LIST_TYPE: 
			/* on the arrows of the text list */  
			do
				{
				if (x>((signed int)TEXTLIST(entry)->window.w-26)) 
					{
					if (is_in_box(x,y, ((signed int)TEXTLIST(entry)->window.w)-22, 2, 20, 20))
						{
						if (TEXTLIST(entry)->start>0)
							{
							TEXTLIST(entry)->start--;
							stk_redraw_dialog_text_list(TEXTLIST(entry));
							}; 
							 
						if ((q=XCheckTypedWindowEvent(stk_display,TEXTLIST(entry)->window.win,ButtonRelease,&xev))==False)
							{
#ifdef HAVE_USLEEP					
							usleep(40000);
#else
							for (i=0;i<ULONG_MAX/1024;i++)
								;
#endif
							};
						}
					else if (is_in_box(x,y, ((signed int)TEXTLIST(entry)->window.w)-22, 
								((signed int)TEXTLIST(entry)->window.h)-22, 20, 20))
						{
						if (TEXTLIST(entry)->number>TEXTLIST(entry)->shown_number &&
							 TEXTLIST(entry)->shown_number < TEXTLIST(entry)->number-TEXTLIST(entry)->start)
							{
							TEXTLIST(entry)->start++;
							stk_redraw_dialog_text_list(TEXTLIST(entry));
							};
							 
						if ((q=XCheckTypedWindowEvent(stk_display,TEXTLIST(entry)->window.win,ButtonRelease,&xev))==False)
							{
#ifdef HAVE_USLEEP					
							usleep(40000);
#else
							for (i=0;i<ULONG_MAX/1024;i++)
								;
#endif
							};
						};
					};
					 
				XFlush(stk_display);
			   XQueryPointer(stk_display,RootWindow(stk_display,DefaultScreen(stk_display)),&wdum,&wdum,&dum,&dum,&dum, &dum, &val); 
				if (!(val & Button1Mask))
					break;
				 
				} while (q==False); 
			break;

		case ICON_TYPE:
			
			/* if attached submenu, open  */

			if (button == Button1 && ICON(entry)->attached_icon_menu!=NULL)
				{
					XEvent xmess; 
					/* notify client program */  
					xmess.xclient.type = ClientMessage;
					xmess.xclient.window = ICON(entry)->window.win;
					xmess.xclient.message_type = (Atom)STK_ICON_CHOSEN;
					xmess.xclient.format = 32;
					/* first long contains tag value of icon */
					/* second long contains parent window id  */  
					xmess.xclient.data.l[0] = ICON(entry)->tag;
					xmess.xclient.data.l[1] = ICON(entry)->window.parent; 

					XSendEvent(stk_display, ICON(entry)->window.win, False, 0, &xmess); 
				};

			break;
			
		case MENU_BAR_TYPE:

			/* if we have opened a menu, do it  */
			if (button == Button1)
				{
				elements = stk_menu_bar.elements; 
				
				do
					{
					elp = ((stkInternalMenuBarElement *)elements->data);
				
					if (is_in_box(x,y, (signed int)elp->x, (signed int)elp->y, (signed int)elp->w, (signed int)elp->h))
						{
						if (stk_menu_bar.current_menu_el != elp)
							{
							if (stk_menu_bar.current_menu_el!=NULL)
								{
								stk_menu_bar.current_menu_el->child_menu_open = FALSE;
								stk_undisplay_menu(stk_menu_bar.current_menu_el->child_menu);
								};
							}; 

						stk_menu_bar.current_menu_el = elp;
						elp->child_menu_open = TRUE;
						stk_internal_display_menu(elp->child_menu);
						};
					
					elements = elements->next;
					} while (elements != NULL);
				}; 

			break;
		}; 
}

void 
stk_handle_button_release(Window win, Time now, int x, int y, uint button)
{
	List entry;
	List elements;
	stkInternalMenuBarElement *elp; 
	stkInternalMenuBar *bar; 
	stkInternalMenu *m; 
	Boolean need_redraw = FALSE; 

	/* close tooltip on button release  */  
	if (tooltip_on)
		{
		XUnmapWindow(stk_display,tooltip_window->win);
		tooltip_on = FALSE;
		};   
		 
	switch (button)
		{
		case Button1:
			mousebutton_pressed[0] = FALSE;
			break;
	 
		case Button2:
			mousebutton_pressed[1] = FALSE;
			break;
	 
		case Button3:
			mousebutton_pressed[2] = FALSE;
			break;
		}; 
	 
	entry = where_in_list(stk_window_list, (ulong)win);
 
	switch (entry->type)
		{
		case DIALOG_VSLIDER_TYPE:
			if (sliding)
				sliding=FALSE;
			else
				{
				XEvent xmess;
				VSLIDER(entry)->pos = max(0.0,min(1.0,((double)x)/VSLIDER(entry)->window.w));
				/* notify client program */  
				xmess.xclient.type = ClientMessage;
				xmess.xclient.window = VSLIDER(entry)->window.win;
				xmess.xclient.message_type = STK_DIALOG_SLID;
				xmess.xclient.format = 32;
				/* first long contains (ulong)window of parent dialog */
				xmess.xclient.data.l[0] = (ulong)VSLIDER(entry)->dialog->window.win;
				/* second long, our call value  */  
				xmess.xclient.data.l[1] = (ulong)VSLIDER(entry)->dialog->call; 
				/* third long, 100*pos  */  
				xmess.xclient.data.l[2] = (ulong)VSLIDER(entry)->pos*100; 
				XSendEvent(stk_display, VSLIDER(entry)->window.win, False, 0, &xmess);
				stk_redraw_dialog_slider(VSLIDER(entry));   
				};
			break;

		case DIALOG_TEXT_ENTRY_ENTRY_TYPE:
			if (button==Button1)
				{
				char *a;
				int c=0;
				int j = TEXTENTRY(entry)->charpos; 

				/* place cursor at the correct point in the text entry  */  
				 
				a = TEXTENTRY(entry)->contents;

				if (TEXTENTRY(entry)->dialog->focus!=TEXTENTRY(entry)) 
					{
					if (TEXTENTRY(entry)->dialog->focus!=NULL)
						{
						TEXTENTRY(entry)->dialog->focus->charpos=-1;
						stk_redraw_dialog_text_entry_entry(TEXTENTRY(entry)->dialog->focus);
						}; 
					};

				TEXTENTRY(entry)->dialog->focus = TEXTENTRY(entry);

				while (*a!='\0')
					{
					if (x-5<=XTextWidth(stk_font,TEXTENTRY(entry)->contents,c))
						break;
					c++;
					a++;
					};
				
				if (c==0)
					{
					TEXTENTRY(entry)->charpos = 0;
					TEXTENTRY(entry)->pos_x = 5;
					} 
				else if (*a=='\0')
					{
					TEXTENTRY(entry)->charpos = strlen(TEXTENTRY(entry)->contents);
					TEXTENTRY(entry)->pos_x = 5 + XTextWidth(stk_font,TEXTENTRY(entry)->contents,(signed int)strlen(TEXTENTRY(entry)->contents)); 
					} 
				else
					{
					TEXTENTRY(entry)->charpos = c-1;
					TEXTENTRY(entry)->pos_x = 5 + XTextWidth(stk_font,TEXTENTRY(entry)->contents, c-1);
					};
					
				if (j!=TEXTENTRY(entry)->charpos)
					stk_redraw_dialog_text_entry_entry(TEXTENTRY(entry));
				};
			break;
			
		case DIALOG_CHOICE_TYPE:
			if (button==Button1) 
				{
				if (is_in_box(x,y, 0,0, (signed int)CHOICE(entry)->window.w, (signed int)CHOICE(entry)->window.h))
					{
					XEvent xmess;
					CHOICE(entry)->on = !CHOICE(entry)->on;
					if (CHOICE(entry)->radio!=0)
						{
						List l;

						CHOICE(entry)->on = TRUE;

						l = where_in_list(stk_window_list,CHOICE(entry)->radio);
						if (RCHOICE(l)->c1!=NULL && RCHOICE(l)->c1!=CHOICE(entry)) 
							{
							RCHOICE(l)->c1->on = FALSE;
							stk_redraw_dialog_choice(RCHOICE(l)->c1);
							};
						if (RCHOICE(l)->c2!=NULL && RCHOICE(l)->c2!=CHOICE(entry)) 
							{
							RCHOICE(l)->c2->on = FALSE;
							stk_redraw_dialog_choice(RCHOICE(l)->c2);
							};
						if (RCHOICE(l)->c3!=NULL && RCHOICE(l)->c3!=CHOICE(entry)) 
							{
							RCHOICE(l)->c3->on = FALSE;
							stk_redraw_dialog_choice(RCHOICE(l)->c3);
							};
						if (RCHOICE(l)->c4!=NULL && RCHOICE(l)->c4!=CHOICE(entry)) 
							{
							RCHOICE(l)->c4->on = FALSE;
							stk_redraw_dialog_choice(RCHOICE(l)->c4);
							};
						};
					stk_redraw_dialog_choice(CHOICE(entry));
					/* notify client program */  
					xmess.xclient.type = ClientMessage;
					xmess.xclient.window = CHOICE(entry)->window.win;
					xmess.xclient.message_type = STK_CHOICE_PRESSED;
					xmess.xclient.format = 32;
					/* first long contains (ulong)window of parent dialog */
					xmess.xclient.data.l[0] = (long)CHOICE(entry)->dialog->window.win;
					/* second long, our call value  */  
					xmess.xclient.data.l[1] = (ulong)CHOICE(entry)->dialog->call; 
					/* third long, selected or deselected  */  
					xmess.xclient.data.l[2] = (long)CHOICE(entry)->on;
					XSendEvent(stk_display, CHOICE(entry)->window.win, False, 0, &xmess);
					};
				};
			break;

		case BUTTON_TYPE:
			 
			if (button == Button1)
				{
				BUTTON(entry)->pressed = FALSE;
				if (is_in_box(x,y, 0,0, (signed int)BUTTON(entry)->window.w, (signed int)BUTTON(entry)->window.h))
					{
					XEvent xmess;
					/* notify client program */  
					xmess.xclient.type = ClientMessage;
					xmess.xclient.window = BUTTON(entry)->window.win;
					xmess.xclient.message_type = STK_DIALOG_BUTTON_CLICKED;
					xmess.xclient.format = 32;
					/* first long contains (ulong)window of parent dialog */
					xmess.xclient.data.l[0] = (ulong)BUTTON(entry)->dialog->window.win;
					/* second long, our call value  */  
					xmess.xclient.data.l[1] = (ulong)BUTTON(entry)->dialog->call; 
					XSendEvent(stk_display, BUTTON(entry)->window.win, False, 0, &xmess);
					stk_redraw_dialog_button(BUTTON(entry));
					}
				else 
					stk_redraw_dialog_button(BUTTON(entry));
				};
			break;
		
		case DIALOG_TEXT_LIST_TYPE:
			/* round of applause for the ugliest if ever */  
			if ( x<=((signed int)TEXTLIST(entry)->window.w)-26 && 
				TEXTLIST(entry)->selection != 
				(int)(TEXTLIST(entry)->start + 
				min((y-2)/(stk_font->max_bounds.ascent+stk_font->max_bounds.descent), (int)TEXTLIST(entry)->number)) && 
				(TEXTLIST(entry)->start +
				min((y-2)/(stk_font->max_bounds.ascent+stk_font->max_bounds.descent), (int)TEXTLIST(entry)->number)) 
				< TEXTLIST(entry)->number)
				{
				char *a;
				uint sel; 
				stkInternalDialogTextList *tl=TEXTLIST(entry); 
				XEvent xmess;
				
				tl->selection = tl->start + min((y-2)/(stk_font->max_bounds.ascent+stk_font->max_bounds.descent),(signed int)tl->number);
				stk_redraw_dialog_text_list(tl);
				/* notify client program */  
				xmess.xclient.type = ClientMessage;
				xmess.xclient.window = tl->window.win;
				xmess.xclient.message_type = STK_DIALOG_TEXT_LIST_SELECTION;
				xmess.xclient.format = 32;
				/* first long contains (ulong)window of parent dialog */
				xmess.xclient.data.l[0] = (ulong)tl->dialog->window.win;
				/* second long contains char * to selected text */  
				a = TEXTLIST(entry)->strings;
				for (sel=0; sel<(uint)TEXTLIST(entry)->selection; sel++)
					a += strlen(a) + 1;

				xmess.xclient.data.l[1] = (long)a;
				/* third long is our call value  */  
				xmess.xclient.data.l[2] = (ulong)tl->dialog->call; 
				XSendEvent(stk_display,tl->window.win, False, 0, &xmess);
				}; 
			break;

		case MENU_BAR_TYPE:                  

			if (button == Button1)
				{ 
				
				if (stk_menu_bar.current_menu_el != NULL)
					{
					/* close menu  */
					stk_menu_bar.current_menu_el->child_menu_open = FALSE;
 					stk_undisplay_menu(stk_menu_bar.current_menu_el->child_menu); 
					stk_menu_bar.current_menu_el = NULL;
					};

				elements = ((stkInternalMenuBar *) entry->data)->elements;
				bar = (stkInternalMenuBar *) entry->data; 

				do
					{
					elp = (stkInternalMenuBarElement *)elements->data;

					if (elp->selected == TRUE && !is_in_box(x, y, elp->x, elp->y, (signed int)elp->w, (signed int)elp->h)) 
						{ 
						elp->selected = FALSE;
						need_redraw = TRUE;
						};

					elements=elements->next;
					} while (elements != NULL);  
				 
				if (need_redraw)
					stk_redraw_menu_bar();
				}; 
			break;

		case MENU_ICON_TYPE: 
		case ICON_TYPE:

			if (ICON(entry)->attached_icon_menu!=NULL)
				{
				/* respond immediately if there is an attached icon menu  */  
				if (button==Button3)
					{
					XEvent xmess;
					xmess.xclient.type = ClientMessage;
					xmess.xclient.window = ICON(entry)->window.win;
					xmess.xclient.message_type = (Atom)STK_ICON_DOUBLECLICKED;
					xmess.xclient.format = 32;
					/* first long contains tag value of icon */
					/* second long contains parent window id  */
					xmess.xclient.data.l[0] = ICON(entry)->tag;
					xmess.xclient.data.l[1] = ICON(entry)->window.parent; 
					XSendEvent(stk_display, ICON(entry)->window.win, False, 0, &xmess);
					};
				return;
				}; 

			if ((button==Button1 || button==Button2) || (button==Button3 && entry->type==MENU_ICON_TYPE))
				{
				XEvent xmess;

				if (entry->type==MENU_ICON_TYPE)
					{ 
					XUngrabPointer(stk_display,CurrentTime);
					if (button==menu_cancel_button)
						{ 
  						stk_undisplay_icon_menu(ICON(entry)->window.parent);   
						xmess.xclient.type = ClientMessage;
						xmess.xclient.window = ICON(entry)->window.win;
						xmess.xclient.message_type = (Atom)STK_MENU_CANCELLED;
						xmess.xclient.format = 32;
						/* first long contains tag value of icon */
						/* second long contains parent window id  */  
						xmess.xclient.data.l[0] = ICON(entry)->tag;
						xmess.xclient.data.l[1] = ICON(entry)->window.parent; 

						XSendEvent(stk_display, ICON(entry)->window.win, False, 0, &xmess);
						return;
						}; 
					};

				if (ICON(entry)->pressed && ICON(entry)->binary)
					{
					ICON(entry)->pressed = FALSE;
					stk_redraw_icon(ICON(entry));
					}
				else if (ICON(entry)->pressable) 
					{ 
					ICON(entry)->pressed = TRUE;
					stk_redraw_icon((stkInternalIcon *)entry->data);
  					if (entry->type==MENU_ICON_TYPE)   
  						stk_undisplay_icon_menu(ICON(entry)->window.parent);   
					}; 

				/* notify client program */  
				xmess.xclient.type = ClientMessage;
				xmess.xclient.window = ICON(entry)->window.win;
				if (entry->type!= MENU_ICON_TYPE && button==Button2)
					xmess.xclient.message_type = (Atom)STK_ICON_DOUBLECLICKED;
				else
					xmess.xclient.message_type = (Atom)STK_ICON_CHOSEN;
				xmess.xclient.format = 32;
				/* first long contains tag value of icon */
				/* second long contains parent window id  */  
				xmess.xclient.data.l[0] = ICON(entry)->tag;
				xmess.xclient.data.l[1] = ICON(entry)->window.parent; 

				XSendEvent(stk_display, ICON(entry)->window.win, False, 0, &xmess);
				};
			
			break;
			 
		case MENU_TYPE:
			m = (stkInternalMenu *)entry->data;
			
			if (button == Button1 || (button==menu_cancel_button))
				{ 
				/* if pointer is no longer in menu, close it */  
				if (!is_in_box(x,y,0,0,(signed int)m->window.w,(signed int)m->window.h))
					{
					stk_undisplay_menu(m);
					if (m->call==NULL)
						{
						if (stk_menu_bar.current_menu_el!=NULL)
							stk_menu_bar.current_menu_el->child_menu_open = FALSE;
						stk_menu_bar.current_menu_el = NULL;
						stk_select_menu(&stk_menu_bar,(signed int)(x+m->relative_x),(signed int)(y+m->relative_y)); 
						}; 
					}
				else
					{
					uint c; 
					
					/* released in menu, anything selected ? */ 
					for (c=0;c<m->label_number;c++)
						{
						if (is_in_box(x,y, m->labels[c].x, m->labels[c].y, (signed int)m->labels[c].w, (signed int)m->labels[c].h))
							break;
					 	}; 
						 
					if (c!=m->label_number && !streq("-",m->labels[c].label) && !m->labels[c].disabled)
						{
						XEvent xmess;
					 
						xmess.xclient.type = ClientMessage;
						xmess.xclient.window = win;
						xmess.xclient.message_type = (Atom)STK_MENU_CHOSEN;
						xmess.xclient.format = 32;
						/* first long contains label tag value */ 
						xmess.xclient.data.l[0] = m->labels[c].tag;
						/* second long contains call  */  
						xmess.xclient.data.l[1] = (ulong)m->call; 

						XSendEvent(stk_display, tool_window_id, False, 0, &xmess);
						};
					
					stk_undisplay_menu(m);
					 
					if (m->call==NULL)
						{
						stk_select_menu(&stk_menu_bar,(signed int)(x+m->relative_x),(signed int)(y+m->relative_y)); 
						if (stk_menu_bar.current_menu_el!=NULL) 
							stk_menu_bar.current_menu_el->child_menu_open = FALSE;
						stk_menu_bar.current_menu_el = NULL; 
						}
 					};  
				}; 
				 
			break;
		};

	switch(button)
		{
		case Button1:
			last_released[0] = now;
			break;
			 
		case Button2:
			last_released[1] = now;
			break;
			 
		case Button3:
			last_released[2] = now;
			break;
		}; 
}
