/* stk_handle_motion  */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: stk_handle_motion.c,v $
 * Revision 1.2  2000/12/06 20:56:05  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.6  2000/03/06 02:36:11  moz
 * Compile fixes.
 *
 * Revision 1.5  2000/01/24 22:21:58  moz
 * Use stk_redraw_menu_labels().
 *
 * Revision 1.4  1999/06/16 00:56:56  moz
 * Hide tooltip when on dialog, menu, or menu bar.
 *
 * Revision 1.3  1999/05/22 23:39:32  moz
 *  Pedantic ANSI.
 *
 * Revision 1.2  1999/05/19 17:07:43  moz
 * 1.0 Checkin.
 *
 * Revision 1.1  1999/03/30 00:06:28  moz
 * Initial revision
 *
 */    

/* deal with mouse motion in an STK window  */

#include "include/stk_internal.h"
#include "include/stk_extern.h"
#include "include/stk.h"

void 
stk_select_menu(stkInternalMenuBar *bar, int x, int y)
{	
	List elements; 
	stkInternalMenuBarElement *elp; 
	Boolean need_to_redraw = FALSE; 
	 
	elements = bar->elements;
 
	do 
		{
		elp = (stkInternalMenuBarElement *)elements->data; 

		if (is_in_box(x, y, elp->x, elp->y, (int)elp->w, (int)elp->h))
			{
			if (mousebutton_pressed[0] && stk_menu_bar.current_menu_el != elp)
				{
				if (stk_menu_bar.current_menu_el != NULL)
					{
					/* must close old menu and open new  */ 
					stk_menu_bar.current_menu_el->child_menu_open = FALSE;
					stk_undisplay_menu(stk_menu_bar.current_menu_el->child_menu);
					}; 

				stk_menu_bar.current_menu_el = elp;
				elp->child_menu_open = TRUE;
				stk_internal_display_menu(elp->child_menu);
				}

			if (stk_menu_bar.current_menu_sel != NULL && elp != stk_menu_bar.current_menu_sel)
				{
				stk_menu_bar.current_menu_sel->selected = FALSE;
				need_to_redraw = TRUE;
				};
						
			if (elp->selected == FALSE)
				{
				need_to_redraw = TRUE;
				stk_menu_bar.current_menu_sel = elp; 
				elp->selected = TRUE;
				}; 
						 
			}
		else
			{
			if (elp->selected == TRUE && !mousebutton_pressed[0])
				{
				need_to_redraw = TRUE;
				elp->selected = FALSE;
				};
			};

		elements=elements->next;
		} while (elements != NULL);

	if (need_to_redraw)
		stk_redraw_menu_bar();

}

void 
stk_handle_motion(Window win, int x, int y)
{
	List entry; 
	stkInternalMenu *m; 
	int old=-1,new=-1; 
	uint i=0; 

	entry = where_in_list(stk_window_list, (ulong)win);

	if (sliding)
		{
		XEvent xmess;
		 
		/* update slider position  */  
		VSLIDER(entry)->pos = max(0.0,min(1.0,((double)x)/VSLIDER(entry)->window.w));
		/* notify client program */
		xmess.xclient.type = ClientMessage;
		xmess.xclient.window = VSLIDER(entry)->window.win;
		xmess.xclient.message_type = STK_DIALOG_SLID;
		xmess.xclient.format = 32;
		/* first long contains (ulong)window of parent dialog */
		xmess.xclient.data.l[0] = (ulong)VSLIDER(entry)->dialog->window.win;
		/* second long, our call value  */
		xmess.xclient.data.l[1] = (ulong)VSLIDER(entry)->dialog->call;
		/* third long, 100*pos  */
		xmess.xclient.data.l[2] = (ulong)(VSLIDER(entry)->pos*100);
		XSendEvent(stk_display, VSLIDER(entry)->window.win, False, 0, &xmess);    
		stk_redraw_dialog_slider(VSLIDER(entry)); 
		return;
		};
		 
	switch (entry->type)
		{
		case DIALOG_TYPE:
			stk_unmap_tooltip();
			break;

		case MENU_BAR_TYPE:
			stk_unmap_tooltip(); 
			stk_select_menu((stkInternalMenuBar *)entry->data,x,y); 
			break;
		
		case MENU_TYPE:
			stk_unmap_tooltip(); 
			/* determine which menu to display as selected */
			m = (stkInternalMenu *)entry->data;
			
			for (i=0; i<m->label_number; i++)
				{
				if (is_in_box(x,y,m->labels[i].x,m->labels[i].y,(int)m->labels[i].w,(int)m->labels[i].h))
					{
					if (!m->labels[i].selected && !streq(m->labels[i].label,"-"))
						{
						m->labels[i].selected = TRUE;
						new=i; 
						};
					}
				else if (m->labels[i].selected && !streq(m->labels[i].label,"-"))
					{
					m->labels[i].selected = FALSE;
					old=i; 
					};
				};

			/* redraw only if labels have changed */
			if (old!=-1 || new!=-1)
				stk_redraw_menu_labels(m,old,new);
			
			if (m->call==NULL)
				{
				if (is_in_box((int)(x+m->relative_x),(int)(y+m->relative_y),stk_menu_bar.window->x, 
					 stk_menu_bar.window->y,(int)stk_menu_bar.window->w,(int)stk_menu_bar.window->h)) 
					stk_select_menu(&stk_menu_bar,(int)(x+m->relative_x),(int)(y+m->relative_y)); 
				};
			 
			break;
		};
}
