/* Menu functions of STK  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: stk_icon.c,v $
 * Revision 1.2  2000/12/06 20:56:05  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.8  2000/02/21 03:17:41  moz
 * Grab keyboard during icon menus.
 *
 * Revision 1.7  2000/02/18 02:19:06  moz
 * Compile fixes.
 *
 * Revision 1.6  2000/01/28 17:02:52  moz
 * Inline stk_tag_to_icon().
 *
 * Revision 1.5  2000/01/26 18:22:33  moz
 * Use free_list().
 *
 * Revision 1.4  1999/11/15 02:04:05  moz
 * Removed useless window border setting.
 *
 * Revision 1.3  1999/08/08 20:55:25  moz
 * From clean up of structs.
 *
 * Revision 1.2  1999/05/19 17:07:23  moz
 * 1.0 Checkin.
 *
 * Revision 1.1  1999/03/30 00:06:37  moz
 * Initial revision
 *
 */    

#include <stdlib.h> 
#include <string.h> 
 
#include "include/stk_internal.h" 
#include "include/stk_extern.h"
#include "include/stk.h"

void free_list(void *);
List delete_from_list_v(List,void *); 
extern List freelist; 

/* convert the client's tag number to an actual icon  */  
/* parent is needed to tell between same tag, different window  */  
inline stkInternalIcon *
stk_tag_to_icon(int tag, Window parent)
{
	List temp = stk_window_list;
	 
	while (temp!=NULL && !((temp->type==ICON_TYPE || temp->type==MENU_ICON_TYPE) && ((stkInternalIcon *)temp->data)->tag==tag && ICON(temp)->window.parent == parent))
		temp = temp->next;
	
	if (temp==NULL)
		return NULL;

	return ((stkInternalIcon *)temp->data);
}

/* remove an icon  */  
void 
stk_delete_icon(int tag, Window parent)
{
	stkInternalIcon *icon;

	icon = stk_tag_to_icon(tag,parent);

	if (icon!=NULL)
		{
		freelist = delete_from_list_v(freelist,icon); 
		stk_window_list = delete_from_list(stk_window_list,icon->window.win);
		free(icon); 
		};
}

/* set the x position of an icon  */  
void 
stk_set_x(int tag, Window parent, int x)
{
	stkInternalIcon *icon;

	icon = stk_tag_to_icon(tag,parent);

	if (icon!=NULL)
		{
		icon->window.x = x;
		XMoveWindow(stk_display, icon->window.win, (signed int)icon->window.x, (signed int)icon->window.y);
		};
}

/* hide an icon from view  */  
void 
stk_hide_icon(int tag, Window parent)
{
	stkInternalIcon *icon;

	icon = stk_tag_to_icon(tag,parent);

	if (icon!=NULL)
		XUnmapWindow(stk_display, icon->window.win);
}

/* make icon appear  */  
void 
stk_show_icon(int tag, Window parent)
{
	stkInternalIcon *icon;

	icon = stk_tag_to_icon(tag,parent);

	if (icon!=NULL)
		XMapWindow(stk_display, icon->window.win);
}

/* display an icon as selected  */ 
void 
stk_select_icon(int tag, Window parent)
{
	stkInternalIcon *icon;

	icon = stk_tag_to_icon(tag,parent);
	
	if (icon!=NULL && !icon->pressed)
		{
		icon->pressed = TRUE;
		stk_redraw_icon(icon); 
		}; 
}

/* display an icon as unselected  */  
void 
stk_unselect_icon(int tag, Window parent)
{
	stkInternalIcon *icon;

	icon = stk_tag_to_icon(tag,parent);

	if (icon!=NULL && icon->pressed)
		{
		icon->pressed = FALSE;
		stk_redraw_icon(icon);
		};
}

/* redraw an icon  */  
void 
stk_redraw_icon(stkInternalIcon *icon)
{

	XClearWindow(stk_display,icon->window.win); 

	if (icon->colour==-1)
		{
		int pixmap_x,pixmap_y; 
		/* now place the pixmap */  

		pixmap_x = max(2,(icon->window.w - icon->pixmap_w) / 2); 
		pixmap_y = max(2,(icon->window.h - icon->pixmap_h) / 2); 
		 
 		if (pixmap_x>=0 && pixmap_y>=0) 
 			XCopyArea(stk_display,icon->actual_pixmap, icon->window.win,
 						backgroundgc, 0, 0, min(icon->pixmap_w,icon->window.w-4), min(icon->pixmap_h,icon->window.h-4),  
 						pixmap_x, pixmap_y ); 
		}
	else
		{
		/* coloured icon, simply fill rectangle */  
		XSetForeground(stk_display, colgc, (ulong)icon->colour);
 		XFillRectangle(stk_display, icon->window.win, colgc, 2, 2, icon->window.w-4, icon->window.h-4); 
		};

	if (icon->pressed)
		stk_inverse_outline(&(icon->window), 0, 0, icon->window.w-1, icon->window.h-1); 
	else if (icon->selected) 
		stk_outline(&(icon->window), 0, 0, icon->window.w-1, icon->window.h-1); 
	else	 
		stk_thin_outline(&(icon->window), 0, 0, icon->window.w-1, icon->window.h-1); 
}

/* resize an icon panel to a new width  */  
void 
stk_resize_icon_panel(uint w)
{
	uint i = 0;
	uint next_icon_x = 0;
	uint next_icon_y = 0;
	stkInternalIcon *temp;

	stk_icon_panel.w = w;
	 
	i = 0;
	next_icon_x = 0;
	next_icon_y = stk_icon_panel.icons[i]->window.y;
	temp = stk_icon_panel.icons[i]; 
	  
	while (temp != NULL && i<stk_icon_panel.iconnum)
		{
		temp = stk_icon_panel.icons[i]; 
		 
		temp->window.x = next_icon_x;
		temp->window.y = next_icon_y;
		temp->window.w = w / 3;

		XMoveResizeWindow(stk_display,temp->window.win, temp->window.x, temp->window.y,
								temp->window.w, temp->window.h);

		next_icon_x += temp->window.w;
		if (next_icon_x > w-temp->window.w)
			{ 
			next_icon_x = 0;
			next_icon_y += temp->window.h;
			}; 
			 
		i++;
		};	
}

/* internal display function  */  
void 
stk_internal_display_icon_menu(stkInternalIconMenu *im, int x, int y)
{
	im->window.x = x;
	im->window.y = y;
	XMoveWindow(stk_display,im->window.win, x, y);
	XRaiseWindow(stk_display,im->window.win); 
	XMapWindow(stk_display,im->window.win);
  	XGrabPointer(stk_display, im->window.win, True, ButtonPressMask | ButtonReleaseMask | PointerMotionMask | ButtonMotionMask  
                  | Button1MotionMask, GrabModeAsync, GrabModeAsync, im->window.win, None, CurrentTime);     
 	XGrabKeyboard(stk_display, im->window.win, False, GrabModeAsync, GrabModeAsync, CurrentTime); 
}

/* display an icon menu  */  
void 
stk_display_icon_menu(Window win,int x,int y, Boolean placeabove, int menu_cancel)
{
	List entry;

	menu_cancel_button = menu_cancel;

	entry = where_in_list(stk_window_list,(ulong)win);
	if (entry==NULL)
		return;
	
	if (placeabove)
		stk_internal_display_icon_menu((stkInternalIconMenu *)entry->data, x, y - ((signed int)((stkInternalIconMenu *)entry->data)->window.h));
	else 
		stk_internal_display_icon_menu((stkInternalIconMenu *)entry->data, x, y);

}

/* hide an icon menu  */  
void 
stk_undisplay_icon_menu(Window win)
{
 	XUngrabKeyboard(stk_display,CurrentTime);
 	XUnmapWindow(stk_display,win); 
}

/* create setup for an icon menu  */  
Window 
stk_create_icon_menu(stkIconMenu *menu, int rowsize)
{
	stkInternalIconMenu *mp;
	int x=0; int y = 0;
	uint i; 

	mp = (stkInternalIconMenu *)malloc(sizeof(stkInternalIconMenu));
	if (mp==NULL)
		return (unsigned)FAIL;
	
	free_list(mp); 
	mp->window.x = 0;
	mp->window.y = 0;
	mp->window.w = 10;
	mp->window.h = 10;
	
	if (!stk_create_window(&(mp->window), RootWindow(stk_display,DefaultScreen(stk_display)), ICON_MENU_TYPE,
	    (void *)mp, TRUE))
	return (unsigned)FAIL;
	
	for (i=0; i<menu->iconnum; i++)
		{
		menu->icons[i].x = x;
		menu->icons[i].y = y;
		if (stk_create_icon(&(menu->icons[i]),mp->window.win,TRUE,-1)==FAIL)
			return (unsigned)FAIL;

		x += menu->icons[i].w; 
		if ((i+1) % rowsize ==0)
			{
			y += menu->icons[i].h;
			x = 0;
			};
		}
		
	if ((i) % rowsize != 0 && x!=0)
		y += menu->icons[i-1].h;

	mp->window.w = menu->icons[0].w*rowsize;
	mp->window.h = y;
	XResizeWindow(stk_display, mp->window.win, mp->window.w, mp->window.h);

	return mp->window.win;
}
 
/* create an icon menu of colours  */ 
Window 
stk_create_colour_icon_menu(VColour cols[], int numcols, int rowsize)
{
	stkInternalIconMenu *mp;
	stkIcon ip; 
	int x=0; int y = 0;
	int i; 

	mp = (stkInternalIconMenu *)malloc(sizeof(stkInternalIconMenu));
	if (mp==NULL)
		return (unsigned)FAIL;
	
	free_list(mp); 
	mp->window.x = 0;
	mp->window.y = 0;
	mp->window.w = 10;
	mp->window.h = 10;
	
   if (!stk_create_window(&(mp->window), RootWindow(stk_display,DefaultScreen(stk_display)), ICON_MENU_TYPE,
       (void *)mp, TRUE))
	return (unsigned)FAIL;
	
	ip.xpm_data = NULL;
	ip.pixmap = (unsigned)-1;
	ip.w = 20;
	ip.h = 20;
	ip.pressable = TRUE;
	ip.binary = FALSE;
	
	for (i=0; i<numcols; i++)
		{
		ip.x =x;
		ip.y = y;
		ip.tooltip = cols[i].label;
		ip.tag = cols[i].tag;
		if (stk_create_icon(&ip,mp->window.win,TRUE,(signed long)cols[i].colour)==FAIL)
			return (unsigned)FAIL;

		x += ip.w; 
		if ((i+1) % rowsize ==0)
			{
			y += ip.h;
			x = 0;
			};
		}
		
	if ((i) % rowsize != 0 && x!=0)
		y += ip.h;

	mp->window.w = ip.w*rowsize;
	mp->window.h = y;
	XResizeWindow(stk_display, mp->window.win, mp->window.w, mp->window.h);

	return mp->window.win;
}

/* create an icon panel  */  
int 
stk_create_icon_panel(WindowStruct window, stkIconPanel *panel)
{
	XpmAttributes xpm_attr;
	XpmColorSymbol xpm_col; 
	XGCValues gcvalues; 
	Pixmap dummy;
	uint next_icon_x = 0;
	uint next_icon_y = 0;
	stkIcon *temp; 
	stkInternalIcon *tempp;
	uint i = 0; 

	/* First set start of first icon to given values */   
	
	next_icon_x = panel->x;
	next_icon_y = panel->y;

	stk_icon_panel.x = panel->x;
	stk_icon_panel.y = panel->y;
	stk_icon_panel.w = window.w;
	stk_icon_panel.iconnum = panel->iconnum; 
	 
	  
	XGetGCValues(stk_display, backgroundgc, (GCBackground), &gcvalues);
	xpm_col.name = NULL;
	xpm_col.value = "none";
	xpm_col.pixel = icon_background; 
	
	/* loop through passed structure and extract our icons */  
	
	i = 0; 
	temp = panel->icons; 
	 
	while (temp != NULL && i<panel->iconnum)
		{
		tempp = (stkInternalIcon *)malloc(sizeof(stkInternalIcon));
		if (tempp==NULL)
			return FAIL;
		
		free_list(tempp); 
		xpm_attr.valuemask = XpmColorSymbols;
		xpm_attr.numsymbols = 1;
		xpm_attr.colorsymbols = &xpm_col;
		 
		if ((XpmCreatePixmapFromData(stk_display, window.win, temp->xpm_data,
				   &(tempp->actual_pixmap), &dummy, &xpm_attr))!=XpmSuccess)
			return FAIL;
	
		tempp->pixmap_w = xpm_attr.width; 
		tempp->pixmap_h = xpm_attr.height; 
		tempp->colour = -1; 
		tempp->selected = FALSE; 
		tempp->pressed = FALSE; 
		tempp->tag = temp->tag; 
		if (!streq(temp->tooltip,"")) 
			strncpy(tempp->tooltip,temp->tooltip,30); 
		else
			strncpy(tempp->tooltip,"",1);
		 
		/* create icon's window and resize it correctly  */  
		 
		tempp->window.parent = window.win;
		tempp->window.x = next_icon_x;
		tempp->window.y = next_icon_y;
		tempp->window.w = window.w / 3;
		tempp->window.h = temp->h;
		tempp->window.size_hints = NULL;
		tempp->window.class_hints = NULL;
		tempp->window.wm_hints = NULL;
		tempp->window.gc = NULL;
		tempp->binary = FALSE; 
		tempp->pressable = TRUE;
		tempp->attached_icon_menu = FALSE;

		if (!stk_create_window(&(tempp->window), tempp->window.parent, ICON_TYPE, (void *)tempp, FALSE))
			return FALSE;

		XMapWindow(stk_display, tempp->window.win); 
		 
		next_icon_x += tempp->window.w;
		if (next_icon_x > window.w-tempp->window.w)
			{ 
			next_icon_x = 0;
			next_icon_y += tempp->window.h;
			}; 
			 
		stk_icon_panel.icons[i] = tempp;	
		 
		i++; 
		temp++; /* move our pointer along  */ 
		 
		};

	stk_icon_panel.w = window.w;
	stk_icon_panel.h = next_icon_y;

	/* finish icon_panel  */ 
	return stk_icon_panel.h;
}

/* indicate an icon has an icon menu attached
	This means is will return a message when pressed,
	rather than released */  
void 
stk_attach_icon_menu(int tag, Window parent, Window menuwin)
{
	stkInternalIcon *ic;
	List l;

	ic = stk_tag_to_icon(tag,parent);
	if (ic==NULL)
		return;
	
	if (menuwin!=(unsigned)-1)
		{
		l = where_in_list(stk_window_list, (ulong)menuwin);

		if (l==NULL)
			return;
		
		ic->attached_icon_menu = ICONMENU(l);
		}
	else
		{ 
		/* note this is never dereferenced, so we get away with this ...  */  
		/* we actually have a text menu  */  
		ic->attached_icon_menu = (stkInternalIconMenu *)tag;
		}; 

	return;
}
 
/* create a normal icon  */  
int
stk_create_icon(stkIcon *ic, Window parent, Boolean is_menu_member, long colour)
{
	XpmAttributes xpm_attr;
	XpmColorSymbol xpm_col; 
	stkInternalIcon *tempp;
	XGCValues gcvalues; 
	XSetWindowAttributes wattr; 
	Pixmap dummy;
	uint type; 
	 
	  
	XGetGCValues(stk_display, backgroundgc, (GCBackground), &gcvalues);
	xpm_col.name = NULL;
	xpm_col.value = "none";
	xpm_col.pixel = icon_background; 

	tempp = (stkInternalIcon *)malloc(sizeof(stkInternalIcon));
	if (tempp==NULL)
		return FAIL;
	
 	free_list(tempp);
	xpm_attr.valuemask = XpmColorSymbols;
	xpm_attr.numsymbols = 1;
	xpm_attr.colorsymbols = &xpm_col;
		 
	if (ic->xpm_data!=NULL)
		{
		if ((XpmCreatePixmapFromData(stk_display, parent, ic->xpm_data,
					&(tempp->actual_pixmap), &dummy, &xpm_attr))!=XpmSuccess)
			return FAIL;

		tempp->pixmap_w = xpm_attr.width;
		tempp->pixmap_h = xpm_attr.height;
		}
	else
		{
		tempp->actual_pixmap = ic->pixmap;
		/* should be actual ! */
		tempp->pixmap_w = 16;
		tempp->pixmap_h = 16;
		};

	tempp->colour=colour;
	tempp->selected = FALSE; 
	tempp->pressed = FALSE; 
	tempp->tag = ic->tag; 
	if (!streq(ic->tooltip,"")) 
		strncpy(tempp->tooltip,ic->tooltip,30); 
	else
		strncpy(tempp->tooltip,"",1);
	 
	/* create icon's window and resize it correctly  */  
	 
	tempp->window.parent = parent;
	tempp->window.x = ic->x; 
	tempp->window.y = ic->y;
	tempp->window.w = max(ic->w,tempp->pixmap_w+2);
	tempp->window.h = max(ic->h,tempp->pixmap_h+2);
	tempp->window.size_hints = NULL;
	tempp->window.class_hints = NULL;
	tempp->window.wm_hints = NULL;
	tempp->window.gc = NULL;
	tempp->binary = ic->binary;
	tempp->pressable = ic->pressable; 
	tempp->attached_icon_menu = NULL; 

	(is_menu_member) ? (type = MENU_ICON_TYPE) : (type = ICON_TYPE);

	if (!stk_create_window(&(tempp->window), tempp->window.parent, type, (void *)tempp, FALSE))
		return FALSE;

	wattr.cursor = stk_arrow_cursor;
	XChangeWindowAttributes(stk_display, tempp->window.win, CWCursor, &wattr);   
	 
	XMapWindow(stk_display, tempp->window.win); 
	 
	return TRUE;  
}

/* change over two pixmaps for icons  */  
void 
stk_swap_pixmap(int tag, Window w1, int tag2, Window w2)
{
	stkInternalIcon *ic1, *ic2;

	ic1 = stk_tag_to_icon(tag, w1);
	ic2 = stk_tag_to_icon(tag2, w2);
	
	if (ic2->colour==-1) 
		ic1->actual_pixmap = ic2->actual_pixmap;
	else
		ic1->colour = ic2->colour;
	
	stk_redraw_icon(ic1);
}

/* change a pixmap for an icon */  
void 
stk_set_pixmap(int tag, Window w, Pixmap p)
{
	stkInternalIcon *ic1;

	ic1 = stk_tag_to_icon(tag,w);

	ic1->actual_pixmap = p;

	stk_redraw_icon(ic1);
}
