/* initialisation of stk */
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: stk_init.c,v $
 * Revision 1.2  2000/12/06 20:56:06  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.7  2000/02/27 21:10:48  moz
 * Removed unused variables.
 *
 * Revision 1.6  2000/02/18 02:18:10  moz
 * tooltipwait removed.
 *
 * Revision 1.5  2000/01/26 18:23:11  moz
 * Use free_list().
 *
 * Revision 1.4  1999/11/15 02:03:48  moz
 * Name change.
 *
 * Revision 1.3  1999/08/10 23:55:30  moz
 * Set save_under for the tooltip window.
 *
 * Revision 1.2  1999/05/19 17:07:18  moz
 * 1.0 Checkin.
 *
 * Revision 1.1  1999/03/30 00:06:40  moz
 * Initial revision
 *
 */    

#include <stdio.h> 
#include <stdlib.h>
#include "include/stk_internal.h" 
#include "include/stk_extern.h"
#include "include/stk.h"
#include "pixmaps/up_arrow.xpm" 
#include "pixmaps/down_arrow.xpm" 
#include <X11/cursorfont.h> 

extern int screen; 
extern WindowStruct bar_window; 

void free_list(void *);

void 
stk_init(WindowStruct * toolWindow, XFontStruct *font,ulong tlcolor, ulong bgcolor, ulong brcolor, ulong tooltipcolor, Display *display)
{
	XGCValues gcvalues;
	XSetWindowAttributes xswa; 
	XpmColorSymbol xpm_col; 
	Pixmap dummy; 
	 
	/* start off with no bar window  */ 
	bar_window.win = 0;

	/* initialise mouse  */

	mousebutton_pressed[0] = FALSE;
	mousebutton_pressed[1] = FALSE;
	mousebutton_pressed[2] = FALSE;
	last_released[0] = 0; 
	last_released[1] = 0; 
	last_released[2] = 0; 

	stk_display = display; 
	 
	icon_background = bgcolor;  
	gcvalues.foreground = tlcolor;
	gcvalues.background = bgcolor;
	gcvalues.font = font->fid;
	
	topleftgc = XCreateGC(stk_display, toolWindow->win, (GCForeground | GCBackground | GCFont),
			 &gcvalues);

	colgc = XCreateGC(stk_display,toolWindow->win, (GCForeground | GCBackground), &gcvalues);

	/* initialise cursors */

	stk_arrow_cursor = XCreateFontCursor(stk_display, XC_left_ptr);
	
	gcvalues.foreground = WhitePixel(display,screen); 
	
	whitegc = XCreateGC(display, toolWindow->win, GCForeground, &gcvalues);

	gcvalues.foreground = BlackPixel(display,screen);
	gcvalues.background = bgcolor;
	gcvalues.font = font->fid;

	fontgc = XCreateGC(display, toolWindow->win, (GCForeground | GCBackground | GCFont),
			 &gcvalues);
								  
	gcvalues.foreground = bgcolor;
	gcvalues.background = bgcolor;
	gcvalues.font = font->fid;
	
	backgroundgc = XCreateGC(display, toolWindow->win, (GCForeground | GCBackground | GCFont),
			 &gcvalues);

	gcvalues.foreground = brcolor;
	gcvalues.background = bgcolor;
	gcvalues.font = font->fid;
	bottomrightgc = XCreateGC(display, toolWindow->win, (GCForeground | GCBackground | GCFont),
			 &gcvalues);
	
	gcvalues.foreground = BlackPixel(display,screen);
	gcvalues.background = tooltipcolor;
	gcvalues.font = font->fid;
	tooltipgc = XCreateGC(display, toolWindow->win, (GCForeground | GCBackground | GCFont),
			 &gcvalues);
 
 	stk_window_list = add_to_list(stk_window_list, (ulong) toolWindow->win, TOOL_WINDOW_TYPE, toolWindow); 
	
	toolWindow->gc = backgroundgc;
	
	stk_font = font;
	
	if ((stk_sfont=XLoadQueryFont(display,"6x10"))==NULL)
		{
		fprintf(stderr, "figurine: could not load font 6x10.\n" );
		return;
		};

	gcvalues.foreground = BlackPixel(display,screen);
	gcvalues.background = bgcolor;
	gcvalues.font = stk_sfont->fid;
	sfontgc = XCreateGC(display, toolWindow->win, (GCForeground | GCBackground | GCFont),
			 &gcvalues);
	
	tooltip_window = (WindowStruct *)malloc(sizeof(WindowStruct));
	if (tooltip_window==NULL)
		return;
		
	free_list(tooltip_window);
	tooltip_window->x = 0;
	tooltip_window->y = 0;
	tooltip_window->w = 100;
	tooltip_window->h = 50;

	/* create tooltip window  */  
	stk_create_window(tooltip_window, RootWindow(stk_display,DefaultScreen(stk_display)), TOOLTIP, (void *)tooltip_window, TRUE);
	XSetWindowBackground(stk_display,tooltip_window->win, tooltipcolor); 
	/* set save_under  */  
	xswa.save_under = True; 
	XChangeWindowAttributes(stk_display,tooltip_window->win, CWSaveUnder, &xswa); 
	
	xpm_col.name = NULL;
	xpm_col.value = "none";
	xpm_col.pixel = icon_background;
	
	down_arrow_attr.valuemask = up_arrow_attr.valuemask = XpmColorSymbols;
	down_arrow_attr.numsymbols = up_arrow_attr.numsymbols = 1; 
	up_arrow_attr.colorsymbols = down_arrow_attr.colorsymbols = &xpm_col;             
	 
	XpmCreatePixmapFromData(stk_display, RootWindow(stk_display,DefaultScreen(stk_display)), up_arrow_xpm,
               &(up_arrow_pixmap), &dummy, &up_arrow_attr);
	XpmCreatePixmapFromData(stk_display, RootWindow(stk_display,DefaultScreen(stk_display)), down_arrow_xpm,
               &(down_arrow_pixmap), &dummy, &down_arrow_attr);

	
}
