/* Menu functions of STK  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: stk_menu.c,v $
 * Revision 1.2  2000/12/06 20:56:06  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:31  moz
 * CVS Import
 *
 * Revision 1.16  2000/03/09 22:52:21  moz
 * Fix to compile fix.
 *
 * Revision 1.15  2000/03/09 01:05:44  moz
 * Compile fixes.
 *
 * Revision 1.14  2000/02/21 03:18:10  moz
 * Grab pointer during menu.
 *
 * Revision 1.13  2000/02/21 01:51:00  moz
 * Small tidyup.
 *
 * Revision 1.12  2000/02/19 01:35:48  moz
 * Compile fixes.
 *
 * Revision 1.11  2000/01/26 18:23:54  moz
 * Use free_list().
 *
 * Revision 1.10  2000/01/25 01:36:40  moz
 * Removed setting border.
 *
 * Revision 1.9  2000/01/24 22:22:09  moz
 * Added stk_redraw_menu_label().
 *
 * Revision 1.8  1999/11/15 02:03:31  moz
 * Name change.
 *
 * Revision 1.7  1999/08/17 00:35:33  moz
 * Menus should SaveUnder.
 *
 * Revision 1.6  1999/05/23 00:27:43  moz
 * Pedantic changes.
 *
 * Revision 1.5  1999/05/22 23:39:36  moz
 *  Pedantic ANSI.
 *
 * Revision 1.4  1999/05/22 02:49:23  moz
 * Removed unwanted debugging message.
 *
 * Revision 1.3  1999/05/19 17:07:08  moz
 * 1.0 Checkin.
 *
 * Revision 1.2  1999/04/27 21:14:48  moz
 * stk_change_menu_label function added.
 *
 * Revision 1.1  1999/03/30 00:06:49  moz
 * Initial revision
 *
 */    

#include <stdlib.h>
#include <stdio.h> 
#include <string.h>
 
#include "include/stk_internal.h" 
#include "include/stk_extern.h"
#include "include/stk.h"

void free_list(void *); 

/* create top-level menu bar  */  
int 
stk_create_menu_bar(WindowStruct window, stkMenuBar *menu)
{
	XGCValues gcvalues;
	List result; 
	stkInternalMenuBarElement *tempp; 
	int i=0; 
	int temp=0; 
	unsigned int spacing=2; /* outer outline */  

	XGetGCValues(stk_display, backgroundgc, (GCForeground | GCBackground), &gcvalues);
	bar_window.x = 0;
	bar_window.y = 0;
	bar_window.parent = window.win; 
	 
	tool_window_id = (ulong)window.win; 
	stk_menu_bar.window = &bar_window;
	stk_menu_bar.elements = NULL;
	stk_menu_bar.current_menu_el = NULL;
	stk_menu_bar.current_menu_sel = NULL;
	
	 while (menu->label[i]!=NULL && i<MENUBAR_MENUS_LIMIT)
		{
		tempp = (stkInternalMenuBarElement *)malloc(sizeof(stkInternalMenuBarElement));
		if (tempp==NULL)
			return FAIL;
			 
		free_list(tempp);
		strncpy(tempp->label,menu->label[i],MAX_MENUBAR_LABEL_SIZE);
		tempp->x = spacing;
		tempp->y = 2;
		/* we want 1 pixels for selected box, and 2 for space  */  
		tempp->text_x = tempp->x + stk_font->min_bounds.lbearing + 2 + 1;
		/* top here is in tempp->y, add 1 for space */  
		tempp->text_y = tempp->y + stk_font->max_bounds.ascent + 1; 
		temp = XTextWidth(stk_font, tempp->label, (int)strlen(tempp->label));
		spacing += temp + PIXEL_SPACING_BETWEEN_MENUBAR_LABELS; 
		tempp->w = temp + PIXEL_SPACING_BETWEEN_MENUBAR_LABELS-1;
		/* don't forget space at the bottom  */  
		tempp->h = stk_font->max_bounds.ascent + stk_font->max_bounds.descent +2 +1;
		tempp->child_menu = NULL;

		tempp->child_menu_open = FALSE; 
		tempp->selected = FALSE; 
		result = add_to_list(stk_menu_bar.elements,(ulong)i, MENU_BAR_ELEMENT_TYPE, tempp);
		if (result==NULL)
			return FAIL;
		stk_menu_bar.elements = result;	 
		i++;
		};   
		 
	if (window.w < spacing +2)
		{
		/* we need to resize window, and enforce minimum width */
		window.size_hints->flags = PMinSize; 
		window.size_hints->min_width = spacing +2;
		XSetWMNormalHints(stk_display,window.win, window.size_hints);
		XResizeWindow(stk_display, window.win, spacing+2, window.h);
		};

	bar_window.w = max(window.w,spacing +2);
	bar_window.h = stk_font->max_bounds.ascent + stk_font->max_bounds.descent + 7;
	bar_window.gc = backgroundgc;

	bar_window.win = XCreateSimpleWindow(stk_display, window.win,
								bar_window.x,bar_window.y,bar_window.w,bar_window.h,
								0, gcvalues.foreground,
								gcvalues.background);
	
	 
	bar_window_id = (ulong)bar_window.win; 
	 
  	XSelectInput(stk_display, bar_window.win, KeyPressMask | ButtonPressMask 
					 | ButtonReleaseMask | EnterWindowMask | LeaveWindowMask
					 | PointerMotionMask | ButtonMotionMask
					 | StructureNotifyMask
					 | ExposureMask | StructureNotifyMask | FocusChangeMask);
					  
	XMapWindow(stk_display,bar_window.win); 
	 
	result = add_to_list(stk_window_list,(ulong)bar_window.win,MENU_BAR_TYPE,(void *)&stk_menu_bar);
	
	if (result==NULL)
		return FAIL;
	
	stk_window_list = result;
	

	return bar_window.h;
}
 
/* create a normal menu  */  
Window 
stk_create_menu(char *parent, stkMenu *menu, WindowStruct *parent_window, uint x, uint y)
{
	stkInternalMenu *mp; 
	uint menu_y =1; 
	uint i=0; 
	List yl; 
	XSetWindowAttributes wattr; 
	 
	mp = (stkInternalMenu *)malloc(sizeof(stkInternalMenu));
	if (mp==NULL)
		return (Window)FAIL;
		
	free_list(mp);
	if (parent_window!=NULL)
		{
		yl = stk_menu_bar.elements;
		
		while (yl != NULL)
			{
			if (streq(parent,((stkInternalMenuBarElement *)yl->data)->label))
				{	   
				/* we have found the parent menu element */ 
				((stkInternalMenuBarElement *)yl->data)->child_menu = mp;
				/* don't forget the x offset */  
				x = ((stkInternalMenuBarElement *)yl->data)->x;
				}; 
			if (yl->next != NULL)
				yl = yl->next;
			else
				yl = NULL;
			};
		mp->window.x = x+parent_window->x;
		mp->window.y = y+parent_window->y;
		mp->window.parent = parent_window->win;
		mp->parent_window = parent_window; 
		}
	else
		{
		x = 0; 
		mp->window.x = 0;
		mp->window.y = 0;
		mp->window.parent = 0;
		mp->parent_window = 0;
		}; 
	 
	mp->relative_x = x;
	mp->relative_y = y;
	mp->window.w = 0;
	mp->window.h = 0;
	mp->window.size_hints = NULL;
	mp->window.class_hints = NULL;
	mp->window.wm_hints = NULL;
	mp->window.gc = NULL;  
	
	mp->label_number = 0;	
	i =0;
	/* run through labels pased and create  */  
 	while (menu->label[i]!=NULL && i<MENU_LABEL_LIMIT)
		{
		
		strncpy(mp->labels[i].label,menu->label[i],MAX_MENU_LABEL_SIZE);
		 
		mp->labels[i].tag = menu->tag[i]; 
		mp->labels[i].x = 1;
		mp->labels[i].y = menu_y;
		mp->labels[i].selected = FALSE;
		mp->labels[i].disabled = FALSE; 
		mp->labels[i].text_x = mp->labels[i].x + 3;
		mp->labels[i].text_y = menu_y + stk_font->max_bounds.ascent + 3;
		mp->window.w = max(10+XTextWidth(stk_font, mp->labels[i].label, (int)strlen(mp->labels[i].label)),(int)mp->window.w);
		if (streq(mp->labels[i].label,"-"))
			{
			mp->labels[i].h = 2;
			mp->labels[i].y = menu_y-3; 
			}
		else
			{ 
			mp->labels[i].h = 6 + stk_font->max_bounds.ascent + stk_font->max_bounds.descent;
			menu_y += 7 + stk_font->max_bounds.ascent + stk_font->max_bounds.descent;
			}; 
		 
		i++;
		};
	mp->label_number = i; 
	
	/* now run through widths, resetting  */ 

	for (i=0;i<mp->label_number;i++)
		mp->labels[i].w = mp->window.w-2;

	mp->window.h = menu_y;

	if (!stk_create_window(&(mp->window), RootWindow(stk_display,DefaultScreen(stk_display)), MENU_TYPE, 
		 (void *)mp, TRUE))
		return (Window)FAIL;

	wattr.save_under = True;
	wattr.cursor = stk_arrow_cursor; 
	XChangeWindowAttributes(stk_display, mp->window.win, CWSaveUnder | CWCursor, &wattr);  
	 
	mp->call = NULL; 
	 
	return mp->window.win;
}

/* enable a menu option  */  
void 
stk_enable_menu_label(Window win, int i)
{
	List l;

	l = where_in_list(stk_window_list,(ulong)win);

	if (l==NULL)
		return;
	
	MENU(l)->labels[i].disabled = FALSE; 

}

/* disable a menu option  */  
void 
stk_disable_menu_label(Window win, int i)
{
	List l;

	l = where_in_list(stk_window_list,(ulong)win);

	if (l==NULL)
		return;
	
	MENU(l)->labels[i].disabled = TRUE;

}
 
/* change a menu label  */  
void
stk_change_menu_label(Window win, char *old, char *new)
{
	List l;
	uint i; 

	l = where_in_list(stk_window_list,(ulong)win);

	if (l==NULL)
		return;
	
	for (i=0;i<MENU(l)->label_number;i++)
		{
		if (streq(old,MENU(l)->labels[i].label))
			strcpy(MENU(l)->labels[i].label,new);
		};
	
	stk_redraw_menu(MENU(l));
}

void 
stk_internal_display_menu(stkInternalMenu *menu)
{

	menu->window.x = menu->parent_window->x + menu->relative_x; 
	menu->window.y = menu->parent_window->y + menu->relative_y; 
	XMoveResizeWindow(stk_display,menu->window.win,menu->window.x, menu->window.y, 
							menu->window.w, menu->window.h);
	XRaiseWindow(stk_display,menu->window.win); 
	XMapWindow(stk_display,menu->window.win);
	XGrabPointer(stk_display,menu->window.win, False, ButtonPressMask
			| ButtonReleaseMask | EnterWindowMask | LeaveWindowMask
			| PointerMotionMask | ButtonMotionMask | Button1MotionMask, 
			GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
	XGrabKeyboard(stk_display,menu->window.win, False,GrabModeAsync,GrabModeAsync,CurrentTime);
}

/* client-called display menu */  
void 
stk_display_menu(void *call, Window win,int x,int y, int menu_cancel)
{
	List entry;

	menu_cancel_button = menu_cancel;

	entry = where_in_list(stk_window_list, (ulong)win);
	if (entry==NULL)
		return;
	
	MENU(entry)->call = call; 
	MENU(entry)->window.x = x;
	MENU(entry)->window.y = y;
	XMoveWindow(stk_display,MENU(entry)->window.win, x, y);
	XRaiseWindow(stk_display,MENU(entry)->window.win);
	XMapWindow(stk_display,MENU(entry)->window.win);
	XGrabPointer(stk_display,MENU(entry)->window.win,False, ButtonPressMask
			| ButtonReleaseMask | EnterWindowMask | LeaveWindowMask
			| PointerMotionMask | ButtonMotionMask | Button1MotionMask, 
			GrabModeAsync, GrabModeAsync, None, None, CurrentTime);
	XGrabKeyboard(stk_display,MENU(entry)->window.win, False,GrabModeAsync,GrabModeAsync,CurrentTime);
}
 
/* client-called undisplay menu  */  
void 
stk_undisplay_menu(stkInternalMenu *menu)
{
	uint i; 

	for (i=0;i<menu->label_number;i++)
		menu->labels[i].selected = FALSE;

	XUnmapWindow(stk_display,menu->window.win);
	XUngrabPointer(stk_display,CurrentTime); 
	XUngrabKeyboard(stk_display,CurrentTime); 
}
 
void stk_redraw_menu_label(stkInternalMenu *menu, int i);
 
/* redraw a menu label */  
void
stk_redraw_menu_label(stkInternalMenu *menu, int i)
{
	GC dgc; 
	char a[50];
			 
	XClearArea(stk_display, menu->window.win, menu->labels[i].x, menu->labels[i].y, 
				menu->labels[i].w, menu->labels[i].h, False);
				 
	if (streq("-", menu->labels[i].label))
		{
		XDrawLine(stk_display, menu->window.win, fontgc, 
                         1, menu->labels[i].y+((int)menu->labels[i].h)/2 + 1,
                         ((int)menu->window.w)-1, menu->labels[i].y+((int)menu->labels[i].h)/2 + 1);             
		return;
		}

	if (menu->labels[i].disabled)
		dgc = bottomrightgc;
	else
		dgc = fontgc;
				 
	if (strlen(menu->labels[i].label)>2 && menu->labels[i].label[strlen(menu->labels[i].label)-2]=='^')
		{
		strncpy(a,&menu->labels[i].label[strlen(menu->labels[i].label)-2],2);
		a[2]='\0';

		XDrawString(stk_display,menu->window.win, dgc, 
			((int)menu->labels[i].w) - 5 - XTextWidth(stk_font,a,2), 
			((int)menu->labels[i].text_y), a, 2);
									 
		strncpy(a,menu->labels[i].label,49);
		a[strlen(a)-2] = '\0';
		XDrawString(stk_display,menu->window.win, dgc, (int)menu->labels[i].text_x, 
			(int)menu->labels[i].text_y, a, (int)strlen(a));
		}
	else
		{
		XDrawString(stk_display,menu->window.win, dgc, (int)menu->labels[i].text_x, 
			(int)menu->labels[i].text_y, menu->labels[i].label, 
			(int)strlen(menu->labels[i].label));
		};
					 
	if (!menu->labels[i].disabled && menu->labels[i].selected)
		stk_outline(&(menu->window), (uint)menu->labels[i].x, (uint)menu->labels[i].y, 
				menu->labels[i].w, menu->labels[i].h);
				 
}

/* redraw two labels on a menu */  
void
stk_redraw_menu_labels(stkInternalMenu *menu, int i, int j)
{
	set_clip(fontgc, 0, 0, DisplayWidth(stk_display,DefaultScreen(stk_display)), DisplayHeight(stk_display,DefaultScreen(stk_display)));  
	stk_thin_outline(&(menu->window), 0, 0, menu->window.w, menu->window.h);

	if (i!=-1)
		stk_redraw_menu_label(menu,i);

	if (j!=-1)
		stk_redraw_menu_label(menu,j);

}

/* redraw a menu  */  
void 
stk_redraw_menu(stkInternalMenu *menu)
{
	uint i; 
	 
	set_clip(fontgc, 0, 0, DisplayWidth(stk_display,DefaultScreen(stk_display)), DisplayHeight(stk_display,DefaultScreen(stk_display)));  
	XClearWindow(stk_display,menu->window.win);  
	stk_thin_outline(&(menu->window), 0, 0, menu->window.w, menu->window.h);
	
	for (i=0; i<menu->label_number; i++)
		stk_redraw_menu_label(menu,(int)i);
}
  
/* redraw the menu bar  */  
void 
stk_redraw_menu_bar()
{
	stkInternalMenuBarElement *p; 
	List ep; 
 	XFillRectangle(stk_display, stk_menu_bar.window->win, backgroundgc, 
		stk_menu_bar.window->x, stk_menu_bar.window->y,  
		stk_menu_bar.window->w, stk_menu_bar.window->h);  
					 
	set_clip(fontgc, 0, 0, DisplayWidth(stk_display,DefaultScreen(stk_display)), 
		DisplayHeight(stk_display,DefaultScreen(stk_display)));  
	/* decorate  */  
	stk_outline(stk_menu_bar.window, (uint)stk_menu_bar.window->x, 
		(uint)stk_menu_bar.window->y, stk_menu_bar.window->w, stk_menu_bar.window->h);

	if (stk_menu_bar.elements == NULL)
		return;
	
	ep = (List) stk_menu_bar.elements;

	do 
		{
		/* loop through our elements in the list, and draw the corresponding string */ 
		p = (stkInternalMenuBarElement *) ep->data;
		XDrawString(stk_display,stk_menu_bar.window->win, fontgc, 
			(int)p->text_x+2, (int)p->text_y, p->label, (int)strlen(p->label));
		if (p->selected==TRUE)
			stk_thin_outline(stk_menu_bar.window, (uint)p->x, (uint)p->y, p->w+1, p->h);

		ep = ep->next; 
		} while (ep!=NULL);
}
