/*******************************************************************************
*	fische - standalone sound visualisation for linux		       *
*	Copyright (C) 2006 Marcel Ebmer					       *
*									       *
*	This program is free software; you can redistribute it and/or	       *
*	modify it under the terms of the GNU General Public License	       *
*	as published by the Free Software Foundation; either version 2	       *
*	of the License, or (at your option) any later version.		       *
*									       *
*	This program is distributed in the hope that it will be useful,	       *
*	but WITHOUT ANY WARRANTY; without even the implied warranty of	       *
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       *
*	GNU General Public License for more details.			       *
*									       *
*	You should have received a copy of the GNU General Public License      *
*	along with this program; if not, write to the Free Software	       *
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 	       *
*	MA  02110-1301, USA.						       *
*******************************************************************************/
#include "fische.h"

int init_SDL ( short int X, short int Y, short int fullscreen ) {
	
#define FAILURE 0
#define SUCCESS 1

	int surface_flags;
	
	if ( SDL_Init ( SDL_INIT_VIDEO | SDL_INIT_TIMER ) != 0 ) {
		fprintf ( stderr, "EE init_SDL: could not initialize SDL\n" );
		return ( FAILURE );
	}
	
	if ( fullscreen ) sdl_screen = SDL_SetVideoMode ( X, Y, 32, SDL_FULLSCREEN | SDL_DOUBLEBUF );
	if ( ! fullscreen ) sdl_screen = SDL_SetVideoMode ( X, Y, 32, SDL_DOUBLEBUF );
	
	if ( ! sdl_screen ) {
		fprintf ( stderr, "EE init_SDL: could not open requested video mode\n" );
		return ( FAILURE );
	}
	
	SDL_ShowCursor ( SDL_DISABLE );
	SDL_WM_GrabInput ( SDL_GRAB_OFF );

	surface_flags = sdl_screen->flags;
	fprintf ( stdout, "II init_SDL: initialized %d x %d x %d SDL Surface with flags:", sdl_screen->w, sdl_screen->h, sdl_screen->format->BitsPerPixel );
	fprintf ( stdout, " %X (", surface_flags );
	if ( surface_flags & SDL_SWSURFACE ) fprintf ( stdout, " SWSURFACE" );
	if ( surface_flags & SDL_HWSURFACE ) fprintf ( stdout, " HWSURFACE" );
	if ( surface_flags & SDL_ASYNCBLIT ) fprintf ( stdout, " ASYNCBLIT" );
	if ( surface_flags & SDL_ANYFORMAT ) fprintf ( stdout, " ANYFORMAT" );
	if ( surface_flags & SDL_HWPALETTE ) fprintf ( stdout, " HWPALETTE" );
	if ( surface_flags & SDL_DOUBLEBUF ) fprintf ( stdout, " DOUBLEBUF" );
	if ( surface_flags & SDL_FULLSCREEN ) fprintf ( stdout, " FULLSCREEN" );
	if ( surface_flags & SDL_OPENGL ) fprintf ( stdout, " OPENGL" );
	if ( surface_flags & SDL_OPENGLBLIT ) fprintf ( stdout, " OPENGLBLIT" );
	if ( surface_flags & SDL_RESIZABLE ) fprintf ( stdout, " RESIZABLE" );
	if ( surface_flags & SDL_HWACCEL ) fprintf ( stdout, " HWACCEL" );
	if ( surface_flags & SDL_SRCCOLORKEY ) fprintf ( stdout, " SRCCOLORKEY" );
	if ( surface_flags & SDL_RLEACCEL ) fprintf ( stdout, " RLEACCEL" );
	if ( surface_flags & SDL_SRCALPHA ) fprintf ( stdout, " SRCALPHA" );
	if ( surface_flags & SDL_PREALLOC ) fprintf ( stdout, " PREALLOC" );
	fprintf ( stdout, " )\n" );

	SDL_WM_SetCaption ( "fische 2.0", "fische 2.0" );

	return ( SUCCESS );
}

