/*******************************************************************************
*	fische - standalone sound visualisation for linux		       *
*	Copyright (C) 2006 Marcel Ebmer					       *
*									       *
*	This program is free software; you can redistribute it and/or	       *
*	modify it under the terms of the GNU General Public License	       *
*	as published by the Free Software Foundation; either version 2	       *
*	of the License, or (at your option) any later version.		       *
*									       *
*	This program is distributed in the hope that it will be useful,	       *
*	but WITHOUT ANY WARRANTY; without even the implied warranty of	       *
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       *
*	GNU General Public License for more details.			       *
*									       *
*	You should have received a copy of the GNU General Public License      *
*	along with this program; if not, write to the Free Software	       *
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 	       *
*	MA  02110-1301, USA.						       *
*******************************************************************************/
#include "fische.h"

void create_vectors ( ) {
	
	int x, y;
	int effectno;
	signed char *dp;

	effectno = VECTORS_VERTICAL_CENTERSPLIT;
	vectors = realloc ( vectors, ( effectno + 1 ) * vector_fieldsize );
	if ( ! vectors ) {
		fprintf ( stderr, "EE create_vectors: out of memory\n" );
		exit ( EXIT_FAILURE );
	}
	
	for ( x = 0; x < XRes; x++ ) {
		for ( y = 0; y < YRes; y++ ) {
			*( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 0 ) = 0;
			dp = ( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 1 );
			if ( y <= YRes / 2 ) {
				*dp = XRes / 200;
				while ( ( y + *dp ) < 2 ) *dp += 1;
			}
			if ( y > YRes / 2 ) {
				*dp = -XRes / 200;
				while ( ( y + *dp ) >= ( YRes - 2 ) ) *dp -= 1;
			}
		}
	}

	effectno = VECTORS_HORIZONTAL_CENTERSPLIT;
	vectors = realloc ( vectors, ( effectno + 1 ) * vector_fieldsize );
	if ( ! vectors ) {
		fprintf ( stderr, "EE create_vectors: out of memory\n" );
		exit ( EXIT_FAILURE );
	}

	for ( x = 0; x < XRes; x++ ) {
		for ( y = 0; y < YRes; y++ ) {
			*( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 1 ) = 0;
			dp = ( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 0 );
			if ( x <= XRes / 2 ) {
				*dp = XRes / 200;
				while ( ( x + *dp ) < 2 ) *dp += 1;
			}
			if ( x > XRes / 2 ) {
				*dp = -XRes / 200;
				while ( ( x + *dp ) >= ( XRes - 2 ) ) *dp -= 1;
			}
		}
	}

	effectno = VECTORS_RADIAL_LINEAR;
	vectors = realloc ( vectors, ( effectno + 1 ) * vector_fieldsize );
	if ( ! vectors ) {
		fprintf ( stderr, "EE create_vectors: out of memory\n" );
		exit ( EXIT_FAILURE );
	}

	for ( x = 0; x < XRes; x++ ) {
		for ( y = 0; y < YRes; y++ ) {
			dp = ( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 0 );
			*dp = -( x - XRes / 2 ) / 25;
			while ( ( x + *dp ) < 2 ) *dp += 1;
			while ( ( x + *dp ) >= ( XRes - 2 ) ) *dp -= 1;
			dp = ( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 1 );
			*dp = -( y - YRes / 2 ) / 25;
			while ( ( y + *dp ) < 2 ) *dp += 1;
			while ( ( y + *dp ) >= ( YRes - 2 ) ) *dp -= 1;
		}
	}

	effectno = VECTORS_SCREW_RIGHT_LINEAR;
	vectors = realloc ( vectors, ( effectno + 1 ) * vector_fieldsize );
	if ( ! vectors ) {
		fprintf ( stderr, "EE create_vectors: out of memory\n" );
		exit ( EXIT_FAILURE );
	}

	for ( x = 0; x < XRes; x++ ) {
		for ( y = 0; y < YRes; y++ ) {
			dp = ( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 0 );
			*dp = -( x - XRes / 2 ) / 25 + ( y - YRes / 2 ) / 50;
			while ( ( x + *dp ) < 2 ) *dp += 1;
			while ( ( x + *dp ) >= ( XRes - 2 ) ) *dp -= 1;
			dp = ( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 1 );
			*dp = -( y - YRes / 2 ) / 25 - ( x - XRes / 2 ) / 50;
			while ( ( y + *dp ) < 2 ) *dp += 1;
			while ( ( y + *dp ) >= ( YRes - 2 ) ) *dp -= 1;
		}
	}

	effectno = VECTORS_SCREW_LEFT_LINEAR;
	vectors = realloc ( vectors, ( effectno + 1 ) * vector_fieldsize );
	if ( ! vectors ) {
		fprintf ( stderr, "EE create_vectors: out of memory\n" );
		exit ( EXIT_FAILURE );
	}

	for ( x = 0; x < XRes; x++ ) {
		for ( y = 0; y < YRes; y++ ) {
			dp = ( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 0 );
			*dp = -( x - XRes / 2 ) / 25 - ( y - YRes / 2 ) / 50;
			while ( ( x + *dp ) < 2 ) *dp += 1;
			while ( ( x + *dp ) >= ( XRes - 2 ) ) *dp -= 1;
			dp = ( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 1 );
			*dp = -( y - YRes / 2 ) / 25 + ( x - XRes / 2 ) / 50;
			while ( ( y + *dp ) < 2 ) *dp += 1;
			while ( ( y + *dp ) >= ( YRes - 2 ) ) *dp -= 1;
		}
	}

	effectno = VECTORS_SPIRAL_RIGHT_LINEAR;
	vectors = realloc ( vectors, ( effectno + 1 ) * vector_fieldsize );
	if ( ! vectors ) {
		fprintf ( stderr, "EE create_vectors: out of memory\n" );
		exit ( EXIT_FAILURE );
	}

	for ( x = 0; x < XRes; x++ ) {
		for ( y = 0; y < YRes; y++ ) {
			dp = ( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 0 );
			*dp = ( y - YRes / 2 ) / 25;
			while ( ( x + *dp ) < 2 ) *dp += 1;
			while ( ( x + *dp ) >= ( XRes - 2 ) ) *dp -= 1;
			dp = ( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 1 );
			*dp = -( x - XRes / 2 ) / 25;
			while ( ( y + *dp ) < 2 ) *dp += 1;
			while ( ( y + *dp ) >= ( YRes - 2 ) ) *dp -= 1;
		}
	}

	effectno = VECTORS_SPIRAL_LEFT_LINEAR;
	vectors = realloc ( vectors, ( effectno + 1 ) * vector_fieldsize );
	if ( ! vectors ) {
		fprintf ( stderr, "EE create_vectors: out of memory\n" );
		exit ( EXIT_FAILURE );
	}

	for ( x = 0; x < XRes; x++ ) {
		for ( y = 0; y < YRes; y++ ) {
			dp = ( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 0 );
			*dp = -( y - YRes / 2 ) / 25;
			while ( ( x + *dp ) < 2 ) *dp += 1;
			while ( ( x + *dp ) >= ( XRes - 2 ) ) *dp -= 1;
			dp = ( vectors + effectno * vector_fieldsize + y * XRes * 2 + x * 2 + 1 );
			*dp = ( x - XRes / 2 ) / 25;
			while ( ( y + *dp ) < 2 ) *dp += 1;
			while ( ( y + *dp ) >= ( YRes - 2 ) ) *dp -= 1;
		}
	}
	fprintf ( stdout, "II create_vectors: successfully calculated %u fields\n", effectno + 1 );
}
