!** Copyright (c) 1989, NVIDIA CORPORATION.  All rights reserved.
!**
!** Licensed under the Apache License, Version 2.0 (the "License");
!** you may not use this file except in compliance with the License.
!** You may obtain a copy of the License at
!**
!**     http://www.apache.org/licenses/LICENSE-2.0
!**
!** Unless required by applicable law or agreed to in writing, software
!** distributed under the License is distributed on an "AS IS" BASIS,
!** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!** See the License for the specific language governing permissions and
!** limitations under the License.

!* Tests for runtime library MATMUL routines

program p

  parameter(NbrTests=1418)
  
  real*4, dimension(3) :: arr1
  real*4, dimension(3,4) :: arr2
  real*4, dimension(4) :: arr3
  real*4, dimension(4,4) :: arr4
  real*4, dimension(0:3,-1:1) :: arr5
  real*4, dimension(-3:-1) :: arr6
  real*4, dimension(-1:2,0:3) :: arr7
  real*4, dimension(3) :: arr8
  real*4, dimension(2:4,4) :: arr9
  real*4, dimension(4) :: arr10
  real*4, dimension(3,2:5) :: arr11
  real*4, dimension(4) :: arr12
  real*4, dimension(11) :: arr20
  real*4, dimension(11) :: arr13
  real*4, dimension(11,11) :: arr14
  real*4, dimension(2,11) :: arr15
  real*4, dimension(389) :: arr16
  real*4, dimension(389,387) :: arr17
  real*4, dimension(387) :: arr18
  real*4, dimension(2,387) :: arr19

  integer :: i, j, m2
  
  data arr1 /0,1,2/
  data arr5 /0,1,2,3,4,5,6,7,8,9,10,11/
  data arr2 /0,1,2,3,4,5,6,7,8,9,10,11/
  data arr6 /0,1,2/
  data arr3 /0,1,2,3/
  data arr4 /0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15/
  data arr7 /0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15/
  data arr8 /0,1,2/
  data arr9 /0,1,2,3,4,5,6,7,8,9,10,11/
  data arr11 /0,1,2,3,4,5,6,7,8,9,10,11/
  data arr10 /0,1,2,3/
  
  real*4 :: expect(NbrTests)
  real*4 :: results(NbrTests)
  
  data expect / &
  ! tests 1-4
      5.0, 14.0, 23.0, 32.0, &
  ! tests 5-8
      0.0, 14.0, 23.0, 32.0, &
  ! tests 9-12
      14.0, 23.0, 32.0, 0.0, &
  ! tests 13-16
      0.0, 5.0, 14.0, 23.0, &
  ! tests 17-20
      0.0, 4.0, 7.0, 10.0, &
  ! tests 21-24
      2.0, 5.0, 8.0, 11.0, &
  ! tests 25-28
      2.0, 11.0, 20.0, 29.0, &
  ! tests 29-32
      0.0, 2.0, 11.0, 20.0, &
  ! tests 33-36
      5.0, 8.0, 11.0, 0.0, &
  ! tests 37-40
      10.0, 16.0, 22.0, 0.0, &
  ! tests 41-44
      0.0, 2.0, 0.0, 20.0, &
  ! tests 45-48
      5.0, 0.0, 11.0, 0.0, &
  ! tests 49-64
      0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
      11.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
  ! tests 65-80
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.0, &
      0.0, 11.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
  ! tests 81-96
    0.0, 7.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
    11.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
  ! tests 97-112
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 19.0, &
      0.0, 31.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
  ! tests 113-116
      18.0, 12.0, 6.0, 0.0, &
  ! tests 117-120
      0.0, 1.0, 0.0, 19.0, &
  ! tests 121-136
      0.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
      10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
  ! tests 137-152
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 11.0, &
      0.0, 5.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
  ! tests 153-168
    0.0, 11.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
    7.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
  ! tests 169-184
      0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 31.0, &
      0.0, 19.0, 0.0, 0.0, 0.0, 0.0, 0.0, &
  ! tests 185-188
      5.0, 14.0, 23.0, 32.0, &
  ! tests 187-192
      5.0, 14.0, 23.0, 32.0, &
 ! tests 193-196
      14.0, 23.0, 32.0, 0.0, &
  ! tests 197-200
      0.0, 5.0, 14.0, 23.0, &
  ! tests 201-204
      0.0, 4.0, 7.0, 10.0, &
  ! tests 205-208
      2.0, 5.0, 8.0, 11.0, &
  ! tests 209-212
      2.0, 11.0, 20.0, 29.0, &
  ! tests 213-216
      0.0, 2.0, 11.0, 20.0, &
  ! tests 217-220
      5.0, 8.0, 11.0, 0.0, &
  ! tests 221-224
      10.0, 16.0, 22.0, 0.0, &
  ! test 225,235
      36.0, 72.0, 108.0, 144.0, &
      180.0, 216.0, 252.0, 288.0, &
      324.0, 360.0, 396.0, &
  ! test 236,257
      36.0, 0.0, 72.0, 0.0, &
      108.0, 0.0, 144.0, 0.0, &
      180.0, 0.0, 216.0, 0.0, &
      252.0, 0.0, 288.0, 0.0, &
      324.0, 0.0, 360.0, 0.0, &
      396.0, 0.0, &
  ! test 258,644
      38025.0, 76050.0, 114075.0, 152100.0, &
      190125.0, 228150.0, 266175.0, 304200.0, &
      342225.0, 380250.0, 418275.0, 456300.0, &
      494325.0, 532350.0, 570375.0, 608400.0, &
      646425.0, 684450.0, 722475.0, 760500.0, &
      798525.0, 836550.0, 874575.0, 912600.0, &
      950625.0, 988650.0, 1026675., 1064700., &
      1102725., 1140750., 1178775., 1216800., &
      1254825., 1292850., 1330875., 1368900., &
      1406925., 1444950., 1482975., 1521000., &
      1559025., 1597050., 1635075., 1673100., &
      1711125., 1749150., 1787175., 1825200., &
      1863225., 1901250., 1939275., 1977300., &
      2015325., 2053350., 2091375., 2129400., &
      2167425., 2205450., 2243475., 2281500., &
      2319525., 2357550., 2395575., 2433600., &
      2471625., 2509650., 2547675., 2585700., &
      2623725., 2661750., 2699775., 2737800., &
      2775825., 2813850., 2851875., 2889900., &
      2927925., 2965950., 3003975., 3042000., &
      3080025., 3118050., 3156075., 3194100., &
      3232125., 3270150., 3308175., 3346200., &
      3384225., 3422250., 3460275., 3498300., &
      3536325., 3574350., 3612375., 3650400., &
      3688425., 3726450., 3764475., 3802500., &
      3840525., 3878550., 3916575., 3954600., &
      3992625., 4030650., 4068675., 4106700., &
      4144725., 4182750., 4220775., 4258800., &
      4296825., 4334850., 4372875., 4410900., &
      4448925., 4486950., 4524975., 4563000., &
      4601025., 4639050., 4677075., 4715100., &
      4753125., 4791150., 4829175., 4867200., &
      4905225., 4943250., 4981275., 5019300., &
      5057325., 5095350., 5133375., 5171400., &
      5209425., 5247450., 5285475., 5323500., &
      5361525., 5399550., 5437575., 5475600., &
      5513625., 5551650., 5589675., 5627700., &
      5665725., 5703750., 5741775., 5779800., &
      5817825., 5855850., 5893875., 5931900., &
      5969925., 6007950., 6045975., 6084000., &
      6122025., 6160050., 6198075., 6236100., &
      6274125., 6312150., 6350175., 6388200., &
      6426225., 6464250., 6502275., 6540300., &
      6578325., 6616350., 6654375., 6692400., &
      6730425., 6768450., 6806475., 6844500., &
      6882525., 6920550., 6958575., 6996600., &
      7034625., 7072650., 7110675., 7148700., &
      7186725., 7224750., 7262775., 7300800., &
      7338825., 7376850., 7414875., 7452900., &
      7490925., 7528950., 7566975., 7605000., &
      7643025., 7681050., 7719075., 7757100., &
      7795125., 7833150., 7871175., 7909200., &
      7947225., 7985250., 8023275., 8061300., &
      8099325., 8137350., 8175375., 8213400., &
      8251425., 8289450., 8327475., 8365500., &
      8403525., 8441550., 8479575., 8517600., &
      8555625., 8593650., 8631675., 8669700., &
      8707725., 8745750., 8783775., 8821800., &
      8859825., 8897850., 8935875., 8973900., &
      9011925., 9049950., 9087975., 9126000., &
      9164025., 9202050., 9240075., 9278100., &
      9316125., 9354150., 9392175., 9430200., &
      9468225., 9506250., 9544275., 9582300., &
      9620325., 9658350., 9696375., 9734400., &
      9772425., 9810450., 9848475., 9886500., &
      9924525., 9962550., 1.0000575E+07, 1.0038600E+07, &
      1.0076625E+07, 1.0114650E+07, 1.0152675E+07, 1.0190700E+07, &
      1.0228725E+07, 1.0266750E+07, 1.0304775E+07, 1.0342800E+07, &
      1.0380825E+07, 1.0418850E+07, 1.0456875E+07, 1.0494900E+07, &
      1.0532925E+07, 1.0570950E+07, 1.0608975E+07, 1.0647000E+07, &
      1.0685025E+07, 1.0723050E+07, 1.0761075E+07, 1.0799100E+07, &
      1.0837125E+07, 1.0875150E+07, 1.0913175E+07, 1.0951200E+07, &
      1.0989225E+07, 1.1027250E+07, 1.1065275E+07, 1.1103300E+07, &
      1.1141325E+07, 1.1179350E+07, 1.1217375E+07, 1.1255400E+07, &
      1.1293425E+07, 1.1331450E+07, 1.1369475E+07, 1.1407500E+07, &
      1.1445525E+07, 1.1483550E+07, 1.1521575E+07, 1.1559600E+07, &
      1.1597625E+07, 1.1635650E+07, 1.1673675E+07, 1.1711700E+07, &
      1.1749725E+07, 1.1787750E+07, 1.1825775E+07, 1.1863800E+07, &
      1.1901825E+07, 1.1939850E+07, 1.1977875E+07, 1.2015900E+07, &
      1.2053925E+07, 1.2091950E+07, 1.2129975E+07, 1.2168000E+07, &
      1.2206025E+07, 1.2244050E+07, 1.2282075E+07, 1.2320100E+07, &
      1.2358125E+07, 1.2396150E+07, 1.2434175E+07, 1.2472200E+07, &
      1.2510225E+07, 1.2548250E+07, 1.2586275E+07, 1.2624300E+07, &
      1.2662325E+07, 1.2700350E+07, 1.2738375E+07, 1.2776400E+07, &
      1.2814425E+07, 1.2852450E+07, 1.2890475E+07, 1.2928500E+07, &
      1.2966525E+07, 1.3004550E+07, 1.3042575E+07, 1.3080600E+07, &
      1.3118625E+07, 1.3156650E+07, 1.3194675E+07, 1.3232700E+07, &
      1.3270725E+07, 1.3308750E+07, 1.3346775E+07, 1.3384800E+07, &
      1.3422825E+07, 1.3460850E+07, 1.3498875E+07, 1.3536900E+07, &
      1.3574925E+07, 1.3612950E+07, 1.3650975E+07, 1.3689000E+07, &
      1.3727025E+07, 1.3765050E+07, 1.3803075E+07, 1.3841100E+07, &
      1.3879125E+07, 1.3917150E+07, 1.3955175E+07, 1.3993200E+07, &
      1.4031225E+07, 1.4069250E+07, 1.4107275E+07, 1.4145300E+07, &
      1.4183325E+07, 1.4221350E+07, 1.4259375E+07, 1.4297400E+07, &
      1.4335425E+07, 1.4373450E+07, 1.4411475E+07, 1.4449500E+07, &
      1.4487525E+07, 1.4525550E+07, 1.4563575E+07, 1.4601600E+07, &
      1.4639625E+07, 1.4677650E+07, 1.4715675E+07, &
  ! test 645,1418
      38025.0, 0.0, 76050.0, 0.0, &
      114075.0, 0.0, 152100.0, 0.0, &
      190125.0, 0.0, 228150.0, 0.0, &
      266175.0, 0.0, 304200.0, 0.0, &
      342225.0, 0.0, 380250.0, 0.0, &
      418275.0, 0.0, 456300.0, 0.0, &
      494325.0, 0.0, 532350.0, 0.0, &
      570375.0, 0.0, 608400.0, 0.0, &
      646425.0, 0.0, 684450.0, 0.0, &
      722475.0, 0.0, 760500.0, 0.0, &
      798525.0, 0.0, 836550.0, 0.0, &
      874575.0, 0.0, 912600.0, 0.0, &
      950625.0, 0.0, 988650.0, 0.0, &
      1026675., 0.0, 1064700., 0.0, &
      1102725., 0.0, 1140750., 0.0, &
      1178775., 0.0, 1216800., 0.0, &
      1254825., 0.0, 1292850., 0.0, &
      1330875., 0.0, 1368900., 0.0, &
      1406925., 0.0, 1444950., 0.0, &
      1482975., 0.0, 1521000., 0.0, &
      1559025., 0.0, 1597050., 0.0, &
      1635075., 0.0, 1673100., 0.0, &
      1711125., 0.0, 1749150., 0.0, &
      1787175., 0.0, 1825200., 0.0, &
      1863225., 0.0, 1901250., 0.0, &
      1939275., 0.0, 1977300., 0.0, &
      2015325., 0.0, 2053350., 0.0, &
      2091375., 0.0, 2129400., 0.0, &
      2167425., 0.0, 2205450., 0.0, &
      2243475., 0.0, 2281500., 0.0, &
      2319525., 0.0, 2357550., 0.0, &
      2395575., 0.0, 2433600., 0.0, &
      2471625., 0.0, 2509650., 0.0, &
      2547675., 0.0, 2585700., 0.0, &
      2623725., 0.0, 2661750., 0.0, &
      2699775., 0.0, 2737800., 0.0, &
      2775825., 0.0, 2813850., 0.0, &
      2851875., 0.0, 2889900., 0.0, &
      2927925., 0.0, 2965950., 0.0, &
      3003975., 0.0, 3042000., 0.0, &
      3080025., 0.0, 3118050., 0.0, &
      3156075., 0.0, 3194100., 0.0, &
      3232125., 0.0, 3270150., 0.0, &
      3308175., 0.0, 3346200., 0.0, &
      3384225., 0.0, 3422250., 0.0, &
      3460275., 0.0, 3498300., 0.0, &
      3536325., 0.0, 3574350., 0.0, &
      3612375., 0.0, 3650400., 0.0, &
      3688425., 0.0, 3726450., 0.0, &
      3764475., 0.0, 3802500., 0.0, &
      3840525., 0.0, 3878550., 0.0, &
      3916575., 0.0, 3954600., 0.0, &
      3992625., 0.0, 4030650., 0.0, &
      4068675., 0.0, 4106700., 0.0, &
      4144725., 0.0, 4182750., 0.0, &
      4220775., 0.0, 4258800., 0.0, &
      4296825., 0.0, 4334850., 0.0, &
      4372875., 0.0, 4410900., 0.0, &
      4448925., 0.0, 4486950., 0.0, &
      4524975., 0.0, 4563000., 0.0, &
      4601025., 0.0, 4639050., 0.0, &
      4677075., 0.0, 4715100., 0.0, &
      4753125., 0.0, 4791150., 0.0, &
      4829175., 0.0, 4867200., 0.0, &
      4905225., 0.0, 4943250., 0.0, &
      4981275., 0.0, 5019300., 0.0, &
      5057325., 0.0, 5095350., 0.0, &
      5133375., 0.0, 5171400., 0.0, &
      5209425., 0.0, 5247450., 0.0, &
      5285475., 0.0, 5323500., 0.0, &
      5361525., 0.0, 5399550., 0.0, &
      5437575., 0.0, 5475600., 0.0, &
      5513625., 0.0, 5551650., 0.0, &
      5589675., 0.0, 5627700., 0.0, &
      5665725., 0.0, 5703750., 0.0, &
      5741775., 0.0, 5779800., 0.0, &
      5817825., 0.0, 5855850., 0.0, &
      5893875., 0.0, 5931900., 0.0, &
      5969925., 0.0, 6007950., 0.0, &
      6045975., 0.0, 6084000., 0.0, &
      6122025., 0.0, 6160050., 0.0, &
      6198075., 0.0, 6236100., 0.0, &
      6274125., 0.0, 6312150., 0.0, &
      6350175., 0.0, 6388200., 0.0, &
      6426225., 0.0, 6464250., 0.0, &
      6502275., 0.0, 6540300., 0.0, &
      6578325., 0.0, 6616350., 0.0, &
      6654375., 0.0, 6692400., 0.0, &
      6730425., 0.0, 6768450., 0.0, &
      6806475., 0.0, 6844500., 0.0, &
      6882525., 0.0, 6920550., 0.0, &
      6958575., 0.0, 6996600., 0.0, &
      7034625., 0.0, 7072650., 0.0, &
      7110675., 0.0, 7148700., 0.0, &
      7186725., 0.0, 7224750., 0.0, &
      7262775., 0.0, 7300800., 0.0, &
      7338825., 0.0, 7376850., 0.0, &
      7414875., 0.0, 7452900., 0.0, &
      7490925., 0.0, 7528950., 0.0, &
      7566975., 0.0, 7605000., 0.0, &
      7643025., 0.0, 7681050., 0.0, &
      7719075., 0.0, 7757100., 0.0, &
      7795125., 0.0, 7833150., 0.0, &
      7871175., 0.0, 7909200., 0.0, &
      7947225., 0.0, 7985250., 0.0, &
      8023275., 0.0, 8061300., 0.0, &
      8099325., 0.0, 8137350., 0.0, &
      8175375., 0.0, 8213400., 0.0, &
      8251425., 0.0, 8289450., 0.0, &
      8327475., 0.0, 8365500., 0.0, &
      8403525., 0.0, 8441550., 0.0, &
      8479575., 0.0, 8517600., 0.0, &
      8555625., 0.0, 8593650., 0.0, &
      8631675., 0.0, 8669700., 0.0, &
      8707725., 0.0, 8745750., 0.0, &
      8783775., 0.0, 8821800., 0.0, &
      8859825., 0.0, 8897850., 0.0, &
      8935875., 0.0, 8973900., 0.0, &
      9011925., 0.0, 9049950., 0.0, &
      9087975., 0.0, 9126000., 0.0, &
      9164025., 0.0, 9202050., 0.0, &
      9240075., 0.0, 9278100., 0.0, &
      9316125., 0.0, 9354150., 0.0, &
      9392175., 0.0, 9430200., 0.0, &
      9468225., 0.0, 9506250., 0.0, &
      9544275., 0.0, 9582300., 0.0, &
      9620325., 0.0, 9658350., 0.0, &
      9696375., 0.0, 9734400., 0.0, &
      9772425., 0.0, 9810450., 0.0, &
      9848475., 0.0, 9886500., 0.0, &
      9924525., 0.0, 9962550., 0.0, &
      1.0000575E+07, 0.0, 1.0038600E+07, 0.0, &
      1.0076625E+07, 0.0, 1.0114650E+07, 0.0, &
      1.0152675E+07, 0.0, 1.0190700E+07, 0.0, &
      1.0228725E+07, 0.0, 1.0266750E+07, 0.0, &
      1.0304775E+07, 0.0, 1.0342800E+07, 0.0, &
      1.0380825E+07, 0.0, 1.0418850E+07, 0.0, &
      1.0456875E+07, 0.0, 1.0494900E+07, 0.0, &
      1.0532925E+07, 0.0, 1.0570950E+07, 0.0, &
      1.0608975E+07, 0.0, 1.0647000E+07, 0.0, &
      1.0685025E+07, 0.0, 1.0723050E+07, 0.0, &
      1.0761075E+07, 0.0, 1.0799100E+07, 0.0, &
      1.0837125E+07, 0.0, 1.0875150E+07, 0.0, &
      1.0913175E+07, 0.0, 1.0951200E+07, 0.0, &
      1.0989225E+07, 0.0, 1.1027250E+07, 0.0, &
      1.1065275E+07, 0.0, 1.1103300E+07, 0.0, &
      1.1141325E+07, 0.0, 1.1179350E+07, 0.0, &
      1.1217375E+07, 0.0, 1.1255400E+07, 0.0, &
      1.1293425E+07, 0.0, 1.1331450E+07, 0.0, &
      1.1369475E+07, 0.0, 1.1407500E+07, 0.0, &
      1.1445525E+07, 0.0, 1.1483550E+07, 0.0, &
      1.1521575E+07, 0.0, 1.1559600E+07, 0.0, &
      1.1597625E+07, 0.0, 1.1635650E+07, 0.0, &
      1.1673675E+07, 0.0, 1.1711700E+07, 0.0, &
      1.1749725E+07, 0.0, 1.1787750E+07, 0.0, &
      1.1825775E+07, 0.0, 1.1863800E+07, 0.0, &
      1.1901825E+07, 0.0, 1.1939850E+07, 0.0, &
      1.1977875E+07, 0.0, 1.2015900E+07, 0.0, &
      1.2053925E+07, 0.0, 1.2091950E+07, 0.0, &
      1.2129975E+07, 0.0, 1.2168000E+07, 0.0, &
      1.2206025E+07, 0.0, 1.2244050E+07, 0.0, &
      1.2282075E+07, 0.0, 1.2320100E+07, 0.0, &
      1.2358125E+07, 0.0, 1.2396150E+07, 0.0, &
      1.2434175E+07, 0.0, 1.2472200E+07, 0.0, &
      1.2510225E+07, 0.0, 1.2548250E+07, 0.0, &
      1.2586275E+07, 0.0, 1.2624300E+07, 0.0, &
      1.2662325E+07, 0.0, 1.2700350E+07, 0.0, &
      1.2738375E+07, 0.0, 1.2776400E+07, 0.0, &
      1.2814425E+07, 0.0, 1.2852450E+07, 0.0, &
      1.2890475E+07, 0.0, 1.2928500E+07, 0.0, &
      1.2966525E+07, 0.0, 1.3004550E+07, 0.0, &
      1.3042575E+07, 0.0, 1.3080600E+07, 0.0, &
      1.3118625E+07, 0.0, 1.3156650E+07, 0.0, &
      1.3194675E+07, 0.0, 1.3232700E+07, 0.0, &
      1.3270725E+07, 0.0, 1.3308750E+07, 0.0, &
      1.3346775E+07, 0.0, 1.3384800E+07, 0.0, &
      1.3422825E+07, 0.0, 1.3460850E+07, 0.0, &
      1.3498875E+07, 0.0, 1.3536900E+07, 0.0, &
      1.3574925E+07, 0.0, 1.3612950E+07, 0.0, &
      1.3650975E+07, 0.0, 1.3689000E+07, 0.0, &
      1.3727025E+07, 0.0, 1.3765050E+07, 0.0, &
      1.3803075E+07, 0.0, 1.3841100E+07, 0.0, &
      1.3879125E+07, 0.0, 1.3917150E+07, 0.0, &
      1.3955175E+07, 0.0, 1.3993200E+07, 0.0, &
      1.4031225E+07, 0.0, 1.4069250E+07, 0.0, &
      1.4107275E+07, 0.0, 1.4145300E+07, 0.0, &
      1.4183325E+07, 0.0, 1.4221350E+07, 0.0, &
      1.4259375E+07, 0.0, 1.4297400E+07, 0.0, &
      1.4335425E+07, 0.0, 1.4373450E+07, 0.0, &
      1.4411475E+07, 0.0, 1.4449500E+07, 0.0, &
      1.4487525E+07, 0.0, 1.4525550E+07, 0.0, &
      1.4563575E+07, 0.0, 1.4601600E+07, 0.0, &
      1.4639625E+07, 0.0, 1.4677650E+07, 0.0, &
      1.4715675E+07, 0.0 /

  ! tests 1-4
  arr3=0
  arr3 = matmul(arr1,arr2)
  call assign_result(1,4,arr3,results)
  !print *,arr3
  
  ! tests 5-8
  arr3=0
  arr3(2:4) = matmul(arr1,arr2(:, 2:4))
  call assign_result(5,8,arr3,results)
  !print *,arr3
  
  ! tests 9-12
  arr3=0
  arr3(1:3) = matmul(arr1,arr2(:,2:4))
  call assign_result(9,12,arr3,results)
  !print *,arr3
  
  !tests 13-16
  arr3=0
  arr3(2:4) = matmul(arr1,arr2(:, 1:3))
   call assign_result(13,16,arr3,results)
  !print *,arr3
  
  !tests 17-20
  arr3=0
  arr3(2:4) = matmul(arr1(1:2),arr2(1:2,2:4))
  call assign_result(17,20,arr3,results)
  !print *,arr3
  
  !tests 21-24
  arr3=0
  arr3 = matmul(arr1(1:2),arr2(2:3,:))
  call assign_result(21,24,arr3,results)
  !print *,arr3
  
  !tests 25-28
  arr3=0
  arr3 = matmul(arr1(2:3),arr2(1:2,:))
  call assign_result(25,28,arr3,results)
  !print *,arr3
  
  !tests 29-32
  arr3=0
  arr3(2:4)  = matmul(arr1(2:3),arr2(1:2,1:3))
  call assign_result(29,32,arr3,results)
  !print *,arr3
  
  !tests 33-36
  arr3=0
  arr3(1:3)  = matmul(arr1(1:2),arr2(2:3,2:4))
  call assign_result(33,36,arr3,results)
  !print *,arr3
  
  !tests 37-40
  arr3=0
  arr3(1:3) = matmul(arr1(1:3:2),arr2(1:3:2,2:4))
  call assign_result(37,40,arr3,results)
  !print *,arr3
  
  !tests 41-44
  arr3=0
  arr3(2:4:2)  = matmul(arr1(2:3),arr2(1:2,1:3:2))
  call assign_result(41,44,arr3,results)
  !print *,arr3
  
  !tests 45-48
  arr3=0
  arr3(1:3:2)  = matmul(arr1(1:2),arr2(2:3,2:4:2))
  call assign_result(45,48,arr3,results)
  !print *,arr3
  
  !tests 49-64
  arr4=0
  arr4(2,1:3:2)  = matmul(arr1(1:2),arr2(2:3,2:4:2))
  call assign_result(49,64,arr4,results)
  !print *,arr4
  
  !tests 65-80
  arr4=0
  arr4(1:3:2,3)  = matmul(arr1(1:2),arr2(2:3,2:4:2))
  call assign_result(65,80,arr4,results)
  !print *,arr4
  
  !tests 81-96
  arr7=0
  arr7(0,0:2:2)  = matmul(arr6(-3:-2),arr5(1:3:2,0:1))
  call assign_result(81,96,arr7,results)
  !print *,arr7
  
  !tests 97-112
  arr7=0
  arr7(-1:1:2,2)  = matmul(arr6(-2:-1),arr5(1:3:2,0:1))
  call assign_result(97,112,arr7,results)
  !print *,arr7
  
  !tests 113-116
  arr3=0
  arr3(3:1:-1) = matmul(arr1(3:1:-2),arr2(1:3:2,2:4))
  call assign_result(113,116,arr3,results)
  !print *,arr3
  
  !tests 117-120
  arr3=0
  arr3(4:2:-2)  = matmul(arr1(3:2:-1),arr2(1:2,3:1:-2))
  call assign_result(117,120,arr3,results)
  !print *,arr3
  
  !tests 121-136
  arr4=0
  arr4(2,3:1:-2)  = matmul(arr1(1:2),arr2(3:2:-1,4:2:-2))
  call assign_result(121,136,arr4,results)
  !print *,arr4
  
  !tests 137-152
  arr4=0
  arr4(3:1:-2,3)  = matmul(arr1(2:1:-1),arr2(3:2:-1,2:4:2))
  call assign_result(137,152,arr4,results)
  !print *,arr4
  
  !tests 153-168
  arr7=0
  arr7(0,2:0:-2)  = matmul(arr6(-3:-2),arr5(1:3:2,0:1))
  call assign_result(153,168,arr7,results)
  !print *,arr7
  
  !tests 169-184
  arr7=0
  arr7(1:-1:-2,2)  = matmul(arr6(-1:-2:-1),arr5(3:1:-2,0:1))
  call assign_result(169,184,arr7,results)
  !print *,arr7
  
  arr12 = 0

  ! tests 185-188
  arr10=0
  arr10 = arr12 + matmul(arr8,arr9)
  call assign_result(185,188,arr10,results)
  !print *,arr10

  ! tests 189-192
  arr10=0
  arr10 = arr12 +  matmul(arr8,arr11)
  call assign_result(189,192,arr10,results)
  !print *,arr10

  ! tests 193-196
  arr10=0
  arr10(1:3) = arr12(1:3)  + matmul(arr8,arr9(:,2:4))
  call assign_result(193,196,arr10,results)
  !print *,arr10
  
  !tests 197-200
  arr10=0 
  arr10(2:4) = arr12(2:4) + matmul(arr8,arr9(:, 1:3))
  call assign_result(197,200,arr10,results)
  !print *,arr10
  
  !tests 201-204
  arr10=0 
  arr10(2:4) = arr12(2:4) + matmul(arr8(1:2),arr9(2:3,2:4))
  call assign_result(201,204,arr10,results)
  !print *,arr10
  
  !tests 205-208
  arr10=0 
  arr10 = arr12 + matmul(arr8(1:2),arr9(3:4,:))
  call assign_result(205,208,arr10,results)
  !print *,arr10

  !tests 209-212
  arr10=0
  arr10 = arr12 + matmul(arr8(2:3),arr9(2:3,:))
  call assign_result(209,212,arr10,results)
  !print *,arr10

  !tests 213-216
  arr10=0
  arr10(2:4)  = arr12(2:4) + matmul(arr8(2:3),arr9(2:3,1:3))
  call assign_result(213,216,arr10,results)
  !print *,arr10

  !tests 217-220
  arr10=0
  arr10(1:3)  = arr12(1:3) + matmul(arr8(1:2),arr9(3:4,2:4))
  call assign_result(217,220,arr10,results)
  !print *,arr10

  !tests 221-224
  arr10=0
  arr10(1:3) = arr12(1:3) + matmul(arr8(1:3:2),arr9(2:4:2,2:4))
  call assign_result(221,224,arr10,results)
  !print *,arr10

   do i = 1,11
     m2 = mod(i,2)
     if (m2 .eq. 0 ) then
         arr13(i) = 0
     else
         arr13(i) = i
     endif
     do j = 1,11
         arr14(i,j) = j;
     enddo
  enddo

  ! tests 225-235
  arr20=0
  arr20 = matmul(arr13,arr14)
  call assign_result(225,235,arr20,results)
  !print *,"test 225,235"
  !print *,arr20

  ! tests 236-257
  arr15=0
  arr15(1,:) = matmul(arr13,arr14)
  call assign_result(236,257,arr15,results)
  !print *,"test 236,257"
  !print *,arr15

   do i = 1,389
     m2 = mod(i,2)
     if (m2 .eq. 0 ) then
         arr16(i) = 0
     else
         arr16(i) = i
     endif
     do j = 1,387
         arr17(i,j) = j
     enddo
  enddo

  ! tests 258-644
  arr18=0
  arr18 = matmul(arr16,arr17)
  call assign_result(258,644,arr18,results)
  !print *,"test 258,644"
  !print *,arr18

  ! tests 645-1418
  arr19=0
  arr19(1,:) = matmul(arr16,arr17)
  call assign_result(645,1418,arr19,results)
  !print *,"test 645,1418"
  !print *,arr19

  call check(results, expect, NbrTests)

end program

subroutine assign_result(s_idx, e_idx , arr, rslt)
  REAL*4, dimension(1:e_idx-s_idx+1) :: arr
  REAL*4, dimension(e_idx) :: rslt
  integer:: s_idx, e_idx

  rslt(s_idx:e_idx) = arr

end subroutine

