/***** BEGIN LICENSE BLOCK *****

    FlashGot - a Firefox extension for external download managers integration
    Copyright (C) 2004-2009 Giorgio Maone - g.maone@informaction.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
                             
***** END LICENSE BLOCK *****/

const CI = Components.interfaces;
const CC = Components.classes;

var Chooser = {
  init: function() {
    this.dialog = document.documentElement;
   
    this.params = window.arguments[0];
    this.params.choosenDir = this.params.initialDir;
    
    this.dialog.setAttribute("title", this.params.title);
    document.getElementById("destLabel").setAttribute("value",
      this.destFolderLabel = gFlashGotService.getString("ph.FOLDER")
    );
    if (this.params.choosenDir) {
      this.sync();
    } else {
      this.browse();
    }
  },
  
  sync: function() {
    var t = document.getElementById("dest");
    var d = this.params.choosenDir;
    if (d && t.value != d.path) {
      t.value = d.path;
    } 
    this.dialog.getButton("accept").setAttribute("disabled", !d);
  },
  
  folderChanged: function(t) {
    var path = t.value;
    this.params.choosenDir = null;      
    try {
      var d = CC["@mozilla.org/file/local;1"].createInstance(CI.nsILocalFile);
      d.initWithPath(t.value);
      if (!d.exists() || d.isDirectory())
        this.params.choosenDir = d;      
    } catch(e) {
    }
    this.sync();
  },

  browse: function() {
    const fp = CC["@mozilla.org/filepicker;1"].createInstance(CI.nsIFilePicker);
   
    fp.init(window, this.params.title + " - " + this.destFolderLabel, CI.nsIFilePicker.modeGetFolder);
    var d = this.params.choosenDir || this.params.initialDir;
    try {
      if (d && (d.exists() || (d = d.parent).exists()) && d.isDirectory()) {
        fp.displayDirectory = d;
      }
    } catch (ex) { gFlashGotService.log(ex); }
    
    fp.appendFilters(CI.nsIFilePicker.filterAll);
    
    if (fp.show() == CI.nsIFilePicker.returnOK) {
      this.params.choosenDir = fp.file;
      this.sync();
    }
  },
  
  accept: function() {
    // create directory if it does not exist
    var d = this.params.choosenDir;
    if (d && !d.exists()) {
      var permissions = d.parent.exists() ? d.parent.permissions : 0600;
      try {
        d.create(CI.nsIFile.DIRECTORY_TYPE, permissions);
      } catch(e) {
      }
    }
  },
  cancel: function() {
    this.params.choosenDir = null;
  }
}