#ifndef _PROPENGINE_HPP
#define _PROPENGINE_HPP

#include "Thruster.hpp"

namespace yasim {

class Propeller;
class PistonEngine;

class PropEngine : public Thruster {
public:
    PropEngine(Propeller* prop, PistonEngine* eng, float moment);
    virtual ~PropEngine();

    void setAdvance(float advance);
    void setVariableProp(float min, float max);

    virtual PropEngine* getPropEngine() { return this; }
    virtual PistonEngine* getPistonEngine() { return _eng; }
    virtual Propeller* getPropeller() { return _prop; }

    // Dynamic output
    virtual void getThrust(float* out);
    virtual void getTorque(float* out);
    virtual void getGyro(float* out);
    virtual float getFuelFlow();

    // Runtime instructions
    virtual void integrate(float dt);
    virtual void stabilize();

    float getOmega();
    
private:
    float _moment;
    Propeller* _prop;
    PistonEngine* _eng;

    bool _variable;
    float _advance; // control input, 0-1
    float _maxOmega;
    float _minOmega;

    float _omega; // RPM, in radians/sec
    float _thrust[3];
    float _torque[3];
    float _gyro[3];
    float _fuelFlow;
};

}; // namespace yasim
#endif // _PROPENGINE_HPP
