{
    $Id: stringss.inc,v 1.12 2004/05/01 17:02:37 jonas Exp $
    This file is part of the Free Pascal run time library.
    Copyright (c) 1999-2000 by Jonas Maebe, member of the
    Free Pascal development team

    Processor dependent part of strings.pp, not shared with
    sysutils unit.

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

{$ifndef FPC_UNIT_HAS_STRPAS}
{$define FPC_UNIT_HAS_STRPAS}
function strpas(p : pchar) : string; assembler;
{$i strpas.inc}
{$endif FPC_UNIT_HAS_STRPAS}

{$ifndef FPC_UNIT_HAS_STRPCOPY}
{$define FPC_UNIT_HAS_STRPCOPY}
function strpcopy(d : pchar;const s : string) : pchar;assembler;
asm
        { get length  }
        lbz     r0,0(r4)
        { put in counter }
        cmplwi  r0,0
        mtctr   r0
        subi    r10,r3,1
        beq     .LStrPCopyEmpty
.LStrPCopyLoop:
        { copy everything }
        lbzu    r0,1(r4)
        stbu    r0,1(r10)
        bdnz    .LStrPCopyLoop
        { add terminating #0 }
        li      r0,0
.LStrPCopyEmpty:
        stb     r0,1(r10)
end;
{$endif FPC_UNIT_HAS_STRPCOPY}

{
  $Log: stringss.inc,v $
  Revision 1.12  2004/05/01 17:02:37  jonas
    * use some more string routines from libc if FPC_USE_LIBC is used

  Revision 1.11  2003/11/29 16:27:19  jonas
    * fixed several ppc assembler reader related problems
    * local vars in assembler procedures now start at offset 4
    * fixed second_int_to_bool (apparently an integer can be in  LOC_JUMP??)

  Revision 1.10  2003/07/07 20:23:46  peter
    * added defines to override generic implementations

  Revision 1.9  2003/06/14 12:41:09  jonas
    * fixed compilation problems (removed unnecessary modified registers
      lists from procedures)

  Revision 1.8  2002/09/11 07:49:40  jonas
    * fixed assembler errors

  Revision 1.7  2002/09/07 16:01:26  peter
    * old logs removed and tabs fixed

  Revision 1.6  2002/09/06 16:58:43  jonas
    * fixed wrong references (used r0 as base register)

  Revision 1.5  2002/08/10 17:14:36  jonas
    * various fixes, mostly changing the names of the modifies registers to
      upper case since that seems to be required by the compiler

}
