/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   Predrag.Viceic@ci.unil.ch                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "floatspinbox.h"

FloatSpinBox::FloatSpinBox(QWidget* parent)
 : QSpinBox(parent)
{
}


FloatSpinBox::~FloatSpinBox()
{
}

QString FloatSpinBox::mapValueToText( int value ){
	return QString( "%1.%2" ) // 0.0 to 10.0
		.arg( value / 10 ).arg( value % 10 );
}

int FloatSpinBox::mapTextToValue( bool *){
	return (int) ( 10 * text().toFloat() ); // 0 to 100
}


