/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "mysavefiledialog.h"

MySaveFileDialog::MySaveFileDialog(QWidget *parent, const char *name)
 : QFileDialog(parent, name,TRUE)
{
    resize(600,700);

    QHButtonGroup* waveFormatFrame=new QHButtonGroup("Wave format",this);
    waveFormatFrame->setMinimumWidth(600);
    QLabel label4("Export bits per sample",waveFormatFrame);
    exportBitsPerSampleDropdown=new BitsPerSampleDropdown(waveFormatFrame);
    addWidgets(0,waveFormatFrame,0);


    /*
    QLabel* label3=new QLabel("Per Chunk attack time",this);
    attackTimeSpinBox=new QSpinBox(this);
    attackTimeSpinBox->setMinValue(0);
    attackTimeSpinBox->setMaxValue(999);
    attackTimeSpinBox->setMinimumWidth(40);
    attackTimeSpinBox->setSuffix(" ms");
    attackTimeSpinBox->setEnabled(FALSE);
    addWidgets(label3,attackTimeSpinBox,0);
    */
    
    QHBox* akp_midi_frame=new QHBox(this);
    akp_midi_frame->setSpacing(10);
    
    QHButtonGroup* midiFrame=new QHButtonGroup("MIDI file export",akp_midi_frame);
    midiFrame->setMinimumWidth(295);
    exportMidifileCheckbox=new QCheckBox("Export midifile",midiFrame);
    
    
    
    QHButtonGroup* akpFrame=new QHButtonGroup("AKAI export",akp_midi_frame);
    akpFrame->setMinimumWidth(295);
    exportAKPCheckbox=new QCheckBox("Export AKP",akpFrame);
    
    addWidgets(0,akp_midi_frame,0);
    
    
    
    QHButtonGroup* exportToSoftSamplers=new QHButtonGroup("Export to Software sampler",this);
    exportToSoftSamplers->setMinimumWidth(600);
    
    
    QHBox* softSamplerExports=new QHBox(exportToSoftSamplers);
    exportSF2Checkbox=new QCheckBox("SoundFont 2",softSamplerExports);
    exportDLSCheckbox=new QCheckBox("DLS",softSamplerExports);
    exportDLSCheckbox->setEnabled(FALSE);
    exportGigaCheckbox=new QCheckBox("Giga",softSamplerExports);
    exportGigaCheckbox->setEnabled(FALSE);
    removeChunksCheckbox=new QCheckBox("Remove chunks",exportToSoftSamplers);
    removeChunksCheckbox->setEnabled(FALSE);
    connect(exportSF2Checkbox,SIGNAL(clicked()),this,SLOT(exportToSoftSamplerClicked()));
    connect(exportDLSCheckbox,SIGNAL(clicked()),this,SLOT(exportToSoftSamplerClicked()));
    connect(exportGigaCheckbox,SIGNAL(clicked()),this,SLOT(exportToSoftSamplerClicked()));
    #ifdef HAS_LIBINSTPATCH
        addWidgets(0,exportToSoftSamplers,0);
    #else
        exportToSoftSamplers->hide();
    #endif
        
    
    
    
    QHBox* midi_range=new QHBox(this);
    midi_range->setSpacing(10);
    
    QHButtonGroup* assignMidi=new QHButtonGroup("MIDI Assignement",midi_range);
    assignMidi->setMinimumWidth(295);
    assignMissingMIDINotesCheckbox=new QCheckBox("Assign missing midi notes",assignMidi);
    assignMissingMIDINotesCheckbox->setEnabled(FALSE);
    
    connect(exportSF2Checkbox,SIGNAL(clicked()),this,SLOT(checkIfMidiAutoAssignementNeeded()));
    connect(exportDLSCheckbox,SIGNAL(clicked()),this,SLOT(checkIfMidiAutoAssignementNeeded()));
    connect(exportGigaCheckbox,SIGNAL(clicked()),this,SLOT(checkIfMidiAutoAssignementNeeded()));
    connect(exportMidifileCheckbox,SIGNAL(clicked()),this,SLOT(checkIfMidiAutoAssignementNeeded()));
    connect(exportAKPCheckbox,SIGNAL(clicked()),this,SLOT(checkIfMidiAutoAssignementNeeded()));

    QHButtonGroup* exportRange=new QHButtonGroup("Export range",midi_range);
    exportRange->setMinimumWidth(295);
    exportRange->setExclusive(TRUE);
    exportAll=new QRadioButton("All",exportRange);
    exportAll->setChecked(TRUE);
    exportLoop=new QRadioButton("Loop",exportRange);
    
    addWidgets(0,midi_range,0);
    
    
    
    //connect(exportMidifileCheckbox,SIGNAL(toggled(bool)),reassignEmptyMIDICheckbox,SLOT(setEnabled(bool)));
    //connect(exportAKPCheckbox,SIGNAL(toggled(bool)),reassignEmptyMIDIAKPCheckbox,SLOT(setEnabled(bool)));
    

    setMode(QFileDialog::AnyFile);
}


MySaveFileDialog::~MySaveFileDialog()
{
}




/*!
    \fn MySaveFileDialog::exportMidifile()
 */
bool MySaveFileDialog::exportMidifile()
{
    return exportMidifileCheckbox->isChecked();
}

/*!
    \fn MySaveFileDialog::exportAKP()
 */
bool MySaveFileDialog::exportAKP()
{
    return exportAKPCheckbox->isChecked();
}




/*!
    \fn MySaveFileDialog::exportMode()
 */
int MySaveFileDialog::exportMode()
{
    if(exportLoop->isChecked()) return EXPORT_LOOP;
    else if(exportAll->isChecked()) return EXPORT_ALL;
    else return -1;
}


/*!
    \fn MySaveFileDialog::getAttackTime()
 */
int MySaveFileDialog::getAttackTime()
{
    return attackTimeSpinBox->value();
}

/*!
    \fn MySaveFileDialog::getExportBitsPerSample()
 */
int MySaveFileDialog::getExportBitsPerSample()
{
    return exportBitsPerSampleDropdown->getModifier();
}

int MySaveFileDialog::exec()
{
    rereadDir();
    return QFileDialog::exec();
}


/*!
    \fn MySaveFileDialog::setBps(int)
 */
void MySaveFileDialog::setBps(int bps)
{
    exportBitsPerSampleDropdown->setBps(bps);
}


/*!
    \fn MySaveFileDialog::assignMissingMIDINotes()
 */
bool MySaveFileDialog::assignMissingMIDINotes()
{
     return assignMissingMIDINotesCheckbox->isChecked();
}


/*!
    \fn MySaveFileDialog::exportSF2()
 */
bool MySaveFileDialog::exportSF2()
{
    return exportSF2Checkbox->isChecked();
}


/*!
    \fn MySaveFileDialog::exportGiga()
 */
bool MySaveFileDialog::exportGiga()
{
    return exportGigaCheckbox->isChecked();
}


/*!
    \fn MySaveFileDialog::exportDLS()
 */
bool MySaveFileDialog::exportDLS()
{
    return exportDLSCheckbox->isChecked();
}


/*!
    \fn MySaveFileDialog::removeChunks()
 */
bool MySaveFileDialog::removeChunks()
{
    return removeChunksCheckbox->isChecked();
}


/*!
    \fn MySaveFileDialog::exportToSoftSamplerClicked()
 */
void MySaveFileDialog::exportToSoftSamplerClicked()
{
    if(exportSF2Checkbox->isChecked() ||
        exportDLSCheckbox->isChecked() ||
        exportGigaCheckbox->isChecked()){
        
        removeChunksCheckbox->setEnabled(TRUE);
        exportBitsPerSampleDropdown->setBps(16);
    }else{
        removeChunksCheckbox->setChecked(FALSE);
        removeChunksCheckbox->setEnabled(FALSE);
    }
}


/*!
    \fn MySaveFileDialog::checkIfMidiAutoAssignementNeeded()
 */
void MySaveFileDialog::checkIfMidiAutoAssignementNeeded()
{
    if( exportAKPCheckbox->isChecked() || 
        exportMidifileCheckbox->isChecked() ||
        exportSF2Checkbox->isChecked() ||
        exportDLSCheckbox->isChecked() ||
        exportGigaCheckbox->isChecked()){
        assignMissingMIDINotesCheckbox->setEnabled(TRUE);
        assignMissingMIDINotesCheckbox->setChecked(TRUE);
        exportBitsPerSampleDropdown->setBps(16);
    }else{
        assignMissingMIDINotesCheckbox->setChecked(FALSE);
        assignMissingMIDINotesCheckbox->setEnabled(FALSE);
    }
}
