#ifndef MISC_H
#define MISC_H

/*****************
**    misc.c    **
******************/
int listen_on_socket(struct sockaddr_in *listen_address, socketuse use);
int connect_to_socket(struct sockaddr_in listen_address, socketuse use);
int bind_me(int fd, struct sockaddr_in *addr, int lo, int hi,
	    int attempts);
struct sockaddr_in com2n(int a1, int a2, int a3, int a4, int p1, int p2);
void n2com(struct sockaddr_in address, int *a1, int *a2, int *a3, int *a4,
	   int *p1, int *p2);
void closeandexit(int status);
struct sockaddr_in extract_address(const sstr * buf);
void write_log(int priority, const char *msg, ...);
sstr *addr2name(struct in_addr address);
void set_server_name(void);
void quit(exitreason reason);
int append_read(int fd, char *buf);
void sstrerr(void);
int send_fd(int sock_fd, int send_fd, char msg);
char recv_fd(int sock_fd, int *recv_fd);
void set_write_lock(int fd);
int set_read_lock(int fd);
int do_chroot(void);
int droppriv(void);
void kill_procs(void);

#endif /*MISC_H*/
