/* plugin.c generated by valac 0.16.1, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
 * Copyright (C) 2009-2012 Michael 'Mickey' Lauer <mlauer@vanille-media.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <freesmartphone.h>
#include <fsobasics.h>
#include <stdlib.h>
#include <string.h>
#include <fsoframework.h>
#include <gee.h>
#include <gio/gio.h>
#include <fsodevice.h>
#include <linux/input.h>
#include <sys/ioctl.h>
#include <fsoresource.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>

typedef struct _KernelIdleStatus KernelIdleStatus;

#define KERNEL_TYPE_IDLE_NOTIFIER (kernel_idle_notifier_get_type ())
#define KERNEL_IDLE_NOTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KERNEL_TYPE_IDLE_NOTIFIER, KernelIdleNotifier))
#define KERNEL_IDLE_NOTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KERNEL_TYPE_IDLE_NOTIFIER, KernelIdleNotifierClass))
#define KERNEL_IS_IDLE_NOTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KERNEL_TYPE_IDLE_NOTIFIER))
#define KERNEL_IS_IDLE_NOTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KERNEL_TYPE_IDLE_NOTIFIER))
#define KERNEL_IDLE_NOTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KERNEL_TYPE_IDLE_NOTIFIER, KernelIdleNotifierClass))

typedef struct _KernelIdleNotifier KernelIdleNotifier;
typedef struct _KernelIdleNotifierClass KernelIdleNotifierClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _KernelIdleNotifierPrivate KernelIdleNotifierPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _kernel_idle_status_free0(var) ((var == NULL) ? NULL : (var = (kernel_idle_status_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _KernelIdleNotifierRequestUsageServiceData KernelIdleNotifierRequestUsageServiceData;

#define KERNEL_TYPE_CPU_RESOURCE (kernel_cpu_resource_get_type ())
#define KERNEL_CPU_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KERNEL_TYPE_CPU_RESOURCE, KernelCpuResource))
#define KERNEL_CPU_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KERNEL_TYPE_CPU_RESOURCE, KernelCpuResourceClass))
#define KERNEL_IS_CPU_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KERNEL_TYPE_CPU_RESOURCE))
#define KERNEL_IS_CPU_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KERNEL_TYPE_CPU_RESOURCE))
#define KERNEL_CPU_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KERNEL_TYPE_CPU_RESOURCE, KernelCpuResourceClass))

typedef struct _KernelCpuResource KernelCpuResource;
typedef struct _KernelCpuResourceClass KernelCpuResourceClass;

#define KERNEL_TYPE_DISPLAY_RESOURCE (kernel_display_resource_get_type ())
#define KERNEL_DISPLAY_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KERNEL_TYPE_DISPLAY_RESOURCE, KernelDisplayResource))
#define KERNEL_DISPLAY_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KERNEL_TYPE_DISPLAY_RESOURCE, KernelDisplayResourceClass))
#define KERNEL_IS_DISPLAY_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KERNEL_TYPE_DISPLAY_RESOURCE))
#define KERNEL_IS_DISPLAY_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KERNEL_TYPE_DISPLAY_RESOURCE))
#define KERNEL_DISPLAY_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KERNEL_TYPE_DISPLAY_RESOURCE, KernelDisplayResourceClass))

typedef struct _KernelDisplayResource KernelDisplayResource;
typedef struct _KernelDisplayResourceClass KernelDisplayResourceClass;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
typedef struct _KernelIdleNotifierGetStateData KernelIdleNotifierGetStateData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _KernelIdleNotifierGetTimeoutsData KernelIdleNotifierGetTimeoutsData;
typedef struct _KernelIdleNotifierSetStateData KernelIdleNotifierSetStateData;
typedef struct _KernelIdleNotifierSetTimeoutData KernelIdleNotifierSetTimeoutData;
typedef struct _KernelDisplayResourcePrivate KernelDisplayResourcePrivate;
typedef struct _kernel_display_resource_enableResourceData kernel_display_resource_enableResourceData;
typedef struct _kernel_display_resource_disableResourceData kernel_display_resource_disableResourceData;
typedef struct _kernel_display_resource_suspendResourceData kernel_display_resource_suspendResourceData;
typedef struct _kernel_display_resource_resumeResourceData kernel_display_resource_resumeResourceData;
typedef struct _KernelCpuResourcePrivate KernelCpuResourcePrivate;
typedef struct _kernel_cpu_resource_enableResourceData kernel_cpu_resource_enableResourceData;
typedef struct _kernel_cpu_resource_disableResourceData kernel_cpu_resource_disableResourceData;
typedef struct _kernel_cpu_resource_suspendResourceData kernel_cpu_resource_suspendResourceData;
typedef struct _kernel_cpu_resource_resumeResourceData kernel_cpu_resource_resumeResourceData;

struct _KernelIdleStatus {
	gint* timeouts;
	gint timeouts_length1;
	FreeSmartphoneDeviceIdleState status;
	guint watch;
};

struct _KernelIdleNotifier {
	FsoFrameworkAbstractObject parent_instance;
	KernelIdleNotifierPrivate * priv;
};

struct _KernelIdleNotifierClass {
	FsoFrameworkAbstractObjectClass parent_class;
};

struct _KernelIdleNotifierPrivate {
	FsoFrameworkSubsystem* subsystem;
	gchar* sysfsnode;
	gint* fds;
	gint fds_length1;
	gint _fds_size_;
	GIOChannel** channels;
	gint channels_length1;
	gint _channels_size_;
	KernelIdleStatus* idlestatus;
	gchar** states;
	gint states_length1;
	gint _states_size_;
	GeeHashMap* stateIgnoreById;
	FreeSmartphoneDeviceIdleState displayResourcePreventState;
	FreeSmartphoneUsage* usage;
	FreeSmartphoneUsageSystemAction lastSystemAction;
};

struct _KernelIdleNotifierRequestUsageServiceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelIdleNotifier* self;
	FreeSmartphoneUsage* _tmp0_;
	FreeSmartphoneUsage* _tmp1_;
	FreeSmartphoneUsage* _tmp2_;
	GError* err;
	FsoFrameworkLogger* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GError * _inner_error_;
};

struct _KernelIdleNotifierGetStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelIdleNotifier* self;
	FreeSmartphoneDeviceIdleState result;
};

struct _KernelIdleNotifierGetTimeoutsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelIdleNotifier* self;
	GHashTable* result;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* dict;
	gint i;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GHashTable* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	FsoFrameworkSmartKeyFile* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_;
	const gchar* _tmp16_;
	KernelIdleStatus* _tmp17_;
	gint* _tmp18_;
	gint _tmp18__length1;
	gint _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
};

struct _KernelIdleNotifierSetStateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelIdleNotifier* self;
	FreeSmartphoneDeviceIdleState status;
	KernelIdleStatus* _tmp0_;
	FreeSmartphoneDeviceIdleState _tmp1_;
};

struct _KernelIdleNotifierSetTimeoutData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelIdleNotifier* self;
	FreeSmartphoneDeviceIdleState status;
	gint timeout;
	FsoFrameworkSmartKeyFile* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	FreeSmartphoneDeviceIdleState _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	KernelIdleStatus* _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	FreeSmartphoneDeviceIdleState _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
};

struct _KernelDisplayResource {
	FsoFrameworkAbstractDBusResource parent_instance;
	KernelDisplayResourcePrivate * priv;
	gboolean on;
};

struct _KernelDisplayResourceClass {
	FsoFrameworkAbstractDBusResourceClass parent_class;
};

struct _kernel_display_resource_enableResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelDisplayResource* self;
	gboolean _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	gboolean _tmp2_;
	KernelIdleNotifier* _tmp3_;
};

struct _kernel_display_resource_disableResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelDisplayResource* self;
	gboolean _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	gboolean _tmp2_;
	KernelIdleNotifier* _tmp3_;
};

struct _kernel_display_resource_suspendResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelDisplayResource* self;
};

struct _kernel_display_resource_resumeResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelDisplayResource* self;
};

struct _KernelCpuResource {
	FsoFrameworkAbstractDBusResource parent_instance;
	KernelCpuResourcePrivate * priv;
	gboolean on;
};

struct _KernelCpuResourceClass {
	FsoFrameworkAbstractDBusResourceClass parent_class;
};

struct _kernel_cpu_resource_enableResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelCpuResource* self;
	gboolean _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	gboolean _tmp2_;
	KernelIdleNotifier* _tmp3_;
};

struct _kernel_cpu_resource_disableResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelCpuResource* self;
	gboolean _tmp0_;
	FsoFrameworkLogger* _tmp1_;
	gboolean _tmp2_;
	KernelIdleNotifier* _tmp3_;
};

struct _kernel_cpu_resource_suspendResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelCpuResource* self;
};

struct _kernel_cpu_resource_resumeResourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	KernelCpuResource* self;
};


extern gchar* kernel_buffer;
extern gint kernel_buffer_length1;
gchar* kernel_buffer = NULL;
gint kernel_buffer_length1 = 0;
static gint _kernel_buffer_size_ = 0;
extern KernelIdleNotifier* instance;
static gpointer kernel_idle_notifier_parent_class = NULL;
extern gchar** ignoreById;
extern gint ignoreById_length1;
extern gchar** ignoreByPhys;
extern gint ignoreByPhys_length1;
extern gchar* dev_input;
static FreeSmartphoneDeviceIdleNotifierIface* kernel_idle_notifier_free_smartphone_device_idle_notifier_parent_iface = NULL;
static GType kernel_idle_notifier_type_id = 0;
static gpointer kernel_display_resource_parent_class = NULL;
static GType kernel_display_resource_type_id = 0;
static gpointer kernel_cpu_resource_parent_class = NULL;
static GType kernel_cpu_resource_type_id = 0;
extern gchar* dev_root;
gchar* dev_root = NULL;
gchar* dev_input = NULL;
KernelIdleNotifier* instance = NULL;
extern KernelCpuResource* cpu;
KernelCpuResource* cpu = NULL;
extern KernelDisplayResource* display;
KernelDisplayResource* display = NULL;
gchar** ignoreById = NULL;
gint ignoreById_length1 = 0;
static gint _ignoreById_size_ = 0;
gchar** ignoreByPhys = NULL;
gint ignoreByPhys_length1 = 0;
static gint _ignoreByPhys_size_ = 0;

#define KERNEL_BUFFER_SIZE ((guint) 512)
#define KERNEL_KERNEL_IDLE_PLUGIN_NAME "fsodevice.kernel_idle"
void kernel_idle_status_free (KernelIdleStatus* self);
static void kernel_idle_status_instance_init (KernelIdleStatus * self);
KernelIdleStatus* kernel_idle_status_new (void);
KernelIdleStatus* kernel_idle_status_new (void);
static FreeSmartphoneDeviceIdleState kernel_idle_status_nextState (KernelIdleStatus* self);
void kernel_idle_status_onState (KernelIdleStatus* self, FreeSmartphoneDeviceIdleState status);
GType kernel_idle_notifier_get_type (void) G_GNUC_CONST;
GType kernel_idle_notifier_register_type (GTypeModule * module);
const gchar* free_smartphone_device_idle_state_to_string (FreeSmartphoneDeviceIdleState self);
gboolean kernel_idle_status_onTimeout (KernelIdleStatus* self);
static gboolean _kernel_idle_status_onTimeout_gsource_func (gpointer self);
#define KERNEL_IDLE_NOTIFIER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KERNEL_TYPE_IDLE_NOTIFIER, KernelIdleNotifierPrivate))
enum  {
	KERNEL_IDLE_NOTIFIER_DUMMY_PROPERTY
};
#define KERNEL_IDLE_NOTIFIER_KEY_RELEASE 0
#define KERNEL_IDLE_NOTIFIER_KEY_PRESS 1
#define KERNEL_IDLE_NOTIFIER_KEY_REPEAT 2
KernelIdleNotifier* kernel_idle_notifier_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
KernelIdleNotifier* kernel_idle_notifier_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode);
static void kernel_idle_notifier_hookToExternalModules (KernelIdleNotifier* self);
void kernel_idle_notifier_resetTimeouts (KernelIdleNotifier* self);
static void kernel_idle_notifier_syncNodesToWatch (KernelIdleNotifier* self);
static void kernel_idle_notifier_registerInputWatches (KernelIdleNotifier* self);
void kernel_idle_notifier_onInputNotification (KernelIdleNotifier* self, GHashTable* properties);
static void _kernel_idle_notifier_onInputNotification_fso_framework_kobject_notifier_func (GHashTable* properties, gpointer self);
static gboolean __lambda2_ (KernelIdleNotifier* self);
static void kernel_idle_notifier_request_usage_service (KernelIdleNotifier* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void kernel_idle_notifier_request_usage_service_finish (KernelIdleNotifier* self, GAsyncResult* _res_);
static gboolean ___lambda2__gsource_func (gpointer self);
static gboolean __lambda3_ (KernelIdleNotifier* self);
static gboolean ___lambda3__gsource_func (gpointer self);
static gchar* kernel_idle_notifier_real_repr (FsoFrameworkAbstractObject* base);
static void kernel_idle_notifier_request_usage_service_data_free (gpointer _data);
static gboolean kernel_idle_notifier_request_usage_service_co (KernelIdleNotifierRequestUsageServiceData* _data_);
static void kernel_idle_notifier_request_usage_service_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void kernel_idle_notifier_onUsageSystemAction (KernelIdleNotifier* self, FreeSmartphoneUsageSystemAction action);
static void _kernel_idle_notifier_onUsageSystemAction_free_smartphone_usage_system_action (FreeSmartphoneUsage* _sender, FreeSmartphoneUsageSystemAction action, gpointer self);
static void kernel_idle_notifier_handleInputEvent (KernelIdleNotifier* self, struct input_event* ev);
static void _kernel_idle_notifier_handleInputEvent_fso_device_signalling_input_device_received_event (FsoDeviceSignallingInputDevice* _sender, struct input_event* ev, gpointer self);
static gchar* kernel_idle_notifier_cleanBuffer (KernelIdleNotifier* self, gint length);
static gboolean kernel_idle_notifier_inquireAndCheckForIgnore (KernelIdleNotifier* self, gint fd);
void kernel_idle_notifier_onResourceChanged (KernelIdleNotifier* self, FsoFrameworkAbstractDBusResource* r, gboolean on);
GType kernel_cpu_resource_get_type (void) G_GNUC_CONST;
GType kernel_cpu_resource_register_type (GTypeModule * module);
GType kernel_display_resource_get_type (void) G_GNUC_CONST;
GType kernel_display_resource_register_type (GTypeModule * module);
static void _vala_array_add1 (gint** array, int* length, int* size, gint value);
gboolean kernel_idle_notifier_onInputEvent (KernelIdleNotifier* self, GIOChannel* source, GIOCondition condition);
static gboolean _kernel_idle_notifier_onInputEvent_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void _vala_array_add2 (GIOChannel*** array, int* length, int* size, GIOChannel* value);
static gboolean kernel_idle_notifier_checkForIgnoreInputEvent (KernelIdleNotifier* self, gint sourceFd);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void kernel_idle_notifier_real_get_state_data_free (gpointer _data);
static void kernel_idle_notifier_real_get_state (FreeSmartphoneDeviceIdleNotifier* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_idle_notifier_real_get_state_co (KernelIdleNotifierGetStateData* _data_);
static void kernel_idle_notifier_real_get_timeouts_data_free (gpointer _data);
static void kernel_idle_notifier_real_get_timeouts (FreeSmartphoneDeviceIdleNotifier* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_idle_notifier_real_get_timeouts_co (KernelIdleNotifierGetTimeoutsData* _data_);
static void _g_free0_ (gpointer var);
static void kernel_idle_notifier_real_set_state_data_free (gpointer _data);
static void kernel_idle_notifier_real_set_state (FreeSmartphoneDeviceIdleNotifier* base, FreeSmartphoneDeviceIdleState status, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_idle_notifier_real_set_state_co (KernelIdleNotifierSetStateData* _data_);
static void kernel_idle_notifier_real_set_timeout_data_free (gpointer _data);
static void kernel_idle_notifier_real_set_timeout (FreeSmartphoneDeviceIdleNotifier* base, FreeSmartphoneDeviceIdleState status, gint timeout, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_idle_notifier_real_set_timeout_co (KernelIdleNotifierSetTimeoutData* _data_);
static void kernel_idle_notifier_finalize (GObject* obj);
enum  {
	KERNEL_DISPLAY_RESOURCE_DUMMY_PROPERTY
};
KernelDisplayResource* kernel_display_resource_new (FsoFrameworkSubsystem* subsystem);
KernelDisplayResource* kernel_display_resource_construct (GType object_type, FsoFrameworkSubsystem* subsystem);
static void kernel_display_resource_real_enableResource_data_free (gpointer _data);
static void kernel_display_resource_real_enableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_display_resource_real_enableResource_co (kernel_display_resource_enableResourceData* _data_);
static void kernel_display_resource_real_disableResource_data_free (gpointer _data);
static void kernel_display_resource_real_disableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_display_resource_real_disableResource_co (kernel_display_resource_disableResourceData* _data_);
static void kernel_display_resource_real_suspendResource_data_free (gpointer _data);
static void kernel_display_resource_real_suspendResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_display_resource_real_suspendResource_co (kernel_display_resource_suspendResourceData* _data_);
static void kernel_display_resource_real_resumeResource_data_free (gpointer _data);
static void kernel_display_resource_real_resumeResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_display_resource_real_resumeResource_co (kernel_display_resource_resumeResourceData* _data_);
static void kernel_display_resource_finalize (GObject* obj);
enum  {
	KERNEL_CPU_RESOURCE_DUMMY_PROPERTY
};
KernelCpuResource* kernel_cpu_resource_new (FsoFrameworkSubsystem* subsystem);
KernelCpuResource* kernel_cpu_resource_construct (GType object_type, FsoFrameworkSubsystem* subsystem);
static void kernel_cpu_resource_real_enableResource_data_free (gpointer _data);
static void kernel_cpu_resource_real_enableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_cpu_resource_real_enableResource_co (kernel_cpu_resource_enableResourceData* _data_);
static void kernel_cpu_resource_real_disableResource_data_free (gpointer _data);
static void kernel_cpu_resource_real_disableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_cpu_resource_real_disableResource_co (kernel_cpu_resource_disableResourceData* _data_);
static void kernel_cpu_resource_real_suspendResource_data_free (gpointer _data);
static void kernel_cpu_resource_real_suspendResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_cpu_resource_real_suspendResource_co (kernel_cpu_resource_suspendResourceData* _data_);
static void kernel_cpu_resource_real_resumeResource_data_free (gpointer _data);
static void kernel_cpu_resource_real_resumeResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean kernel_cpu_resource_real_resumeResource_co (kernel_cpu_resource_resumeResourceData* _data_);
static void kernel_cpu_resource_finalize (GObject* obj);
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error);
void fso_register_function (GTypeModule* module);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


KernelIdleStatus* kernel_idle_status_new (void) {
	KernelIdleStatus* self;
	gint* _tmp0_ = NULL;
	self = g_slice_new0 (KernelIdleStatus);
	kernel_idle_status_instance_init (self);
	_tmp0_ = g_new0 (gint, 7);
	_tmp0_[0] = 0;
	_tmp0_[1] = 2;
	_tmp0_[2] = 10;
	_tmp0_[3] = 20;
	_tmp0_[4] = 2;
	_tmp0_[5] = 20;
	_tmp0_[6] = -1;
	self->timeouts = (g_free (self->timeouts), NULL);
	self->timeouts = _tmp0_;
	self->timeouts_length1 = 7;
	return self;
}


static FreeSmartphoneDeviceIdleState kernel_idle_status_nextState (KernelIdleStatus* self) {
	FreeSmartphoneDeviceIdleState result = 0;
	FreeSmartphoneDeviceIdleState _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->status;
	if (_tmp0_ == FREE_SMARTPHONE_DEVICE_IDLE_STATE_AWAKE) {
		result = 0;
		return result;
	} else {
		FreeSmartphoneDeviceIdleState _tmp1_;
		_tmp1_ = self->status;
		result = (FreeSmartphoneDeviceIdleState) (((gint) _tmp1_) + 1);
		return result;
	}
}


static gboolean _kernel_idle_status_onTimeout_gsource_func (gpointer self) {
	gboolean result;
	result = kernel_idle_status_onTimeout (self);
	return result;
}


void kernel_idle_status_onState (KernelIdleStatus* self, FreeSmartphoneDeviceIdleState status) {
	guint _tmp0_;
	FreeSmartphoneDeviceIdleState _tmp2_;
	FreeSmartphoneDeviceIdleState _tmp3_;
	FreeSmartphoneDeviceIdleState _tmp16_ = 0;
	FreeSmartphoneDeviceIdleState next;
	gint* _tmp17_;
	gint _tmp17__length1;
	FreeSmartphoneDeviceIdleState _tmp18_;
	gint _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->watch;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->watch;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = self->status;
	_tmp3_ = status;
	if (_tmp2_ != _tmp3_) {
		KernelIdleNotifier* _tmp4_;
		FsoFrameworkLogger* _tmp5_;
		FreeSmartphoneDeviceIdleState _tmp6_;
		GEnumValue* _tmp7_;
		FreeSmartphoneDeviceIdleState _tmp8_;
		GEnumValue* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gboolean _tmp12_ = FALSE;
		FreeSmartphoneDeviceIdleState _tmp13_;
		KernelIdleNotifier* _tmp14_;
		FreeSmartphoneDeviceIdleState _tmp15_;
		_tmp4_ = instance;
		_tmp5_ = ((FsoFrameworkAbstractObject*) _tmp4_)->logger;
		_tmp6_ = self->status;
		_tmp7_ = g_enum_get_value (g_type_class_ref (FREE_SMARTPHONE_DEVICE_TYPE_IDLE_STATE), _tmp6_);
		_tmp8_ = status;
		_tmp9_ = g_enum_get_value (g_type_class_ref (FREE_SMARTPHONE_DEVICE_TYPE_IDLE_STATE), _tmp8_);
		_tmp10_ = g_strconcat ("onState transitioning from ", (_tmp7_ != NULL) ? _tmp7_->value_name : NULL, " to ", (_tmp9_ != NULL) ? _tmp9_->value_name : NULL, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = fso_framework_logger_debug (_tmp5_, _tmp11_);
		g_assert (_tmp12_);
		_g_free0 (_tmp11_);
		_tmp13_ = status;
		self->status = _tmp13_;
		_tmp14_ = instance;
		_tmp15_ = self->status;
		g_signal_emit_by_name ((FreeSmartphoneDeviceIdleNotifier*) _tmp14_, "state", _tmp15_);
	}
	_tmp16_ = kernel_idle_status_nextState (self);
	next = _tmp16_;
	_tmp17_ = self->timeouts;
	_tmp17__length1 = self->timeouts_length1;
	_tmp18_ = next;
	_tmp19_ = _tmp17_[_tmp18_];
	if (_tmp19_ > 0) {
		gint* _tmp20_;
		gint _tmp20__length1;
		FreeSmartphoneDeviceIdleState _tmp21_;
		gint _tmp22_;
		guint _tmp23_ = 0U;
		_tmp20_ = self->timeouts;
		_tmp20__length1 = self->timeouts_length1;
		_tmp21_ = next;
		_tmp22_ = _tmp20_[_tmp21_];
		_tmp23_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp22_, _kernel_idle_status_onTimeout_gsource_func, self, NULL);
		self->watch = _tmp23_;
	} else {
		gint* _tmp24_;
		gint _tmp24__length1;
		FreeSmartphoneDeviceIdleState _tmp25_;
		gint _tmp26_;
		_tmp24_ = self->timeouts;
		_tmp24__length1 = self->timeouts_length1;
		_tmp25_ = next;
		_tmp26_ = _tmp24_[_tmp25_];
		if (_tmp26_ == 0) {
			FreeSmartphoneDeviceIdleState _tmp27_ = 0;
			_tmp27_ = kernel_idle_status_nextState (self);
			kernel_idle_status_onState (self, _tmp27_);
		} else {
			KernelIdleNotifier* _tmp28_;
			FsoFrameworkLogger* _tmp29_;
			FreeSmartphoneDeviceIdleState _tmp30_;
			GEnumValue* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_;
			gboolean _tmp34_ = FALSE;
			_tmp28_ = instance;
			_tmp29_ = ((FsoFrameworkAbstractObject*) _tmp28_)->logger;
			_tmp30_ = next;
			_tmp31_ = g_enum_get_value (g_type_class_ref (FREE_SMARTPHONE_DEVICE_TYPE_IDLE_STATE), _tmp30_);
			_tmp32_ = g_strconcat ("Timeout for ", (_tmp31_ != NULL) ? _tmp31_->value_name : NULL, " disabled, not falling into this state.", NULL);
			_tmp33_ = _tmp32_;
			_tmp34_ = fso_framework_logger_debug (_tmp29_, _tmp33_);
			g_assert (_tmp34_);
			_g_free0 (_tmp33_);
		}
	}
}


gboolean kernel_idle_status_onTimeout (KernelIdleStatus* self) {
	gboolean result = FALSE;
	FreeSmartphoneDeviceIdleState _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	self->watch = (guint) 0;
	_tmp0_ = kernel_idle_status_nextState (self);
	kernel_idle_status_onState (self, _tmp0_);
	result = FALSE;
	return result;
}


static void kernel_idle_status_instance_init (KernelIdleStatus * self) {
	self->status = FREE_SMARTPHONE_DEVICE_IDLE_STATE_AWAKE;
}


void kernel_idle_status_free (KernelIdleStatus* self) {
	self->timeouts = (g_free (self->timeouts), NULL);
	g_slice_free (KernelIdleStatus, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _kernel_idle_notifier_onInputNotification_fso_framework_kobject_notifier_func (GHashTable* properties, gpointer self) {
	kernel_idle_notifier_onInputNotification (self, properties);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean __lambda2_ (KernelIdleNotifier* self) {
	gboolean result = FALSE;
	kernel_idle_notifier_request_usage_service (self, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean ___lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda2_ (self);
	return result;
}


static gboolean __lambda3_ (KernelIdleNotifier* self) {
	gboolean result = FALSE;
	KernelIdleStatus* _tmp0_;
	_tmp0_ = self->priv->idlestatus;
	kernel_idle_status_onState (_tmp0_, FREE_SMARTPHONE_DEVICE_IDLE_STATE_AWAKE);
	result = FALSE;
	return result;
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
	return result;
}


KernelIdleNotifier* kernel_idle_notifier_construct (GType object_type, FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	KernelIdleNotifier * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	FsoFrameworkSubsystem* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	KernelIdleStatus* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_ = NULL;
	GeeHashMap* _tmp12_;
	FsoFrameworkSubsystem* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	FsoFrameworkSmartKeyFile* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean display_resource_allows_dim;
	FreeSmartphoneDeviceIdleState _tmp18_ = 0;
	gboolean _tmp19_;
	FreeSmartphoneDeviceIdleState _tmp20_;
	gint n;
	gchar** _tmp21_;
	gint _tmp21__length1;
	g_return_val_if_fail (subsystem != NULL, NULL);
	g_return_val_if_fail (sysfsnode != NULL, NULL);
	self = (KernelIdleNotifier*) fso_framework_abstract_object_construct (object_type);
	_tmp0_ = subsystem;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->subsystem);
	self->priv->subsystem = _tmp1_;
	_tmp2_ = sysfsnode;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->sysfsnode);
	self->priv->sysfsnode = _tmp3_;
	_tmp4_ = kernel_idle_status_new ();
	_kernel_idle_status_free0 (self->priv->idlestatus);
	self->priv->idlestatus = _tmp4_;
	_tmp5_ = g_strdup ("busy");
	_tmp6_ = g_strdup ("idle");
	_tmp7_ = g_strdup ("idle_dim");
	_tmp8_ = g_strdup ("idle_prelock");
	_tmp9_ = g_strdup ("lock");
	_tmp10_ = g_strdup ("suspend");
	_tmp11_ = g_new0 (gchar*, 6 + 1);
	_tmp11_[0] = _tmp5_;
	_tmp11_[1] = _tmp6_;
	_tmp11_[2] = _tmp7_;
	_tmp11_[3] = _tmp8_;
	_tmp11_[4] = _tmp9_;
	_tmp11_[5] = _tmp10_;
	self->priv->states = (_vala_array_free (self->priv->states, self->priv->states_length1, (GDestroyNotify) g_free), NULL);
	self->priv->states = _tmp11_;
	self->priv->states_length1 = 6;
	self->priv->_states_size_ = self->priv->states_length1;
	_tmp12_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->stateIgnoreById);
	self->priv->stateIgnoreById = _tmp12_;
	kernel_idle_notifier_hookToExternalModules (self);
	kernel_idle_notifier_resetTimeouts (self);
	kernel_idle_notifier_syncNodesToWatch (self);
	kernel_idle_notifier_registerInputWatches (self);
	fso_framework_base_kobject_notifier_addMatch ("add", "input", _kernel_idle_notifier_onInputNotification_fso_framework_kobject_notifier_func, self);
	fso_framework_base_kobject_notifier_addMatch ("remove", "input", _kernel_idle_notifier_onInputNotification_fso_framework_kobject_notifier_func, self);
	_tmp13_ = subsystem;
	_tmp14_ = g_strdup_printf ("%s/0", FSO_FRAMEWORK_DEVICE_IdleNotifierServicePath);
	_tmp15_ = _tmp14_;
	fso_framework_subsystem_registerObjectForService (_tmp13_, FREE_SMARTPHONE_DEVICE_TYPE_IDLE_NOTIFIER, (GBoxedCopyFunc) g_object_ref, g_object_unref, FSO_FRAMEWORK_DEVICE_ServiceDBusName, _tmp15_, (FreeSmartphoneDeviceIdleNotifier*) self);
	_g_free0 (_tmp15_);
	_tmp16_ = ((FsoFrameworkAbstractObject*) self)->config;
	_tmp17_ = fso_framework_smart_key_file_boolValue (_tmp16_, KERNEL_KERNEL_IDLE_PLUGIN_NAME, "display_resource_allows_dim", FALSE);
	display_resource_allows_dim = _tmp17_;
	_tmp19_ = display_resource_allows_dim;
	if (_tmp19_) {
		_tmp18_ = FREE_SMARTPHONE_DEVICE_IDLE_STATE_IDLE_PRELOCK;
	} else {
		_tmp18_ = FREE_SMARTPHONE_DEVICE_IDLE_STATE_IDLE_DIM;
	}
	_tmp20_ = _tmp18_;
	self->priv->displayResourcePreventState = _tmp20_;
	n = 0;
	_tmp21_ = self->priv->states;
	_tmp21__length1 = self->priv->states_length1;
	{
		gchar** state_collection = NULL;
		gint state_collection_length1 = 0;
		gint _state_collection_size_ = 0;
		gint state_it = 0;
		state_collection = _tmp21_;
		state_collection_length1 = _tmp21__length1;
		for (state_it = 0; state_it < _tmp21__length1; state_it = state_it + 1) {
			gchar* _tmp22_;
			gchar* state = NULL;
			_tmp22_ = g_strdup (state_collection[state_it]);
			state = _tmp22_;
			{
				FsoFrameworkSmartKeyFile* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gchar* _tmp27_;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_;
				gchar* to_ignore;
				GeeHashMap* _tmp30_;
				gint _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _tmp42_;
				_tmp23_ = ((FsoFrameworkAbstractObject*) self)->config;
				_tmp24_ = state;
				_tmp25_ = string_to_string (_tmp24_);
				_tmp26_ = g_strconcat (_tmp25_, ":ignore_by_id", NULL);
				_tmp27_ = _tmp26_;
				_tmp28_ = fso_framework_smart_key_file_stringValue (_tmp23_, KERNEL_KERNEL_IDLE_PLUGIN_NAME, _tmp27_, "");
				_tmp29_ = _tmp28_;
				_g_free0 (_tmp27_);
				to_ignore = _tmp29_;
				_tmp30_ = self->priv->stateIgnoreById;
				_tmp31_ = n;
				_tmp32_ = to_ignore;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp30_, GINT_TO_POINTER (_tmp31_), _tmp32_);
				_tmp33_ = to_ignore;
				_tmp34_ = strlen (_tmp33_);
				_tmp35_ = _tmp34_;
				if (_tmp35_ > 0) {
					FsoFrameworkLogger* _tmp36_;
					const gchar* _tmp37_;
					const gchar* _tmp38_ = NULL;
					gchar* _tmp39_ = NULL;
					gchar* _tmp40_;
					gboolean _tmp41_ = FALSE;
					_tmp36_ = ((FsoFrameworkAbstractObject*) self)->logger;
					_tmp37_ = state;
					_tmp38_ = string_to_string (_tmp37_);
					_tmp39_ = g_strconcat ("Read ignore_by_id entry for state = ", _tmp38_, NULL);
					_tmp40_ = _tmp39_;
					_tmp41_ = fso_framework_logger_debug (_tmp36_, _tmp40_);
					g_assert (_tmp41_);
					_g_free0 (_tmp40_);
				}
				_tmp42_ = n;
				n = _tmp42_ + 1;
				_g_free0 (to_ignore);
				_g_free0 (state);
			}
		}
	}
	self->priv->lastSystemAction = FREE_SMARTPHONE_USAGE_SYSTEM_ACTION_ALIVE;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda2__gsource_func, g_object_ref (self), g_object_unref);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda3__gsource_func, g_object_ref (self), g_object_unref);
	return self;
}


KernelIdleNotifier* kernel_idle_notifier_new (FsoFrameworkSubsystem* subsystem, const gchar* sysfsnode) {
	return kernel_idle_notifier_construct (KERNEL_TYPE_IDLE_NOTIFIER, subsystem, sysfsnode);
}


static gchar* kernel_idle_notifier_real_repr (FsoFrameworkAbstractObject* base) {
	KernelIdleNotifier * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	self = (KernelIdleNotifier*) base;
	_tmp0_ = self->priv->sysfsnode;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("<", _tmp1_, ">", NULL);
	result = _tmp2_;
	return result;
}


static void kernel_idle_notifier_request_usage_service_data_free (gpointer _data) {
	KernelIdleNotifierRequestUsageServiceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelIdleNotifierRequestUsageServiceData, _data_);
}


static void kernel_idle_notifier_request_usage_service (KernelIdleNotifier* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelIdleNotifierRequestUsageServiceData* _data_;
	KernelIdleNotifier* _tmp0_;
	_data_ = g_slice_new0 (KernelIdleNotifierRequestUsageServiceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_idle_notifier_request_usage_service);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_idle_notifier_request_usage_service_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_idle_notifier_request_usage_service_co (_data_);
}


static void kernel_idle_notifier_request_usage_service_finish (KernelIdleNotifier* self, GAsyncResult* _res_) {
	KernelIdleNotifierRequestUsageServiceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void kernel_idle_notifier_request_usage_service_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	KernelIdleNotifierRequestUsageServiceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	kernel_idle_notifier_request_usage_service_co (_data_);
}


static void _kernel_idle_notifier_onUsageSystemAction_free_smartphone_usage_system_action (FreeSmartphoneUsage* _sender, FreeSmartphoneUsageSystemAction action, gpointer self) {
	kernel_idle_notifier_onUsageSystemAction (self, action);
}


static gboolean kernel_idle_notifier_request_usage_service_co (KernelIdleNotifierRequestUsageServiceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (FREE_SMARTPHONE_TYPE_USAGE_PROXY, 0, NULL, kernel_idle_notifier_request_usage_service_ready, _data_, "g-flags", 0, "g-name", FSO_FRAMEWORK_USAGE_ServiceDBusName, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", FSO_FRAMEWORK_USAGE_ServicePathPrefix, "g-interface-name", "org.freesmartphone.Usage", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp1_ = (FreeSmartphoneUsage*) _data_->_tmp0_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->self->priv->usage);
		_data_->self->priv->usage = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->self->priv->usage;
		g_signal_connect_object (_data_->_tmp2_, "system-action", (GCallback) _kernel_idle_notifier_onUsageSystemAction_free_smartphone_usage_system_action, _data_->self, 0);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp3_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
		_data_->_tmp4_ = _data_->err;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = string_to_string (_data_->_tmp5_);
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_strconcat ("Could not request proxy object for usage service: ", _data_->_tmp6_, NULL);
		_data_->_tmp8_ = _data_->_tmp7_;
		fso_framework_logger_error (_data_->_tmp3_, _data_->_tmp8_);
		_g_free0 (_data_->_tmp8_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_idle_notifier_onUsageSystemAction (KernelIdleNotifier* self, FreeSmartphoneUsageSystemAction action) {
	FreeSmartphoneUsageSystemAction _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = action;
	self->priv->lastSystemAction = _tmp0_;
}


static void _kernel_idle_notifier_handleInputEvent_fso_device_signalling_input_device_received_event (FsoDeviceSignallingInputDevice* _sender, struct input_event* ev, gpointer self) {
	kernel_idle_notifier_handleInputEvent (self, ev);
}


static void kernel_idle_notifier_hookToExternalModules (KernelIdleNotifier* self) {
	FsoFrameworkSubsystem* _tmp0_;
	gint _tmp1_ = 0;
	GObject** _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->subsystem;
	_tmp2_ = fso_framework_subsystem_allObjectsWithPrefix (_tmp0_, "/org/freesmartphone/Device/Input/", &_tmp1_);
	{
		GObject** object_collection = NULL;
		gint object_collection_length1 = 0;
		gint _object_collection_size_ = 0;
		gint object_it = 0;
		object_collection = _tmp2_;
		object_collection_length1 = _tmp1_;
		for (object_it = 0; object_it < _tmp1_; object_it = object_it + 1) {
			GObject* _tmp3_;
			GObject* object = NULL;
			_tmp3_ = _g_object_ref0 (object_collection[object_it]);
			object = _tmp3_;
			{
				GObject* _tmp4_;
				_tmp4_ = object;
				if (FSO_DEVICE_IS_SIGNALLING_INPUT_DEVICE (_tmp4_)) {
					FsoFrameworkLogger* _tmp5_;
					gboolean _tmp6_ = FALSE;
					GObject* _tmp7_;
					_tmp5_ = ((FsoFrameworkAbstractObject*) self)->logger;
					_tmp6_ = fso_framework_logger_debug (_tmp5_, "Found an auxilliary input object, connecting to signal");
					g_assert (_tmp6_);
					_tmp7_ = object;
					g_signal_connect_object (FSO_DEVICE_SIGNALLING_INPUT_DEVICE (_tmp7_), "received-event", (GCallback) _kernel_idle_notifier_handleInputEvent_fso_device_signalling_input_device_received_event, self, 0);
				}
				_g_object_unref0 (object);
			}
		}
		object_collection = (_vala_array_free (object_collection, object_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
}


static gchar* kernel_idle_notifier_cleanBuffer (KernelIdleNotifier* self, gint length) {
	gchar* result = NULL;
	gchar* _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				gchar* _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				gchar _tmp7_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = length;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = kernel_buffer;
				_tmp5__length1 = kernel_buffer_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				if (((gint) _tmp7_) < 0) {
					gchar* _tmp8_;
					gint _tmp8__length1;
					gint _tmp9_;
					gchar _tmp10_;
					_tmp8_ = kernel_buffer;
					_tmp8__length1 = kernel_buffer_length1;
					_tmp9_ = i;
					_tmp8_[_tmp9_] = '?';
					_tmp10_ = _tmp8_[_tmp9_];
				}
			}
		}
	}
	_tmp11_ = kernel_buffer;
	_tmp11__length1 = kernel_buffer_length1;
	_tmp12_ = g_strdup ((const gchar*) _tmp11_);
	result = _tmp12_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gboolean kernel_idle_notifier_inquireAndCheckForIgnore (KernelIdleNotifier* self, gint fd) {
	gboolean result = FALSE;
	gboolean ignore;
	gint _tmp0_;
	gint _tmp1_ = 0;
	gchar* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gint length;
	gint _tmp4_;
	gint _tmp12_;
	gint _tmp13_ = 0;
	gchar* _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_ = 0;
	gint _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	ignore = FALSE;
	_tmp0_ = fd;
	_tmp1_ = EVIOCGNAME (KERNEL_BUFFER_SIZE);
	_tmp2_ = kernel_buffer;
	_tmp2__length1 = kernel_buffer_length1;
	_tmp3_ = ioctl (_tmp0_, _tmp1_, _tmp2_);
	length = _tmp3_;
	_tmp4_ = length;
	if (_tmp4_ > 0) {
		gint _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* product;
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp5_ = length;
		_tmp6_ = kernel_idle_notifier_cleanBuffer (self, _tmp5_);
		product = _tmp6_;
		_tmp7_ = ignoreById;
		_tmp7__length1 = ignoreById_length1;
		{
			gchar** i_collection = NULL;
			gint i_collection_length1 = 0;
			gint _i_collection_size_ = 0;
			gint i_it = 0;
			i_collection = _tmp7_;
			i_collection_length1 = _tmp7__length1;
			for (i_it = 0; i_it < _tmp7__length1; i_it = i_it + 1) {
				gchar* _tmp8_;
				gchar* i = NULL;
				_tmp8_ = g_strdup (i_collection[i_it]);
				i = _tmp8_;
				{
					const gchar* _tmp9_;
					const gchar* _tmp10_;
					gboolean _tmp11_ = FALSE;
					_tmp9_ = product;
					_tmp10_ = i;
					_tmp11_ = string_contains (_tmp9_, _tmp10_);
					if (_tmp11_) {
						ignore = TRUE;
					}
					_g_free0 (i);
				}
			}
		}
		_g_free0 (product);
	}
	_tmp12_ = fd;
	_tmp13_ = EVIOCGPHYS (KERNEL_BUFFER_SIZE);
	_tmp14_ = kernel_buffer;
	_tmp14__length1 = kernel_buffer_length1;
	_tmp15_ = ioctl (_tmp12_, _tmp13_, _tmp14_);
	length = _tmp15_;
	_tmp16_ = length;
	if (_tmp16_ > 0) {
		gint _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* phys;
		gchar** _tmp19_;
		gint _tmp19__length1;
		_tmp17_ = length;
		_tmp18_ = kernel_idle_notifier_cleanBuffer (self, _tmp17_);
		phys = _tmp18_;
		_tmp19_ = ignoreByPhys;
		_tmp19__length1 = ignoreByPhys_length1;
		{
			gchar** p_collection = NULL;
			gint p_collection_length1 = 0;
			gint _p_collection_size_ = 0;
			gint p_it = 0;
			p_collection = _tmp19_;
			p_collection_length1 = _tmp19__length1;
			for (p_it = 0; p_it < _tmp19__length1; p_it = p_it + 1) {
				gchar* _tmp20_;
				gchar* p = NULL;
				_tmp20_ = g_strdup (p_collection[p_it]);
				p = _tmp20_;
				{
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					gboolean _tmp23_ = FALSE;
					_tmp21_ = phys;
					_tmp22_ = p;
					_tmp23_ = string_contains (_tmp21_, _tmp22_);
					if (_tmp23_) {
						ignore = TRUE;
					}
					_g_free0 (p);
				}
			}
		}
		_g_free0 (phys);
	}
	result = ignore;
	return result;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


void kernel_idle_notifier_onResourceChanged (KernelIdleNotifier* self, FsoFrameworkAbstractDBusResource* r, gboolean on) {
	FsoFrameworkAbstractDBusResource* _tmp0_;
	FsoFrameworkAbstractDBusResource* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	if (KERNEL_IS_CPU_RESOURCE (_tmp0_)) {
		FsoFrameworkLogger* _tmp1_;
		gboolean _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		_tmp1_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp2_ = on;
		_tmp3_ = bool_to_string (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat ("CPU resource changed status to ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = fso_framework_logger_debug (_tmp1_, _tmp6_);
		g_assert (_tmp7_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_tmp8_ = on;
		if (_tmp8_) {
			KernelIdleStatus* _tmp9_;
			gint* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			_tmp9_ = self->priv->idlestatus;
			_tmp10_ = _tmp9_->timeouts;
			_tmp10__length1 = _tmp9_->timeouts_length1;
			_tmp10_[FREE_SMARTPHONE_DEVICE_IDLE_STATE_SUSPEND] = -1;
			_tmp11_ = _tmp10_[FREE_SMARTPHONE_DEVICE_IDLE_STATE_SUSPEND];
		} else {
			KernelIdleStatus* _tmp12_;
			gint* _tmp13_;
			gint _tmp13__length1;
			FsoFrameworkSmartKeyFile* _tmp14_;
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			gint _tmp17_ = 0;
			gint _tmp18_;
			KernelIdleStatus* _tmp19_;
			FreeSmartphoneDeviceIdleState _tmp20_;
			_tmp12_ = self->priv->idlestatus;
			_tmp13_ = _tmp12_->timeouts;
			_tmp13__length1 = _tmp12_->timeouts_length1;
			_tmp14_ = ((FsoFrameworkAbstractObject*) self)->config;
			_tmp15_ = self->priv->states;
			_tmp15__length1 = self->priv->states_length1;
			_tmp16_ = _tmp15_[FREE_SMARTPHONE_DEVICE_IDLE_STATE_SUSPEND];
			_tmp17_ = fso_framework_smart_key_file_intValue (_tmp14_, KERNEL_KERNEL_IDLE_PLUGIN_NAME, _tmp16_, 20);
			_tmp13_[FREE_SMARTPHONE_DEVICE_IDLE_STATE_SUSPEND] = _tmp17_;
			_tmp18_ = _tmp13_[FREE_SMARTPHONE_DEVICE_IDLE_STATE_SUSPEND];
			_tmp19_ = self->priv->idlestatus;
			_tmp20_ = _tmp19_->status;
			if (_tmp20_ == FREE_SMARTPHONE_DEVICE_IDLE_STATE_LOCK) {
				KernelIdleStatus* _tmp21_;
				_tmp21_ = self->priv->idlestatus;
				kernel_idle_status_onState (_tmp21_, FREE_SMARTPHONE_DEVICE_IDLE_STATE_LOCK);
			}
		}
	}
	_tmp22_ = r;
	if (KERNEL_IS_DISPLAY_RESOURCE (_tmp22_)) {
		FsoFrameworkLogger* _tmp23_;
		gboolean _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_;
		_tmp23_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp24_ = on;
		_tmp25_ = bool_to_string (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat ("Display resource changed status to ", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = fso_framework_logger_debug (_tmp23_, _tmp28_);
		g_assert (_tmp29_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		_tmp30_ = on;
		if (_tmp30_) {
			KernelIdleStatus* _tmp31_;
			gint* _tmp32_;
			gint _tmp32__length1;
			FreeSmartphoneDeviceIdleState _tmp33_;
			gint _tmp34_;
			KernelIdleStatus* _tmp35_;
			FreeSmartphoneDeviceIdleState _tmp36_;
			_tmp31_ = self->priv->idlestatus;
			_tmp32_ = _tmp31_->timeouts;
			_tmp32__length1 = _tmp31_->timeouts_length1;
			_tmp33_ = self->priv->displayResourcePreventState;
			_tmp32_[_tmp33_] = -1;
			_tmp34_ = _tmp32_[_tmp33_];
			_tmp35_ = self->priv->idlestatus;
			_tmp36_ = _tmp35_->status;
			if (((gint) _tmp36_) > ((gint) FREE_SMARTPHONE_DEVICE_IDLE_STATE_IDLE)) {
				KernelIdleStatus* _tmp37_;
				_tmp37_ = self->priv->idlestatus;
				kernel_idle_status_onState (_tmp37_, FREE_SMARTPHONE_DEVICE_IDLE_STATE_IDLE);
			}
		} else {
			KernelIdleStatus* _tmp38_;
			gint* _tmp39_;
			gint _tmp39__length1;
			FreeSmartphoneDeviceIdleState _tmp40_;
			FsoFrameworkSmartKeyFile* _tmp41_;
			gchar** _tmp42_;
			gint _tmp42__length1;
			FreeSmartphoneDeviceIdleState _tmp43_;
			const gchar* _tmp44_;
			gint _tmp45_ = 0;
			gint _tmp46_;
			KernelIdleStatus* _tmp47_;
			FreeSmartphoneDeviceIdleState _tmp48_;
			_tmp38_ = self->priv->idlestatus;
			_tmp39_ = _tmp38_->timeouts;
			_tmp39__length1 = _tmp38_->timeouts_length1;
			_tmp40_ = self->priv->displayResourcePreventState;
			_tmp41_ = ((FsoFrameworkAbstractObject*) self)->config;
			_tmp42_ = self->priv->states;
			_tmp42__length1 = self->priv->states_length1;
			_tmp43_ = self->priv->displayResourcePreventState;
			_tmp44_ = _tmp42_[_tmp43_];
			_tmp45_ = fso_framework_smart_key_file_intValue (_tmp41_, KERNEL_KERNEL_IDLE_PLUGIN_NAME, _tmp44_, 10);
			_tmp39_[_tmp40_] = _tmp45_;
			_tmp46_ = _tmp39_[_tmp40_];
			_tmp47_ = self->priv->idlestatus;
			_tmp48_ = _tmp47_->status;
			if (_tmp48_ == FREE_SMARTPHONE_DEVICE_IDLE_STATE_IDLE) {
				KernelIdleStatus* _tmp49_;
				_tmp49_ = self->priv->idlestatus;
				kernel_idle_status_onState (_tmp49_, FREE_SMARTPHONE_DEVICE_IDLE_STATE_IDLE);
			}
		}
	}
}


void kernel_idle_notifier_resetTimeouts (KernelIdleNotifier* self) {
	g_return_if_fail (self != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				KernelIdleStatus* _tmp5_;
				gint* _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				FsoFrameworkSmartKeyFile* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				const gchar* _tmp11_;
				KernelIdleStatus* _tmp12_;
				gint* _tmp13_;
				gint _tmp13__length1;
				gint _tmp14_;
				gint _tmp15_;
				gint _tmp16_ = 0;
				gint _tmp17_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->states;
				_tmp4__length1 = self->priv->states_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = self->priv->idlestatus;
				_tmp6_ = _tmp5_->timeouts;
				_tmp6__length1 = _tmp5_->timeouts_length1;
				_tmp7_ = i;
				_tmp8_ = ((FsoFrameworkAbstractObject*) self)->config;
				_tmp9_ = self->priv->states;
				_tmp9__length1 = self->priv->states_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = self->priv->idlestatus;
				_tmp13_ = _tmp12_->timeouts;
				_tmp13__length1 = _tmp12_->timeouts_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				_tmp16_ = fso_framework_smart_key_file_intValue (_tmp8_, KERNEL_KERNEL_IDLE_PLUGIN_NAME, _tmp11_, _tmp15_);
				_tmp6_[_tmp7_] = _tmp16_;
				_tmp17_ = _tmp6_[_tmp7_];
			}
		}
	}
}


void kernel_idle_notifier_onInputNotification (KernelIdleNotifier* self, GHashTable* properties) {
	GHashTable* _tmp0_;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* devpath;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (properties != NULL);
	_tmp0_ = properties;
	_tmp1_ = g_hash_table_lookup (_tmp0_, "DEVPATH");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	devpath = _tmp2_;
	_tmp4_ = devpath;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = devpath;
		_tmp6_ = string_contains (_tmp5_, "event");
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp7_ = _tmp3_;
	if (_tmp7_) {
		kernel_idle_notifier_resetTimeouts (self);
		kernel_idle_notifier_syncNodesToWatch (self);
		kernel_idle_notifier_registerInputWatches (self);
	}
	_g_free0 (devpath);
}


static void _vala_array_add1 (gint** array, int* length, int* size, gint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void kernel_idle_notifier_syncNodesToWatch (KernelIdleNotifier* self) {
	gint* _tmp0_;
	gint _tmp0__length1;
	gint* _tmp3_ = NULL;
	GDir* dir = NULL;
	GDir* _tmp15_;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* entry;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fds;
	_tmp0__length1 = self->priv->fds_length1;
	if (_tmp0_ != NULL) {
		gint* _tmp1_;
		gint _tmp1__length1;
		_tmp1_ = self->priv->fds;
		_tmp1__length1 = self->priv->fds_length1;
		{
			gint* fd_collection = NULL;
			gint fd_collection_length1 = 0;
			gint _fd_collection_size_ = 0;
			gint fd_it = 0;
			fd_collection = _tmp1_;
			fd_collection_length1 = _tmp1__length1;
			for (fd_it = 0; fd_it < _tmp1__length1; fd_it = fd_it + 1) {
				gint fd = 0;
				fd = fd_collection[fd_it];
				{
					gint _tmp2_;
					_tmp2_ = fd;
					close (_tmp2_);
				}
			}
		}
	}
	_tmp3_ = g_new0 (gint, 0);
	self->priv->fds = (g_free (self->priv->fds), NULL);
	self->priv->fds = _tmp3_;
	self->priv->fds_length1 = 0;
	self->priv->_fds_size_ = self->priv->fds_length1;
	{
		const gchar* _tmp4_;
		GDir* _tmp5_ = NULL;
		GDir* _tmp6_;
		_tmp4_ = self->priv->sysfsnode;
		_tmp5_ = g_dir_open (_tmp4_, (guint) 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_g_dir_close0 (dir);
		dir = _tmp6_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		FsoFrameworkLogger* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp8_ = self->priv->sysfsnode;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = string_to_string (_tmp11_);
		_tmp13_ = g_strconcat ("Can't open ", _tmp9_, " (", _tmp12_, "); idle notifier will not work", NULL);
		_tmp14_ = _tmp13_;
		fso_framework_logger_error (_tmp7_, _tmp14_);
		_g_free0 (_tmp14_);
		_g_error_free0 (e);
		_g_dir_close0 (dir);
		return;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_dir_close0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp15_ = dir;
	_tmp16_ = g_dir_read_name (_tmp15_);
	_tmp17_ = g_strdup (_tmp16_);
	entry = _tmp17_;
	while (TRUE) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gboolean _tmp20_ = FALSE;
		GDir* _tmp46_;
		const gchar* _tmp47_ = NULL;
		gchar* _tmp48_;
		_tmp18_ = entry;
		if (!(_tmp18_ != NULL)) {
			break;
		}
		_tmp19_ = entry;
		_tmp20_ = g_str_has_prefix (_tmp19_, "event");
		if (_tmp20_) {
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			gint _tmp25_ = 0;
			gint _tmp26_;
			gint fd;
			gint _tmp27_;
			_tmp21_ = dev_input;
			_tmp22_ = entry;
			_tmp23_ = g_build_filename (_tmp21_, _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			_tmp25_ = open (_tmp24_, O_RDONLY, (mode_t) 0);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp24_);
			fd = _tmp26_;
			_tmp27_ = fd;
			if (_tmp27_ == (-1)) {
				FsoFrameworkLogger* _tmp28_;
				const gchar* _tmp29_;
				const gchar* _tmp30_ = NULL;
				gint _tmp31_;
				const gchar* _tmp32_ = NULL;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_;
				_tmp28_ = ((FsoFrameworkAbstractObject*) self)->logger;
				_tmp29_ = entry;
				_tmp30_ = string_to_string (_tmp29_);
				_tmp31_ = errno;
				_tmp32_ = g_strerror (_tmp31_);
				_tmp33_ = string_to_string (_tmp32_);
				_tmp34_ = g_strconcat ("Could not open ", _tmp30_, ": ", _tmp33_, " (ignoring)", NULL);
				_tmp35_ = _tmp34_;
				fso_framework_logger_warning (_tmp28_, _tmp35_);
				_g_free0 (_tmp35_);
			} else {
				gint _tmp36_;
				gboolean _tmp37_ = FALSE;
				_tmp36_ = fd;
				_tmp37_ = kernel_idle_notifier_inquireAndCheckForIgnore (self, _tmp36_);
				if (_tmp37_) {
					FsoFrameworkLogger* _tmp38_;
					const gchar* _tmp39_;
					const gchar* _tmp40_ = NULL;
					gchar* _tmp41_ = NULL;
					gchar* _tmp42_;
					gint _tmp43_;
					_tmp38_ = ((FsoFrameworkAbstractObject*) self)->logger;
					_tmp39_ = entry;
					_tmp40_ = string_to_string (_tmp39_);
					_tmp41_ = g_strconcat ("Skipping ", _tmp40_, " as instructed by configuration", NULL);
					_tmp42_ = _tmp41_;
					fso_framework_logger_info (_tmp38_, _tmp42_);
					_g_free0 (_tmp42_);
					_tmp43_ = fd;
					close (_tmp43_);
				} else {
					gint* _tmp44_;
					gint _tmp44__length1;
					gint _tmp45_;
					_tmp44_ = self->priv->fds;
					_tmp44__length1 = self->priv->fds_length1;
					_tmp45_ = fd;
					_vala_array_add1 (&self->priv->fds, &self->priv->fds_length1, &self->priv->_fds_size_, _tmp45_);
				}
			}
		}
		_tmp46_ = dir;
		_tmp47_ = g_dir_read_name (_tmp46_);
		_tmp48_ = g_strdup (_tmp47_);
		_g_free0 (entry);
		entry = _tmp48_;
	}
	_g_free0 (entry);
	_g_dir_close0 (dir);
}


static gboolean _kernel_idle_notifier_onInputEvent_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	gboolean result;
	result = kernel_idle_notifier_onInputEvent (self, source, condition);
	return result;
}


static gpointer _g_io_channel_ref0 (gpointer self) {
	return self ? g_io_channel_ref (self) : NULL;
}


static void _vala_array_add2 (GIOChannel*** array, int* length, int* size, GIOChannel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GIOChannel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void kernel_idle_notifier_registerInputWatches (KernelIdleNotifier* self) {
	GIOChannel** _tmp0_ = NULL;
	gint* _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (GIOChannel*, 0 + 1);
	self->priv->channels = (_vala_array_free (self->priv->channels, self->priv->channels_length1, (GDestroyNotify) g_io_channel_unref), NULL);
	self->priv->channels = _tmp0_;
	self->priv->channels_length1 = 0;
	self->priv->_channels_size_ = self->priv->channels_length1;
	_tmp1_ = self->priv->fds;
	_tmp1__length1 = self->priv->fds_length1;
	{
		gint* fd_collection = NULL;
		gint fd_collection_length1 = 0;
		gint _fd_collection_size_ = 0;
		gint fd_it = 0;
		fd_collection = _tmp1_;
		fd_collection_length1 = _tmp1__length1;
		for (fd_it = 0; fd_it < _tmp1__length1; fd_it = fd_it + 1) {
			gint fd = 0;
			fd = fd_collection[fd_it];
			{
				gint _tmp2_;
				GIOChannel* _tmp3_;
				GIOChannel* channel;
				GIOChannel* _tmp4_;
				GIOChannel* _tmp5_;
				GIOChannel** _tmp6_;
				gint _tmp6__length1;
				GIOChannel* _tmp7_;
				GIOChannel* _tmp8_;
				_tmp2_ = fd;
				_tmp3_ = g_io_channel_unix_new (_tmp2_);
				channel = _tmp3_;
				_tmp4_ = channel;
				g_io_channel_set_close_on_unref (_tmp4_, TRUE);
				_tmp5_ = channel;
				g_io_add_watch (_tmp5_, G_IO_IN, _kernel_idle_notifier_onInputEvent_gio_func, self);
				_tmp6_ = self->priv->channels;
				_tmp6__length1 = self->priv->channels_length1;
				_tmp7_ = channel;
				_tmp8_ = _g_io_channel_ref0 (_tmp7_);
				_vala_array_add2 (&self->priv->channels, &self->priv->channels_length1, &self->priv->_channels_size_, _tmp8_);
				_g_io_channel_unref0 (channel);
			}
		}
	}
}


/**
     * In some cases we have to check for an input device id to ignore only in one idle
     * state. So we ask here about the device id where the event comes from and then check
     * if we have to ignore it in the current idle state.
     **/
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static gboolean kernel_idle_notifier_checkForIgnoreInputEvent (KernelIdleNotifier* self, gint sourceFd) {
	gboolean result = FALSE;
	gboolean ignore;
	GeeHashMap* _tmp0_;
	KernelIdleStatus* _tmp1_;
	FreeSmartphoneDeviceIdleState _tmp2_;
	gpointer _tmp3_ = NULL;
	gchar* ids;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** idsToIgnore;
	gint idsToIgnore_length1;
	gint _idsToIgnore_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	gint _tmp10_ = 0;
	gchar* _tmp11_;
	gint _tmp11__length1;
	gint _tmp12_ = 0;
	gint length;
	gint _tmp13_;
	gboolean _tmp18_;
	g_return_val_if_fail (self != NULL, FALSE);
	ignore = FALSE;
	_tmp0_ = self->priv->stateIgnoreById;
	_tmp1_ = self->priv->idlestatus;
	_tmp2_ = _tmp1_->status;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, GINT_TO_POINTER ((gint) _tmp2_));
	ids = (gchar*) _tmp3_;
	_tmp4_ = ids;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_free0 (ids);
		return result;
	}
	_tmp5_ = ids;
	_tmp7_ = _tmp6_ = g_strsplit (_tmp5_, ";", 0);
	idsToIgnore = _tmp7_;
	idsToIgnore_length1 = _vala_array_length (_tmp6_);
	_idsToIgnore_size_ = idsToIgnore_length1;
	_tmp8_ = idsToIgnore;
	_tmp8__length1 = idsToIgnore_length1;
	if (_tmp8__length1 == 0) {
		result = FALSE;
		idsToIgnore = (_vala_array_free (idsToIgnore, idsToIgnore_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (ids);
		return result;
	}
	_tmp9_ = sourceFd;
	_tmp10_ = EVIOCGNAME (KERNEL_BUFFER_SIZE);
	_tmp11_ = kernel_buffer;
	_tmp11__length1 = kernel_buffer_length1;
	_tmp12_ = ioctl (_tmp9_, _tmp10_, _tmp11_);
	length = _tmp12_;
	_tmp13_ = length;
	if (_tmp13_ > 0) {
		gint _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* product;
		const gchar* _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		_tmp14_ = length;
		_tmp15_ = kernel_idle_notifier_cleanBuffer (self, _tmp14_);
		product = _tmp15_;
		_tmp16_ = product;
		_tmp17_ = idsToIgnore;
		_tmp17__length1 = idsToIgnore_length1;
		ignore = _vala_string_array_contains (_tmp17_, _tmp17__length1, _tmp16_);
		_g_free0 (product);
	}
	_tmp18_ = ignore;
	if (!_tmp18_) {
		gint _tmp19_;
		gint _tmp20_ = 0;
		gchar* _tmp21_;
		gint _tmp21__length1;
		gint _tmp22_ = 0;
		gint _tmp23_;
		_tmp19_ = sourceFd;
		_tmp20_ = EVIOCGPHYS (KERNEL_BUFFER_SIZE);
		_tmp21_ = kernel_buffer;
		_tmp21__length1 = kernel_buffer_length1;
		_tmp22_ = ioctl (_tmp19_, _tmp20_, _tmp21_);
		length = _tmp22_;
		_tmp23_ = length;
		if (_tmp23_ > 0) {
			gint _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* phys;
			const gchar* _tmp26_;
			gchar** _tmp27_;
			gint _tmp27__length1;
			_tmp24_ = length;
			_tmp25_ = kernel_idle_notifier_cleanBuffer (self, _tmp24_);
			phys = _tmp25_;
			_tmp26_ = phys;
			_tmp27_ = idsToIgnore;
			_tmp27__length1 = idsToIgnore_length1;
			ignore = _vala_string_array_contains (_tmp27_, _tmp27__length1, _tmp26_);
			_g_free0 (phys);
		}
	}
	result = ignore;
	idsToIgnore = (_vala_array_free (idsToIgnore, idsToIgnore_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (ids);
	return result;
}


static void kernel_idle_notifier_handleInputEvent (KernelIdleNotifier* self, struct input_event* ev) {
	FreeSmartphoneUsageSystemAction _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = self->priv->lastSystemAction;
	if (_tmp0_ != FREE_SMARTPHONE_USAGE_SYSTEM_ACTION_SUSPEND) {
		KernelIdleStatus* _tmp1_;
		_tmp1_ = self->priv->idlestatus;
		kernel_idle_status_onState (_tmp1_, FREE_SMARTPHONE_DEVICE_IDLE_STATE_BUSY);
	}
}


gboolean kernel_idle_notifier_onInputEvent (KernelIdleNotifier* self, GIOChannel* source, GIOCondition condition) {
	gboolean result = FALSE;
	struct input_event _tmp0_ = {0};
	struct input_event ev;
	GIOChannel* _tmp1_;
	gint _tmp2_ = 0;
	gssize _tmp3_ = 0L;
	gssize bytesread;
	gssize _tmp4_;
	GIOChannel* _tmp12_;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	ev = _tmp0_;
	_tmp1_ = source;
	_tmp2_ = g_io_channel_unix_get_fd (_tmp1_);
	_tmp3_ = read (_tmp2_, &ev, (gsize) sizeof (struct input_event));
	bytesread = _tmp3_;
	_tmp4_ = bytesread;
	if (_tmp4_ == ((gssize) 0)) {
		FsoFrameworkLogger* _tmp5_;
		GIOChannel* _tmp6_;
		gint _tmp7_ = 0;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		_tmp5_ = ((FsoFrameworkAbstractObject*) self)->logger;
		_tmp6_ = source;
		_tmp7_ = g_io_channel_unix_get_fd (_tmp6_);
		_tmp8_ = g_strdup_printf ("%i", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("Could not read from input device fd ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		fso_framework_logger_warning (_tmp5_, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		result = FALSE;
		return result;
	}
	_tmp12_ = source;
	_tmp13_ = g_io_channel_unix_get_fd (_tmp12_);
	_tmp14_ = kernel_idle_notifier_checkForIgnoreInputEvent (self, _tmp13_);
	if (!_tmp14_) {
		kernel_idle_notifier_handleInputEvent (self, &ev);
	}
	result = TRUE;
	return result;
}


static void kernel_idle_notifier_real_get_state_data_free (gpointer _data) {
	KernelIdleNotifierGetStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelIdleNotifierGetStateData, _data_);
}


static void kernel_idle_notifier_real_get_state (FreeSmartphoneDeviceIdleNotifier* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelIdleNotifier * self;
	KernelIdleNotifierGetStateData* _data_;
	KernelIdleNotifier* _tmp0_;
	self = (KernelIdleNotifier*) base;
	_data_ = g_slice_new0 (KernelIdleNotifierGetStateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_idle_notifier_real_get_state);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_idle_notifier_real_get_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_idle_notifier_real_get_state_co (_data_);
}


static FreeSmartphoneDeviceIdleState kernel_idle_notifier_real_get_state_finish (FreeSmartphoneDeviceIdleNotifier* base, GAsyncResult* _res_, GError** error) {
	FreeSmartphoneDeviceIdleState result;
	KernelIdleNotifierGetStateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return 0;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean kernel_idle_notifier_real_get_state_co (KernelIdleNotifierGetStateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->result = 0;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_idle_notifier_real_get_timeouts_data_free (gpointer _data) {
	KernelIdleNotifierGetTimeoutsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelIdleNotifierGetTimeoutsData, _data_);
}


static void kernel_idle_notifier_real_get_timeouts (FreeSmartphoneDeviceIdleNotifier* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelIdleNotifier * self;
	KernelIdleNotifierGetTimeoutsData* _data_;
	KernelIdleNotifier* _tmp0_;
	self = (KernelIdleNotifier*) base;
	_data_ = g_slice_new0 (KernelIdleNotifierGetTimeoutsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_idle_notifier_real_get_timeouts);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_idle_notifier_real_get_timeouts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_idle_notifier_real_get_timeouts_co (_data_);
}


static GHashTable* kernel_idle_notifier_real_get_timeouts_finish (FreeSmartphoneDeviceIdleNotifier* base, GAsyncResult* _res_, GError** error) {
	GHashTable* result;
	KernelIdleNotifierGetTimeoutsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gboolean kernel_idle_notifier_real_get_timeouts_co (KernelIdleNotifierGetTimeoutsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_str_hash;
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, NULL);
	_data_->dict = _data_->_tmp2_;
	{
		_data_->i = 0;
		{
			_data_->_tmp3_ = TRUE;
			while (TRUE) {
				_data_->_tmp4_ = _data_->_tmp3_;
				if (!_data_->_tmp4_) {
					_data_->_tmp5_ = _data_->i;
					_data_->i = _data_->_tmp5_ + 1;
				}
				_data_->_tmp3_ = FALSE;
				_data_->_tmp6_ = _data_->i;
				_data_->_tmp7_ = _data_->self->priv->states;
				_data_->_tmp7__length1 = _data_->self->priv->states_length1;
				if (!(_data_->_tmp6_ < _data_->_tmp7__length1)) {
					break;
				}
				_data_->_tmp8_ = _data_->dict;
				_data_->_tmp9_ = _data_->self->priv->states;
				_data_->_tmp9__length1 = _data_->self->priv->states_length1;
				_data_->_tmp10_ = _data_->i;
				_data_->_tmp11_ = _data_->_tmp9_[_data_->_tmp10_];
				_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
				_data_->_tmp13_ = ((FsoFrameworkAbstractObject*) _data_->self)->config;
				_data_->_tmp14_ = _data_->self->priv->states;
				_data_->_tmp14__length1 = _data_->self->priv->states_length1;
				_data_->_tmp15_ = _data_->i;
				_data_->_tmp16_ = _data_->_tmp14_[_data_->_tmp15_];
				_data_->_tmp17_ = _data_->self->priv->idlestatus;
				_data_->_tmp18_ = _data_->_tmp17_->timeouts;
				_data_->_tmp18__length1 = _data_->_tmp17_->timeouts_length1;
				_data_->_tmp19_ = _data_->i;
				_data_->_tmp20_ = _data_->_tmp18_[_data_->_tmp19_];
				_data_->_tmp21_ = 0;
				_data_->_tmp21_ = fso_framework_smart_key_file_intValue (_data_->_tmp13_, KERNEL_KERNEL_IDLE_PLUGIN_NAME, _data_->_tmp16_, _data_->_tmp20_);
				g_hash_table_insert (_data_->_tmp8_, _data_->_tmp12_, GINT_TO_POINTER (_data_->_tmp21_));
			}
		}
	}
	_data_->result = _data_->dict;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_hash_table_unref0 (_data_->dict);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_idle_notifier_real_set_state_data_free (gpointer _data) {
	KernelIdleNotifierSetStateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelIdleNotifierSetStateData, _data_);
}


static void kernel_idle_notifier_real_set_state (FreeSmartphoneDeviceIdleNotifier* base, FreeSmartphoneDeviceIdleState status, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelIdleNotifier * self;
	KernelIdleNotifierSetStateData* _data_;
	KernelIdleNotifier* _tmp0_;
	FreeSmartphoneDeviceIdleState _tmp1_;
	self = (KernelIdleNotifier*) base;
	_data_ = g_slice_new0 (KernelIdleNotifierSetStateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_idle_notifier_real_set_state);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_idle_notifier_real_set_state_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = status;
	_data_->status = _tmp1_;
	kernel_idle_notifier_real_set_state_co (_data_);
}


static void kernel_idle_notifier_real_set_state_finish (FreeSmartphoneDeviceIdleNotifier* base, GAsyncResult* _res_, GError** error) {
	KernelIdleNotifierSetStateData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel_idle_notifier_real_set_state_co (KernelIdleNotifierSetStateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->idlestatus;
	_data_->_tmp1_ = _data_->status;
	kernel_idle_status_onState (_data_->_tmp0_, _data_->_tmp1_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_idle_notifier_real_set_timeout_data_free (gpointer _data) {
	KernelIdleNotifierSetTimeoutData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (KernelIdleNotifierSetTimeoutData, _data_);
}


static void kernel_idle_notifier_real_set_timeout (FreeSmartphoneDeviceIdleNotifier* base, FreeSmartphoneDeviceIdleState status, gint timeout, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelIdleNotifier * self;
	KernelIdleNotifierSetTimeoutData* _data_;
	KernelIdleNotifier* _tmp0_;
	FreeSmartphoneDeviceIdleState _tmp1_;
	gint _tmp2_;
	self = (KernelIdleNotifier*) base;
	_data_ = g_slice_new0 (KernelIdleNotifierSetTimeoutData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_idle_notifier_real_set_timeout);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_idle_notifier_real_set_timeout_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = status;
	_data_->status = _tmp1_;
	_tmp2_ = timeout;
	_data_->timeout = _tmp2_;
	kernel_idle_notifier_real_set_timeout_co (_data_);
}


static void kernel_idle_notifier_real_set_timeout_finish (FreeSmartphoneDeviceIdleNotifier* base, GAsyncResult* _res_, GError** error) {
	KernelIdleNotifierSetTimeoutData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel_idle_notifier_real_set_timeout_co (KernelIdleNotifierSetTimeoutData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((FsoFrameworkAbstractObject*) _data_->self)->config;
	_data_->_tmp1_ = _data_->self->priv->states;
	_data_->_tmp1__length1 = _data_->self->priv->states_length1;
	_data_->_tmp2_ = _data_->status;
	_data_->_tmp3_ = _data_->_tmp1_[_data_->_tmp2_];
	_data_->_tmp4_ = _data_->timeout;
	fso_framework_smart_key_file_write (_data_->_tmp0_, G_TYPE_INT, NULL, NULL, KERNEL_KERNEL_IDLE_PLUGIN_NAME, _data_->_tmp3_, GINT_TO_POINTER (_data_->_tmp4_));
	_data_->_tmp5_ = _data_->self->priv->idlestatus;
	_data_->_tmp6_ = _data_->_tmp5_->timeouts;
	_data_->_tmp6__length1 = _data_->_tmp5_->timeouts_length1;
	_data_->_tmp7_ = _data_->status;
	_data_->_tmp8_ = _data_->timeout;
	_data_->_tmp6_[_data_->_tmp7_] = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->_tmp6_[_data_->_tmp7_];
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_idle_notifier_class_init (KernelIdleNotifierClass * klass) {
	gchar* _tmp0_ = NULL;
	kernel_idle_notifier_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KernelIdleNotifierPrivate));
	FSO_FRAMEWORK_ABSTRACT_OBJECT_CLASS (klass)->repr = kernel_idle_notifier_real_repr;
	G_OBJECT_CLASS (klass)->finalize = kernel_idle_notifier_finalize;
	_tmp0_ = g_new0 (gchar, KERNEL_BUFFER_SIZE);
	kernel_buffer = (g_free (kernel_buffer), NULL);
	kernel_buffer = _tmp0_;
	kernel_buffer_length1 = KERNEL_BUFFER_SIZE;
	_kernel_buffer_size_ = kernel_buffer_length1;
}


static void kernel_idle_notifier_free_smartphone_device_idle_notifier_interface_init (FreeSmartphoneDeviceIdleNotifierIface * iface) {
	kernel_idle_notifier_free_smartphone_device_idle_notifier_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_state = (FreeSmartphoneDeviceIdleState (*)(FreeSmartphoneDeviceIdleNotifier*, GError**)) kernel_idle_notifier_real_get_state;
	iface->get_state_finish = kernel_idle_notifier_real_get_state_finish;
	iface->get_timeouts = (GHashTable* (*)(FreeSmartphoneDeviceIdleNotifier*, GError**)) kernel_idle_notifier_real_get_timeouts;
	iface->get_timeouts_finish = kernel_idle_notifier_real_get_timeouts_finish;
	iface->set_state = (void (*)(FreeSmartphoneDeviceIdleNotifier*, FreeSmartphoneDeviceIdleState, GError**)) kernel_idle_notifier_real_set_state;
	iface->set_state_finish = kernel_idle_notifier_real_set_state_finish;
	iface->set_timeout = (void (*)(FreeSmartphoneDeviceIdleNotifier*, FreeSmartphoneDeviceIdleState, gint, GError**)) kernel_idle_notifier_real_set_timeout;
	iface->set_timeout_finish = kernel_idle_notifier_real_set_timeout_finish;
}


static void kernel_idle_notifier_instance_init (KernelIdleNotifier * self) {
	self->priv = KERNEL_IDLE_NOTIFIER_GET_PRIVATE (self);
}


static void kernel_idle_notifier_finalize (GObject* obj) {
	KernelIdleNotifier * self;
	self = KERNEL_IDLE_NOTIFIER (obj);
	_g_object_unref0 (self->priv->subsystem);
	_g_free0 (self->priv->sysfsnode);
	self->priv->fds = (g_free (self->priv->fds), NULL);
	self->priv->channels = (_vala_array_free (self->priv->channels, self->priv->channels_length1, (GDestroyNotify) g_io_channel_unref), NULL);
	_kernel_idle_status_free0 (self->priv->idlestatus);
	self->priv->states = (_vala_array_free (self->priv->states, self->priv->states_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->stateIgnoreById);
	_g_object_unref0 (self->priv->usage);
	G_OBJECT_CLASS (kernel_idle_notifier_parent_class)->finalize (obj);
}


/**
 * Implementation of org.freesmartphone.Device.IdleNotifier for Kernel Input Devices
 **/
GType kernel_idle_notifier_get_type (void) {
	return kernel_idle_notifier_type_id;
}


GType kernel_idle_notifier_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (KernelIdleNotifierClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kernel_idle_notifier_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KernelIdleNotifier), 0, (GInstanceInitFunc) kernel_idle_notifier_instance_init, NULL };
	static const GInterfaceInfo free_smartphone_device_idle_notifier_info = { (GInterfaceInitFunc) kernel_idle_notifier_free_smartphone_device_idle_notifier_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	kernel_idle_notifier_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_OBJECT, "KernelIdleNotifier", &g_define_type_info, 0);
	g_type_module_add_interface (module, kernel_idle_notifier_type_id, FREE_SMARTPHONE_DEVICE_TYPE_IDLE_NOTIFIER, &free_smartphone_device_idle_notifier_info);
	return kernel_idle_notifier_type_id;
}


KernelDisplayResource* kernel_display_resource_construct (GType object_type, FsoFrameworkSubsystem* subsystem) {
	KernelDisplayResource * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = subsystem;
	self = (KernelDisplayResource*) fso_framework_abstract_dbus_resource_construct (object_type, "Display", _tmp0_);
	return self;
}


KernelDisplayResource* kernel_display_resource_new (FsoFrameworkSubsystem* subsystem) {
	return kernel_display_resource_construct (KERNEL_TYPE_DISPLAY_RESOURCE, subsystem);
}


static void kernel_display_resource_real_enableResource_data_free (gpointer _data) {
	kernel_display_resource_enableResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (kernel_display_resource_enableResourceData, _data_);
}


static void kernel_display_resource_real_enableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelDisplayResource * self;
	kernel_display_resource_enableResourceData* _data_;
	KernelDisplayResource* _tmp0_;
	self = (KernelDisplayResource*) base;
	_data_ = g_slice_new0 (kernel_display_resource_enableResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_display_resource_real_enableResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_display_resource_real_enableResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_display_resource_real_enableResource_co (_data_);
}


static void kernel_display_resource_real_enableResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_, GError** error) {
	kernel_display_resource_enableResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel_display_resource_real_enableResource_co (kernel_display_resource_enableResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->on;
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = fso_framework_logger_debug (_data_->_tmp1_, "Enabling...");
	g_assert (_data_->_tmp2_);
	_data_->_tmp3_ = instance;
	kernel_idle_notifier_onResourceChanged (_data_->_tmp3_, (FsoFrameworkAbstractDBusResource*) _data_->self, TRUE);
	_data_->self->on = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_display_resource_real_disableResource_data_free (gpointer _data) {
	kernel_display_resource_disableResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (kernel_display_resource_disableResourceData, _data_);
}


static void kernel_display_resource_real_disableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelDisplayResource * self;
	kernel_display_resource_disableResourceData* _data_;
	KernelDisplayResource* _tmp0_;
	self = (KernelDisplayResource*) base;
	_data_ = g_slice_new0 (kernel_display_resource_disableResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_display_resource_real_disableResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_display_resource_real_disableResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_display_resource_real_disableResource_co (_data_);
}


static void kernel_display_resource_real_disableResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_) {
	kernel_display_resource_disableResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel_display_resource_real_disableResource_co (kernel_display_resource_disableResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->on;
	if (!_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = fso_framework_logger_debug (_data_->_tmp1_, "Disabling...");
	g_assert (_data_->_tmp2_);
	_data_->_tmp3_ = instance;
	kernel_idle_notifier_onResourceChanged (_data_->_tmp3_, (FsoFrameworkAbstractDBusResource*) _data_->self, FALSE);
	_data_->self->on = FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_display_resource_real_suspendResource_data_free (gpointer _data) {
	kernel_display_resource_suspendResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (kernel_display_resource_suspendResourceData, _data_);
}


static void kernel_display_resource_real_suspendResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelDisplayResource * self;
	kernel_display_resource_suspendResourceData* _data_;
	KernelDisplayResource* _tmp0_;
	self = (KernelDisplayResource*) base;
	_data_ = g_slice_new0 (kernel_display_resource_suspendResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_display_resource_real_suspendResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_display_resource_real_suspendResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_display_resource_real_suspendResource_co (_data_);
}


static void kernel_display_resource_real_suspendResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_) {
	kernel_display_resource_suspendResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel_display_resource_real_suspendResource_co (kernel_display_resource_suspendResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_display_resource_real_resumeResource_data_free (gpointer _data) {
	kernel_display_resource_resumeResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (kernel_display_resource_resumeResourceData, _data_);
}


static void kernel_display_resource_real_resumeResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelDisplayResource * self;
	kernel_display_resource_resumeResourceData* _data_;
	KernelDisplayResource* _tmp0_;
	self = (KernelDisplayResource*) base;
	_data_ = g_slice_new0 (kernel_display_resource_resumeResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_display_resource_real_resumeResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_display_resource_real_resumeResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_display_resource_real_resumeResource_co (_data_);
}


static void kernel_display_resource_real_resumeResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_) {
	kernel_display_resource_resumeResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel_display_resource_real_resumeResource_co (kernel_display_resource_resumeResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_display_resource_class_init (KernelDisplayResourceClass * klass) {
	kernel_display_resource_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->enableResource = kernel_display_resource_real_enableResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->enableResource_finish = kernel_display_resource_real_enableResource_finish;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->disableResource = kernel_display_resource_real_disableResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->disableResource_finish = kernel_display_resource_real_disableResource_finish;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->suspendResource = kernel_display_resource_real_suspendResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->suspendResource_finish = kernel_display_resource_real_suspendResource_finish;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->resumeResource = kernel_display_resource_real_resumeResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->resumeResource_finish = kernel_display_resource_real_resumeResource_finish;
	G_OBJECT_CLASS (klass)->finalize = kernel_display_resource_finalize;
}


static void kernel_display_resource_instance_init (KernelDisplayResource * self) {
}


static void kernel_display_resource_finalize (GObject* obj) {
	KernelDisplayResource * self;
	self = KERNEL_DISPLAY_RESOURCE (obj);
	G_OBJECT_CLASS (kernel_display_resource_parent_class)->finalize (obj);
}


/**
 * Implementation of org.freesmartphone.Resource for the Display Resource
 **/
GType kernel_display_resource_get_type (void) {
	return kernel_display_resource_type_id;
}


GType kernel_display_resource_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (KernelDisplayResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kernel_display_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KernelDisplayResource), 0, (GInstanceInitFunc) kernel_display_resource_instance_init, NULL };
	kernel_display_resource_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_DBUS_RESOURCE, "KernelDisplayResource", &g_define_type_info, 0);
	return kernel_display_resource_type_id;
}


KernelCpuResource* kernel_cpu_resource_construct (GType object_type, FsoFrameworkSubsystem* subsystem) {
	KernelCpuResource * self = NULL;
	FsoFrameworkSubsystem* _tmp0_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = subsystem;
	self = (KernelCpuResource*) fso_framework_abstract_dbus_resource_construct (object_type, "CPU", _tmp0_);
	return self;
}


KernelCpuResource* kernel_cpu_resource_new (FsoFrameworkSubsystem* subsystem) {
	return kernel_cpu_resource_construct (KERNEL_TYPE_CPU_RESOURCE, subsystem);
}


static void kernel_cpu_resource_real_enableResource_data_free (gpointer _data) {
	kernel_cpu_resource_enableResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (kernel_cpu_resource_enableResourceData, _data_);
}


static void kernel_cpu_resource_real_enableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelCpuResource * self;
	kernel_cpu_resource_enableResourceData* _data_;
	KernelCpuResource* _tmp0_;
	self = (KernelCpuResource*) base;
	_data_ = g_slice_new0 (kernel_cpu_resource_enableResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_cpu_resource_real_enableResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_cpu_resource_real_enableResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_cpu_resource_real_enableResource_co (_data_);
}


static void kernel_cpu_resource_real_enableResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_, GError** error) {
	kernel_cpu_resource_enableResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel_cpu_resource_real_enableResource_co (kernel_cpu_resource_enableResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->on;
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = fso_framework_logger_debug (_data_->_tmp1_, "Enabling...");
	g_assert (_data_->_tmp2_);
	_data_->_tmp3_ = instance;
	kernel_idle_notifier_onResourceChanged (_data_->_tmp3_, (FsoFrameworkAbstractDBusResource*) _data_->self, TRUE);
	_data_->self->on = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_cpu_resource_real_disableResource_data_free (gpointer _data) {
	kernel_cpu_resource_disableResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (kernel_cpu_resource_disableResourceData, _data_);
}


static void kernel_cpu_resource_real_disableResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelCpuResource * self;
	kernel_cpu_resource_disableResourceData* _data_;
	KernelCpuResource* _tmp0_;
	self = (KernelCpuResource*) base;
	_data_ = g_slice_new0 (kernel_cpu_resource_disableResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_cpu_resource_real_disableResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_cpu_resource_real_disableResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_cpu_resource_real_disableResource_co (_data_);
}


static void kernel_cpu_resource_real_disableResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_) {
	kernel_cpu_resource_disableResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel_cpu_resource_real_disableResource_co (kernel_cpu_resource_disableResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->on;
	if (!_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = ((FsoFrameworkAbstractObject*) _data_->self)->logger;
	_data_->_tmp2_ = FALSE;
	_data_->_tmp2_ = fso_framework_logger_debug (_data_->_tmp1_, "Disabling...");
	g_assert (_data_->_tmp2_);
	_data_->_tmp3_ = instance;
	kernel_idle_notifier_onResourceChanged (_data_->_tmp3_, (FsoFrameworkAbstractDBusResource*) _data_->self, FALSE);
	_data_->self->on = FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_cpu_resource_real_suspendResource_data_free (gpointer _data) {
	kernel_cpu_resource_suspendResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (kernel_cpu_resource_suspendResourceData, _data_);
}


static void kernel_cpu_resource_real_suspendResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelCpuResource * self;
	kernel_cpu_resource_suspendResourceData* _data_;
	KernelCpuResource* _tmp0_;
	self = (KernelCpuResource*) base;
	_data_ = g_slice_new0 (kernel_cpu_resource_suspendResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_cpu_resource_real_suspendResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_cpu_resource_real_suspendResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_cpu_resource_real_suspendResource_co (_data_);
}


static void kernel_cpu_resource_real_suspendResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_) {
	kernel_cpu_resource_suspendResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel_cpu_resource_real_suspendResource_co (kernel_cpu_resource_suspendResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_cpu_resource_real_resumeResource_data_free (gpointer _data) {
	kernel_cpu_resource_resumeResourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (kernel_cpu_resource_resumeResourceData, _data_);
}


static void kernel_cpu_resource_real_resumeResource (FsoFrameworkAbstractDBusResource* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	KernelCpuResource * self;
	kernel_cpu_resource_resumeResourceData* _data_;
	KernelCpuResource* _tmp0_;
	self = (KernelCpuResource*) base;
	_data_ = g_slice_new0 (kernel_cpu_resource_resumeResourceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, kernel_cpu_resource_real_resumeResource);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, kernel_cpu_resource_real_resumeResource_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	kernel_cpu_resource_real_resumeResource_co (_data_);
}


static void kernel_cpu_resource_real_resumeResource_finish (FsoFrameworkAbstractDBusResource* base, GAsyncResult* _res_) {
	kernel_cpu_resource_resumeResourceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean kernel_cpu_resource_real_resumeResource_co (kernel_cpu_resource_resumeResourceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void kernel_cpu_resource_class_init (KernelCpuResourceClass * klass) {
	kernel_cpu_resource_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->enableResource = kernel_cpu_resource_real_enableResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->enableResource_finish = kernel_cpu_resource_real_enableResource_finish;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->disableResource = kernel_cpu_resource_real_disableResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->disableResource_finish = kernel_cpu_resource_real_disableResource_finish;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->suspendResource = kernel_cpu_resource_real_suspendResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->suspendResource_finish = kernel_cpu_resource_real_suspendResource_finish;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->resumeResource = kernel_cpu_resource_real_resumeResource;
	FSO_FRAMEWORK_ABSTRACT_DBUS_RESOURCE_CLASS (klass)->resumeResource_finish = kernel_cpu_resource_real_resumeResource_finish;
	G_OBJECT_CLASS (klass)->finalize = kernel_cpu_resource_finalize;
}


static void kernel_cpu_resource_instance_init (KernelCpuResource * self) {
}


static void kernel_cpu_resource_finalize (GObject* obj) {
	KernelCpuResource * self;
	self = KERNEL_CPU_RESOURCE (obj);
	G_OBJECT_CLASS (kernel_cpu_resource_parent_class)->finalize (obj);
}


/**
 * Implementation of org.freesmartphone.Resource for the CPU Resource
 **/
GType kernel_cpu_resource_get_type (void) {
	return kernel_cpu_resource_type_id;
}


GType kernel_cpu_resource_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (KernelCpuResourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kernel_cpu_resource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KernelCpuResource), 0, (GInstanceInitFunc) kernel_cpu_resource_instance_init, NULL };
	kernel_cpu_resource_type_id = g_type_module_register_type (module, FSO_FRAMEWORK_TYPE_ABSTRACT_DBUS_RESOURCE, "KernelCpuResource", &g_define_type_info, 0);
	return kernel_cpu_resource_type_id;
}


/**
 * This function gets called on plugin initialization time.
 * @return the name of your plugin here
 * @note that it needs to be a name in the format <subsystem>.<plugin>
 * else your module will be unloaded immediately.
 **/
gchar* fso_factory_function (FsoFrameworkSubsystem* subsystem, GError** error) {
	gchar* result = NULL;
	FsoFrameworkSmartKeyFile* _tmp0_;
	FsoFrameworkSmartKeyFile* _tmp1_;
	FsoFrameworkSmartKeyFile* config;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gint _tmp7_ = 0;
	gchar** _tmp8_ = NULL;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_ = 0;
	gchar** _tmp12_ = NULL;
	FsoFrameworkSubsystem* _tmp13_;
	const gchar* _tmp14_;
	KernelIdleNotifier* _tmp15_;
	FsoFrameworkSubsystem* _tmp16_;
	KernelCpuResource* _tmp17_;
	FsoFrameworkSubsystem* _tmp18_;
	KernelDisplayResource* _tmp19_;
	gchar* _tmp20_;
	g_return_val_if_fail (subsystem != NULL, NULL);
	_tmp0_ = fso_framework_theConfig;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	config = _tmp1_;
	_tmp2_ = fso_framework_smart_key_file_stringValue (config, "cornucopia", "dev_root", "/dev");
	_g_free0 (dev_root);
	dev_root = _tmp2_;
	_tmp3_ = dev_root;
	_tmp4_ = g_strdup_printf ("%s/input", _tmp3_);
	_g_free0 (dev_input);
	dev_input = _tmp4_;
	_tmp5_ = g_new0 (gchar*, 0 + 1);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 0;
	_tmp8_ = fso_framework_smart_key_file_stringListValue (config, KERNEL_KERNEL_IDLE_PLUGIN_NAME, "ignore_by_id", _tmp6_, 0, &_tmp7_);
	ignoreById = (_vala_array_free (ignoreById, ignoreById_length1, (GDestroyNotify) g_free), NULL);
	ignoreById = _tmp8_;
	ignoreById_length1 = _tmp7_;
	_ignoreById_size_ = ignoreById_length1;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	_tmp9_ = g_new0 (gchar*, 0 + 1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 0;
	_tmp12_ = fso_framework_smart_key_file_stringListValue (config, KERNEL_KERNEL_IDLE_PLUGIN_NAME, "ignore_by_path", _tmp10_, 0, &_tmp11_);
	ignoreByPhys = (_vala_array_free (ignoreByPhys, ignoreByPhys_length1, (GDestroyNotify) g_free), NULL);
	ignoreByPhys = _tmp12_;
	ignoreByPhys_length1 = _tmp11_;
	_ignoreByPhys_size_ = ignoreByPhys_length1;
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = subsystem;
	_tmp14_ = dev_input;
	_tmp15_ = kernel_idle_notifier_new (_tmp13_, _tmp14_);
	_g_object_unref0 (instance);
	instance = _tmp15_;
	_tmp16_ = subsystem;
	_tmp17_ = kernel_cpu_resource_new (_tmp16_);
	_g_object_unref0 (cpu);
	cpu = _tmp17_;
	_tmp18_ = subsystem;
	_tmp19_ = kernel_display_resource_new (_tmp18_);
	_g_object_unref0 (display);
	display = _tmp19_;
	_tmp20_ = g_strdup (KERNEL_KERNEL_IDLE_PLUGIN_NAME);
	result = _tmp20_;
	_g_object_unref0 (config);
	return result;
}


void fso_register_function (GTypeModule* module) {
	FsoFrameworkLogger* _tmp0_;
	g_return_if_fail (module != NULL);
	kernel_idle_notifier_register_type (module);
	kernel_display_resource_register_type (module);
	kernel_cpu_resource_register_type (module);
	_tmp0_ = fso_framework_theLogger;
	fso_framework_logger_debug (_tmp0_, "fsodevice.kernel_idle fso_register_function()");
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



