class fvPreferences {
   constructor { args } {}
   destructor { }

   public {
      method save  { }
      method edit  { {page "fv"} }
      method close { }
   }

   private {
      method read {}

      method buildPage_App      { w }
      method buildPage_Keywords { w }
      method buildPage_Tables   { w }
      method buildPage_Graphs   { w }
      method buildPage_Colors   { w }

      method setGraphSize { menu {val ""} }
      method getGraphSize { }
      method changeColor  { type }
      method changeWindowColors { win type }

      variable FVRC
      variable padXAmnt 10
      variable padYAmnt 3
      variable tabLabels [list App Keywords Tables Graphs Colors]
   }
}

body fvPreferences::constructor { args } {
   global tcl_platform env FITSVIEWER_LIBRARY

   switch $tcl_platform(platform) {
      "macintosh" {
         set FVRC [file join $env(PREF_FOLDER) "fv Preferences"]
      }
      "windows" {
         set  FITSVIEWER_LIBRARY $env(FITSVIEWER_LIBRARY)
         set FVRC [file join $FITSVIEWER_LIBRARY "fv.ini"]
      }
      default {
         set FVRC "~/.fvrc"
      }
   }

   # Create and initialize fvPref namespace

   namespace eval ::fvPref { 
      variable globalBgColor        #cccccc
      variable globalFgColor        black  
      variable activeBgColor        #eeeeee
      variable activeFgColor        black  
      variable checkBBgColor        #ff3366
      variable imgDisplayer         POW
      variable ifWriteHisKey        1
      variable ifDispFitsOnly       1
      variable ifWCSInfo            1
      variable ifProtectedKeys      1
      variable ifAutoReformatKeys   1
      variable ifLeftJustifyString  1
      variable ifAutoUpdateChecksum 0
      variable ifUseManager         1
      variable ifAutoPlotPrimary    0
      variable winManagement        Keep
      variable graphDispSize        [list 300 300]
      variable webModules           [list hera]
      variable webModulesURLs       [list http://olegacy.gsfc.nasa.gov/hera/tcl]
   }

   # Override some defaults based on environment

   if { [winfo screenheight .]>850 } {
      set fvPref::graphDispSize [list 500 500]
   }

   set tmpBg [option get . background Background]
   if { $tmpBg != ""} {
      set fvPref::globalBgColor $tmpBg
   }
   set tmpFg [option get . foreground Foreground]
   if { $tmpFg != ""} {
      set fvPref::globalFgColor $tmpFg
   }

   if { $tcl_platform(platform)=="macintosh" } {
      set fvPref::ifUseManager 0
      set fvPref::globalBgColor "#eeeeee"
      set fvPref::activeBgColor "#cccccc"
   }

   #  Read in the preferences file

   read
}

body fvPreferences::destructor { } {
   if { [winfo exists .fvpref] } {
      destroy .fvpref
   }
}


body fvPreferences::edit { {page "fv"} } {

   if { [winfo exists .fvpref] } {
      .fvpref activate
      Notebook:raise [.fvpref childsite].notebook $page
      return
   }

   ###########
   # Setup Dialog Box
   ###########

   ::iwidgets::dialogshell .fvpref -title "fv: Preferences" \
         -modality "none"

   .fvpref add Save -text "Save" -command [code $this save]
   .fvpref add Help -text "Help" -command "hhelp preferences"
   .fvpref add Exit -text "Exit" -command [code $this close]
   .fvpref default Exit

   bind .fvpref <<CloseWindow>> [code $this close]

   ###########
   # Setup Tabbed Notebook Widget
   ###########

   set note "[.fvpref childsite].notebook"

   Notebook:create $note -pages $tabLabels -pad 8

   foreach p $tabLabels {
      eval buildPage_$p [Notebook:frame $note $p]
   }

   pack $note -fill both -expand 1

   ###########
   # Display dialog
   ###########

   Notebook:raise $note $page
   Notebook:resize $note
   .fvpref activate
}


body fvPreferences::close { } {
   if { [winfo exists .fvpref] } {
      .fvpref deactivate
   }
   checkForExit
}


body fvPreferences::read { } {
   global tcl_platform

   if { ![catch { set rcFile [open $FVRC r] } ] } {
      while { [gets $rcFile line] != -1} {
         set entry [lindex $line 0]
         set value [lindex $line 1]
         switch -glob -- $entry {
            "Background" {	
               set fvPref::globalBgColor $value
            }
            "Foreground" {
               set fvPref::globalFgColor $value
            }
            "ActiveBackground" {
               set fvPref::activeBgColor $value
            }
            "ActiveForeground" {
               set fvPref::activeFgColor $value
            }
            "CheckButtonColor" {
               set fvPref::checkBBgColor $value
            }
            "ImageDisplayer" {
               set fvPref::imgDisplayer $value
            }
            "IfWriteHisKey" {
               set fvPref::ifWriteHisKey $value
            } 
            "IfDispFitsOnly" {
               set fvPref::ifDispFitsOnly $value
            } 	
            "IfWCSInfo" {
               set fvPref::ifWCSInfo $value
            }
            "IfProtectedKeys" {
               set fvPref::ifProtectedKeys $value
            }
            "IfAutoReformatKeys" {
               set fvPref::ifAutoReformatKeys $value
            }
            "WinManagement" {
               set fvPref::winManagement $value	
            }		
            "IfAutoUpdateChecksum" {
               set fvPref::ifAutoUpdateChecksum $value
            }	
            "IfLeftJustifyString" {
               set fvPref::ifLeftJustifyString $value
            }
            "IfUseDesktopManager" {
               if { $tcl_platform(platform) != "macintosh" } {
                  set fvPref::ifUseManager $value
               }
            }
            "IfAutoPlotPrimary" {
               set fvPref::ifAutoPlotPrimary $value
            }
            "GraphDisplaySize" {
               set fvPref::graphDispSize $value
            }
            "#*" {
            }
            default {
               set fvPref::$entry $value
            }
         }
      }			 
      ::close $rcFile
   }

   option add *Background          $fvPref::globalBgColor
   option add *Foreground          $fvPref::globalFgColor
   option add *HighlightBackground $fvPref::globalBgColor
   option add *activeForeground    $fvPref::activeFgColor
   option add *activeBackground    $fvPref::activeBgColor
   option add *selectForeground    $fvPref::activeFgColor
   option add *selectBackground    $fvPref::activeBgColor
   option add *selectColor         $fvPref::checkBBgColor

}

body fvPreferences::save { } {
    
# check if FVRC file is there
   catch { [file delete -force $FVRC]} 

   if { [catch {set rcFile [open $FVRC w]} err] == 1} {
      error "Unable to open $FVRC to write"
      return 
   }

   puts $rcFile "\# Please don't change this file. It's auto generated by fv"
   puts $rcFile "Background           $fvPref::globalBgColor"
   puts $rcFile "Foreground           $fvPref::globalFgColor"
   puts $rcFile "ActiveBackground     $fvPref::activeBgColor"
   puts $rcFile "ActiveForeground     $fvPref::activeFgColor"
   puts $rcFile "CheckButtonColor     $fvPref::checkBBgColor"
   puts $rcFile "ImageDisplayer       $fvPref::imgDisplayer"
   puts $rcFile "IfWriteHisKey        $fvPref::ifWriteHisKey"
   puts $rcFile "IfDispFitsOnly       $fvPref::ifDispFitsOnly"
   puts $rcFile "WinManagement        $fvPref::winManagement"
   puts $rcFile "IfWCSInfo            $fvPref::ifWCSInfo"
   puts $rcFile "IfProtectedKeys      $fvPref::ifProtectedKeys"
   puts $rcFile "IfAutoReformatKeys   $fvPref::ifAutoReformatKeys"
   puts $rcFile "IfAutoUpdateChecksum $fvPref::ifAutoUpdateChecksum"
   puts $rcFile "IfLeftJustifyString  $fvPref::ifLeftJustifyString"
   puts $rcFile "IfUseDesktopManager  $fvPref::ifUseManager"
   puts $rcFile "IfAutoPlotPrimary    $fvPref::ifAutoPlotPrimary"
   puts $rcFile "GraphDisplaySize     {$fvPref::graphDispSize}"

   ::close $rcFile
   puts "Options saved in $FVRC"
}

##########################################################
#############      Private Functions      ################
##########################################################


##################
#
# Setup Page: fv
#
##################

body fvPreferences::buildPage_App { w } {
   global tcl_platform

   checkbutton $w.fits  -text "List FITS files only"  \
         -variable fvPref::ifDispFitsOnly

   if { $tcl_platform(platform)!="macintosh" } {
      checkbutton $w.mngr  -text "Show desktop manager"  \
            -variable fvPref::ifUseManager \
            -command ".fvwinkeeper updateVisibility"
   }

   ::iwidgets::radiobox $w.windows -labeltext "Window Management"

   $w.windows add NONE \
         -text "Leave existing windows open when opening new one" \
         -variable fvPref::winManagement -value "Keep"
   $w.windows add HIDE \
         -text "Hide existing windows when opening new one" \
         -variable fvPref::winManagement -value "Hide"
   $w.windows add CLOSE \
         -text "Close existing windows when opening new one" \
         -variable fvPref::winManagement -value "Close"

   grid $w.fits     -row 1  -column 1  -sticky w   -pady $padYAmnt \
         -padx $padXAmnt
   if { $tcl_platform(platform)!="macintosh" } {
      grid $w.mngr  -row 2  -column 1  -sticky w   -pady $padYAmnt \
            -padx $padXAmnt
   }
   grid $w.windows  -row 3  -column 1  -sticky we  -pady $padYAmnt
   grid columnconfig $w 1 -weight 1
}

##################
#
# Setup Page: Keywords
#
##################

body fvPreferences::buildPage_Keywords { w } {

   checkbutton $w.hist  -text "Write history keyword after modification" \
         -variable fvPref::ifWriteHisKey
   checkbutton $w.format  -text "Auto-reformat keywords"  \
         -variable fvPref::ifAutoReformatKeys
   checkbutton $w.protect  -text "Protect required keywords"  \
         -variable fvPref::ifProtectedKeys

   ::iwidgets::radiobox $w.chksm -labeltext "Checksum Updates"

   $w.chksm add ALWAYS -text "Always update" \
         -variable fvPref::ifAutoUpdateChecksum -value 2
   $w.chksm add EXIST  -text "Update only if they exist" \
         -variable fvPref::ifAutoUpdateChecksum -value 1
   $w.chksm add NEVER  -text "Do not update" \
         -variable fvPref::ifAutoUpdateChecksum -value 0

   grid $w.hist     -row 1  -column 1  -sticky w  -pady $padYAmnt \
         -padx $padXAmnt
   grid $w.format   -row 2  -column 1  -sticky w  -pady $padYAmnt \
         -padx $padXAmnt
   grid $w.protect  -row 3  -column 1  -sticky w  -pady $padYAmnt \
         -padx $padXAmnt
   grid $w.chksm    -row 4  -column 1  -sticky we -pady $padYAmnt
   grid columnconfig $w 1 -weight 1
}

##################
#
# Setup Page: Table
#
##################

body fvPreferences::buildPage_Tables { w } {

   ::iwidgets::radiobox $w.justify -labeltext "ASCII Column Justification"

   $w.justify add LFT -text Left \
         -variable fvPref::ifLeftJustifyString -value 1
   $w.justify add RGT -text Right\
         -variable fvPref::ifLeftJustifyString -value 0

   grid $w.justify  -row 2  -column 1 -sticky ew  -pady $padYAmnt
   grid columnconfig $w 1 -weight 1
}

##################
#
# Setup Page: Graph
#
##################

body fvPreferences::buildPage_Graphs { w } {
   global hasSAOtng hasDS9

   # Auto Plot Primary
   
   checkbutton $w.auto  -text "Auto-Plot Primary Image" \
         -variable fvPref::ifAutoPlotPrimary

   # WCS info
   
   checkbutton $w.wcs  -text "Use WCS Info" -variable fvPref::ifWCSInfo

   # Image Viewer

   ::iwidgets::radiobox $w.viewer -labeltext "Image Viewer"

   $w.viewer add POW -text POW \
         -variable fvPref::imgDisplayer -value POW
   $w.viewer add SAO -text SAOtng \
         -variable fvPref::imgDisplayer -value SAOtng
   $w.viewer add DS9 -text DS9 \
         -variable fvPref::imgDisplayer -value DS9
   if { ! $hasSAOtng } {
       $w.viewer buttonconfigure SAO -state disabled
   }
   if { ! $hasDS9 } {
       $w.viewer buttonconfigure DS9 -state disabled
   }

   # Default graph display size
   
   ::iwidgets::optionmenu $w.graphsize -labeltext "Graph Size:" -labelpos w \
         -command [code $this setGraphSize $w.graphsize]
   $w.graphsize insert 0 \
         300x300 500x300 300x500 500x500 700x500 500x700 700x700 \
         "-----" Other...
   $w.graphsize disable "-----"
   setGraphSize $w.graphsize $fvPref::graphDispSize

   grid $w.auto       -row 1  -column 1  -sticky w  -pady $padYAmnt \
         -padx $padXAmnt
   grid $w.wcs        -row 2  -column 1  -sticky w  -pady $padYAmnt \
         -padx $padXAmnt
   grid $w.viewer     -row 3  -column 1  -sticky we -pady $padYAmnt
   grid $w.graphsize  -row 4  -column 1  -sticky w  -pady $padYAmnt \
         -padx $padXAmnt

   grid columnconfig $w 1 -weight 1
}

##################
#
# Setup Page: Colors   grid columnconfig $w 1 -weight 1
#
##################

body fvPreferences::buildPage_Colors { w } {

   set row 1
   foreach lbl [list \
         Background: \
         Foreground: \
         "Active Background:" \
         "Active Foreground:" \
         "Check Button:"] \
         var [list \
         globalBg \
         globalFg \
         activeBg \
         activeFg \
         checkBBg] {
      label $w.clab$row -text $lbl
      button $w.cbtn$row -textvariable fvPref::${var}Color -width 7 \
            -command [code $this changeColor $var]
      grid $w.clab$row -row $row -column 1 -sticky w  -pady 0 \
            -padx $padXAmnt
      grid $w.cbtn$row -row $row -column 2 -sticky w  -pady 0 \
            -padx 0
      incr row
   }
   grid columnconfigure $w 2 -weight 1
}


body fvPreferences::setGraphSize { menu {val ""} } {

   if { $val=="" } {
      # Update parameter for menu selection

      set value [$menu get]
      if { $value=="Other..." } {
         set val [getGraphSize]
         setGraphSize $menu $val
      } else {
         set fvPref::graphDispSize [split $value x]
      }

   } else {

      # Set menu selection to supplied value
      set value [join $val x]
      if { [catch {$menu index $value}] } {
         $menu insert 0 $value
      }
      $menu select $value
      set fvPref::graphDispSize $val

   }
}


body fvPreferences::getGraphSize { } {

   ::iwidgets::dialogshell .gSize -title "fv: Graph Size" \
         -modality "application"

   .gSize add OK     -text Ok      -command {.gSize deactivate 1}
   .gSize add CANCEL -text Cancel  -command {.gSize deactivate 0}
   .gSize default OK

   set w [.gSize childsite]

   label $w.wid -text "Width:"
   label $w.hgt -text "Height:"
   entry $w.wide
   entry $w.hgte

   $w.wide insert 0 [lindex $fvPref::graphDispSize 0]
   $w.hgte insert 0 [lindex $fvPref::graphDispSize 1]

   grid $w.wid   -row 1  -column 1  -padx 3 -pady 3 -sticky e
   grid $w.hgt   -row 2  -column 1  -padx 3 -pady 3 -sticky e
   grid $w.wide  -row 1  -column 2  -padx 3 -pady 3 -sticky w
   grid $w.hgte  -row 2  -column 2  -padx 3 -pady 3 -sticky w

   set result [.gSize activate]
   set width  [$w.wide get]
   set height [$w.hgte get]
   destroy .gSize

   if { $result!="" && $result } {
      if { $width > 19 && $height > 19 && $width < 2001 && $height < 2001 } {
         return [list $width $height]
      }
      tk_messageBox -type ok -icon error -parent .fvpref -title "Bad Size" \
            -message "The graph size entered does not fall into the range\
            20-2000.  Reverting to previous value."
   }
   return $fvPref::graphDispSize
}



body fvPreferences::changeColor {type} {
   
   switch $type {
      "globalBg" { set currColor $fvPref::globalBgColor }
      "globalFg" { set currColor $fvPref::globalFgColor }
      "activeBg" { set currColor $fvPref::activeBgColor }
      "activeFg" { set currColor $fvPref::activeFgColor }
      "checkBBg" { set currColor $fvPref::checkBBgColor }
      default    { set currColor "black" }
   }

   set tmpColor [tk_chooseColor -initialcolor $currColor]
   if { $tmpColor == "" } return 
   
   switch $type {
      "globalBg" {
         option add *Background          $tmpColor
         option add *HighlightBackground $tmpColor
         set fvPref::globalBgColor       $tmpColor
      }
      "globalFg" {
         option add *Foreground          $tmpColor
         set fvPref::globalFgColor       $tmpColor
      }
      "activeFg" {
         option add *activeForeground    $tmpColor
         set fvPref::activeFgColor       $tmpColor
      }
      "activeBg" {
         option add *activeBackground    $tmpColor
         set fvPref::activeBgColor       $tmpColor
      }
      "checkBBg" {
         option add *selectColor         $tmpColor
         set fvPref::checkBBgColor       $tmpColor
      }
      default {error "Unknown color type"}
   }

   # find all the windows and change their color
   set tmpWins [winfo children .]
   foreach i $tmpWins {
      changeWindowColors $i $type
   }
}


body fvPreferences::changeWindowColors {win type} {

   switch $type {
      "globalBg" {
         catch {$win configure -background $fvPref::globalBgColor}
         catch {$win configure -highlightbackground $fvPref::globalBgColor}
         if { [winfo class $win] == "Checkbutton" } {
            catch {$win configure -activebackground $fvPref::globalBgColor}
         }
      }
      "globalFg" {
         catch {$win configure -foreground $fvPref::globalFgColor}	    
      }
      "activeFg" {
         catch {$win configure -activeforeground $fvPref::activeFgColor}
      }
      "activeBg" {
         catch {$win configure -activebackground $fvPref::activeBgColor}
      }
      "checkBBg" {
         catch {$win configure -selectcolor $fvPref::checkBBgColor}
      }
      default {error "Unknown bg type"}
   }
   
   set tmpChildren [winfo children $win]
   if { $tmpChildren == "" } {
      return
   } else {
      foreach i $tmpChildren {
         changeWindowColors $i $type 
      }
   }
}
