/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruid.hh,v 1.11 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _DISCOVERY_DRUID_HH
#define _DISCOVERY_DRUID_HH

#include <Druid.hh>

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/IPAddress.hh"
#include "fwbuilder/Firewall.hh"

#include <vector>

class DiscoveryDruidP05Dialog;
class DiscoveryDruidP10Dialog;
class DiscoveryDruidP20Dialog;
class DiscoveryDruidP30Dialog;
class DiscoveryDruidP35Dialog;
class DiscoveryDruidP40Dialog;
		       
class DiscoveryDruidP50Dialog;
class DiscoveryDruidP51Dialog;
class DiscoveryDruidP53Dialog;
class DiscoveryDruidP65Dialog;
class DiscoveryDruidP70Dialog;

class libfwbuilder::Firewall;

class DiscoveryDruid : public Druid {

    DiscoveryDruidP05Dialog  *p05;
    DiscoveryDruidP10Dialog  *p10;
    DiscoveryDruidP20Dialog  *p20;
    DiscoveryDruidP30Dialog  *p30;
    DiscoveryDruidP35Dialog  *p35;
    DiscoveryDruidP40Dialog  *p40;

    DiscoveryDruidP50Dialog  *p50;
    DiscoveryDruidP51Dialog  *p51;
    DiscoveryDruidP53Dialog  *p53;
    DiscoveryDruidP65Dialog  *p65;
    DiscoveryDruidP70Dialog  *p70;

    vector<libfwbuilder::IPNetwork>  include_networks;

    public:

    DiscoveryDruid(const string &t, const string& l);

    virtual void     on_prepare();
    virtual gboolean on_next();
    virtual gboolean on_back();
    virtual gboolean on_cancel();
    virtual void     on_finish();


};

#endif
