/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: DiscoveryDruidP53Dialog.cc,v 1.4 2001/09/22 01:39:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "DiscoveryDruidP53Dialog.hh"

#include "MessageDialog.hh"

using namespace libfwbuilder;


DiscoveryDruidP53Dialog::DiscoveryDruidP53Dialog()
{
    p53_txt_1->set_line_wrap(true);
    p53_txt_1->set_alignment(0.0, 0.5);

    p53_txt_2->set_alignment(1.0, 0.5);
    p53_txt_3->set_alignment(1.0, 0.5);
    p53_txt_4->set_alignment(1.0, 0.5);
    p53_txt_5->set_alignment(1.0, 0.5);
    p53_txt_6->set_alignment(1.0, 0.5);
}

void DiscoveryDruidP53Dialog::prepare()
{
    snmp_community->grab_focus();
}


bool DiscoveryDruidP53Dialog::checkData()
{
    if ( snmp_community->get_text()!="") return true;

    MessageDialog::Error( "Empty community string" );
    return false;
}
