/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FWObjectClipboard.cc,v 1.10 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#include "fwbuilder/FWObjectReference.hh"
#include "FWObjectClipboard.hh"

/*
    This class is nothing more than FWObject with two additional methods
    provided for convenience: 

    void      putObject(FWObject *obj)
    FWObject* getObject()

    this simply returns pointer to the first child

    Since we use standard methods of underlying class FWObject to
    add and remove child, object reference counter is being taken
    care of automatically. If object is not a member of any group but
    clipboard and is being removed from there, it will be automatically
    destroyed. Actually this is whole point of making clipboard a separate
    class derived from FWObject

    We may want to extend clipboard in the future so it will manipulate 
    more than one child object. So far you can put and then get only
    one object to/from clipboard


 */

#include "FWObjectDatabaseGUI.hh"
#include "fwbuilder/Group.hh"

using namespace libfwbuilder;



FWObjectClipboard* FWObjectClipboard::obj_clipboard=NULL;

FWObjectClipboard::FWObjectClipboard()
{
    assert(obj_clipboard==NULL);
    obj_clipboard=this;
    obj=NULL;
}

FWObjectClipboard::~FWObjectClipboard()
{
    obj_clipboard=NULL;
}

void      FWObjectClipboard::putObject(FWObject *_obj)
{
    obj=_obj;
    obj->ref();
}

FWObject* FWObjectClipboard::getObject()
{
    obj->unref();
    return obj;
}


