/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: GroupDialog.hh,v 1.14 2001/12/28 04:37:18 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef _GROUPDIALOG_HH
#  include "GroupDialog_glade.hh"
#  define _GROUPDIALOG_HH
#include "glademm_support.hh"

#include "ListOfIcons.hh"

#include "fwbuilder/FWObject.hh"
#include "fwbuilder/Group.hh"

class GroupDialog : public GroupDialog_glade
{   
        
    friend class GroupDialog_glade;

    void on_viewport1_check_resize();
    void on_viewport1_size_allocate(GtkAllocation *all);
    void on_open_item(void *arg);
    void on_popup_menu(void *arg);

    void on_changed();

    void obj_drag_data_received(GdkDragContext* p0,
				gint p1,
				gint p2,
				GtkSelectionData* p3,
				guint p4,
				guint32 p5);

 
    Gtk::ScrolledWindow     *sw;
    ListOfIcons             *GroupIconList;
    string                   gr_lib;

public:

    GroupDialog(libfwbuilder::FWObject *obj);
    ~GroupDialog();

    virtual void wrk2dlg();
    virtual bool dlg2wrk();
    virtual void updateMainMenu();

    void setLibrary(const string &lib);
    void addObject(libfwbuilder::FWObject *obj);

    void Update();

};
#endif

