/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: InterfaceDialog.cc,v 1.22 2001/12/18 22:48:29 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <gtk--/main.h>

#include "fwbuilder/IPAddress.hh"
#include "InterfaceDialog.hh"
#include "IPAddressWidget.hh"

#include "PixmapButton.hh"

#include "helpers.hh"

using namespace libfwbuilder;

InterfaceDialog::InterfaceDialog( Interface *i )
{
    choice=false;
    interface=i;

    addr=manage(new IPAddressWidget());
    table1->attach(*addr, 1, 2, 4, 5, GTK_EXPAND|GTK_FILL, 0, 0, 0);

    netmask=manage(new IPAddressWidget());
    table1->attach(*netmask, 1, 2, 5, 6, GTK_EXPAND|GTK_FILL, 0, 0, 0);

    addr->setAssociatedNetmaskWidget( netmask );

    name->set_text( i->getName() );
    label->set_text( i->getLabel() );

    if (! i->isDyn() ) {
	addr->setAddress( i->getStr("address") );
	netmask->setAddress( i->getStr("netmask") );
    } else {
	addr->clear();
	addr->set_sensitive(false);
	netmask->clear();
	netmask->set_sensitive(false);
    }
    extint->set_active( i->isExt() );
    dyn_addr->set_active( i->isDyn() );

    physAddress->set_text( i->getPhysicalAddress() );


    name->grab_focus();

    PixmapButton::addPixmapAndText( *button17 , "Ok"     , "OK"     );
    PixmapButton::addPixmapAndText( *button18 , "Cancel" , "Cancel" );

    button17->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    button18->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    button17->grab_default();

    delete_event.connect( SigC::slot(this, &InterfaceDialog::on_delete) );

    show_all();
}

bool InterfaceDialog::run()
{

    while (true) {
	Gtk::Main::grab_add(*this);
	Gtk::Main::run();
	Gtk::Main::grab_remove(*this);

	if (choice) {
	    if (  ! checkObjectName(name->get_text() ) ) continue;
	    if (  ! dyn_addr->get_active() ) {
		if ( ! checkIPaddress(addr->getAsString()) ) continue;
		if ( ! checkNetmask(netmask->getAsString()) ) continue;
	    }
	}
	break;
    }

    hide();

    if (choice) {
	interface->setName(name->get_text() );
	interface->setLabel(label->get_text() );
	interface->setStr("address",addr->getAsString());
	interface->setStr("netmask",netmask->getAsString());
	interface->setExt( extint->get_active() );
	interface->setBool("dyn",dyn_addr->get_active());
	interface->setStr("physAddress", physAddress->get_text() );
    }
    return(choice);
}


gint InterfaceDialog::on_delete(GdkEventAny* ev)
{
    choice=false;
    Gtk::Main::quit();
    return false;
}

void InterfaceDialog::on_ok_clicked()
{   
    choice=true;
    Gtk::Main::quit();
}

void InterfaceDialog::on_cancel_clicked()
{   
    choice=false;
    Gtk::Main::quit();
}

void InterfaceDialog::on_extint_toggled()
{   
}

void InterfaceDialog::on_dyn_addr_toggled()
{

    if (dyn_addr->get_active()) {
	addr->clear();
	addr->set_sensitive(false);
	netmask->clear();
	netmask->set_sensitive(false);
    } else {
	addr->set_sensitive(true);
	netmask->set_sensitive(true);
    }

}


