/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: MessageDialog.hh,v 1.12 2001/12/22 22:40:05 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/




#ifndef _MESSAGEDIALOG_HH
#  include "MessageDialog_glade.hh"
#  define _MESSAGEDIALOG_HH

#include "config.h"

#include "glademm_support.hh"

class MessageDialog : public MessageDialog_glade
{ 
  
public:

    typedef enum {
	OK_YES,
	NO,
	CANCEL
    } DlgReturnValue;
    
protected:
        
    friend class MessageDialog_glade;
    void on_button1_clicked();
    void on_button2_clicked();
    void on_button3_clicked();
    void on_button4_clicked();

    gint on_delete(GdkEventAny* ev);

    bool           running;
    DlgReturnValue result;

public:

    typedef enum  {
	ErrorDlg,
	LongTextErrorDlg,
	WarningDlg,
	LongTextInfoDlg,
	QuestionDlg,
	YesNoDlg
    } DlgType;


    MessageDialog(const string& msg,
		  MessageDialog::DlgType t=MessageDialog::WarningDlg);

    DlgReturnValue run();

    static void Error(const string& msg);
    static void Error(const string& msg,const string& errcode);
    static void LongTextError(const string& msg);
    static void LongTextError(const string& msg,const string& errcode);
    static void Warning(const string& msg);
    static void LongTextInfo(const string& msg);
    static DlgReturnValue  Question(const string& msg);
    static DlgReturnValue  YesNo(const string& msg);

};
#endif
