/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: OptionMenuWidget.hh,v 1.3 2001/12/23 07:15:34 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef _OPTIONMENUWIDGET_HH
#  define _OPTIONMENUWIDGET_HH

#include "config.h"

#include <vector>
#include <string>
#include <map>

#include <gtk--/optionmenu.h>

class OptionMenuWidget : public Gtk::OptionMenu {

    map<string,string>   items;

    void create_menu(int active_item_n=0);
    void on_menu_selection_changed();

    string current_state;

    public:

    OptionMenuWidget();

    void set_menu( vector<string> &);
    void set_menu( map<string,string> &);

    void set_active_item(int n);
    void set_active_item_by_label(const string& label);
    void set_active_item_by_value(const string& val);

    string get_value();
    
/*
 * this signal is sent every time menu selection is changed
 */
    SigC::Signal0<void>changed;

};




#endif
