/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: OptionsDlg.cc,v 1.26 2001/12/08 09:33:08 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <gtk--/main.h>

#include "OptionsDlg.hh"

#include "main_window.hh"
#include "helpers.hh"
#include "MessageDialog.hh"

#include "PixmapButton.hh"

using namespace libfwbuilder;
using namespace Gtk::CTree_Helpers;

RowList::iterator  OptionsDlg::addTreeRow(RowList &rowlist,
					  const string &lbl)
{
    RowList::iterator j;

    vector<const gchar*>      item;
    item.push_back( lbl.c_str() );
    rowlist.push_back(Element(item));
    j= --rowlist.end();

    return j;
}


RowList::iterator  OptionsDlg::addTreeRow(RowList &rowlist,
					  const string &lbl, 
					  unsigned notebook_page_number)
{
    RowList::iterator j;

    vector<const gchar*>      item;
    item.push_back( lbl.c_str() );
    rowlist.push_back(Element(item));
    j= --rowlist.end();
    /*
     *  store page name in the tree widget element
     */
    char *id_storage=cxx_strdup( lbl.c_str() );
    j->set_data( id_storage );

    notebook_pages[lbl]=notebook_page_number;

    return j;
}

/*
    Tree labels and Notebook pages

    Blank       0
    Paths       1
    Network     2
    GUI         3
    Tooltips    4
    Behavior    5
    Tree View   6

*/

OptionsDlg::OptionsDlg()
{

    commit_changes=false;

    PixmapButton::addPixmapAndText( *button12 , "Ok"     , "OK"     );
    PixmapButton::addPixmapAndText( *button10 , "Cancel" , "Cancel" );

    button10->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    button12->set_flags(GTK_CAN_FOCUS|GTK_CAN_DEFAULT);
    button12->grab_default();
    button12->grab_focus();


    label422->set_line_wrap(true);       label422->show();
    label423->set_line_wrap(true);       label423->show();
    label425->set_line_wrap(true);       label425->show();
    label426->set_line_wrap(true);       label426->show();
    label427->set_line_wrap(true);       label427->show();
    label431->set_line_wrap(true);       label431->show();

    ctree->set_expander_style( GTK_CTREE_EXPANDER_CIRCULAR );
    ctree->set_line_style( GTK_CTREE_LINES_SOLID  );

/*
 *  Now build the tree
 */
    RowList  top_level = ctree->rows();

    RowList  subtree = (addTreeRow(top_level, "General", 0 ))->subtree();

    addTreeRow(subtree,"Paths"          , 1);
    addTreeRow(top_level,"Network"      , 2);

    subtree = (addTreeRow(top_level,"GUI" , 3))->subtree();

    addTreeRow(subtree,"Object Tooltips", 4);
    addTreeRow(subtree,"Behavior"       , 5);
    addTreeRow(subtree,"Tree View"      , 6);

    notebook->set_show_tabs(false);
    notebook->set_show_border(false);


    delete_event.connect( SigC::slot(this,&OptionsDlg::on_delete_event));


/*
 *  Paths  tab
 */

  wdir->set_text(
      Preferences::global_prefs->getOpt("/FWBuilderPreferences/Paths/Wdir") );
      
  wdir->grab_focus();

/*
 *   User Interface  tab
 */

  ((Gtk::Label*)(remember_window->get_child()))->set_alignment(0.0,0.5);

  remember_window->set_active(
      Preferences::global_prefs->getOptBool(
	  "/FWBuilderPreferences/UI/RememberWindowPositionAndSize") );

  ((Gtk::Label*)(hide_navbar->get_child()))->set_alignment(0.0,0.5);

  hide_navbar->set_active(
      Preferences::global_prefs->getOptBool(
	  "/FWBuilderPreferences/UI/HideNavigationBar") );

 
  ((Gtk::Label*)(quick_view_off->get_child()))->set_alignment(0.0,0.5);
  ((Gtk::Label*)(quick_view_popup->get_child()))->set_alignment(0.0,0.5);
  ((Gtk::Label*)(quick_view_window->get_child()))->set_alignment(0.0,0.5);

  string qv=Preferences::global_prefs->getOptStr(
      "/FWBuilderPreferences/UI/ObjectQuickView");

  if ( qv=="off" )     quick_view_off->set_active(true);
  if ( qv=="popup" )   quick_view_popup->set_active(true);
  if ( qv=="window" )  quick_view_window->set_active(true);

  quick_view_timeout->set_value(
      Preferences::global_prefs->getOptInt(
	  "/FWBuilderPreferences/UI/ObjectQuickViewTimeout") );

  ((Gtk::Label*)(autosave->get_child()))->set_alignment(0.0,0.5);
  ((Gtk::Label*)(autosave->get_child()))->set_line_wrap(true);

  autosave->set_active(
      Preferences::global_prefs->getOptBool(
	  "/FWBuilderPreferences/UI/Autosave")  );

  ((Gtk::Label*)(obj_tree_split->get_child()))->set_alignment(0.0,0.5);
  ((Gtk::Label*)(obj_tree_combined->get_child()))->set_alignment(0.0,0.5);

  string ot=Preferences::global_prefs->getOptStr(
      "/FWBuilderPreferences/UI/ObjectTreeMode");

  if (ot=="Split")    obj_tree_split->set_active(true);
  if (ot=="Combined") obj_tree_combined->set_active(true);

  ((Gtk::Label*)(show_obj_props_in_tree->get_child()))->set_alignment(0.0,0.5);
  show_obj_props_in_tree->set_active(
      Preferences::global_prefs->getOptBool(
	  "/FWBuilderPreferences/UI/ShowObjectPropertiesInTree") );

/*************** Network tab ******************/

  snmp_timeout->set_value(
      Preferences::global_prefs->getOptInt(
	  "/FWBuilderPreferences/Network/SNMPTimeout") );

  snmp_retries->set_value(
      Preferences::global_prefs->getOptInt(
	  "/FWBuilderPreferences/Network/SNMPRetries") );

  dns_timeout->set_value(
      Preferences::global_prefs->getOptInt(
	  "/FWBuilderPreferences/Network/DNSTimeout") );

  dns_retries->set_value(
      Preferences::global_prefs->getOptInt(
	  "/FWBuilderPreferences/Network/DNSRetries") );



//  show_hidden->set_active(
//      Preferences::global_prefs->getOpt("/FWBuilderPreferences/UI/ShowHidden")=="1");


  show_all();
}

gint OptionsDlg::on_delete_event(GdkEventAny* ev)
{
    commit_changes=false;
    Gtk::Main::quit();
    return true;
}

OptionsDlg::~OptionsDlg() 
{
    RowList::iterator i;

    for (i=ctree->rows().begin(); i!=ctree->rows().end(); ++i) {
	char *cptr= (char*)( (*i).get_data() );
	if (cptr) delete cptr;
    }
}

void OptionsDlg::on_ctree_select_row(gint row, gint column, GdkEvent *event)
{
    RowList          rl=ctree->rows();
    if (rl.empty()) return;  

    char      *lbl=(char*)(rl[row].get_data());
    if (lbl!=NULL) {
	unsigned  page=notebook_pages[ string(lbl) ];
	notebook->set_page(page);
    }
}

void OptionsDlg::run()
{
    commit_changes=false;

    Gtk::Main::grab_add(*this);
    Gtk::Main::run();
    Gtk::Main::grab_remove(*this);

    if (commit_changes) {


/*
 *  Paths  tab
 */
/*
	Preferences::global_prefs->setOpt("/FWBuilderPreferences/Paths/Icndir",
			     icn_dir->get_text().c_str());

	Preferences::global_prefs->setOpt(
	    "/FWBuilderPreferences/Paths/SNMPget",
	    snmpget_path->get_text().c_str());

	Preferences::global_prefs->setOpt(
	    "/FWBuilderPreferences/Paths/SNMPwalk",
	    snmpwalk_path->get_text().c_str() );
*/
	Preferences::global_prefs->setOpt(
	    "/FWBuilderPreferences/Paths/Wdir",
	    wdir->get_text().c_str() );

/*
 *   User Interface  tab
 */

	Preferences::global_prefs->setOptBool(
	    "/FWBuilderPreferences/UI/RememberWindowPositionAndSize",
	    remember_window->get_active() );

	Preferences::global_prefs->setOptBool(
	    "/FWBuilderPreferences/UI/HideNavigationBar",
	    hide_navbar->get_active() );



	string qv;

	if (quick_view_off->get_active())    qv="off";
	if (quick_view_popup->get_active())  qv="popup";
	if (quick_view_window->get_active()) qv="window";

	Preferences::global_prefs->setOpt("/FWBuilderPreferences/UI/ObjectQuickView", qv );

	Preferences::global_prefs->setOptInt(
	    "/FWBuilderPreferences/UI/ObjectQuickViewTimeout",
	    quick_view_timeout->get_value_as_int() );

	Preferences::global_prefs->setOptBool(
	    "/FWBuilderPreferences/UI/Autosave",
	    autosave->get_active() );

	string ot;

	if (obj_tree_split->get_active())     ot="Split";
	if (obj_tree_combined->get_active())  ot="Combined";

	Preferences::global_prefs->setOpt("/FWBuilderPreferences/UI/ObjectTreeMode", ot );

	Preferences::global_prefs->setOptBool(
	    "/FWBuilderPreferences/UI/ShowObjectPropertiesInTree",
	    show_obj_props_in_tree->get_active() );


/* Network */

	Preferences::global_prefs->setOptInt(
	    "/FWBuilderPreferences/Network/SNMPTimeout",
	    snmp_timeout->get_value_as_int() );

	Preferences::global_prefs->setOptInt(
	    "/FWBuilderPreferences/Network/SNMPRetries",
	    snmp_retries->get_value_as_int() );

	Preferences::global_prefs->setOptInt(
	    "/FWBuilderPreferences/Network/DNSTimeout",
	    dns_timeout->get_value_as_int() );

	Preferences::global_prefs->setOptInt(
	    "/FWBuilderPreferences/Network/DNSRetries",
	    dns_retries->get_value_as_int() );


//	Preferences::global_prefs->setOpt("/FWBuilderPreferences/UI/ShowHidden",
//			     show_hidden->get_active()?"1":"0");

        try
        {
            Preferences::global_prefs->savePrefs();
        } catch(FWException &ex)
        {
	    MessageDialog::Error("Error saving preferences.",ex.toString());
        }

	main_w->RefreshRightPane();
  }
}

void OptionsDlg::on_ok_clicked()
{   
    commit_changes=true;
    Gtk::Main::quit();
}

void OptionsDlg::on_cancel_clicked()
{   
    commit_changes=false;
    Gtk::Main::quit();
}








