/* 

                          Firewall Builder

                 Copyright (C) 2001 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: PixmapButton.cc,v 1.3 2001/12/29 10:06:35 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "Resources.hh"
#include "PixmapButton.hh"


PixmapButton::PixmapButton() : Gtk::Button()
{
}

PixmapButton::PixmapButton(const string &icn) : Gtk::Button()
{
    addPixmapAndText(*this,icn,"");
}

PixmapButton::PixmapButton(const string &icn, const string &text) : 
    Gtk::Button()
{
    addPixmapAndText(*this,icn,text);
}

static Gtk::HBox* _packHBox(const string &icn, const string &text)
{

    string icn_path;
    if (icn.find("/")==string::npos)
	icn_path=Resources::global_res->getIconPath(icn);
    else
	icn_path=icn;

    Gtk::HBox *hb=manage(new Gtk::HBox());

    Gtk::Pixmap *pixmap=manage(new Gtk::Pixmap(icn_path));
    hb->pack_start(*pixmap, true,true,false);

    if (!text.empty()) {
	Gtk::Label *label =manage(new Gtk::Label(text));
	hb->pack_start(*label , true,true,false);
    }

    return hb;
}

void PixmapButton::addPixmapAndText(const string &icn, const string &text)
{
    addPixmapAndText(*this,icn,text);
}

void PixmapButton::addPixmapAndText(Gtk::Button &btn,
				    const string &icn, const string &text)
{
    btn.remove();
    Gtk::HBox *hb=_packHBox(icn,text);
    btn.add(*hb);

    hb->show_all();
}
