/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: main_window_menu.cc,v 1.31 2001/12/22 02:34:35 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <config.h>
#include "main_window.hh"

using namespace libfwbuilder;


void main_window::build_menu()
{
    using Gtk::Menu_Helpers::MenuElem;
    using Gtk::Menu_Helpers::SeparatorElem;
    using SigC::slot;
    using SigC::bind;
    
    using namespace Gtk;

    Gtk::Menu *file_menu=new Menu();

    Gtk::Menu *new_menu=new Menu();

    new_menu->items().push_back( MenuElem("Firewall",
			      slot(this, &main_window::on_new_fw) ) );

    new_menu->items().push_back( MenuElem("Host",
			      slot(this, &main_window::on_new_host) ) );

    new_menu->items().push_back( MenuElem("Network",
			      slot(this, &main_window::on_new_net) ) );

    new_menu->items().push_back( MenuElem("Group of Objects",
		       slot(this, &main_window::on_new_obj_group) ) );

    new_menu->items().push_back( MenuElem("IP",
			      slot(this, &main_window::on_new_ip) ) );

    new_menu->items().push_back( MenuElem("ICMP",
			      slot(this, &main_window::on_new_icmp) ) );

    new_menu->items().push_back( MenuElem("TCP",
			      slot(this, &main_window::on_new_tcp) ) );

    new_menu->items().push_back( MenuElem("UDP",
			      slot(this, &main_window::on_new_udp) ) );

    new_menu->items().push_back( MenuElem("Custom Service",
			      slot(this, &main_window::on_new_custom) ) );

    new_menu->items().push_back( MenuElem("Group of Services",
		       slot(this, &main_window::on_new_srv_group) ) );

    new_menu->items().push_back( MenuElem("Time",
			      slot(this, &main_window::on_new_time) ) );


    file_menu->items().push_back(MenuElem("_New", "<control>N",
		       slot(this, &main_window::on_new1_activate) ) );

    file_menu->items().push_back(MenuElem("_Open", "<control>O",
		       slot(this, &main_window::on_open1_activate) ) );

    file_menu->items().push_back(MenuElem("_Save", "<control>S",
		       slot(this, &main_window::on_save1_activate) ) );

    file_menu->items().push_back(MenuElem("Save _As", "<control>A",
		       slot(this, &main_window::on_saveas1_activate) ) );

    file_menu->items().push_back( SeparatorElem());

    file_menu->items().push_back(MenuElem("_Print", "<control>P",
		       slot(this, &main_window::on_print_activate) ) );

    file_menu->items().push_back( SeparatorElem());

    file_menu->items().push_back(MenuElem("_Quit","<control>Q",
		       slot(this, &main_window::on_exit1_activate) ) );


    Menu *edit_menu=new Menu();

    edit_menu->items().push_back( MenuElem("Duplicate Object","",
			      slot(this, &main_window::on_duplicate) ) );
    edit_menu->items().back()->set_name("duplicate");
    edit_menu->items().back()->set_sensitive(false);

    edit_menu->items().push_back( MenuElem("Copy Object","",
			      slot(this, &main_window::on_copyobj) ) );
    edit_menu->items().back()->set_name("copy");
    edit_menu->items().back()->set_sensitive(false);

    edit_menu->items().push_back( MenuElem("Cut Object","",
			      slot(this, &main_window::on_cutobj) ) );
    edit_menu->items().back()->set_name("cut");
    edit_menu->items().back()->set_sensitive(false);

    edit_menu->items().push_back( MenuElem("Paste Object","",
			      slot(this, &main_window::on_pasteobj) ) );
    edit_menu->items().back()->set_name("paste");
    edit_menu->items().back()->set_sensitive(false);

    edit_menu->items().push_back( MenuElem("Delete Object","",
			      slot(this, &main_window::on_delobj) ) );
    edit_menu->items().back()->set_name("delete");
    edit_menu->items().back()->set_sensitive(false);

    edit_menu->items().push_back( SeparatorElem());

    edit_menu->items().push_back( MenuElem("Copy","<control>C",
			      slot(this, &main_window::on_copy) ) );
    edit_menu->items().back()->set_name("copy-cpb");
    edit_menu->items().back()->set_sensitive(true);

    edit_menu->items().push_back( MenuElem("Cut","<control>X",
			      slot(this, &main_window::on_cut) ) );
    edit_menu->items().back()->set_name("cut-cpb");
    edit_menu->items().back()->set_sensitive(true);

    edit_menu->items().push_back( MenuElem("Paste","<control>V",
			      slot(this, &main_window::on_paste) ) );
    edit_menu->items().back()->set_name("paste-cpb");
    edit_menu->items().back()->set_sensitive(true);

    edit_menu->items().push_back( SeparatorElem());

    edit_menu->items().push_back( MenuElem("_Find Object","<control>F",
			      slot(this, &main_window::on_find) ) );
    edit_menu->items().back()->set_name("find");
    edit_menu->items().back()->set_sensitive(true);

    edit_menu->items().push_back( SeparatorElem());

    edit_menu->items().push_back( MenuElem("_Where used","",
			      slot(this, &main_window::on_where_used) ) );
    edit_menu->items().back()->set_name("where_used");
    edit_menu->items().back()->set_sensitive(true);

    edit_menu->items().push_back( SeparatorElem());

    edit_menu->items().push_back( MenuElem("Sort subtree","<control>T",
			      slot(this, &main_window::on_sort) ) );
    edit_menu->items().back()->set_name("sort");
    edit_menu->items().back()->set_sensitive(false);

    edit_menu->items().push_back( SeparatorElem());

    edit_menu->items().push_back( MenuElem("Options",
	      slot(this, &main_window::on_options_activate) ) );


    Menu *view_menu=new Menu();
/*
 *  use MenuElem without accelerator string so that get_child will
 *  return Label later. We use that to change menu item label text. --vk
 */
    view_menu->items().push_back( MenuElem("Float Object Dialog",
			      slot(this, &main_window::on_float_pane) ) );
    view_menu->items().back()->set_name("float_pane");
    view_menu->items().back()->set_sensitive(true);
    view_menu->items().back()->configure(true,false);

    Menu *policy_menu=new Menu();

    policy_menu->set_name("policy_menu");

    policy_menu->items().push_back( MenuElem("Insert rule on the top",
	       slot(this,&main_window::on_insert_top)) );
    policy_menu->items().back()->set_name("insert_top");

    policy_menu->items().push_back( MenuElem("Append rule at the bottom",
	       slot(this,&main_window::on_append_bottom)) );
    policy_menu->items().back()->set_name("append_bottom");

    policy_menu->items().push_back( MenuElem("Add rule after current",
	       slot(this,&main_window::on_add_rule)) );
    policy_menu->items().back()->set_name("add_after");

    policy_menu->items().push_back( MenuElem("Remove current rule",
	       slot(this,&main_window::on_remove_rule)) );
    policy_menu->items().back()->set_name("remove_current");

    policy_menu->items().push_back( MenuElem("Move rule up",
	       slot(this,&main_window::on_move_up)) );
    policy_menu->items().back()->set_name("move_up");

    policy_menu->items().push_back( MenuElem("Move rule down",
	       slot(this,&main_window::on_move_down)) );
    policy_menu->items().back()->set_name("move_down");

    policy_menu->items().push_back( SeparatorElem());

    policy_menu->items().push_back( MenuElem("Help me build firewall policy",
	       slot(this,&main_window::on_build_autorules)) );
    policy_menu->items().back()->set_name("rules_druid");

    policy_menu->items().push_back( SeparatorElem());

    policy_menu->items().push_back( MenuElem("Compile",
	       slot(this,&main_window::on_compile)) );
    policy_menu->items().back()->set_name("compile_policy");

    policy_menu->items().push_back( MenuElem("Install",
	       slot(this,&main_window::on_install)) );
    policy_menu->items().back()->set_name("install_policy");


    Menu *tools_menu=new Menu();

    tools_menu->set_name("tools_menu");

    tools_menu->items().push_back( MenuElem("Discover Objects",
	       slot(this,&main_window::on_tools_scan)) );
    tools_menu->items().back()->set_name("scan");

    tools_menu->items().back()->set_sensitive(true);


    Menu *help_menu=new Menu();

    help_menu->items().push_back(MenuElem("About",
               slot(this,&main_window::on_about1_activate)) );
/*
    help_menu->items().push_back( SeparatorElem());

    help_menu->items().push_back(MenuElem("Release Notes",
               slot(this,&main_window::on_release_notes_activate)) );
*/
    main_menubar1->items().push_back( MenuElem("_File",  
					       "<Alt>F",
					       *file_menu ) );
    main_menubar1->items().back()->set_name("file");

    main_menubar1->items().push_back( MenuElem("_Edit",  
					       "<Alt>E", 
					       *edit_menu ) );
    main_menubar1->items().back()->set_name("edit");

    main_menubar1->items().push_back( MenuElem("_View",  
					       "<Alt>V", 
					       *view_menu ) );
    main_menubar1->items().back()->set_name("edit");

    main_menubar1->items().push_back( MenuElem("_Insert",  
					       "<Alt>I", 
					       *new_menu ) );
    main_menubar1->items().back()->set_name("new");

    main_menubar1->items().push_back( MenuElem("_Rules",
					       "<Alt>R", 
					       *policy_menu ) );
    main_menubar1->items().back()->set_name("policy");
    main_menubar1->items().back()->set_sensitive(false);

    main_menubar1->items().push_back( MenuElem("_Tools",
					       "<Alt>T", 
					       *tools_menu ) );
    main_menubar1->items().back()->set_name("tools");

    main_menubar1->items().push_back( MenuElem("_Help",  
					       "<Alt>H", 
					       *help_menu ) );

    main_menubar1->items().back()->right_justify();
    main_menubar1->items().back()->set_name("help");


}

