/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: policy.c,v 1.1 2001/05/29 21:32:09 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Puplic License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "ipfilter.h"


#include <stdio.h>
#include <string.h>
#include <stdlib.h>


void rulePrologue(xmlNodePtr filrewall,
		  xmlNodePtr rule,
		  xmlNodePtr iface,
		  int subrules_n)
{
    int           num=getInt(rule,"position");
    const char* comm =getStr(rule,"comment");

    total_subrules=subrules_n;
    
    fprintf(ipf_file,"#\n");
    fprintf(ipf_file,"#   %s Rule #%d\n", (iface!=NULL)?"Interface":"" , num );
    fprintf(ipf_file,"#\n");
    if (comm) {
	fprintf(ipf_file,"#    %s\n",comm);
	fprintf(ipf_file,"#\n");
    }
}
 
void ruleEpilogue(xmlNodePtr filrewall,xmlNodePtr rule, xmlNodePtr iface)
{
    xmlNodePtr src,dst,srv;
    elementaryRule  *trule;

    const char *action    = getStr(rule,"action");
    const char *direction = getStr(rule,"direction");
    int         log       = getBool(rule,"log");
    
    src=getFirstChildXmlNode(rule,"Src");
    dst=getFirstChildXmlNode(rule,"Dst");
    srv=getFirstChildXmlNode(rule,"Srv");

    if (getBool(src,"neg") || getBool(dst,"neg") ) {

	trule=createElementaryPolicyRule();
	trule->src=NULL;
	trule->dst=NULL;
	trule->srv=NULL;

	trule->p_action=" ??? ";
	if (strcasecmp(action,"accept")==0)   trule->p_action="pass";
	if (strcasecmp(action,"reject")==0)   trule->p_action="block";
	if (strcasecmp(action,"deny")==0)     trule->p_action="block";

	if (direction!=NULL)
	    trule->p_direction=direction;
	if (log)
	    trule->p_log="log";
	
	printPolicyRule( trule);
    }
}


void elementaryRulePrologue(xmlNodePtr filrewall,
			    xmlNodePtr iface,
			    xmlNodePtr rule,
			    elementaryRule *erule)
{
    char str[80];

    xmlNodePtr  options;
    const char  *action;
    int          num, log;
    
    options=getFirstChildXmlNode(rule,"PolicyRuleOptions");
    action=getStr(rule,"action");
    log=getBool(rule,"log");
    num=getInt(rule,"position");

    
    erule->p_action=" ??? ";
    if (strcasecmp(action,"accept")==0)	  erule->p_action="pass";
    if (strcasecmp(action,"reject")==0)   erule->p_action="block";
    if (strcasecmp(action,"deny")==0)     erule->p_action="block";

    if (erule->src_neg || erule->dst_neg) {
	sprintf(str,"skip %d",total_subrules - erule->subrule_no + 1);
	erule->p_action= strdup(str);
	erule->p_log=NULL;
    }
    else {    
	if (log)  erule->p_log="log";
	else      erule->p_log="";
    }
}

void elementaryRuleEpilogue(xmlNodePtr filrewall,
			    xmlNodePtr iface,
			    xmlNodePtr rule,
			    elementaryRule *erule) {}


void processPolicyRule(xmlNodePtr firewall,
		       xmlNodePtr iface,
		       xmlNodePtr rule,
		       const char *comment,
		       GSList    *subrules)
{
}


void printPolicyRule(elementaryRule *erule)
{
    if (erule->p_direction!=NULL &&
	strcasecmp(erule->p_direction,"inbound")==SAME )
	erule->p_direction="in";
    
    if (erule->p_direction!=NULL &&
	strcasecmp(erule->p_direction,"outbound")==SAME )
	erule->p_direction="out";

    
    fprintf(ipf_file,"%s %s",  erule->p_action,  erule->p_direction);

    if (erule->p_log)	fprintf(ipf_file," %s",erule->p_log);
    else                fprintf(ipf_file,"    ");

    if (strstr(erule->p_action,"skip")==NULL)
	fprintf(ipf_file," quick");
    
    if (erule->p_iface)
	fprintf(ipf_file," on %s",erule->p_iface);

    if (erule->t->p_proto)
	fprintf(ipf_file," proto %s",erule->t->p_proto);

    if ( erule->t->p_src!=NULL || erule->t->p_dst!=NULL )
	fprintf(ipf_file," keep state");

    if (erule->t->p_src)    fprintf(ipf_file," from %s",  erule->t->p_src);
    if (erule->t->p_sprt)	fprintf(ipf_file,"  %s",  erule->t->p_sprt);
    if (erule->t->p_dst)    fprintf(ipf_file," to %s",  erule->t->p_dst);
    if (erule->t->p_dprt)	fprintf(ipf_file,"  %s",  erule->t->p_dprt);

    if (erule->t->p_options!=NULL)	fprintf(ipf_file," %s",erule->t->p_options);

/*    fprintf(ipf_file," group %s",erule->p_group); */
    
    fprintf(ipf_file,"\n");
}
