
#include "fwcompiler.h"

extern FILE *ofile;
extern int   dynamic_address;

extern char  global_log_parameters[256];

extern char  global_log_level[256];
extern char  global_log_prefix[256];
extern char  global_log_tcp_seq[256];
extern char  global_log_tcp_opt[256];
extern char  global_log_ip_opt[256];
extern char  global_log_limit[256];
extern int   global_use_numeric_log_levels;
extern char  global_action_on_reject[256];
extern int   global_no_optimisation;
extern int   global_no_state;
extern int   global_manage_virtual_addr;
extern int   global_use_ip;

extern int   generate_input_output_groups_for_any;

extern char rule_chain[64];
extern char temp_i_chain[64];
extern char temp_o_chain[64];
extern char temp_f_chain[64];

extern char temp_n_chain[64];


extern void parseOptions(xmlNodePtr options,
			 char* log_level,
			 char* log_prefix,
			 char* log_tcp_seq,
			 char* log_tcp_opt,
			 char* log_ip_opt,
			 int * use_numeric_log_levels,
			 char* limit,
			 char* action_on_reject,
			 int * no_optimisation,
			 int * no_state,
			 int * manage_arp);

extern void printARPEntryCommands(xmlNodePtr firewall,
				  xmlNodePtr odst,
				  xmlNodePtr tdst);

extern void rulePrologue(xmlNodePtr firewall,
			 xmlNodePtr iface,
			 xmlNodePtr rule,
			 int subrules_n);

extern void ruleEpilogue(xmlNodePtr firewall,
			 xmlNodePtr iface,
			 xmlNodePtr rule,
			 GSList     *subrules);

extern void expandPolicyRuleIfFirewall(xmlNodePtr      firewall,
				       xmlNodePtr      iface,
				       xmlNodePtr      rule,
				       elementaryRule *erule);


extern void processElementaryPolicyRule(xmlNodePtr firewall,
					xmlNodePtr iface,
					xmlNodePtr rule,
					elementaryRule *erule);

extern void parsePolicyRule(xmlNodePtr rule,elementaryRule *erule);
extern void optimisePolicyRules();
extern void storePolicyRule(elementaryRule *erule);
extern void printElementaryRule(FILE *f,  elementaryRule *erule );
extern void printPolicyRule();

extern void addARPEntries(xmlNodePtr firewall);

extern void optimiseNatRules();
extern void parseNatRule(xmlNodePtr rule, elementaryNatRule *erule);
extern void storeNatRule(elementaryNatRule *erule);
extern void printNatRule();

extern void processTime(xmlNodePtr time,char *buff);

extern int processSrcAndDst(xmlNodePtr obj,char *buff);
extern void processSrc(xmlNodePtr obj,triplet *tr);
extern void processDst(xmlNodePtr obj,triplet *tr);
extern void processSrv(xmlNodePtr obj,triplet *tr);
