/* 

                          Firewall Builder

                 Copyright (C) 2000-2004 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: FWObjectClipboard.cpp,v 1.6 2004/06/09 05:36:50 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"

#include "fwbuilder/FWObjectReference.h"
#include "fwbuilder/FWObjectDatabase.h"

#include "FWObjectClipboard.h"


using namespace std;
using namespace libfwbuilder;

FWObjectClipboard* FWObjectClipboard::obj_clipboard=NULL;

FWObjectClipboard::FWObjectClipboard()
{
    assert(obj_clipboard==NULL);
    obj_clipboard=this;
}

FWObjectClipboard::~FWObjectClipboard()
{
    clear();
    obj_clipboard=NULL;
}

void      FWObjectClipboard::clear()
{
    for (vector<FWObject*>::iterator i=objects.begin(); i!=objects.end(); ++i)
    {
        FWObject *obj= *i;
        obj->clearChildren(true);
        obj->unref();
        delete obj;
    }
    objects.clear();
}

void      FWObjectClipboard::add(FWObject *_obj)
{
    FWObject *obj= FWObjectDatabase::db->create(_obj->getTypeName(),true);
    obj->ref();
    *obj = *_obj;

    objects.push_back(obj);
}

FWObject* FWObjectClipboard::getObject()
{
//    if (obj) 
//	obj->unref();

    return objects.back();
}

