/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@fwbuilder.org

  $Id: TimeDialog.cpp,v 1.16 2007/03/14 05:08:11 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "config.h"
#include "global.h"
#include "utils.h"

#include "FWBTree.h"
#include "TimeDialog.h"
#include "ObjectManipulator.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/Interval.h"

#include <qlineedit.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qdatetimeedit.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qcheckbox.h>

#include <iostream>

using namespace libfwbuilder;
using namespace std;

void TimeDialog::loadFWObject(FWObject *o)
{
    obj=o;
    Interval *s = dynamic_cast<Interval*>(obj);
    assert(s!=NULL);

    init=true;

    fillLibraries(libs,obj);

    obj_name->setText( QString::fromUtf8(s->getName().c_str()) );
    comment->setText( QString::fromUtf8(s->getComment().c_str()) );

    switch (startDate->order())
    {
    case QDateEdit::MDY:
        startDateLabel->setText( tr("(M/D/Y)") );
        endDateLabel->setText(   tr("(M/D/Y)") );
        break;

    case QDateEdit::DMY:
        startDateLabel->setText( tr("(D/M/Y)") );
        endDateLabel->setText(   tr("(D/M/Y)") );
        break;

    case QDateEdit::YMD:
        startDateLabel->setText( tr("(Y/M/D)") );
        endDateLabel->setText(   tr("(Y/M/D)") );
        break;

    case QDateEdit::YDM:
        startDateLabel->setText( tr("(Y/D/M)") );
        endDateLabel->setText(   tr("(Y/D/M)") );
        break;

    }
    int fromH = obj->getInt("from_hour");
    int fromM = obj->getInt("from_minute");
    if (fromH<0) fromH=0;
    if (fromM<0) fromM=0;
    startTime->setTime( QTime( fromH, fromM ) );

    int y=obj->getInt("from_year");
    int m=obj->getInt("from_month");
    int d=obj->getInt("from_day");
    bool using_start_date = (y>0 && m>0 && d>0);
    startDate->setDate( (using_start_date)?QDate( y, m, d ):QDate() );
    useStartDate->setChecked(using_start_date);

    // from_weekday is -1 for "All days" 
    startDOW->setCurrentItem( obj->getInt("from_weekday") + 1 );

    int toH = obj->getInt("to_hour");
    int toM = obj->getInt("to_minute");
    if (toH<0) toH=0;
    if (toM<0) toM=0;
    endTime->setTime( QTime( toH, toM ) );

    y=obj->getInt("to_year");
    m=obj->getInt("to_month");
    d=obj->getInt("to_day");
    bool using_end_date = (y>0 && m>0 && d>0);
    endDate->setDate( (using_end_date)?QDate( y, m, d ):QDate() );
    useEndDate->setChecked(using_end_date);

    // to_weekday is -1 for "All days" 
    endDOW->setCurrentItem( obj->getInt("to_weekday") + 1 );


    setDisabledPalette(obj_name);
    setDisabledPalette(libs);
    setDisabledPalette(comment);
    setDisabledPalette(startTime);
    setDisabledPalette(useStartDate);
    setDisabledPalette(startDate);
    //setDisabledPalette(startDOW);
    setDisabledPalette(endTime);
    setDisabledPalette(useEndDate);
    setDisabledPalette(endDate);
    //setDisabledPalette(endDOW);

    enableAllWidgets();

    //apply->setEnabled( false );


    init=false;
}

void TimeDialog::enableAllWidgets()
{
    obj_name->setEnabled(!obj->isReadOnly());
    libs->setEnabled(!obj->isReadOnly());
    comment->setReadOnly(obj->isReadOnly());

    startTime->setEnabled(!obj->isReadOnly());
    useStartDate->setEnabled(!obj->isReadOnly());
    startDate->setEnabled(!obj->isReadOnly() && useStartDate->isChecked());
    startDOW->setEnabled(!obj->isReadOnly() && !useStartDate->isChecked());

    endTime->setEnabled(!obj->isReadOnly());
    useEndDate->setEnabled(!obj->isReadOnly());
    endDate->setEnabled(!obj->isReadOnly() && useEndDate->isChecked());
    endDOW->setEnabled(!obj->isReadOnly() && !useEndDate->isChecked());
}
    
void TimeDialog::changed()
{
    //apply->setEnabled( true );
    emit changed_sign();
}

void TimeDialog::useStartOrEndDate()
{
    enableAllWidgets();
    changed();
}

void TimeDialog::validate(bool *res)
{
    *res=true;
}

void TimeDialog::isChanged(bool *res)
{
    //*res=(!init && apply->isEnabled());
}

void TimeDialog::libChanged()
{
    changed();
}

void TimeDialog::applyChanges()
{
    if (!isTreeReadWrite(this,obj)) return;

    string oldname=obj->getName();
    obj->setName( string(obj_name->text().utf8()) );
    obj->setComment( string(comment->text().utf8()) );
    
    if (useStartDate->isChecked())
    {
        obj->setInt( "from_day"   ,      startDate->date().day()   );
        obj->setInt( "from_month" ,      startDate->date().month() );
        obj->setInt( "from_year"  ,      startDate->date().year()  );
    } else
    {
        obj->setInt( "from_day"   ,      -1 );
        obj->setInt( "from_month" ,      -1 );
        obj->setInt( "from_year"  ,      -1 );
    }
    obj->setInt( "from_minute"   ,   startTime->time().minute());
    obj->setInt( "from_hour"  ,      startTime->time().hour()  );
    obj->setInt( "from_weekday" ,    startDOW->currentItem() -1);


    if (useEndDate->isChecked())
    {
        obj->setInt( "to_day"   ,        endDate->date().day()     );
        obj->setInt( "to_month" ,        endDate->date().month()   );
        obj->setInt( "to_year"  ,        endDate->date().year()    );
    } else
    {
        obj->setInt( "to_day"   ,      -1 );
        obj->setInt( "to_month" ,      -1 );
        obj->setInt( "to_year"  ,      -1 );
    }
    obj->setInt( "to_minute"   ,     endTime->time().minute()  );
    obj->setInt( "to_hour"  ,        endTime->time().hour()    );
    obj->setInt( "to_weekday" ,      endDOW->currentItem() - 1 );

    om->updateObjName(obj,QString::fromUtf8(oldname.c_str()));

    init=true;

/* move to another lib if we have to */
    if (! FWBTree::isSystem(obj) && libs->currentText() != QString(obj->getLibrary()->getName().c_str()))
        om->moveObject(libs->currentText(), obj);

    init=false;

    //apply->setEnabled( false );
    om->updateLastModifiedTimestampForAllFirewalls(obj);
}

void TimeDialog::discardChanges()
{
    loadFWObject(obj);
}

/* ObjectEditor class connects its slot to this signal and does all
 * the verification for us, then accepts (or not) the event. So we do
 * nothing here and defer all the processing to ObjectEditor
 */
void TimeDialog::closeEvent(QCloseEvent *e)
{
    emit close_sign(e);

}

