/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2008 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"


extern char global_netmask[1024];
extern char global_subnet[1024];
extern char global_nic[1024];

extern char DHCPD_CONF_BUF[1024];


char * get_ranges_from_current_scope()
{
    FILE *fp;
    long conf_size  = 0;
    int found_scope = 0;
    int found_pool  = 0;
    char *line, *retval=NULL;

    gchar *scope_line1 = g_strdup_printf("subnet %s netmask %s\n", global_subnet, global_netmask);
    gchar *scope_line2 = g_strdup_printf("subnet %s netmask %s{\n", global_subnet, global_netmask);
    gchar *scope_line3 = g_strdup_printf("subnet %s netmask %s {\n", global_subnet, global_netmask);
    gchar *nic_line = g_strdup_printf("interface %s;\n", global_nic);

    if((fp=fopen(DHCPD_CONF_BUF, "r"))==NULL)
    {
        printf("Couldnt find: %s\n", DHCPD_CONF_BUF);
        return retval;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size+1);

    /* Freed in the calling function */
    retval = allocate(conf_size+1);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( ( strstr(line, scope_line1) || strstr(line, scope_line2) 
	|| strstr(line, scope_line3) ) && ! strstr(line, "#") )
	{
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		if( strstr(line, nic_line) && ! strstr(line, "#") )
		{
		    found_scope = 1;
		    break;
		}
	    }
	}
	if( found_scope )
	  break;
    }


    /* Add ranges to retval, include the entire pool { } if any */
    if( found_scope && conf_size > 1 )
    {
	while(fgets(line, conf_size, fp)!=NULL)
	{
	    if( strstr(line, "}") )
	      break;

	    /* Get the failover pool with ranges */
	    if( strstr(line, "pool {") )
	    {
		found_pool = 1;
		strcat(retval, line);

		/* Gather pool ranges and other content */
		while(fgets(line, conf_size, fp)!=NULL)
		{
		    strcat(retval, line);

		    if( strstr(line, "}") )
			break;
		}
	    }
	    
	    if( found_pool )
	      break;

	    /* Gather normal ranges */	    	
	    if( strstr(line, "range ") && ! strstr(line, "#") )
	      strcat(retval, line);
	}
    }
    fclose(fp);
    free(line);

    g_free(scope_line1);
    g_free(scope_line2);
    g_free(scope_line3);
    g_free(nic_line);

    return retval;
}
