#! /usr/bin/env python

import sys
import ConfigParser
import glob
import re
import os, xreadlines
import Image

def createHtml(title, 
               outputpath,
               current, 
               next, 
               previous, 
               id,
               total, 
               index,
               width,
               height):

  return

g_defaults = {
'title'        : 'My Galrey pictures collection',
'pattern'      : '*.jpg',
'thumbsize'    : '80x60',
'thumbprefix'  : 't_',
'thumbsperrow' : 5,
'index'        : 'index.html',
'generatedext' : 'html',
'imagespath'   : '.',
'outputpath'   : '.',
'template'     : 'galrey.tpl',
'showinfo'     : 'yes',
'memofile'     : ''
}

class gconfig:
  title         = ''
  thumbsize     = ''
  thumbprefix   = ''
  thumbsperrow  = 0
  index         = ''
  pattern       = ''
  imagespath    = ''
  outputpath    = ''
  generatedext  = ''
  template      = ''
  showinfo      = ''
  memofile      = ''

cfg = gconfig()

cp = ConfigParser.ConfigParser(g_defaults)

# TODO add path checking
cp.read('/home/claudioc/scozia/web/varie/galrey.rc')

cfg.title         = cp.get('galrey', 'title')
cfg.thumbsize     = cp.get('galrey', 'thumbsize')
cfg.thumbprefix   = cp.get('galrey', 'thumbprefix')
cfg.thumbsperrow  = int(cp.get('galrey', 'thumbsperrow'))
cfg.index         = cp.get('galrey', 'index')
cfg.pattern       = cp.get('galrey', 'pattern')
cfg.imagespath    = cp.get('galrey', 'imagespath')
cfg.outputpath    = cp.get('galrey', 'outputpath')
cfg.generatedext  = cp.get('galrey', 'generatedext')
cfg.template      = cp.get('galrey', 'template')
cfg.showinfo      = cp.get('galrey', 'showinfo').upper()
cfg.memofile      = cp.get('galrey', 'memofile')

print "GALREY version 0.5.3, Copyright (C) 2001 Claudio Cicali\n";
print "Galrey comes with ABSOLUTELY NO WARRANTY;\n";
print "This is free software, and you are welcome to redistribute it under certain conditions;\nread COPYING for details.\n\n";

# Final configuration refining. Be sure to have the paths and a valid generated ext
if cfg.imagespath == '' :
  cfg.imagespath = '.'

if cfg.outputpath == '' :
  cfg.outputpath  = '.'
  
if cfg.template == '' :
  cfg.template  = 'galrey.tpl'

if cfg.generatedext[0] != '.':
  cfg.generatedext = '.' + cfg.generatedext;
  
print "Analyzing...\n"

files = glob.glob(cfg.imagespath + '/' + cfg.pattern)

if len(files) == 0:
  print "No images to process.\n"
  sys.exit(1)

i = 0
prev_ext = ''
error = 0
for f in files:
  files[i] = os.path.basename(f)
  curr_ext = re.search('\.(.*)', files[i]).group(1)
  if prev_ext != '':
    if prev_ext != curr_ext:
      error = 1
      break
  prev_ext = curr_ext
  i += 1

if error == 1:
  # Error: the specified pattern is wrong
  print "The specified pattern is not selective.\n"
  exit(1)

files.sort()

print files

memos = {}

if cfg.memofile != '':
  fd = open(cfg.memofile) # Todo: error checking
  for line in xreadlines.xreadlines(fd):
    line = line.splitlines()[0].strip()
    file = line.split()[0]
    try:
      comment = line[line.index(' ')+1:]
    except:
      comment = ''
#    print "'"+file+"' has comment '" + comment + "'"
    memos[file] = comment;

if memos != {}:
  print memos
  fd.close()

first = files[0].replace(curr_ext,cfg.generatedext[1:])
last = files[len(files)-1].replace(curr_ext,cfg.generatedext[1:])
print first
print last
print "Creating HTML"

previous = 'xxx'
next = 'xxx'
i = 0
for i in range(len(files)):
  filehtml = files[i].replace(curr_ext,cfg.generatedext[1:])
  current = files[i]

  try:
    next = files[i+1]
  except:
    next = ''

  dim = Image.open(cfg.imagespath+'/'+files[i]).size
  
  print filehtml, previous, current, next, dim[0], dim[1]

  previous = files[i]

  createHtml(cfg.title,
             cfg.imagespath+'/'+files[i],
             current,
             next,
             previous,
             i,
             len(files),
             cfg.index,
             dim[0],
             dim[1])


print "Creating index.html...";

indexfile = cfg.outputpath+'/'+cfg.index

fd = open(indexfile, "w")

fd.write ("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n")
fd.write( "<html>\n<head>\n")
fd.write( "<META http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n")
fd.write( "<title></title>\n")
fd.write( "</head>\n<body>\n<br>\n")
fd.write( "<b><I>Click on a picture to see it enlarged</I></b><br>\n")
fd.write( "\n<!------------- [CUT HERE] ---------->\n")
fd.write( "<table cellpadding=\"3\" cellspacing=\"3\">\n")

r = 0
for i in range(len(files)):
  filehtml = files[i].replace(curr_ext,cfg.generatedext[1:])
  thumb = cfg.thumbprefix+files[i]

  if r == 0:
    fd.write("\n<tr>")

  if cfg.showinfo == 'YES':
    dim = Image.open(cfg.imagespath+'/'+files[i]).size
    size = os.stat(cfg.imagespath+'/'+files[i])[6]
    fd.write("\n<td><a href=\""+filehtml+"\"><img src=\""+thumb+"\" border=\"0\" alt=\""+files[i]+"\"></a><br><div align=\"center\">["+str(dim[0])+"x"+str(dim[1])+"] "+ str(size) +"</div></td>")
  else:
    fd.write("\n<td><a href=\""+filehtml+"\"><img src=\""+thumb+"\" border=\"0\" alt=\""+files[i]+"\"></a></td>")

  r += 1

  if r == cfg.thumbsperrow:
    r = 0
    fd.write("\n</tr>")

if r == cfg.thumbsperrow:
  fd.write("\n</tr>")
  
fd.write("</table>\n\n<!------------- [CUT HERE] ---------->\n</body>\n</html>\n")
fd.close();

print "Creating thumbnails...\n";

thumbdim = cfg.thumbsize.split('x')
for i in range(len(files)):
  fullname  = cfg.imagespath + '/' + files[i];
  thumbname = cfg.outputpath + '/' + cfg.thumbprefix + files[i];
  Image.open(fullname).resize((int(thumbdim[0]), int(thumbdim[1]))).save(thumbname)

#sys.exit(0)




