# -*- python -*-                        vim:set ts=4 sw=4:

# Arj, the great dos compressor.

# Copyright (C) 2000 by Jaco Marais
# Copyright (C) 2000 by Natalie Ausmeier

from archive import *
from settings import *
import popen2
import string
import os
import gettext
import os.path

class Arj (Archive):

    def __init__(self, name, None, None, None):
    
        Archive.__init__(self, name, None, None, None)
        
        self.log = ''
        self.error_log = ''
        
    def available (self):
        return os.access (PS ('unarj_path'), os.X_OK)

    def extract (self, to, with_path, files=None):
    
        log=''
        error_log=''            
        
        cmd_cd = 'cp "' + self.name + '" ' + to
        (cd_in, cd_out, cd_err) = popen2.popen3 (cmd_cd)
        current_dir = os.getcwd()
        os.chdir(to)

        
        if with_path:

            if (files != None) and (files != []):
                for line in files:
                    pos = string.rfind(line, '/')                   
                    #if the filename contains a directory
                    if (pos != -1):                 
                        direc = to + '/' + line[:pos]
                        try:
                            #recursively create the directories
                            os.makedirs(direc, 0755)
                        except OSError:
                        #when the leave node exists, skip it
                        #self.error_log=error_log+line  
                            pass

            else: #no files selected, extract all files
                cmd_t = PS('unarj_path') + ' t "' + self.name + '"'
                (child_in_t, child_out_t, child_err_t) = popen2.popen3 (cmd_t)
                lines_t = child_in_t.readlines ()
                child_in_t.close ()
                err_t = child_err_t.readlines ()
                child_err_t.close ()
                
                #strip whitespaces in front and at back of messages
                err_t = map (string.strip, err_t)
                lines_t = map (string.strip, lines_t)
                
                #remove all garbage
                del lines_t [:4]
                del lines_t [len(lines_t)-1]
                
                for line in lines_t:
                    try:
                        #only to obtain the pathname of the files
                        (crap1, path, crap2) = string.split (line,None, 2)
                    except ValueError:
                        pass                

                    pos = string.rfind(path, '/')
                    if (pos != -1):                 
                        direc = to + '/' + path[:pos]
                        try:
                            os.makedirs(direc, 0755)
                        except OSError:
                            pass


        pos = string.rfind(self.name, '/')
        cmd_e = PS('unarj_path') + ' x "' + self.name[pos+1:]   + '"'
        self.log = self.log + cmd_e + '\n'
        (sub_in_e, sub_cout_e, sub_err_e) = popen2.popen3 (cmd_e)

        '''
        def rem(arg, dirname, names):
            for file in names:
                for f in files:
                    if (file != f):
                        system("rm " + file)
        
        '''
        
#       if ((with_path) and (files != None) and (files != [])):
#           self.walk(to, rem, "t")
        if self.error_log !='':
            self.error(self.error_log,self.log) 
        cmd_cd = 'rm ' + to + "/" +self.name[pos+1:]
        (cd_in, cd_out, cd_err) = popen2.popen3 (cmd_cd)

        os.chdir(current_dir)
        
    def add (self, files):
        pass

    def list_headers(self):
        return [gettext.gettext('Packed')]
        
    def list (self):
        cmd = PS('unarj_path') + ' l "' + self.name + '"'
        cmd_t = PS('unarj_path') + ' t "' + self.name + '"'
        ret = []

        (child_in, child_out, child_err) = popen2.popen3 (cmd)
        lines = child_in.readlines ()
        child_in.close ()
        err = child_err.readlines ()
        child_err.close ()
        err = map (string.strip, err)
        lines = map (string.strip, lines)
        #strip some unwanted information
        del lines [:lines.index ('------------ ---------- ---------- ----- ----------------- -------- -----------')+1]
        del lines [lines.index ('------------ ---------- ---------- ----- -----------------'):]

        (child_in_t, child_out_t, child_err_t) = popen2.popen3 (cmd_t)
        #get lines from standard input
        lines_t = child_in_t.readlines ()
        child_in_t.close ()
        err_t = child_err_t.readlines ()
        child_err_t.close ()
        err_t = map (string.strip, err_t)
        lines_t = map (string.strip, lines_t)
        #remove all garbage
        del lines_t [:4]
        del lines_t [len(lines_t)-1]
        s = []
        d = []
        t = []
        p = []
        
        #save all relevant information
        for line in lines:
            try:
                info = string.split(line, None, 7)
                size = info[1] 
                date = info[4] 
                time = info[5]
                packed = info[2]
                s.append(size) 
                d.append(date)
                t.append(time)
                p.append(packed)
            except ValueError:
                pass        
                
        cnt = 0
        for line_t in lines_t:
            try:
                (crap1, pathname, crap2) = string.split(line_t, None, 2)
                pos = string.rfind(pathname, '/')
                if pos != -1:
                    path = pathname [:pos]
                    name = pathname [pos+1:]
                else:
                    path = ''
                    name = pathname
                ret.append ((name, s[cnt], path, d[cnt], t[cnt], p[cnt]))
                cnt=cnt+1
            except ValueError:
                pass        
                
        self.number_of_files = len(ret)
        return ret

    def list_dir(self):
        cmd_t = PS('unarj_path') + ' t "' + self.name + '"'
        ret = []

        (child_in_t, child_out_t, child_err_t) = popen2.popen3 (cmd_t)
        lines_t = child_in_t.readlines ()
        lines_t = map (string.strip, lines_t)

        child_in_t.close ()
        err_t = child_err_t.readlines ()
        child_err_t.close ()
        err_t = map (string.strip, err_t)

        #remove all garbage
        del lines_t [:4]
        del lines_t [len(lines_t)-1]
        
        cnt = 0
        path = ""
        for line in lines_t:
            try:
                (crap1, path, crap2) = string.split (line, None, 2)
                pos = string.rfind(path, '/')
                if pos != -1:
                    ret.append ((path[:pos+1]))
                cnt=cnt+1
            except ValueError:
                pass
                
        self.number_of_files = len(ret)
        return ret

    def view (self, file):
        cmd = PS('unarj_path') + '-o -d /tmp/garchiver/ "' + self.name + '" ' + file
        os.system(cmd)
        tmp = self.make_tempfile (file)
        os.rename('/tmp/garchiver/' + file, tmp)
#       os.remove('tmp/garchiver/' + 
        return tmp
        
    def get_log (self):
        '''
        Return the log file so that the GUI can display it on
        the request of the user in a dialog box
        ''' 
        return self.log

if __name__ == '__main__':
    z = Arj ('/home/jaco/Projects/arj/comp.arj', None, None, None)
    z.list()
