/* Gnome BibTeX command_dlg.C
 *    Copyright 1999 Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 * 
 *    This program is free software; you can redistribute it and'or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2, or (at your option)
 *    any later version.
 */

#include <iostream.h>
#include <vector>

extern "C" {
#include <gnome.h>
}

#include "gbib.h"

extern vector_string commandTab;
extern GtkWidget *app;

class Kommand {
public:
  Kommand(string &a,string &b) { kind=a; data=b; }
  Kommand(pair_strings &a) { kind=a.first; data=a.second; }    
  string kind;
  string data;
};

// all prototypes for this file

GtkWidget * make_pix_button(char *text,const char *icon);

void clear_local_copy();
void build_local_copy();
void fetch_local_copy();

void cmd_delete_cb(GtkWidget *widget, gpointer data);
void newcmd_cb(GtkWidget *widget, gpointer data);
void specialdlg_cb(GnomeDialog * dialog, gint button_number, 
		   gpointer data);
void command_dlg(BibentryTable &t);
void  cmd_select_row(GtkCList *clist, gint row, gint column,
		     GdkEventButton *event, gpointer user_data);
void  cmd_unselect_row(GtkCList *clist, gint row, gint column,
		       GdkEventButton *event, gpointer user_data);

// Local data
static BibentryTable *table = 0;
static GtkWidget *cmdlist, *delete_button, *text_entry;

/* the best way to keep state is make a copy of the command table
   on startup, work on the copy. If the user clicks Ok, fetch
   the local_copy back, else nothing happens */
vector<Kommand *> local_copy;
vector<Kommand *>::iterator lci;
int idx=-1;
int skip_copyback=0;

// ------------------------

void clear_local_copy() {
  for(lci=local_copy.begin();lci!=local_copy.end();lci++)
    delete(*lci);
  local_copy.clear();
}

void build_local_copy() {

  clear_local_copy();
  for (int i=0; i < table->commandSize(); i++) {
    pair_strings p=table->getCommand(i);
    local_copy.push_back( new Kommand(p) );
  }
}

void fetch_local_copy() {
  while(table->commandSize())
    table->delCommand(0);
  for(lci=local_copy.begin();lci!=local_copy.end();lci++)
    table->new_command( (*lci)->kind, (*lci)->data );
}

void specialdlg_cb(GnomeDialog * dialog, gint button_number, 
			  gpointer data)
{
  switch (button_number) {
  case 0: // OK
    fetch_local_copy();
    gnome_dialog_close(dialog);
    break;
  case 1: // CANCEL
    gnome_dialog_close(dialog);
    break;
  }
}

void cmd_delete_cb(GtkWidget *widget, gpointer data) {
  if (idx >= 0) {
    skip_copyback++; // else the list unselection callback screws up the data
    delete(*(local_copy.begin()+idx));
    local_copy.erase(local_copy.begin()+idx);
    gtk_clist_remove(GTK_CLIST(cmdlist),idx);
    idx=-1;
  }
}

void newcmd_cb(GtkWidget *widget, gpointer data)
{
  string kind,nada;
  char *s = (char*)data;
  char *a[1];   
  kind=s;
  local_copy.push_back(new Kommand(kind,nada));
  a[0]=s;
  gtk_clist_append(GTK_CLIST(cmdlist),a);
  gtk_clist_select_row(GTK_CLIST(cmdlist), local_copy.size()-1, 0);
}

void command_dlg(BibentryTable &t)
{
    GtkWidget * dialog;
    GtkWidget *label;
    GtkWidget *scrolled_window;
    GtkWidget *box;
    GtkWidget *list_item;
    GtkWidget *left_v, *newbt;
    GtkTooltips *tips;
 
    table = &t;
    idx=-1;
    skip_copyback=0;

    dialog = gnome_dialog_new("Commands", 
			      GNOME_STOCK_BUTTON_OK,
			      GNOME_STOCK_BUTTON_CANCEL,
			      0);
    gnome_dialog_set_default(GNOME_DIALOG(dialog), 0);
    tips=gtk_tooltips_new();

    left_v = gtk_hbox_new(TRUE,0);
    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), 
			left_v, FALSE, TRUE, 0);

    box = gtk_hbox_new(FALSE, 5);

    // make the "New ..." buttons
    vector_string::iterator it = commandTab.begin();
    char zzz[128];
    for (;it != commandTab.end();it++) {
      sprintf(zzz,"%s",it->c_str());
      newbt=make_pix_button(zzz,GNOME_STOCK_PIXMAP_NEW);
      gtk_box_pack_start (GTK_BOX (left_v), newbt, FALSE, TRUE, 0);
      gtk_widget_show(newbt);
      gtk_signal_connect(GTK_OBJECT(newbt),"clicked",
			 GTK_SIGNAL_FUNC(newcmd_cb),
			 (gpointer)(Unconst::copy(it->c_str())));
      sprintf(zzz,"Add a new %s command",it->c_str());
      gtk_tooltips_set_tip(tips,newbt,zzz,0);
    }

    // delete button
    delete_button=make_pix_button("Delete",GNOME_STOCK_PIXMAP_TRASH);
    gtk_box_pack_start (GTK_BOX (left_v), delete_button, FALSE, TRUE, 0);
    gtk_widget_show(delete_button);
    gtk_signal_connect(GTK_OBJECT(delete_button),"clicked",
		       GTK_SIGNAL_FUNC(cmd_delete_cb),0);
    gtk_widget_set_sensitive(delete_button,FALSE);
    gtk_tooltips_set_tip(tips,delete_button,"Delete the selected command",0);

    // list on the left
    cmdlist = gtk_clist_new(1); 
    gtk_clist_column_titles_hide(GTK_CLIST(cmdlist));
    gtk_clist_set_selection_mode(GTK_CLIST(cmdlist),GTK_SELECTION_SINGLE);

    build_local_copy();
    for(lci=local_copy.begin();lci!=local_copy.end();lci++) {       
      char *a[1];
      a[0]=Unconst::copy((*lci)->kind.c_str());
      gtk_clist_append(GTK_CLIST(cmdlist),a);
    }
    
    scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_widget_set_usize(scrolled_window, 100, 180);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_NEVER,
				    GTK_POLICY_AUTOMATIC);

    gtk_box_pack_start (GTK_BOX (box), scrolled_window, FALSE, TRUE, 0);
    gtk_widget_show(scrolled_window);
   
    gtk_container_add(GTK_CONTAINER(scrolled_window),cmdlist);
    gtk_widget_show(cmdlist);    

    // the text entry
    text_entry = gtk_text_new(NULL, NULL);
    gtk_text_set_editable(GTK_TEXT(text_entry), TRUE);
    gtk_widget_set_usize (text_entry, 420, 
			  (text_entry->style->font->ascent +
			   text_entry->style->font->descent) * 6);

    gtk_box_pack_start (GTK_BOX (box), text_entry, TRUE, TRUE, 0);
    gtk_widget_show(text_entry);   
   
    gtk_signal_connect(GTK_OBJECT(cmdlist),
		       "select_row",
		       GTK_SIGNAL_FUNC(cmd_select_row),0);
    gtk_signal_connect(GTK_OBJECT(cmdlist),
		       "unselect_row",
		       GTK_SIGNAL_FUNC(cmd_unselect_row),0);
   
   
    gtk_signal_connect(GTK_OBJECT (dialog),
		       "clicked", GTK_SIGNAL_FUNC(specialdlg_cb),0);
   
    gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (dialog)->vbox), 
			box, TRUE, TRUE, 0);
   
    gtk_widget_show(delete_button);
    gtk_widget_show(left_v);
    gtk_widget_show(box);

    GTK_WINDOW (dialog)->type = GTK_WINDOW_TOPLEVEL;
    gtk_widget_show(dialog);
}

GtkWidget * make_pix_button(char *text,const char *icon) {
  GtkWidget *d0,*d1,*d2,*d3;
  d0=gtk_button_new();
  gtk_button_set_relief(GTK_BUTTON(d0),GTK_RELIEF_NONE);
  d1=gtk_vbox_new(FALSE,2);
  gtk_container_set_border_width(GTK_CONTAINER(d1),2);
  gtk_container_add(GTK_CONTAINER(d0),d1);
  gtk_box_pack_start(GTK_BOX(d1),d2=gnome_stock_pixmap_widget_new(app,icon),
		     FALSE,TRUE,2);
  d3=gtk_label_new(text);
  gtk_box_pack_start(GTK_BOX(d1),d3,FALSE,TRUE,2);
  gtk_widget_show(d1);
  gtk_widget_show(d2);
  gtk_widget_show(d3);
  return d0;
}

// - sets idx
// - sets text entry to entry's content
// - enables delete button
void  cmd_select_row(GtkCList *clist, gint row, gint column,
		     GdkEventButton *event, gpointer user_data)
{  
  idx=row;

  gtk_text_freeze(GTK_TEXT(text_entry));
  gtk_editable_delete_text(GTK_EDITABLE(text_entry), 0, -1);      
  char *s = Unconst::copy( local_copy[idx]->data.c_str() );
  gtk_text_insert(GTK_TEXT(text_entry), 0, 0, 0, s, -1);
  Unconst::pop(1);
  gtk_text_thaw(GTK_TEXT(text_entry));
 
  gtk_widget_set_sensitive(delete_button,TRUE);
}

// - copies text entry contents to local copy
// - clears the text entry
// - disables delete button
// - unsets idx (current entry index)
void  cmd_unselect_row(GtkCList *clist, gint row, gint column,
		     GdkEventButton *event, gpointer user_data)
{
  char *s;

  if (!skip_copyback) {
    if (row==idx) {
      s=gtk_editable_get_chars(GTK_EDITABLE(text_entry),0,-1);  
      local_copy[idx]->data=s;
      g_free(s);
    }
  } else
    --skip_copyback;

  gtk_editable_delete_text(GTK_EDITABLE(text_entry), 0, -1);

  gtk_widget_set_sensitive(delete_button,FALSE);

  idx=-1;
}
