/* Gnome BibTeX recent.C
 *    Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 *    Felipe Bergo <bergo@seul.org>
 * 
 *    This program is free software; you can redistribute it and'or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2, or (at your option)
 *    any later version.
 */

// mostly inspired from gedit's file history code

#include <stdio.h>
#include <string.h>
#include <list>
#include <string>

#include "gbib.h"
#include "recent.h"

#ifndef DATA_ITEMS_TO_REMOVE
#define DATA_ITEMS_TO_REMOVE "items_to_remove"
#endif

list<string *> RecentFiles;
list<string *>::iterator rfi;
list<string *>::reverse_iterator rrfi;

int HistorySize=4;

void recent_rebuild_menus(GnomeApp *app);
void recent_add_menu(GnomeApp *app,string *file,const char *path,int num);
void recent_write_rc();

// gui.C
extern GtkWidget *app;
int open_file(char *s);

void recent_startup(GnomeApp *app) {
  int i;
  char *s, temp[64];
  gboolean do_set=FALSE;

  gnome_config_push_prefix("/GnomeBibtex/History/");

  HistorySize = gnome_config_get_int_with_default("HistorySize=4",&do_set);
  if (do_set)
    gnome_config_set_int("HistorySize",4);

  // clear list
  for(rfi=RecentFiles.begin();rfi!=RecentFiles.end();rfi++)
    delete(*rfi);
  RecentFiles.clear();
  
  for(i=0;i<HistorySize;i++) {
    sprintf(temp,"File%d",i+1);
    s=gnome_config_get_string(temp);
    if (!s)
      break;
    RecentFiles.push_back(new string(s));
  }

  gnome_config_sync();
  gnome_config_pop_prefix();

  recent_rebuild_menus(app);
}

void recent_write_rc() {
  char temp[64];
  int i;

  gnome_config_clean_section("/GnomeBibtex/History/");
  gnome_config_push_prefix("/GnomeBibtex/History/");
  gnome_config_set_int("HistorySize",HistorySize);

  for(i=0,rfi=RecentFiles.begin();rfi!=RecentFiles.end();i++,rfi++) {
    sprintf(temp,"File%d",i+1);
    gnome_config_set_string(temp,const_cast<char*>((*rfi)->c_str()));
  }

  gnome_config_sync();
  gnome_config_pop_prefix();
}

void add_recent_item(GnomeApp *app,char *filename) {
  
  for(rfi=RecentFiles.begin();rfi!=RecentFiles.end();rfi++)
    if ( (*(*rfi) == filename ) )
      return; // already in the file list

  if (RecentFiles.size()==HistorySize) {
    delete(RecentFiles.back());
    RecentFiles.pop_back();
  }

  RecentFiles.push_front(new string(filename));
  recent_rebuild_menus(app);
  recent_write_rc();
}

void recent_rebuild_menus(GnomeApp *app) {
  static gint items_in_menu = 0;
  const gchar *file_name;
  gchar *path;
  int i;
  gint* items_to_remove = NULL;

  items_to_remove = (gint *)gtk_object_get_data(GTK_OBJECT(app),
						DATA_ITEMS_TO_REMOVE);
  if (items_to_remove!=0) {
    gnome_app_remove_menu_range (app, _("_File/"), 5, *items_to_remove);
    gtk_object_remove_data(GTK_OBJECT(app), DATA_ITEMS_TO_REMOVE);
  }

  items_in_menu = RecentFiles.size();
  path = g_strdup_printf ("%s/%s", _("_File"), "<Separator>");
    
  for(i=RecentFiles.size(),rrfi=RecentFiles.rbegin();
      rrfi!=RecentFiles.rend();rrfi++,i--)
    recent_add_menu(app, *rrfi , path, i);
  g_free (path);

  items_to_remove = g_new0 (gint, 1);
  *items_to_remove = items_in_menu;
  gtk_object_set_data_full (GTK_OBJECT(app), DATA_ITEMS_TO_REMOVE,
			    items_to_remove, g_free);
}

static void recent_cb (GtkWidget *w, gpointer data) {
  string *file_to_open;
  char no_const_for_the_dying[256];
  file_to_open=(string *)data;  
  strcpy(no_const_for_the_dying,file_to_open->c_str());
  if (open_file(no_const_for_the_dying)<0) {
    // remove item from history
    for(rfi=RecentFiles.begin();rfi!=RecentFiles.end();rfi++)
      if ( (*(*rfi)) == (*file_to_open) ) {
	RecentFiles.erase(rfi);
	recent_write_rc();
	recent_rebuild_menus(GNOME_APP(app));
	return;
      }
  } else
    if ( (*(RecentFiles.front())) != (*file_to_open) ) {
      // move up
      for(rfi=RecentFiles.begin();rfi!=RecentFiles.end();rfi++)
	if ( (*(*rfi)) == (*file_to_open) ) {
	  RecentFiles.erase(rfi);
	  break;
	}
      RecentFiles.push_front(file_to_open);
      recent_write_rc();
      recent_rebuild_menus(GNOME_APP(app));
    }
}

void recent_add_menu(GnomeApp *app,string *file,const char *path,int num) {
  GnomeUIInfo *menu;

  menu = (GnomeUIInfo *)g_malloc0 (2 * sizeof (GnomeUIInfo));
  menu->label = g_strdup_printf ("_%i. %s", num, file->c_str());
  menu->type = GNOME_APP_UI_ITEM;
  menu->hint = NULL;
  menu->moreinfo = (gpointer) recent_cb;
  menu->user_data = (gpointer) file;
  menu->unused_data = NULL;
  menu->pixmap_type = GNOME_APP_PIXMAP_NONE;
  menu->pixmap_info = NULL;
  menu->accelerator_key = 0;

  (menu + 1)->type = GNOME_APP_UI_ENDOFINFO;

  gnome_app_insert_menus (GNOME_APP(app), path, menu);

  g_free (menu->label);
  g_free (menu);
}
