// -*- C++ -*-

/* 
 * GChemPaint arrows plugin
 * plugin.cc 
 *
 * Copyright (C) 2004 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include "gchempaint-config.h"
#include "plugin.h"
#include "lib/application.h"
#include "arrowtool.h"
#include "retrosynthesis.h"
#include "retrosynthesisarrow.h"
#include "retrosynthesisstep.h"
#include <glib/gi18n.h>
#include <gconf/gconf-client.h>
	
gcpArrowsPlugin plugin;

static Object* CreateRetrosynthesis ()
{
	return new gcpRetrosynthesis ();
}

static Object* CreateRetrosynthesisArrow ()
{
	return new gcpRetrosynthesisArrow (NULL);
}

static Object* CreateRetrosynthesisStep ()
{
	return new gcpRetrosynthesisStep ();
}

gcpArrowsPlugin::gcpArrowsPlugin (): gcpPlugin ()
{
	RetrosynthesisType = Object::AddType ("retrosynthesis", CreateRetrosynthesis);
	Object::SetCreationLabel (RetrosynthesisType, _("Create a new retrosynthesis pathway"));
	RetrosynthesisArrowType = Object::AddType ("retrosynthesis-arrow", CreateRetrosynthesisArrow);
	RetrosynthesisStepType = Object::AddType ("retrosynthesis-step", CreateRetrosynthesisStep);
}

gcpArrowsPlugin::~gcpArrowsPlugin ()
{
}

void gcpArrowsPlugin::Populate (gcpApplication* App)
{
	GError *error = NULL;
	GConfClient *conf_client = gconf_client_get_default ();
	gconf_client_add_dir (conf_client, "/apps/gchempaint/plugins/arrows", GCONF_CLIENT_PRELOAD_ONELEVEL, NULL);
	bool FullHeads = gconf_client_get_bool (conf_client, "/apps/gchempaint/plugins/arrows/full-arrows-heads", &error);
	if (error) {
		FullHeads = false;
		g_message("GConf failed: %s", error->message);
		g_error_free (error);
	}
	gconf_client_remove_dir (conf_client, "/apps/gchempaint/plugins/arrows", NULL);
	g_object_unref (conf_client);
	App->AddUI (GLADEDIR"/arrows.xml");
	new gcpArrowTool (App);
	new gcpArrowTool (App, FullHeads? gcpFullReversibleArrow: gcpReversibleArrow);
	new gcpArrowTool (App, gcpDoubleHeadedArrow);
	new gcpArrowTool (App, gcpDoubleQueuedArrow);
	Object::AddRule ("retrosynthesis", RuleMustContain, "retrosynthesis-step");
	Object::AddRule ("retrosynthesis", RuleMustContain, "retrosynthesis-arrow");
	Object::AddRule ("retrosynthesis-step", RuleMustContain, "molecule");
	Object::AddRule ("molecule", RuleMayBeIn, "retrosynthesis-step");
	Object::AddRule ("retrosynthesis-arrow", RuleMustBeIn, "retrosynthesis");
	Object::AddRule ("retrosynthesis-step", RuleMustBeIn, "retrosynthesis");
}
