/*
  GNOME Comics Organizer
  Copyright (C) 1999-2001 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef COMICLIST_H
#define COMICLIST_H

#include <glib.h>
#include <time.h>

typedef enum{Mint, NearMint, VeryFine, FineVeryFine, Fine, VeryGood, Good, Fair, Poor} TCondition;

typedef struct TIssue {
  GString *IssueNo, *Location, *Price, *CurrentPrice, *PurchasePrice, *Comment, *Image;
  GList *Writer, *Penciller, *Inker, *Title; /* GList of GString */
  TCondition Condition;
  time_t Date;
  gboolean ShowMe;
  guint32 UID;

  GList *ILinks, *CLinks;
} TIssue; 

typedef struct TComic {
  GString *CTitle, *CPublisher, *CType, *CVolume, *CGroup, *LinkFile, *Comment;
  gboolean ShowMe, IsLink;
  GList *IssueNumbers;
  guint32 UID;

  GList *ILinks, *CLinks;
} TComic;

typedef struct TILink {
  GString *Name;
  guint32 UID;
  TIssue *Issue;
} TILink;
typedef struct TCLink {
  GString *Name;
  guint32 UID;
  TComic *Comic;
} TCLink;

/* When loading a Comics Organizer for Windows file do AssignUID for
   each Issue and Comic. AssignUID will return a unique identifier in
   the form of a guint32.  The largest used UID can be saved in the
   file for easier assignment later on. This will allow for 2^32 =
   4294967296 Comics and Issues to be added.  That large amount should
   be adequate even if "dead" UIDs aren't reused.  These UIDs will
   enable creation of links between individual Issues and/or Comics.
*/


TIssue *Init_Issue();
TComic *Init_Comic();
guint32 AssignUID();
GString *Condition2GString(TCondition con);

guint32 GetUID();
void SetUID(guint32 setme);

gint CompareTComic_Title(gconstpointer a, gconstpointer b);
gint CompareTComic_Publisher(gconstpointer a, gconstpointer b);
gint CompareTComic_Type(gconstpointer a, gconstpointer b);
gint CompareTIssue_IssueNo(gconstpointer a, gconstpointer b);

void ASCIIDumpComicList(GList *clist);

#endif
